/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.filters.KeywordFilter;
import com.limegroup.gnutella.filters.SpamFilter;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.QueryReply;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeSet;

public final class MutableGUIDFilter
extends SpamFilter {
    private static final MutableGUIDFilter INSTANCE = new MutableGUIDFilter();
    private Set _guids = new TreeSet((Comparator)new GUID.GUIDByteComparator());
    private final KeywordFilter FILTER = new KeywordFilter();

    private MutableGUIDFilter() {
        this.FILTER.disallowAdult();
    }

    public static MutableGUIDFilter instance() {
        return INSTANCE;
    }

    public synchronized void addGUID(byte[] byArray) {
        TreeSet treeSet = new TreeSet((Comparator)new GUID.GUIDByteComparator());
        treeSet.addAll((Collection)treeSet);
        treeSet.add((Object)byArray);
        this._guids = treeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGUID(byte[] byArray) {
        if (this._guids.size() == 0) {
            return;
        }
        MutableGUIDFilter mutableGUIDFilter = this;
        synchronized (mutableGUIDFilter) {
            if (this._guids.size() > 0) {
                TreeSet treeSet = new TreeSet((Comparator)new GUID.GUIDByteComparator());
                treeSet.addAll((Collection)this._guids);
                treeSet.remove((Object)byArray);
                this._guids = treeSet;
            }
        }
    }

    public boolean allow(QueryReply queryReply) {
        if (this._guids.contains((Object)queryReply.getGUID())) {
            return this.FILTER.allow(queryReply);
        }
        return true;
    }

    public boolean allow(Message message) {
        if (message instanceof QueryReply) {
            return this.allow((QueryReply)message);
        }
        return true;
    }
}

