/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.UrnType;
import com.limegroup.gnutella.guess.QueryKey;
import com.limegroup.gnutella.messages.BadGGEPBlockException;
import com.limegroup.gnutella.messages.BadGGEPPropertyException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.GGEP;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.statistics.DroppedSentMessageStatHandler;
import com.limegroup.gnutella.statistics.ReceivedErrorStat;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Set;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.xml.sax.SAXException;

public class QueryRequest
extends Message
implements Serializable {
    public static final int SPECIAL_MINSPEED_MASK = 128;
    public static final int SPECIAL_FIREWALL_MASK = 64;
    public static final int SPECIAL_XML_MASK = 32;
    public static final int SPECIAL_OUTOFBAND_MASK = 4;
    public static final int AUDIO_MASK = 4;
    public static final int VIDEO_MASK = 8;
    public static final int DOC_MASK = 16;
    public static final int IMAGE_MASK = 32;
    public static final int WIN_PROG_MASK = 64;
    public static final int LIN_PROG_MASK = 128;
    public static final String WHAT_IS_NEW_QUERY_STRING = "WhatIsNewXOXO";
    public static int WHAT_IS_NEW_GGEP_VALUE = 1;
    private final byte[] PAYLOAD;
    private final int MIN_SPEED;
    private final String QUERY;
    private final LimeXMLDocument XML_DOC;
    private int _capabilitySelector = 0;
    private boolean _doNotProxy = false;
    private final Set REQUESTED_URN_TYPES;
    private final Set QUERY_URNS;
    private final QueryKey QUERY_KEY;
    private Integer _metaMask = null;
    private volatile int _hashCode = 0;
    private static final Set EMPTY_SET = Collections.unmodifiableSet((Set)new HashSet());
    private static final byte DEFAULT_TTL = 6;
    private static final char[] ILLEGAL_CHARS = SearchSettings.ILLEGAL_CHARS.getValue();
    private static final int MAX_QUERY_LENGTH = SearchSettings.MAX_QUERY_LENGTH.getValue();
    private static final int MAX_XML_QUERY_LENGTH = SearchSettings.MAX_XML_QUERY_LENGTH.getValue();
    private static final String DEFAULT_URN_QUERY = "\\";

    public static QueryRequest createRequery(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        HashSet hashSet = new HashSet();
        hashSet.add((Object)uRN);
        return new QueryRequest(QueryRequest.newQueryGUID(true), 6, DEFAULT_URN_QUERY, "", UrnType.SHA1_SET, (Set)hashSet, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createQuery(URN uRN) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        HashSet hashSet = new HashSet();
        hashSet.add((Object)uRN);
        return new QueryRequest(QueryRequest.newQueryGUID(false), 6, DEFAULT_URN_QUERY, "", UrnType.SHA1_SET, (Set)hashSet, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createRequery(URN uRN, String string) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string.length() == 0) {
            string = DEFAULT_URN_QUERY;
        }
        HashSet hashSet = new HashSet();
        hashSet.add((Object)uRN);
        return new QueryRequest(QueryRequest.newQueryGUID(true), 6, string, "", UrnType.SHA1_SET, (Set)hashSet, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createQuery(URN uRN, String string) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string.length() == 0) {
            string = DEFAULT_URN_QUERY;
        }
        HashSet hashSet = new HashSet();
        hashSet.add((Object)uRN);
        return new QueryRequest(QueryRequest.newQueryGUID(false), 6, string, "", UrnType.SHA1_SET, (Set)hashSet, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createRequery(URN uRN, byte by) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        if (by <= 0 || by > 6) {
            throw new IllegalArgumentException("invalid TTL: " + by);
        }
        HashSet hashSet = new HashSet();
        hashSet.add((Object)uRN);
        return new QueryRequest(QueryRequest.newQueryGUID(true), by, DEFAULT_URN_QUERY, "", UrnType.SHA1_SET, (Set)hashSet, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createQuery(Set set, Set set2) {
        if (set2 == null) {
            throw new NullPointerException("null urnSet");
        }
        if (set == null) {
            throw new NullPointerException("null urnTypeSet");
        }
        return new QueryRequest(QueryRequest.newQueryGUID(false), 6, DEFAULT_URN_QUERY, "", set, set2, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createRequery(String string) {
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        return new QueryRequest(QueryRequest.newQueryGUID(true), string);
    }

    public static QueryRequest createQuery(String string) {
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        return new QueryRequest(QueryRequest.newQueryGUID(false), string);
    }

    public static QueryRequest createOutOfBandQuery(byte[] byArray, String string, String string2) {
        string = I18NConvert.instance().getNorm(string);
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string2 == null) {
            throw new NullPointerException("null xml query");
        }
        if (string.length() == 0 && string2.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (string2.length() != 0 && !string2.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return new QueryRequest(byArray, 6, string, string2, true);
    }

    public static QueryRequest createOutOfBandQuery(byte[] byArray, String string, String string2, MediaType mediaType) {
        string = I18NConvert.instance().getNorm(string);
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string2 == null) {
            throw new NullPointerException("null xml query");
        }
        if (string.length() == 0 && string2.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (string2.length() != 0 && !string2.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return new QueryRequest(byArray, 6, string, string2, true, mediaType);
    }

    public static QueryRequest createOutOfBandQuery(String string, byte[] byArray, int n) {
        byte[] byArray2 = GUID.makeAddressEncodedGuid(byArray, n);
        return QueryRequest.createOutOfBandQuery(byArray2, string, "");
    }

    public static QueryRequest createWhatIsNewQuery(byte[] byArray, byte by) {
        return QueryRequest.createWhatIsNewQuery(byArray, by, null);
    }

    public static QueryRequest createWhatIsNewQuery(byte[] byArray, byte by, MediaType mediaType) {
        if (by < 1) {
            throw new IllegalArgumentException("Bad TTL.");
        }
        return new QueryRequest(byArray, by, WHAT_IS_NEW_QUERY_STRING, "", null, null, null, !RouterService.acceptedIncomingConnection(), -1, false, WHAT_IS_NEW_GGEP_VALUE, false, QueryRequest.getMetaFlag(mediaType));
    }

    public static QueryRequest createWhatIsNewOOBQuery(byte[] byArray, byte by) {
        return QueryRequest.createWhatIsNewOOBQuery(byArray, by, null);
    }

    public static QueryRequest createWhatIsNewOOBQuery(byte[] byArray, byte by, MediaType mediaType) {
        if (by < 1) {
            throw new IllegalArgumentException("Bad TTL.");
        }
        return new QueryRequest(byArray, by, WHAT_IS_NEW_QUERY_STRING, "", null, null, null, !RouterService.acceptedIncomingConnection(), -1, true, WHAT_IS_NEW_GGEP_VALUE, false, QueryRequest.getMetaFlag(mediaType));
    }

    public static QueryRequest createQuery(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string2 == null) {
            throw new NullPointerException("null xml query");
        }
        if (string.length() == 0 && string2.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (string2.length() != 0 && !string2.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return new QueryRequest(QueryRequest.newQueryGUID(false), string, string2);
    }

    public static QueryRequest createQuery(String string, byte by) {
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (by <= 0 || by > 6) {
            throw new IllegalArgumentException("invalid TTL: " + by);
        }
        return new QueryRequest(QueryRequest.newQueryGUID(false), by, string);
    }

    public static QueryRequest createQuery(byte[] byArray, String string, String string2) {
        string = I18NConvert.instance().getNorm(string);
        if (byArray == null) {
            throw new NullPointerException("null guid");
        }
        if (byArray.length != 16) {
            throw new IllegalArgumentException("invalid guid length");
        }
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string2 == null) {
            throw new NullPointerException("null xml query");
        }
        if (string.length() == 0 && string2.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (string2.length() != 0 && !string2.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return new QueryRequest(byArray, string, string2);
    }

    public static QueryRequest createQuery(byte[] byArray, String string, String string2, MediaType mediaType) {
        string = I18NConvert.instance().getNorm(string);
        if (byArray == null) {
            throw new NullPointerException("null guid");
        }
        if (byArray.length != 16) {
            throw new IllegalArgumentException("invalid guid length");
        }
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string2 == null) {
            throw new NullPointerException("null xml query");
        }
        if (string.length() == 0 && string2.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (string2.length() != 0 && !string2.startsWith("<?xml")) {
            throw new IllegalArgumentException("invalid XML");
        }
        return new QueryRequest(byArray, 6, string, string2, mediaType);
    }

    public static QueryRequest createQuery(QueryRequest queryRequest, byte by) {
        return new QueryRequest(queryRequest.getGUID(), by, queryRequest.getQuery(), queryRequest.getRichQueryString(), queryRequest.getRequestedUrnTypes(), queryRequest.getQueryUrns(), queryRequest.getQueryKey(), queryRequest.isFirewalledSource(), queryRequest.getNetwork(), queryRequest.desiresOutOfBandReplies(), queryRequest.getCapabilitySelector(), queryRequest.doNotProxy(), queryRequest.getMetaMask());
    }

    public static QueryRequest createProxyQuery(QueryRequest queryRequest, byte[] byArray) {
        if (byArray.length != 16) {
            throw new IllegalArgumentException("bad guid size: " + byArray.length);
        }
        byte[] byArray2 = new byte[queryRequest.PAYLOAD.length];
        System.arraycopy(queryRequest.PAYLOAD, 0, byArray2, 0, byArray2.length);
        byArray2[0] = (byte)(byArray2[0] | 4);
        try {
            return QueryRequest.createNetworkQuery(byArray, queryRequest.getTTL(), queryRequest.getHops(), byArray2, queryRequest.getNetwork());
        }
        catch (BadPacketException badPacketException) {
            throw new IllegalArgumentException("Input QR was bad!");
        }
    }

    public static QueryRequest unmarkOOBQuery(QueryRequest queryRequest) {
        return new QueryRequest(queryRequest.getGUID(), queryRequest.getTTL(), queryRequest.getQuery(), queryRequest.getRichQueryString(), queryRequest.getRequestedUrnTypes(), queryRequest.getQueryUrns(), queryRequest.getQueryKey(), queryRequest.isFirewalledSource(), queryRequest.getNetwork(), false, queryRequest.getCapabilitySelector(), queryRequest.doNotProxy(), queryRequest.getMetaMask());
    }

    public static QueryRequest createQueryKeyQuery(String string, QueryKey queryKey) {
        if (string == null) {
            throw new NullPointerException("null query");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("empty query");
        }
        if (queryKey == null) {
            throw new NullPointerException("null query key");
        }
        return new QueryRequest(QueryRequest.newQueryGUID(false), 1, string, "", UrnType.ANY_TYPE_SET, EMPTY_SET, queryKey, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createQueryKeyQuery(URN uRN, QueryKey queryKey) {
        if (uRN == null) {
            throw new NullPointerException("null sha1");
        }
        if (queryKey == null) {
            throw new NullPointerException("null query key");
        }
        HashSet hashSet = new HashSet();
        hashSet.add((Object)uRN);
        return new QueryRequest(QueryRequest.newQueryGUID(false), 1, DEFAULT_URN_QUERY, "", UrnType.SHA1_SET, (Set)hashSet, queryKey, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    public static QueryRequest createMulticastQuery(QueryRequest queryRequest) {
        if (queryRequest == null) {
            throw new NullPointerException("null query");
        }
        QueryRequest queryRequest2 = new QueryRequest(queryRequest.getGUID(), 1, queryRequest.getQuery(), queryRequest.getRichQueryString(), queryRequest.getRequestedUrnTypes(), queryRequest.getQueryUrns(), queryRequest.getQueryKey(), false, 3, false, queryRequest.getCapabilitySelector(), false, 0);
        queryRequest2.setHops(queryRequest.getHops());
        return queryRequest2;
    }

    public static QueryRequest createQueryKeyQuery(QueryRequest queryRequest, QueryKey queryKey) {
        return new QueryRequest(queryRequest.getGUID(), queryRequest.getTTL(), queryRequest.getQuery(), queryRequest.getRichQueryString(), queryRequest.getRequestedUrnTypes(), queryRequest.getQueryUrns(), queryKey, queryRequest.isFirewalledSource(), -1, queryRequest.desiresOutOfBandReplies(), queryRequest.getCapabilitySelector(), false, queryRequest.getMetaMask());
    }

    public static QueryRequest createBrowseHostQuery() {
        return new QueryRequest(QueryRequest.newQueryGUID(false), 1, "    ", "", UrnType.ANY_TYPE_SET, EMPTY_SET, null, false, -1, false, 0, false, 0);
    }

    public static QueryRequest createNonFirewalledQuery(String string, byte by) {
        return new QueryRequest(QueryRequest.newQueryGUID(false), by, string, "", UrnType.ANY_TYPE_SET, EMPTY_SET, null, false, -1, false, 0, false, 0);
    }

    public static QueryRequest createNetworkQuery(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
        return new QueryRequest(byArray, by, by2, byArray2, n);
    }

    private QueryRequest(byte[] byArray, String string) {
        this(byArray, string, "");
    }

    private QueryRequest(byte[] byArray, byte by, String string) {
        this(byArray, by, string, "");
    }

    private QueryRequest(byte[] byArray, String string, String string2) {
        this(byArray, 6, string, string2);
    }

    private QueryRequest(byte[] byArray, byte by, String string, String string2) {
        this(byArray, by, string, string2, UrnType.ANY_TYPE_SET, EMPTY_SET, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, 0);
    }

    private QueryRequest(byte[] byArray, byte by, String string, String string2, MediaType mediaType) {
        this(byArray, by, string, string2, UrnType.ANY_TYPE_SET, EMPTY_SET, null, !RouterService.acceptedIncomingConnection(), -1, false, 0, false, QueryRequest.getMetaFlag(mediaType));
    }

    private QueryRequest(byte[] byArray, byte by, String string, String string2, boolean bl) {
        this(byArray, by, string, string2, UrnType.ANY_TYPE_SET, EMPTY_SET, null, !RouterService.acceptedIncomingConnection(), -1, bl, 0, false, 0);
    }

    private QueryRequest(byte[] byArray, byte by, String string, String string2, boolean bl, MediaType mediaType) {
        this(byArray, by, string, string2, UrnType.ANY_TYPE_SET, EMPTY_SET, null, !RouterService.acceptedIncomingConnection(), -1, bl, 0, false, QueryRequest.getMetaFlag(mediaType));
    }

    private static int getMetaFlag(MediaType mediaType) {
        int n = 0;
        if (mediaType != null) {
            if (mediaType.getDescriptionKey() == "MEDIA_AUDIO") {
                n |= 4;
            } else if (mediaType.getDescriptionKey() == "MEDIA_VIDEO") {
                n |= 8;
            } else if (mediaType.getDescriptionKey() == "MEDIA_IMAGES") {
                n |= 0x20;
            } else if (mediaType.getDescriptionKey() == "MEDIA_DOCUMENTS") {
                n |= 0x10;
            } else if (mediaType.getDescriptionKey() == "MEDIA_PROGRAMS") {
                if (CommonUtils.isLinux() || CommonUtils.isAnyMac()) {
                    n |= 0x80;
                } else if (CommonUtils.isWindows()) {
                    n |= 0x40;
                }
            }
        }
        return n;
    }

    public QueryRequest(byte[] byArray, byte by, String string, String string2, Set set, Set set2, QueryKey queryKey, boolean bl, int n, boolean bl2, int n2) {
        this(byArray, by, string, string2, set, set2, queryKey, bl, n, bl2, n2, false, 0);
    }

    public QueryRequest(byte[] byArray, byte by, String string, String string2, Set set, Set set2, QueryKey queryKey, boolean bl, int n, boolean bl2, int n2, boolean bl3, int n3) {
        super(byArray, (byte)-128, by, (byte)0, 0, n);
        LimeXMLDocument limeXMLDocument;
        if (!(string != null && string.length() != 0 || string2 != null && string2.length() != 0 || set2 != null && set2.size() != 0)) {
            throw new IllegalArgumentException("cannot create empty query");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Bad capability = " + n2);
        }
        this._capabilitySelector = n2;
        if (n3 > 0 && n3 < 4 || n3 > 248) {
            throw new IllegalArgumentException("Bad Meta Flag = " + n3);
        }
        if (n3 > 0) {
            this._metaMask = new Integer(n3);
        }
        int n4 = 128;
        if (bl && !this.isMulticast()) {
            n4 |= 0x40;
        }
        n4 = !bl2 ? (n4 |= 0x20) : (n4 |= 4);
        this.MIN_SPEED = n4;
        this.QUERY = string == null ? "" : string;
        if (string2 == null || string2.equals("")) {
            this.XML_DOC = null;
        } else {
            limeXMLDocument = null;
            try {
                limeXMLDocument = new LimeXMLDocument(string2);
            }
            catch (SAXException sAXException) {
            }
            catch (SchemaNotFoundException schemaNotFoundException) {
            }
            catch (IOException iOException) {}
            this.XML_DOC = limeXMLDocument;
        }
        limeXMLDocument = null;
        Object object = null;
        limeXMLDocument = set != null ? new HashSet((Collection)set) : EMPTY_SET;
        object = set2 != null ? new HashSet((Collection)set2) : EMPTY_SET;
        this.QUERY_KEY = queryKey;
        this._doNotProxy = bl3;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ByteArrayOutputStream byteArrayOutputStream2;
            ByteOrder.short2leb((short)this.MIN_SPEED, byteArrayOutputStream);
            byteArrayOutputStream.write(this.QUERY.getBytes("UTF-8"));
            byteArrayOutputStream.write(0);
            boolean bl4 = false;
            byte[] byArray2 = null;
            if (this.XML_DOC != null) {
                byArray2 = string2.getBytes("UTF-8");
            }
            bl4 = this.writeGemExtension((OutputStream)byteArrayOutputStream, bl4, byArray2);
            bl4 = this.writeGemExtensions(byteArrayOutputStream, bl4, object == null ? null : object.iterator());
            bl4 = this.writeGemExtensions(byteArrayOutputStream, bl4, limeXMLDocument == null ? null : limeXMLDocument.iterator());
            GGEP gGEP = new GGEP(false);
            if (this.QUERY_KEY != null) {
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                this.QUERY_KEY.write(byteArrayOutputStream2);
                gGEP.put("QK", byteArrayOutputStream2.toByteArray());
            }
            if (this._capabilitySelector > 0) {
                gGEP.put("WH", this._capabilitySelector);
            }
            if (bl3) {
                gGEP.put("NP");
            }
            if (this._metaMask != null) {
                gGEP.put("M", this._metaMask);
            }
            if (this.QUERY_KEY != null || this._capabilitySelector > 0 || this._doNotProxy || this._metaMask != null) {
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                gGEP.write(byteArrayOutputStream2);
                bl4 = this.writeGemExtension((OutputStream)byteArrayOutputStream, bl4, byteArrayOutputStream2.toByteArray());
            }
            byteArrayOutputStream.write(0);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("could not get UTF-8 bytes for query :" + this.QUERY + " with richquery :" + string2);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        this.PAYLOAD = byteArrayOutputStream.toByteArray();
        this.updateLength(this.PAYLOAD.length);
        this.QUERY_URNS = Collections.unmodifiableSet((Set)object);
        this.REQUESTED_URN_TYPES = Collections.unmodifiableSet((Set)limeXMLDocument);
    }

    private QueryRequest(byte[] byArray, byte by, byte by2, byte[] byArray2, int n) throws BadPacketException {
        super(byArray, (byte)-128, by, by2, byArray2.length, n);
        Object object;
        if (byArray2 == null) {
            throw new BadPacketException("no payload");
        }
        this.PAYLOAD = byArray2;
        String string = "";
        Object object2 = "";
        int n2 = 0;
        HashSet hashSet = null;
        HashSet hashSet2 = null;
        QueryKey queryKey = null;
        try {
            object = new ByteArrayInputStream(this.PAYLOAD);
            short s = ByteOrder.leb2short((InputStream)object);
            n2 = ByteOrder.ubytes2int(s);
            string = new String(super.readNullTerminatedBytes((InputStream)object), "UTF-8");
            byte[] byArray3 = super.readNullTerminatedBytes((InputStream)object);
            int n3 = 0;
            while (n3 < byArray3.length && byArray3[n3] != 0) {
                Object object3;
                Object object4;
                if (byArray3[n3] == -61) {
                    int[] nArray = new int[]{n3 + 1};
                    try {
                        object4 = new GGEP(byArray3, n3, nArray);
                        if (((GGEP)object4).hasKey("QK")) {
                            object3 = ((GGEP)object4).getBytes("QK");
                            queryKey = QueryKey.getQueryKey(object3, false);
                        }
                        if (((GGEP)object4).hasKey("WH")) {
                            this._capabilitySelector = ((GGEP)object4).getInt("WH");
                        }
                        if (((GGEP)object4).hasKey("NP")) {
                            this._doNotProxy = true;
                        }
                        if (((GGEP)object4).hasKey("M")) {
                            this._metaMask = new Integer(((GGEP)object4).getInt("M"));
                            if (this._metaMask < 4 || this._metaMask > 248) {
                                this._metaMask = null;
                            }
                        }
                    }
                    catch (BadGGEPBlockException badGGEPBlockException) {
                    }
                    catch (BadGGEPPropertyException badGGEPPropertyException) {}
                    n3 = nArray[0];
                    continue;
                }
                int n4 = n3;
                while (n4 < byArray3.length && byArray3[n4] != 28) {
                    ++n4;
                }
                if (n4 <= byArray3.length) {
                    object4 = new String(byArray3, n3, n4 - n3, "UTF-8");
                    if (URN.isUrn((String)object4)) {
                        object3 = null;
                        try {
                            object3 = URN.createSHA1Urn((String)object4);
                        }
                        catch (IOException iOException) {
                            continue;
                        }
                        if (hashSet == null) {
                            hashSet = new HashSet();
                        }
                        hashSet.add(object3);
                    } else if (UrnType.isSupportedUrnType((String)object4)) {
                        if (hashSet2 == null) {
                            hashSet2 = new HashSet();
                        }
                        if (UrnType.isSupportedUrnType((String)object4)) {
                            hashSet2.add((Object)UrnType.createUrnType((String)object4));
                        }
                    } else if (((String)object4).startsWith("<?xml")) {
                        object2 = object4;
                    }
                }
                n3 = n4 + 1;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BadPacketException("encountered UnsupportedEncodingException with data snatched from network");
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        this.QUERY = string;
        object = null;
        try {
            object = new LimeXMLDocument((String)object2);
        }
        catch (SAXException sAXException) {
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
        }
        catch (IOException iOException) {}
        this.XML_DOC = object;
        this.MIN_SPEED = n2;
        this.QUERY_URNS = hashSet == null ? EMPTY_SET : Collections.unmodifiableSet(hashSet);
        this.REQUESTED_URN_TYPES = hashSet2 == null ? EMPTY_SET : Collections.unmodifiableSet(hashSet2);
        this.QUERY_KEY = queryKey;
        if (this.QUERY.length() == 0 && ((String)object2).length() == 0 && this.QUERY_URNS.size() == 0) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.QUERY_EMPTY.incrementStat();
            }
            throw new BadPacketException("empty query");
        }
        if (this.QUERY.length() > MAX_QUERY_LENGTH) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.QUERY_TOO_LARGE.incrementStat();
            }
            throw BadPacketException.QUERY_TOO_BIG;
        }
        if (((String)object2).length() > MAX_XML_QUERY_LENGTH) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.QUERY_XML_TOO_LARGE.incrementStat();
            }
            throw BadPacketException.XML_QUERY_TOO_BIG;
        }
        if ((this.QUERY_URNS.size() <= 0 || !this.QUERY.equals(DEFAULT_URN_QUERY)) && QueryRequest.hasIllegalChars(this.QUERY)) {
            if (Message.RECORD_STATS) {
                ReceivedErrorStat.QUERY_ILLEGAL_CHARS.incrementStat();
            }
            throw BadPacketException.ILLEGAL_CHAR_IN_QUERY;
        }
    }

    private static boolean hasIllegalChars(String string) {
        char[] cArray = string.toCharArray();
        Arrays.sort((char[])cArray);
        int n = 0;
        while (n < ILLEGAL_CHARS.length) {
            if (Arrays.binarySearch((char[])cArray, (char)ILLEGAL_CHARS[n]) >= 0) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static byte[] newQueryGUID(boolean bl) {
        return bl ? GUID.makeGuidRequery() : GUID.makeGuid();
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.PAYLOAD);
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(this);
        }
    }

    public byte[] getPayload() {
        return this.PAYLOAD;
    }

    public String getQuery() {
        return this.QUERY;
    }

    public LimeXMLDocument getRichQuery() {
        return this.XML_DOC;
    }

    private String getRichQueryString() {
        if (this.XML_DOC == null) {
            return null;
        }
        try {
            return this.XML_DOC.getXMLString();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            return null;
        }
    }

    public Set getRequestedUrnTypes() {
        return this.REQUESTED_URN_TYPES;
    }

    public Set getQueryUrns() {
        return this.QUERY_URNS;
    }

    public boolean hasQueryUrns() {
        return !this.QUERY_URNS.isEmpty();
    }

    public int getMinSpeed() {
        return this.MIN_SPEED;
    }

    public boolean isFirewalledSource() {
        return !this.isMulticast() && (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 0x40) > 0;
    }

    public boolean desiresXMLResponses() {
        return (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 0x20) > 0;
    }

    public boolean desiresOutOfBandReplies() {
        return (this.MIN_SPEED & 0x80) > 0 && (this.MIN_SPEED & 4) > 0;
    }

    public boolean doNotProxy() {
        return this._doNotProxy;
    }

    public boolean isWhatIsNewRequest() {
        return this._capabilitySelector == WHAT_IS_NEW_GGEP_VALUE;
    }

    public int getCapabilitySelector() {
        return this._capabilitySelector;
    }

    public String getReplyAddress() {
        return new GUID(this.getGUID()).getIP();
    }

    public boolean matchesReplyAddress(byte[] byArray) {
        return new GUID(this.getGUID()).matchesIP(byArray);
    }

    public int getReplyPort() {
        return new GUID(this.getGUID()).getPort();
    }

    public boolean isLimeRequery() {
        return GUID.isLimeRequeryGUID(this.getGUID());
    }

    public QueryKey getQueryKey() {
        return this.QUERY_KEY;
    }

    public boolean desiresAll() {
        return this._metaMask == null;
    }

    public boolean desiresAudio() {
        if (this._metaMask != null) {
            return (this._metaMask & 4) > 0;
        }
        return true;
    }

    public boolean desiresVideo() {
        if (this._metaMask != null) {
            return (this._metaMask & 8) > 0;
        }
        return true;
    }

    public boolean desiresDocuments() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x10) > 0;
        }
        return true;
    }

    public boolean desiresImages() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x20) > 0;
        }
        return true;
    }

    public boolean desiresWindowsPrograms() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x40) > 0;
        }
        return true;
    }

    public boolean desiresLinuxOSXPrograms() {
        if (this._metaMask != null) {
            return (this._metaMask & 0x80) > 0;
        }
        return true;
    }

    private int getMetaMask() {
        if (this._metaMask != null) {
            return this._metaMask;
        }
        return 0;
    }

    public void recordDrop() {
        if (Message.RECORD_STATS) {
            DroppedSentMessageStatHandler.TCP_QUERY_REQUESTS.addMessage(this);
        }
    }

    public Message stripExtendedPayload() {
        return this;
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            int n = 17;
            n = 37 * n + this.QUERY.hashCode();
            if (this.XML_DOC != null) {
                n = 37 * n + this.XML_DOC.hashCode();
            }
            n = 37 * n + this.REQUESTED_URN_TYPES.hashCode();
            n = 37 * n + this.QUERY_URNS.hashCode();
            if (this.QUERY_KEY != null) {
                n = 37 * n + this.QUERY_KEY.hashCode();
            }
            this._hashCode = n;
        }
        return this._hashCode;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof QueryRequest)) {
            return false;
        }
        QueryRequest queryRequest = (QueryRequest)object;
        return this.MIN_SPEED == queryRequest.MIN_SPEED && this.QUERY.equals(queryRequest.QUERY) && (this.XML_DOC == null ? queryRequest.XML_DOC == null : this.XML_DOC.equals(queryRequest.XML_DOC)) && this.REQUESTED_URN_TYPES.equals((Object)queryRequest.REQUESTED_URN_TYPES) && this.QUERY_URNS.equals((Object)queryRequest.QUERY_URNS) && Arrays.equals((byte[])this.getGUID(), (byte[])queryRequest.getGUID()) && Arrays.equals((byte[])this.PAYLOAD, (byte[])queryRequest.PAYLOAD);
    }

    public String toString() {
        return "<query: \"" + this.getQuery() + "\", " + "ttl: " + this.getTTL() + ", " + "hops: " + this.getHops() + ", " + "meta: \"" + this.getRichQueryString() + "\", " + "types: " + this.getRequestedUrnTypes().size() + "," + "urns: " + this.getQueryUrns().size() + ">";
    }
}

