/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class CapabilitiesVM
extends VendorMessage {
    private static final byte[] CAPABILITY_BYTES = new byte[]{87, 72, 65, 84};
    public static final int CAPABILITY_MAX_SELECTOR = 1;
    public static final int CAPABILITY_MIN_SELECTOR = 1;
    public static final int VERSION = 0;
    private final Set _capabilitiesSupported = new HashSet();
    private static CapabilitiesVM _instance;

    CapabilitiesVM(byte[] byArray, byte by, byte by2, int n, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, VendorMessage.F_NULL_VENDOR_ID, 10, n, byArray2);
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.getPayload());
            int n2 = ByteOrder.ubytes2int(ByteOrder.leb2short(byteArrayInputStream));
            int n3 = 0;
            while (n3 < n2) {
                this._capabilitiesSupported.add((Object)new SupportedMessageBlock(byteArrayInputStream));
                ++n3;
            }
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
    }

    private CapabilitiesVM() {
        super(VendorMessage.F_NULL_VENDOR_ID, 10, 0, CapabilitiesVM.derivePayload());
        CapabilitiesVM.addSupportedMessages(this._capabilitiesSupported);
    }

    private static byte[] derivePayload() {
        HashSet hashSet = new HashSet();
        CapabilitiesVM.addSupportedMessages((Set)hashSet);
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteOrder.short2leb((short)hashSet.size(), byteArrayOutputStream);
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                SupportedMessageBlock supportedMessageBlock = (SupportedMessageBlock)iterator.next();
                supportedMessageBlock.encode(byteArrayOutputStream);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
            return null;
        }
    }

    private static void addSupportedMessages(Set set) {
        SupportedMessageBlock supportedMessageBlock = null;
        supportedMessageBlock = new SupportedMessageBlock(CAPABILITY_BYTES, 1);
        set.add((Object)supportedMessageBlock);
    }

    public static CapabilitiesVM instance() {
        if (_instance == null) {
            _instance = new CapabilitiesVM();
        }
        return _instance;
    }

    public int supportsCapability(byte[] byArray) {
        Iterator iterator = this._capabilitiesSupported.iterator();
        while (iterator.hasNext()) {
            SupportedMessageBlock supportedMessageBlock = (SupportedMessageBlock)iterator.next();
            int n = supportedMessageBlock.matches(byArray);
            if (n <= -1) continue;
            return n;
        }
        return -1;
    }

    public int supportsCapabilityQueries() {
        return this.supportsCapability(CAPABILITY_BYTES);
    }

    public boolean supportsWhatIsNew() {
        return this.supportsCapabilityQueries() > 0;
    }

    public boolean equals(Object object) {
        if (object instanceof CapabilitiesVM) {
            CapabilitiesVM capabilitiesVM = (CapabilitiesVM)object;
            return this._capabilitiesSupported.equals((Object)capabilitiesVM._capabilitiesSupported);
        }
        return false;
    }

    public int hashCode() {
        return 17 * this._capabilitiesSupported.hashCode();
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
        if (Message.RECORD_STATS) {
            SentMessageStatHandler.TCP_MESSAGES_SUPPORTED.addMessage(this);
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }

    static class SupportedMessageBlock {
        final byte[] _capabilityName;
        final int _version;
        final int _hashCode;

        public SupportedMessageBlock(byte[] byArray, int n) {
            this._capabilityName = byArray;
            this._version = n;
            this._hashCode = SupportedMessageBlock.computeHashCode(this._capabilityName, this._version);
        }

        public SupportedMessageBlock(InputStream inputStream) throws BadPacketException, IOException {
            if (inputStream.available() < 6) {
                throw new BadPacketException("invalid block.");
            }
            this._capabilityName = new byte[4];
            inputStream.read(this._capabilityName, 0, this._capabilityName.length);
            this._version = ByteOrder.ubytes2int(ByteOrder.leb2short(inputStream));
            this._hashCode = SupportedMessageBlock.computeHashCode(this._capabilityName, this._version);
        }

        public void encode(OutputStream outputStream) throws IOException {
            outputStream.write(this._capabilityName);
            ByteOrder.short2leb((short)this._version, outputStream);
        }

        public int matches(byte[] byArray) {
            if (Arrays.equals((byte[])this._capabilityName, (byte[])byArray)) {
                return this._version;
            }
            return -1;
        }

        public boolean equals(Object object) {
            if (object instanceof SupportedMessageBlock) {
                SupportedMessageBlock supportedMessageBlock = (SupportedMessageBlock)object;
                return this._version == supportedMessageBlock._version && Arrays.equals((byte[])this._capabilityName, (byte[])supportedMessageBlock._capabilityName);
            }
            return false;
        }

        public int hashCode() {
            return this._hashCode;
        }

        private static int computeHashCode(byte[] byArray, int n) {
            int n2 = 0;
            n2 += 37 * n;
            int n3 = 0;
            while (n3 < byArray.length) {
                n2 += 37 * byArray[n3];
                ++n3;
            }
            return n2;
        }
    }
}

