/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.statistics.SentMessageStatHandler;
import java.io.IOException;
import java.io.OutputStream;

public class GiveStatsVendorMessage
extends VendorMessage {
    public static final int VERSION = 1;
    public static final byte GNUTELLA_INCOMING_TRAFFIC = 0;
    public static final byte GNUTELLA_OUTGOING_TRAFFIC = 1;
    public static final byte HTTP_DOWNLOAD_TRAFFIC_STATS = 2;
    public static final byte HTTP_UPLOAD_TRAFFIC_STATS = 3;
    public static final byte PER_CONNECTION_STATS = 0;
    public static final byte ALL_CONNECTIONS_STATS = 1;
    public static final byte LEAF_CONNECTIONS_STATS = 2;
    public static final byte UP_CONNECTIONS_STATS = 3;

    GiveStatsVendorMessage(byte[] byArray, byte by, byte by2, int n, byte[] byArray2, int n2) throws BadPacketException {
        super(byArray, by, by2, VendorMessage.F_LIME_VENDOR_ID, 14, n, byArray2, n2);
        if (this.getPayload().length < 2) {
            throw new BadPacketException("INVALID PAYLOAD LENGTH: " + byArray2.length);
        }
        if (n == 1 && this.getPayload().length != 2) {
            throw new BadPacketException("UNSUPPORTED PAYLOAD LENGTH: " + byArray2.length);
        }
    }

    public GiveStatsVendorMessage(byte by, byte by2, int n) {
        super(VendorMessage.F_LIME_VENDOR_ID, 14, 1, GiveStatsVendorMessage.derivePayload(by, by2), n);
    }

    private static byte[] derivePayload(byte by, byte by2) {
        if (by < 0 || by > 3) {
            throw new IllegalArgumentException(" invalid control byte ");
        }
        if (by2 < 0 || by2 > 3) {
            throw new IllegalArgumentException(" invalid stat type ");
        }
        byte[] byArray = new byte[]{by, by2};
        return byArray;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        super.writePayload(outputStream);
        if (Message.RECORD_STATS) {
            if (this.isTCP()) {
                SentMessageStatHandler.TCP_GIVE_STATS.addMessage(this);
            } else if (this.isUDP()) {
                SentMessageStatHandler.UDP_GIVE_STATS.addMessage(this);
            }
        }
    }

    public void recordDrop() {
        super.recordDrop();
    }

    protected byte getStatControl() {
        byte[] byArray = this.getPayload();
        return byArray[0];
    }

    protected byte getStatType() {
        byte[] byArray = this.getPayload();
        return byArray[1];
    }
}

