/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.ResetTableMessage;
import java.io.IOException;
import java.io.OutputStream;

public abstract class RouteTableMessage
extends Message {
    public static final byte RESET_VARIANT = 0;
    public static final byte PATCH_VARIANT = 1;
    private byte variant;

    protected RouteTableMessage(byte by, int n, byte by2) {
        super((byte)48, by, n);
        this.variant = by2;
    }

    protected void writePayload(OutputStream outputStream) throws IOException {
        outputStream.write(this.variant);
        this.writePayloadData(outputStream);
    }

    protected abstract void writePayloadData(OutputStream var1) throws IOException;

    public static RouteTableMessage read(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        if (byArray2.length < 2) {
            throw new BadPacketException("Payload too small");
        }
        byte by3 = byArray2[0];
        switch (by3) {
            case 0: {
                return new ResetTableMessage(byArray, by, by2, byArray2);
            }
            case 1: {
                return new PatchTableMessage(byArray, by, by2, byArray2);
            }
        }
        throw new BadPacketException("Unknown table variant");
    }

    protected RouteTableMessage(byte[] byArray, byte by, byte by2, int n, byte by3) {
        super(byArray, (byte)48, by, by2, n);
        this.variant = by3;
    }

    public byte getVariant() {
        return this.variant;
    }

    public Message stripExtendedPayload() {
        return this;
    }
}

