/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Set;

public final class HostData {
    private final byte[] CLIENT_GUID;
    private final byte[] MESSAGE_GUID;
    private final int SPEED;
    private final boolean FIREWALLED;
    private final boolean BUSY;
    private final boolean MULTICAST;
    private final boolean CHAT_ENABLED;
    private final boolean BROWSE_HOST_ENABLED;
    private final boolean MEASURED_SPEED;
    private final int PORT;
    private final String IP;
    private final int QUALITY;
    private final String VENDOR_CODE;
    private final Set PROXIES;

    public HostData(QueryReply queryReply) {
        this.CLIENT_GUID = queryReply.getClientGUID();
        this.MESSAGE_GUID = queryReply.getGUID();
        this.IP = queryReply.getIP();
        this.PORT = queryReply.getPort();
        boolean bl = true;
        boolean bl2 = true;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        String string = "";
        try {
            bl = queryReply.getNeedsPush() || NetworkUtils.isPrivateAddress(this.IP);
        }
        catch (BadPacketException badPacketException) {
            bl = true;
        }
        try {
            bl3 = queryReply.getSupportsBrowseHost();
        }
        catch (BadPacketException badPacketException) {
            bl3 = false;
        }
        try {
            bl4 = queryReply.getSupportsChat() && !bl;
        }
        catch (BadPacketException badPacketException) {
            bl4 = false;
        }
        try {
            bl5 = queryReply.getIsMeasuredSpeed();
        }
        catch (BadPacketException badPacketException) {
            bl5 = false;
        }
        try {
            bl2 = queryReply.getIsBusy();
        }
        catch (BadPacketException badPacketException) {
            bl2 = true;
        }
        try {
            bl6 = queryReply.isReplyToMulticastQuery();
        }
        catch (BadPacketException badPacketException) {
            bl6 = false;
        }
        try {
            string = queryReply.getVendor();
        }
        catch (BadPacketException badPacketException) {}
        this.FIREWALLED = bl && !bl6;
        this.BUSY = bl2;
        this.BROWSE_HOST_ENABLED = bl3;
        this.CHAT_ENABLED = bl4;
        this.MEASURED_SPEED = bl5 || bl6;
        this.MULTICAST = bl6;
        this.VENDOR_CODE = string;
        boolean bl7 = !RouterService.acceptedIncomingConnection();
        this.QUALITY = queryReply.calculateQualityOfService(bl7);
        this.PROXIES = queryReply.getPushProxies();
        this.SPEED = bl6 ? Integer.MAX_VALUE : ByteOrder.long2int(queryReply.getSpeed());
    }

    public byte[] getClientGUID() {
        return this.CLIENT_GUID;
    }

    public String getVendorCode() {
        return this.VENDOR_CODE;
    }

    public byte[] getMessageGUID() {
        return this.MESSAGE_GUID;
    }

    public int getSpeed() {
        return this.SPEED;
    }

    public int getQuality() {
        return this.QUALITY;
    }

    public String getIP() {
        return this.IP;
    }

    public int getPort() {
        return this.PORT;
    }

    public boolean isFirewalled() {
        return this.FIREWALLED;
    }

    public boolean isBusy() {
        return this.BUSY;
    }

    public boolean isBrowseHostEnabled() {
        return this.BROWSE_HOST_ENABLED;
    }

    public boolean isChatEnabled() {
        return this.CHAT_ENABLED;
    }

    public boolean isMeasuredSpeed() {
        return this.MEASURED_SPEED;
    }

    public boolean isReplyToMulticastQuery() {
        return this.MULTICAST;
    }

    public Set getPushProxies() {
        return this.PROXIES;
    }
}

