/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.bitzi.util.Base32;
import com.limegroup.gnutella.dime.DIMEGenerator;
import com.limegroup.gnutella.dime.DIMEParser;
import com.limegroup.gnutella.dime.DIMERecord;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.UUID;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class HashTreeHandler {
    private static final Log LOG;
    private static final String OUTPUT_TYPE = "application/dime";
    private static final String SERIALIZED_TREE_TYPE = "http://open-content.net/spec/thex/breadthfirst";
    private static final String XML_TYPE = "text/xml";
    private static final byte[] TREE_TYPE_BYTES;
    private static final byte[] XML_TYPE_BYTES;
    private static final String DIGEST = "http://open-content.net/spec/digest/tiger";
    private static final String DTD_PUBLIC_ID = "-//NET//OPEN-CONTENT//THEX 02//EN";
    private static final String DTD_SYSTEM_ID = "http://open-content.net/spec/thex/thex.dtd";
    private static final String DTD_ENTITY = "<!ELEMENT hashtree (file,digest,serializedtree)><!ELEMENT file EMPTY><!ATTLIST file size CDATA #REQUIRED><!ATTLIST file segmentsize CDATA #REQUIRED><!ELEMENT digest EMPTY><!ATTLIST digest algorithm CDATA #REQUIRED><!ATTLIST digest outputsize CDATA #REQUIRED><!ELEMENT serializedtree EMPTY><!ATTLIST serializedtree depth CDATA #REQUIRED><!ATTLIST serializedtree type CDATA #REQUIRED><!ATTLIST serializedtree uri CDATA #REQUIRED>";
    private static final String SYSTEM_STRING = "SYSTEM";
    private static final String XML_TREE_DESC_START = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE hashtree SYSTEM \"http://open-content.net/spec/thex/thex.dtd\"><hashtree>";
    private static final String XML_TREE_DESC_END = "</hashtree>";
    private static int HASH_SIZE;
    private final DIMEGenerator GENERATOR;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.tigertree.HashTreeHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        TREE_TYPE_BYTES = HashTreeHandler.getBytes(SERIALIZED_TREE_TYPE);
        XML_TYPE_BYTES = HashTreeHandler.getBytes(XML_TYPE);
        HASH_SIZE = 24;
    }

    private static byte[] getBytes(String string) {
        try {
            return string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LOG.debug((Object)string, (Throwable)unsupportedEncodingException);
            return string.getBytes();
        }
    }

    public HashTreeHandler(HashTree hashTree) {
        LOG.trace((Object)"creating HashTreeHandler for sending");
        UUID uUID = UUID.nextUUID();
        this.GENERATOR = new DIMEGenerator();
        this.GENERATOR.add(new XMLRecord(hashTree, uUID));
        this.GENERATOR.add(new TreeRecord(hashTree, uUID));
    }

    public void write(OutputStream outputStream) throws IOException {
        this.GENERATOR.write(outputStream);
    }

    public int getLength() {
        return this.GENERATOR.getLength();
    }

    public String getType() {
        return OUTPUT_TYPE;
    }

    static List read(InputStream inputStream, long l, String string) throws IOException {
        LOG.trace((Object)"creating HashTreeHandler from network");
        DIMEParser dIMEParser = new DIMEParser(inputStream);
        DIMERecord dIMERecord = dIMEParser.nextRecord();
        DIMERecord dIMERecord2 = dIMEParser.nextRecord();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("xml id: [" + dIMERecord.getIdentifier() + "]"));
            LOG.debug((Object)("xml type: [" + dIMERecord.getTypeString() + "]"));
            LOG.debug((Object)("tree id: [" + dIMERecord2.getIdentifier() + "]"));
            LOG.debug((Object)("tree type: [" + dIMERecord2.getTypeString() + "]"));
            LOG.debug((Object)("xml type num: [" + dIMERecord.getTypeId() + "]"));
            LOG.debug((Object)("tree type num: [" + dIMERecord2.getTypeId() + "]"));
        }
        while (dIMEParser.hasNext()) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)"more elements in the dime record.");
            }
            dIMEParser.nextRecord();
        }
        String string2 = new String(dIMERecord.getData(), "UTF-8");
        byte[] byArray = dIMERecord2.getData();
        XMLTreeDescription xMLTreeDescription = new XMLTreeDescription(string2);
        if (!xMLTreeDescription.isValid()) {
            throw new IOException("invalid XMLTreeDescription " + xMLTreeDescription.toString());
        }
        if (xMLTreeDescription.getFileSize() != l) {
            throw new IOException("file size attribute was " + xMLTreeDescription.getFileSize() + " expected " + l);
        }
        HashTreeDescription hashTreeDescription = new HashTreeDescription(byArray);
        if (!Base32.encode(hashTreeDescription.getRoot()).equals(string)) {
            throw new IOException("Root hashes do not match");
        }
        return hashTreeDescription.getAllNodes(l);
    }

    private static class XMLRecord
    extends DIMERecord {
        XMLRecord(HashTree hashTree, UUID uUID) {
            super((byte)16, null, null, XML_TYPE_BYTES, XMLRecord.getXML(hashTree, uUID));
        }

        private static byte[] getXML(HashTree hashTree, UUID uUID) {
            String string = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><!DOCTYPE hashtree SYSTEM \"http://open-content.net/spec/thex/thex.dtd\"><hashtree><file size='" + hashTree.getFileSize() + "' segmentsize='" + 1024 + "'/>" + "<digest algorithm='" + HashTreeHandler.DIGEST + "' outputsize='" + HASH_SIZE + "'/>" + "<serializedtree depth='" + hashTree.getDepth() + "' type='" + HashTreeHandler.SERIALIZED_TREE_TYPE + "' uri='uuid:" + uUID + "'/>" + HashTreeHandler.XML_TREE_DESC_END;
            return HashTreeHandler.getBytes(string);
        }
    }

    private static class TreeRecord
    extends DIMERecord {
        private final HashTree TREE;
        private final int LENGTH;

        TreeRecord(HashTree hashTree, UUID uUID) {
            super((byte)32, null, HashTreeHandler.getBytes("uuid:" + uUID), TREE_TYPE_BYTES, null);
            this.TREE = hashTree;
            this.LENGTH = this.TREE.getNodeCount() * HASH_SIZE;
        }

        public void writeData(OutputStream outputStream) throws IOException {
            Iterator iterator = this.TREE.getAllNodes().iterator();
            while (iterator.hasNext()) {
                Iterator iterator2 = ((List)iterator.next()).iterator();
                while (iterator2.hasNext()) {
                    outputStream.write((byte[])iterator2.next());
                }
            }
            DIMERecord.writePadding(this.getDataLength(), outputStream);
        }

        public int getDataLength() {
            return this.LENGTH;
        }
    }

    private static class XMLTreeDescription {
        private static final int UNKNOWN = 0;
        private static final int VALID = 1;
        private static final int INVALID = 2;
        private int _parsed = 0;
        private long _fileSize = 0L;
        private int _blockSize = 0;
        private String _algorithm = null;
        private int _hashSize = 0;
        private String _serializationType = null;
        private String _uri;
        private String data;

        protected XMLTreeDescription(String string) {
            this.data = string;
        }

        long getFileSize() {
            return this._fileSize;
        }

        String getURI() {
            return this._uri;
        }

        boolean isValid() {
            if (this._parsed == 0) {
                int n = this._parsed = this.parse() ? 1 : 2;
            }
            if (this._parsed == 2) {
                return false;
            }
            if (this._blockSize != 1024) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("unexpected block size: " + this._blockSize));
                }
                return false;
            }
            if (!HashTreeHandler.DIGEST.equals(this._algorithm)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("unsupported digest algorithm: " + this._algorithm));
                }
                return false;
            }
            if (this._hashSize != HASH_SIZE) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("unexpected block size: " + this._blockSize));
                }
                return false;
            }
            if (!HashTreeHandler.SERIALIZED_TREE_TYPE.equals(this._serializationType)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("unexpected serialization type: " + this._serializationType));
                }
                return false;
            }
            return true;
        }

        private boolean parse() {
            int n = this.data.indexOf("system");
            if (n > 0 && n < this.data.indexOf(HashTreeHandler.DTD_SYSTEM_ID)) {
                this.data = String.valueOf(this.data.substring(0, n)) + HashTreeHandler.SYSTEM_STRING + this.data.substring(n + "system".length());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("XMLTreeDescription read: " + this.data));
            }
            DOMParser dOMParser = new DOMParser();
            InputSource inputSource = new InputSource(new StringReader(this.data));
            dOMParser.setEntityResolver((EntityResolver)new Resolver());
            try {
                dOMParser.parse(inputSource);
            }
            catch (IOException iOException) {
                LOG.debug((Object)iOException);
                return false;
            }
            catch (SAXException sAXException) {
                LOG.debug((Object)sAXException);
                return false;
            }
            Document document = dOMParser.getDocument();
            Node node = document.getElementsByTagName("hashtree").item(0);
            if (node == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("couldn't find hashtree element: " + this.data));
                }
                return false;
            }
            NodeList nodeList = node.getChildNodes();
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1) {
                    Element element = (Element)node2;
                    if (element.getTagName().equals("file")) {
                        this.parseFileElement(element);
                    } else if (element.getTagName().equals("digest")) {
                        this.parseDigestElement(element);
                    } else if (element.getTagName().equals("serializedtree")) {
                        this.parseSerializedtreeElement(element);
                    }
                }
                ++n2;
            }
            return true;
        }

        private void parseFileElement(Element element) {
            block5: {
                block4: {
                    try {
                        this._fileSize = Long.parseLong(element.getAttribute("size"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!LOG.isDebugEnabled()) break block4;
                        LOG.debug((Object)("couldn't parse file size: " + element.getNodeValue()), (Throwable)numberFormatException);
                    }
                }
                try {
                    this._blockSize = Integer.parseInt(element.getAttribute("segmentsize"));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOG.isDebugEnabled()) break block5;
                    LOG.debug((Object)("couldn't parse block size: " + element.getNodeValue()), (Throwable)numberFormatException);
                }
            }
        }

        private void parseDigestElement(Element element) {
            block2: {
                this._algorithm = element.getAttribute("algorithm");
                try {
                    this._hashSize = Integer.parseInt(element.getAttribute("outputsize"));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug((Object)("couldn't parse hash size: " + element.getNodeValue()), (Throwable)numberFormatException);
                }
            }
        }

        private void parseSerializedtreeElement(Element element) {
            block2: {
                this._serializationType = element.getAttribute("type");
                this._uri = element.getAttribute("uri");
                try {
                    Integer.parseInt(element.getAttribute("depth"));
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LOG.isDebugEnabled()) break block2;
                    LOG.debug((Object)("couldn't parse depth: " + element.getNodeValue()), (Throwable)numberFormatException);
                }
            }
        }
    }

    private static final class Resolver
    implements EntityResolver {
        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            if (string2.equals(HashTreeHandler.DTD_SYSTEM_ID)) {
                InputSource inputSource = new InputSource(new StringReader(HashTreeHandler.DTD_ENTITY));
                inputSource.setPublicId(HashTreeHandler.DTD_PUBLIC_ID);
                inputSource.setSystemId(HashTreeHandler.DTD_SYSTEM_ID);
                return inputSource;
            }
            if (string == null) {
                throw new SAXException("Can't resolve SYSTEM entity at '" + string2 + "'");
            }
            throw new SAXException("Can't resolve PUBLIC entity '" + string + "' at '" + string2 + "'");
        }
    }

    private static class HashTreeDescription {
        private final byte[] DATA;

        protected HashTreeDescription(byte[] byArray) {
            this.DATA = byArray;
        }

        byte[] getRoot() throws IOException {
            if (this.DATA.length < HASH_SIZE) {
                throw new IOException("invalid data");
            }
            byte[] byArray = new byte[HASH_SIZE];
            System.arraycopy(this.DATA, 0, byArray, 0, HASH_SIZE);
            return byArray;
        }

        List getAllNodes(long l) throws IOException {
            Object object;
            int n = HashTree.calculateDepth(l);
            ArrayList arrayList = new ArrayList();
            byte[] byArray = this.DATA;
            if (byArray.length % HASH_SIZE != 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"illegal size of data field for HashTree");
                }
                throw new IOException("corrupted hash tree detected");
            }
            int n2 = 0;
            while (n2 + HASH_SIZE <= byArray.length) {
                object = new byte[HASH_SIZE];
                System.arraycopy(byArray, n2, object, 0, HASH_SIZE);
                arrayList.add(object);
                n2 += HASH_SIZE;
            }
            Base32.encode(this.getRoot());
            Iterator iterator = arrayList.iterator();
            object = new ArrayList(1);
            Object object2 = null;
            int n3 = 0;
            boolean bl = false;
            ArrayList arrayList2 = new ArrayList(n + 1);
            while (n3 <= n && iterator.hasNext()) {
                String string;
                bl = false;
                byte[] byArray2 = (byte[])iterator.next();
                object.add((Object)byArray2);
                if (object2 == null) {
                    bl = true;
                    ++n3;
                    object2 = object;
                    arrayList2.add(object);
                    object = new ArrayList(2);
                    continue;
                }
                if (object.size() > object2.size() * 2) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"parent");
                        string = "";
                        Iterator iterator2 = object2.iterator();
                        while (iterator2.hasNext()) {
                            string = String.valueOf(string) + Base32.encode((byte[])iterator2.next()) + "; ";
                        }
                        LOG.debug((Object)string);
                        string = "";
                        LOG.debug((Object)"newparent");
                        iterator2 = HashTree.createParentGeneration((List)object);
                        Iterator iterator3 = iterator2.iterator();
                        while (iterator3.hasNext()) {
                            string = String.valueOf(string) + Base32.encode((byte[])iterator3.next()) + "; ";
                        }
                        LOG.debug((Object)string);
                        string = "";
                        LOG.debug((Object)"generation");
                        iterator3 = object.iterator();
                        while (iterator3.hasNext()) {
                            string = String.valueOf(string) + Base32.encode((byte[])iterator3.next()) + "; ";
                        }
                        LOG.debug((Object)string);
                        string = "";
                    }
                    throw new IOException("corrupted hash tree detected");
                }
                if (object.size() != object2.size() * 2 - 1 && object.size() != object2.size() * 2 || !this.isMatching((List)object2, (List)(string = HashTree.createParentGeneration((List)object)))) continue;
                object2 = object;
                arrayList2.add((Object)Collections.unmodifiableList((List)object));
                if (++n3 <= n && iterator.hasNext()) {
                    object = new ArrayList(object2.size() * 2);
                }
                bl = true;
            }
            if (!bl) {
                throw new IOException("corrupted hash tree detected");
            }
            LOG.debug((Object)"Valid hash tree received.");
            return arrayList2;
        }

        private boolean isMatching(List list, List list2) {
            if (list.size() == list2.size()) {
                int n = 0;
                while (n < list.size()) {
                    byte[] byArray;
                    byte[] byArray2 = (byte[])list.get(n);
                    if (!Arrays.equals((byte[])byArray2, (byte[])(byArray = (byte[])list2.get(n)))) {
                        return false;
                    }
                    ++n;
                }
                return true;
            }
            return false;
        }
    }
}

