/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ByteOrder;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2BadFrameException;
import de.vdheide.mp3.ID3v2DecompressionException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class ID3v2Frame {
    public static final byte NO_COMPRESSION = 0;
    public static final byte IS_COMPRESSED = 1;
    public static final byte DO_COMPRESS = 2;
    public static final String ID_INVALID = null;
    private String id = null;
    private boolean tag_alter_preservation = false;
    private boolean file_alter_preservation = false;
    private boolean read_only = false;
    private byte encryption_id = 0;
    private int decompressed_length = 0;
    private boolean compression = false;
    private byte group = 0;
    private boolean uses_unsynch = false;
    private byte[] content;
    private byte[] compressed_content;
    private static final byte FLAG_TAG_ALTER_PRESERVATION = -128;
    private static final byte FLAG_FILE_ALTER_PRESERVATION = 64;
    private static final byte FLAG_READ_ONLY = 32;
    private static final byte FLAG_COMPRESSION = -128;
    private static final byte FLAG_ENCRYPTION = 64;
    private static final byte FLAG_GROUPING = 32;
    private boolean isISOLatin1 = true;
    private final int SMALL_THRESHOLD = 1024;
    private final int BIG_THRESHOLD = 10240;

    public ID3v2Frame(String id, byte[] content, boolean tag_alter_preservation, boolean file_alter_preservation, boolean read_only, byte compression_type, byte encryption_id, byte group, boolean isISOLatin1) throws ID3v2DecompressionException {
        this.id = id;
        ByteArrayOutputStream baos = null;
        try {
            baos = new ByteArrayOutputStream();
            if (id.equals("COMM")) {
                baos.write(0);
                baos.write(0);
                baos.write(0);
                baos.write(0);
            }
            baos.write(isISOLatin1 ? 0 : 1);
            baos.write(content);
            this.content = baos.toByteArray();
        }
        catch (IOException iox) {
            this.content = content;
        }
        this.isISOLatin1 = isISOLatin1;
        this.tag_alter_preservation = tag_alter_preservation;
        this.file_alter_preservation = file_alter_preservation;
        this.read_only = read_only;
        this.compression = compression_type == 2 || compression_type == 1;
        this.encryption_id = encryption_id;
        this.group = group;
        if (compression_type == 2) {
            this.decompressed_length = this.content.length;
            this.compressContent();
        } else if (compression_type == 1) {
            this.compressed_content = content;
            this.decompressContent();
            this.decompressed_length = this.content.length;
        } else {
            this.decompressed_length = this.content.length;
            this.compressed_content = this.content;
        }
    }

    public ID3v2Frame(InputStream in) throws IOException, ID3v2BadFrameException, ID3v2DecompressionException {
        byte[] head = new byte[10];
        try {
            ID3v2.fillBuffer(head, in);
        }
        catch (IOException ioe) {
            this.id = ID_INVALID;
            return;
        }
        if (head[0] == 0) {
            this.id = ID_INVALID;
            return;
        }
        StringBuffer tmp = new StringBuffer(4);
        for (int i = 0; i < 4; ++i) {
            tmp.append((char)(head[i] & 0xFF));
        }
        this.id = tmp.toString();
        byte[] lenBytes = new byte[4];
        System.arraycopy(head, 4, lenBytes, 0, 4);
        long l = ByteOrder.ubytes2long(ByteOrder.beb2int(lenBytes, 0));
        int length = (int)l;
        if ((head[8] & 0xFF & 0xFFFFFF80) > 0) {
            this.tag_alter_preservation = true;
        }
        if ((head[8] & 0xFF & 0x40) > 0) {
            this.file_alter_preservation = true;
        }
        if ((head[8] & 0xFF & 0x20) > 0) {
            this.read_only = true;
        }
        if ((head[9] & 0xFF & 0xFFFFFF80) > 0) {
            this.compression = true;
        }
        boolean encryption = false;
        if ((head[9] & 0xFF & 0x40) > 0) {
            encryption = true;
        }
        boolean grouping = false;
        if ((head[9] & 0xFF & 0x20) > 0) {
            grouping = true;
        }
        if (this.compression) {
            byte[] decomp_byte = new byte[4];
            ID3v2.fillBuffer(decomp_byte, in);
            long dl = ByteOrder.ubytes2long(ByteOrder.beb2int(decomp_byte, 0));
            this.decompressed_length = (int)dl;
            length -= 4;
        }
        if (encryption) {
            this.encryption_id = (byte)in.read();
            --length;
        }
        if (grouping) {
            this.group = (byte)in.read();
            --length;
        } else {
            this.group = 0;
        }
        int extra = in.read();
        boolean bl = this.isISOLatin1 = extra == 0;
        if (--length > 10240) {
            this.id = ID_INVALID;
            return;
        }
        if (length > 1024) {
            try {
                ID3v2.skipData(length, in);
            }
            catch (IOException iox) {
                this.id = ID_INVALID;
                return;
            }
            throw new ID3v2BadFrameException();
        }
        if (length > 0) {
            this.content = new byte[length];
            ID3v2.fillBuffer(this.content, in);
            if (this.compression) {
                this.compressed_content = new byte[this.content.length];
                System.arraycopy(this.content, 0, this.compressed_content, 0, this.content.length);
                this.decompressContent();
            }
        } else {
            this.content = new byte[0];
        }
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public boolean getTagAlterPreservation() {
        return this.tag_alter_preservation;
    }

    public void setTagAlterPreservation(boolean tag_alter_preservation) {
        this.tag_alter_preservation = tag_alter_preservation;
    }

    public boolean getFileAlterPreservation() {
        return this.file_alter_preservation;
    }

    public void setFileAlterPreservation(boolean file_alter_preservation) {
        this.file_alter_preservation = file_alter_preservation;
    }

    public boolean getReadOnly() {
        return this.read_only;
    }

    public void setReadOnly(boolean read_only) {
        this.read_only = read_only;
    }

    public boolean getCompression() {
        return this.compression;
    }

    public void setCompression(boolean compression) {
        this.compression = compression;
    }

    public byte getEncryptionID() {
        return this.encryption_id;
    }

    public void setEncryption(byte encryption_id) {
        this.encryption_id = encryption_id;
    }

    public byte getGroup() {
        return this.group;
    }

    public void setGroup(byte group) {
        this.group = group;
    }

    public int getLength() {
        int length = 10;
        if (this.compression) {
            length += 4;
        }
        if (this.encryption_id != 0) {
            ++length;
        }
        if (this.group != 0) {
            ++length;
        }
        length = this.compression ? (length += this.compressed_content.length) : (length += this.content.length);
        return length;
    }

    public byte[] getContent() {
        return this.content;
    }

    public byte[] getBytes() {
        int length = this.getLength();
        byte[] ret = new byte[length];
        for (int i = 0; i < 4; ++i) {
            ret[i] = this.id.length() < i - 1 ? (byte)0 : (byte)this.id.charAt(i);
        }
        byte[] size_byte = new byte[4];
        ByteOrder.int2beb(length - 10, size_byte, 0);
        System.arraycopy(size_byte, 0, ret, 4, 4);
        int flag1 = 0;
        if (this.tag_alter_preservation) {
            flag1 = (byte)(flag1 | 0xFFFFFF80);
        }
        if (this.file_alter_preservation) {
            flag1 = (byte)(flag1 + (byte)(flag1 | 0x40));
        }
        if (this.read_only) {
            flag1 = (byte)(flag1 + (byte)(flag1 | 0x20));
        }
        ret[8] = flag1;
        int flag2 = 0;
        if (this.compression) {
            flag2 = (byte)(flag2 + (byte)(flag2 | 0xFFFFFF80));
        }
        if (this.encryption_id != 0) {
            flag2 = (byte)(flag2 + (byte)(flag2 | 0x40));
        }
        if (this.group > 0) {
            flag2 = (byte)(flag2 + (byte)(flag2 | 0x20));
        }
        ret[9] = flag2;
        int content_offset = 10;
        if (this.compression) {
            byte[] decomp_byte = new byte[4];
            ByteOrder.int2beb(length, decomp_byte, 0);
            System.arraycopy(decomp_byte, 0, ret, content_offset, 4);
            content_offset = (short)(content_offset + 4);
        }
        if (this.encryption_id != 0) {
            ret[content_offset] = this.encryption_id;
            content_offset = (short)(content_offset + 1);
        }
        if (this.group > 0) {
            ret[content_offset] = this.group;
            content_offset = (short)(content_offset + 1);
        }
        if (this.compression) {
            this.compressContent();
            System.arraycopy(this.compressed_content, 0, ret, content_offset, this.compressed_content.length);
        } else {
            System.arraycopy(this.content, 0, ret, content_offset, this.content.length);
        }
        return ret;
    }

    public boolean isISOLatin1() {
        return this.isISOLatin1;
    }

    public boolean isUnicode() {
        return !this.isISOLatin1();
    }

    private void compressContent() {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gout = new GZIPOutputStream(bout);
            gout.write(this.content, 0, this.content.length);
            gout.close();
            this.compressed_content = bout.toByteArray();
            if (this.content.length <= this.compressed_content.length) {
                this.compression = false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void decompressContent() throws ID3v2DecompressionException {
        ByteArrayInputStream bin = new ByteArrayInputStream(this.compressed_content);
        try {
            GZIPInputStream gin = new GZIPInputStream(bin);
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int res = 0;
            while ((res = gin.read()) != -1) {
                bout.write(res);
            }
            this.content = bout.toByteArray();
        }
        catch (IOException e) {
            throw new ID3v2DecompressionException();
        }
    }

    public boolean equals(Object o) {
        ID3v2Frame other = (ID3v2Frame)o;
        return other.getID().equals(this.getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }
}

