/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.protocols;

import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.keys.KeyRecord;
import org.logi.crypto.protocols.CryptoProtocolException;
import org.logi.crypto.protocols.NoninterKeyExServer;
import org.logi.crypto.protocols.SendHashKeyEx;

public class SendHashKeyExServer
extends SendHashKeyEx
implements NoninterKeyExServer {
    public byte[] message(byte[] byArray) throws CryptoProtocolException {
        try {
            if (byArray == null) {
                throw new CryptoProtocolException("A KeyExServer should never send the first message.");
            }
            try {
                KeyRecord keyRecord = keySource.byFingerprint((Fingerprint)Crypto.fromString(new String(byArray)));
                if (keyRecord == null) {
                    throw new CryptoProtocolException("No Key matching the specified Fingerprint found in keySource.");
                }
                this.sessionKey = keyRecord.getKey();
                this.keyDecided = true;
                return null;
            }
            catch (InvalidCDSException invalidCDSException) {
                throw new CryptoProtocolException("A CDS for a Fingerprint object expected.");
            }
            catch (ClassCastException classCastException) {
                throw new CryptoProtocolException("A CDS for a Fingerprint object expected.");
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new CryptoProtocolException("Malformed message.");
        }
    }

    public SendHashKeyExServer() {
        super(null);
    }
}

