/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation;

import java.io.File;
import java.util.Vector;

public final class NSRuntime {
    private static boolean _initDone = false;
    private static final String _osType = System.getProperty("os.name");
    private static final String _fileSeparator = System.getProperties().getProperty("file.separator");
    private static final String _libraryPrefix = "lib";
    private static final String _librarySuffix = ".dylib";
    private static String[] _searchPaths = null;
    private static Vector _loadedLibraries = new Vector(4);

    private static native String[] initialSearchPaths();

    private NSRuntime() {
    }

    private static boolean isAbsolutePath(String string) {
        return string.startsWith(_fileSeparator);
    }

    private static String tail(String string) {
        return string.substring(string.lastIndexOf(_fileSeparator) + 1, string.length());
    }

    private static String stripFixes(String string) {
        int n = 0;
        int n2 = string.length();
        if (string.startsWith(_libraryPrefix)) {
            n += _libraryPrefix.length();
        }
        if (string.endsWith(_librarySuffix)) {
            n2 -= _librarySuffix.length();
        }
        return string.substring(n, n2);
    }

    public static native String nextRootPath();

    public static String[] librarySearchPaths() {
        return _searchPaths;
    }

    public static void addPathToLibrarySearchPaths(String string) {
        if (string == null) {
            return;
        }
        if (!string.endsWith(_fileSeparator)) {
            string = string + _fileSeparator;
        }
        String[] stringArray = new String[_searchPaths.length + 1];
        stringArray[0] = string;
        System.arraycopy(_searchPaths, 0, stringArray, 1, _searchPaths.length);
        _searchPaths = stringArray;
    }

    private static native void initializeObjcLibrary(String var0, String var1);

    public static void loadLibrary(String string) {
        try {
            boolean bl = false;
            String string2 = NSRuntime.tail(string);
            String string3 = NSRuntime.stripFixes(string2);
            String string4 = null;
            if (string3.equals(string2)) {
                string2 = _libraryPrefix + string3 + _librarySuffix;
            }
            Vector vector = _loadedLibraries;
            synchronized (vector) {
                if (!_loadedLibraries.contains(string3)) {
                    if (NSRuntime.isAbsolutePath(string)) {
                        System.load(string);
                        string4 = string;
                    } else {
                        int n = _searchPaths.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String string5 = _searchPaths[n2] + string2;
                            File file = new File(string5);
                            if (file.exists()) {
                                System.load(string5);
                                string4 = string5;
                                break;
                            }
                            ++n2;
                        }
                    }
                    if (string4 == null) {
                        System.loadLibrary(string3);
                    }
                    _loadedLibraries.addElement(string3);
                    NSRuntime.initializeObjcLibrary(string3, string4);
                }
            }
        }
        catch (Throwable throwable) {
            System.err.println("NSRuntime.loadLibrary(" + string + ") error.");
            throwable.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    static {
        try {
            NSRuntime.loadLibrary("/usr/lib/java/libObjCJava.dylib");
            _searchPaths = NSRuntime.initialSearchPaths();
            int n = _searchPaths.length;
            int n2 = 0;
            while (n2 < n) {
                if (!_searchPaths[n2].endsWith(_fileSeparator)) {
                    NSRuntime._searchPaths[n2] = _searchPaths[n2] + _fileSeparator;
                }
                ++n2;
            }
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("NSRuntime: Fatal error. JavaBridge native library failed to load.");
            throw unsatisfiedLinkError;
        }
    }
}

