/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.http;

import java.util.Vector;
import org.cybergarage.http.HTTPRequestListener;
import org.cybergarage.http.HTTPServer;
import org.cybergarage.net.HostInterface;

public class HTTPServerList
extends Vector {
    public void addRequestListener(HTTPRequestListener listener) {
        int nServers = this.size();
        for (int n = 0; n < nServers; ++n) {
            HTTPServer server = this.getHTTPServer(n);
            server.addRequestListener(listener);
        }
    }

    public HTTPServer getHTTPServer(int n) {
        return (HTTPServer)this.get(n);
    }

    public void close() {
        int nServers = this.size();
        for (int n = 0; n < nServers; ++n) {
            HTTPServer server = this.getHTTPServer(n);
            server.close();
        }
    }

    public boolean open(int port) {
        int nHostAddrs = HostInterface.getNHostAddresses();
        for (int n = 0; n < nHostAddrs; ++n) {
            HTTPServer httpServer = new HTTPServer();
            String bindAddr = HostInterface.getHostAddress(n);
            if (!httpServer.open(bindAddr, port)) {
                this.close();
                this.clear();
                return false;
            }
            this.add(httpServer);
        }
        return true;
    }

    public void start() {
        int nServers = this.size();
        for (int n = 0; n < nServers; ++n) {
            HTTPServer server = this.getHTTPServer(n);
            server.start();
        }
    }

    public void stop() {
        int nServers = this.size();
        for (int n = 0; n < nServers; ++n) {
            HTTPServer server = this.getHTTPServer(n);
            server.stop();
        }
    }
}

