/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaapRequest {
    public static final int SERVER_INFO = 1;
    public static final int CONTENT_CODES = 2;
    public static final int LOGIN = 3;
    public static final int LOGOUT = 4;
    public static final int UPDATE = 5;
    public static final int RESOLVE = 6;
    public static final int DATABASES = 7;
    public static final int DATABASE_SONGS = 8;
    public static final int DATABASE_PLAYLISTS = 9;
    public static final int PLAYLIST_SONGS = 10;
    public static final int SONG = 11;
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$DaapRequest == null ? (class$de$kapsi$net$daap$DaapRequest = DaapRequest.class$("de.kapsi.net.daap.DaapRequest")) : class$de$kapsi$net$daap$DaapRequest));
    private String method;
    private URI uri;
    private String protocol;
    private Map queryMap;
    private int sessionId;
    private int revisionNumber;
    private int delta;
    private ArrayList meta;
    private String metaString;
    private int requestType;
    private int databaseId;
    private int containerId;
    private int itemId;
    private ArrayList headers;
    private boolean isServerSideRequest;
    private boolean isUpdateType;
    private DaapConnection connection;
    static /* synthetic */ Class class$de$kapsi$net$daap$DaapRequest;

    private DaapRequest(DaapConnection connection) {
        this.sessionId = 0;
        this.revisionNumber = 0;
        this.delta = 0;
        this.requestType = 0;
        this.databaseId = 0;
        this.containerId = 0;
        this.itemId = 0;
        this.connection = connection;
        this.headers = new ArrayList();
    }

    public DaapRequest(DaapConnection connection, int sessionId, int revisionNumber, int delta) {
        this(connection);
        this.sessionId = sessionId;
        this.revisionNumber = revisionNumber;
        this.delta = delta;
        this.requestType = 5;
        this.isServerSideRequest = true;
        this.isUpdateType = false;
    }

    public DaapRequest(DaapConnection connection, String requestLine) throws URIException {
        String protocol;
        URI uri;
        String method;
        block5: {
            this(connection);
            method = null;
            uri = null;
            protocol = null;
            try {
                StringTokenizer st;
                block4: {
                    st = new StringTokenizer(requestLine, " ");
                    method = st.nextToken();
                    try {
                        uri = new URI(st.nextToken().toCharArray());
                    }
                    catch (URIException err) {
                        if (!LOG.isErrorEnabled()) break block4;
                        LOG.error((Object)err);
                    }
                }
                protocol = st.nextToken();
            }
            catch (NoSuchElementException err) {
                if (!LOG.isErrorEnabled()) break block5;
                LOG.error((Object)err);
            }
        }
        this.isServerSideRequest = false;
        this.isUpdateType = false;
        this.setMethod(method);
        this.setURI(uri);
        this.setProtocol(protocol);
    }

    public DaapRequest(DaapConnection connection, String method, URI uri, String protocol) throws URIException {
        this(connection);
        this.isServerSideRequest = false;
        this.isUpdateType = false;
        this.setMethod(method);
        this.setURI(uri);
        this.setProtocol(protocol);
    }

    private void setMethod(String method) {
        this.method = method;
    }

    private void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setURI(URI uri) throws URIException {
        this.uri = uri;
        if (uri != null) {
            String path = uri.getPath();
            this.queryMap = DaapUtil.parseQuery(uri.getQuery());
            if (path.equals("/server-info")) {
                this.requestType = 1;
            } else if (path.equals("/content-codes")) {
                this.requestType = 2;
            } else if (path.equals("/login")) {
                this.requestType = 3;
            } else if (path.equals("/logout")) {
                this.requestType = 4;
            } else if (path.equals("/update")) {
                this.requestType = 5;
            } else if (path.equals("/resolve")) {
                this.requestType = 6;
            }
            if (this.queryMap.containsKey("session-id")) {
                this.sessionId = Integer.parseInt((String)this.queryMap.get("session-id"));
            }
            if (this.sessionId == 0) return;
            if (this.queryMap.containsKey("revision-number")) {
                this.revisionNumber = Integer.parseInt((String)this.queryMap.get("revision-number"));
            }
            if (this.queryMap.containsKey("delta")) {
                this.delta = Integer.parseInt((String)this.queryMap.get("delta"));
            }
            if (this.queryMap.containsKey("meta")) {
                this.metaString = (String)this.queryMap.get("meta");
            }
            boolean bl = this.isUpdateType = this.delta != 0 && this.delta < this.revisionNumber;
            if (path.equals("/databases")) {
                this.requestType = 7;
                return;
            } else {
                if (!path.startsWith("/databases")) return;
                StringTokenizer tok = new StringTokenizer(path, "/");
                int count = tok.countTokens();
                if (count < 3) throw new URIException("Unknown token in path: " + path);
                String token = tok.nextToken();
                if (!token.equals("databases")) {
                    throw new URIException("Unknown token in path: " + path + " [" + token + "]@1");
                }
                this.databaseId = Integer.parseInt(tok.nextToken());
                token = tok.nextToken();
                if (token.equals("items")) {
                    this.requestType = 8;
                } else {
                    if (!token.equals("containers")) throw new URIException("Unknown token in path: " + path + " [" + token + "]@2");
                    this.requestType = 9;
                }
                if (count == 3) return;
                if (count == 4) {
                    token = tok.nextToken();
                    StringTokenizer fileTokenizer = new StringTokenizer(token, ".");
                    if (fileTokenizer.countTokens() != 2) throw new URIException("Unknown token in path: " + path + " [" + token + "]@3");
                    this.itemId = Integer.parseInt(fileTokenizer.nextToken());
                    this.requestType = 11;
                    return;
                } else {
                    if (count != 5) throw new URIException("Unknown token in path: " + path + " [" + token + "]@5");
                    this.containerId = Integer.parseInt(tok.nextToken());
                    token = tok.nextToken();
                    if (!token.equals("items")) throw new URIException("Unknown token in path: " + path + " [" + token + "@4");
                    this.requestType = 10;
                }
            }
            return;
        } else {
            this.queryMap = null;
            this.metaString = null;
            this.isUpdateType = false;
            this.requestType = 0;
            this.databaseId = 0;
            this.containerId = 0;
            this.itemId = 0;
            this.sessionId = 0;
            this.revisionNumber = 0;
            this.delta = 0;
        }
    }

    public void addHeaders(Header[] headers) {
        for (int i = 0; i < headers.length; ++i) {
            this.headers.add(headers[i]);
        }
    }

    public void addHeaders(List headers) {
        if (this.headers != headers) {
            this.headers.addAll(headers);
        }
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public List getHeaders() {
        return this.headers;
    }

    public Header getHeader(String key) {
        if (this.headers == null) {
            return null;
        }
        Iterator it = this.headers.iterator();
        while (it.hasNext()) {
            Header header = (Header)it.next();
            if (!header.getName().equals(key)) continue;
            return header;
        }
        return null;
    }

    public DaapConnection getConnection() {
        return this.connection;
    }

    public boolean isUnknownRequest() {
        return this.requestType == 0;
    }

    public boolean isServerInfoRequest() {
        return this.requestType == 1;
    }

    public boolean isContentCodesRequest() {
        return this.requestType == 2;
    }

    public boolean isLoginRequest() {
        return this.requestType == 3;
    }

    public boolean isLogoutRequest() {
        return this.requestType == 4;
    }

    public boolean isUpdateRequest() {
        return this.requestType == 5;
    }

    public boolean isResolveRequest() {
        return this.requestType == 6;
    }

    public boolean isDatabasesRequest() {
        return this.requestType == 7;
    }

    public boolean isDatabaseSongsRequest() {
        return this.requestType == 8;
    }

    public boolean isDatabasePlaylistsRequest() {
        return this.requestType == 9;
    }

    public boolean isPlaylistSongsRequest() {
        return this.requestType == 10;
    }

    public boolean isSongRequest() {
        return this.requestType == 11;
    }

    public URI getUri() {
        return this.uri;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public int getRevisionNumber() {
        return this.revisionNumber;
    }

    public int getDelta() {
        return this.delta;
    }

    public List getMeta() {
        if (this.meta == null && this.metaString != null) {
            this.meta = DaapUtil.parseMeta(this.metaString);
            this.metaString = null;
        }
        return this.meta;
    }

    public int getDatabaseId() {
        return this.databaseId;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public int getItemId() {
        return this.itemId;
    }

    public boolean isDatabaseIdSet() {
        return this.databaseId != 0;
    }

    public boolean isContainerIdSet() {
        return this.containerId != 0;
    }

    public boolean isItemIdSet() {
        return this.itemId != 0;
    }

    public int getRequestType() {
        return this.requestType;
    }

    public Map getQueryMap() {
        return this.queryMap;
    }

    public boolean isServerSideRequest() {
        return this.isServerSideRequest;
    }

    public boolean isUpdateType() {
        return this.isUpdateType;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.isServerSideRequest) {
            buffer.append("ServerSideRequest").append("\n");
        }
        if (this.uri != null) {
            buffer.append(this.uri).append("\n");
        }
        if (this.headers != null) {
            for (int i = 0; i < this.headers.size(); ++i) {
                buffer.append(this.headers.get(i));
            }
        }
        return buffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

