/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.ByteUtil;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.chunks.Chunk;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class DaapUtil {
    public static final int NULL = 0;
    public static final boolean COMPRESS = true;
    private static final byte[] CRLF = new byte[]{13, 10};
    private static final String ISO_8859_1 = "ISO-8859-1";
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$DaapUtil == null ? (class$de$kapsi$net$daap$DaapUtil = DaapUtil.class$("de.kapsi.net.daap.DaapUtil")) : class$de$kapsi$net$daap$DaapUtil));
    private static final SimpleDateFormat formatter = new SimpleDateFormat("EEE, d MMM yyyy hh:mm:ss z", Locale.US);
    private static final Random generator = new Random();
    public static final String[] DATABASE_SONGS_META;
    public static final String[] DATABASE_PLAYLISTS_META;
    public static final String[] PLAYLIST_SONGS_META;
    public static final int VERSION_1 = 65536;
    public static final int VERSION_2 = 131072;
    public static final int VERSION_3 = 196608;
    private static final String CLIENT_DAAP_VERSION = "Client-DAAP-Version";
    private static final String USER_AGENT = "User-Agent";
    static /* synthetic */ Class class$de$kapsi$net$daap$DaapUtil;

    private DaapUtil() {
    }

    public static boolean isSupportedProtocolVersion(int version) {
        return version >= 196608;
    }

    public static int toContentCodeNumber(String contentCode) {
        if (contentCode.length() != 4) {
            throw new IllegalArgumentException("content code must have 4 characters!");
        }
        try {
            byte[] chars = contentCode.getBytes("UTF-8");
            return ByteUtil.toIntBE(chars, 0);
        }
        catch (UnsupportedEncodingException err) {
            LOG.error((Object)err);
            return 0;
        }
    }

    public static final String now() {
        return formatter.format(new Date());
    }

    public static final byte[] serialize(Chunk chunk, boolean compress) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(chunk.getSize());
        if (compress) {
            GZIPOutputStream gzip = new GZIPOutputStream(buffer);
            chunk.serialize(gzip);
            gzip.finish();
            gzip.close();
        } else {
            chunk.serialize(buffer);
            buffer.flush();
            buffer.close();
        }
        return buffer.toByteArray();
    }

    public static final Map parseQuery(String queryString) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (queryString != null && queryString.length() != 0) {
            StringTokenizer tok = new StringTokenizer(queryString, "&");
            while (tok.hasMoreTokens()) {
                String token = tok.nextToken();
                int q = token.indexOf(61);
                if (q == -1 || q == token.length()) continue;
                String key = token.substring(0, q);
                String value = token.substring(++q);
                map.put(key, value);
            }
        }
        return map;
    }

    public static final ArrayList parseMeta(String meta) {
        StringTokenizer tok = new StringTokenizer(meta, ",");
        ArrayList<String> list = new ArrayList<String>(tok.countTokens());
        boolean flag = false;
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (!flag && token.equals("dmap.itemkind")) {
                list.add(0, token);
                flag = true;
                continue;
            }
            list.add(token);
        }
        return list;
    }

    public static Integer createSessionId(Set knownIDs) {
        Integer sessionId = null;
        while (sessionId == null || knownIDs.contains(sessionId)) {
            int tmp = generator.nextInt();
            if (tmp == 0) continue;
            if (tmp < 0) {
                tmp = -tmp;
            }
            sessionId = new Integer(tmp);
        }
        return sessionId;
    }

    public static int toVersion(int major) {
        return DaapUtil.toVersion(major, 0, 0);
    }

    public static int toVersion(int major, int minor) {
        return DaapUtil.toVersion(major, minor, 0);
    }

    public static int toVersion(int major, int minor, int patch) {
        byte[] dst = new byte[4];
        ByteUtil.toByte16BE(major & 0xFFFF, dst, 0);
        dst[2] = (byte)(minor & 0xFF);
        dst[3] = (byte)(patch & 0xFF);
        return ByteUtil.toIntBE(dst, 0);
    }

    public static int getProtocolVersion(DaapRequest request) {
        if (request.isUnknownRequest()) {
            return 0;
        }
        Header header = request.getHeader(CLIENT_DAAP_VERSION);
        if (header == null && request.isSongRequest()) {
            header = request.getHeader(USER_AGENT);
        }
        if (header == null) {
            return 0;
        }
        String name = header.getName();
        String value = header.getValue();
        if (request.isSongRequest() && name.equals(USER_AGENT)) {
            if (value.startsWith("iTunes/4.5") || value.startsWith("iTunes/4.6")) {
                return 196608;
            }
            if (value.startsWith("iTunes/4.2") || value.startsWith("iTunes/4.1")) {
                return 131072;
            }
            if (value.startsWith("iTunes/4.0")) {
                return 65536;
            }
            return 0;
        }
        StringTokenizer tokenizer = new StringTokenizer(value, ".");
        int count = tokenizer.countTokens();
        if (count >= 2 && count <= 3) {
            try {
                int major = 0;
                int minor = 0;
                int patch = 0;
                major = Integer.parseInt(tokenizer.nextToken());
                minor = Integer.parseInt(tokenizer.nextToken());
                if (count == 3) {
                    patch = Integer.parseInt(tokenizer.nextToken());
                }
                return DaapUtil.toVersion(major, minor, patch);
            }
            catch (NumberFormatException err) {
                // empty catch block
            }
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        for (int i = 0; i < 100; ++i) {
            generator.nextInt();
        }
        DATABASE_SONGS_META = new String[]{"dmap.itemkind", "daap.songalbum", "daap.songgrouping", "daap.songartist", "daap.songbeatsperminute", "daap.songbitrate", "daap.songcomment", "daap.songcompilation", "daap.songcomposer", "daap.songdateadded", "daap.songdatemodified", "daap.songdisccount", "daap.songdiscnumber", "daap.songdatakind", "daap.songformat", "daap.songeqpreset", "daap.songgenre", "dmap.itemid", "daap.songdescription", "dmap.itemname", "com.apple.itunes.norm-volume", "dmap.persistentid", "daap.songdisabled", "daap.songrelativevolume", "daap.songsamplerate", "daap.songsize", "daap.songstarttime", "daap.songstoptime", "daap.songtime", "daap.songtrackcount", "daap.songtracknumber", "daap.songuserrating", "daap.songyear", "dmap.containeritemid", "daap.songdataurl"};
        DATABASE_PLAYLISTS_META = new String[]{"dmap.itemid", "dmap.persistentid", "dmap.itemname", "com.apple.itunes.smart-playlist", "dmap.itemcount"};
        PLAYLIST_SONGS_META = new String[]{"dmap.itemkind", "dmap.itemid", "dmap.containeritemid"};
    }
}

