/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapException;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Database;
import de.kapsi.net.daap.Playlist;
import de.kapsi.net.daap.Transaction;
import de.kapsi.net.daap.Txn;
import de.kapsi.net.daap.chunks.ChunkImpls;
import de.kapsi.net.daap.chunks.ContentCode;
import de.kapsi.net.daap.chunks.impl.ContainerCount;
import de.kapsi.net.daap.chunks.impl.ContentCodesResponse;
import de.kapsi.net.daap.chunks.impl.DaapProtocolVersion;
import de.kapsi.net.daap.chunks.impl.DatabaseCount;
import de.kapsi.net.daap.chunks.impl.DmapProtocolVersion;
import de.kapsi.net.daap.chunks.impl.ItemCount;
import de.kapsi.net.daap.chunks.impl.ItemId;
import de.kapsi.net.daap.chunks.impl.ItemName;
import de.kapsi.net.daap.chunks.impl.Listing;
import de.kapsi.net.daap.chunks.impl.ListingItem;
import de.kapsi.net.daap.chunks.impl.LoginRequired;
import de.kapsi.net.daap.chunks.impl.PersistentId;
import de.kapsi.net.daap.chunks.impl.ReturnedCount;
import de.kapsi.net.daap.chunks.impl.ServerDatabases;
import de.kapsi.net.daap.chunks.impl.ServerInfoResponse;
import de.kapsi.net.daap.chunks.impl.SpecifiedTotalCount;
import de.kapsi.net.daap.chunks.impl.Status;
import de.kapsi.net.daap.chunks.impl.SupportsAutoLogout;
import de.kapsi.net.daap.chunks.impl.SupportsBrowse;
import de.kapsi.net.daap.chunks.impl.SupportsExtensions;
import de.kapsi.net.daap.chunks.impl.SupportsIndex;
import de.kapsi.net.daap.chunks.impl.SupportsPersistentIds;
import de.kapsi.net.daap.chunks.impl.SupportsQuery;
import de.kapsi.net.daap.chunks.impl.SupportsResolve;
import de.kapsi.net.daap.chunks.impl.SupportsUpdate;
import de.kapsi.net.daap.chunks.impl.TimeoutInterval;
import de.kapsi.net.daap.chunks.impl.UpdateType;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Library {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$Library == null ? (class$de$kapsi$net$daap$Library = Library.class$("de.kapsi.net.daap.Library")) : class$de$kapsi$net$daap$Library));
    public static final int DEFAULT_KEEP_REVISIONS = 10;
    private static final int GC_TIMER_INTERVAL = 10000;
    private static long persistentId = 0L;
    private int revision = 0;
    private ArrayList databases = new ArrayList();
    private boolean useLibraryGC;
    private LibraryRevision[] revisions;
    private Timer gcTimer = null;
    private final ItemName itemName = new ItemName();
    private byte[] contentCodes;
    static /* synthetic */ Class class$de$kapsi$net$daap$Library;

    public Library(String name) {
        this(name, 10, true);
    }

    public Library(String name, int keepNumRevisions, boolean useLibraryGC) {
        if (keepNumRevisions <= 0) {
            throw new IllegalArgumentException("keepNumRevisions must be >= 1");
        }
        this.useLibraryGC = useLibraryGC && keepNumRevisions > 1;
        this.revisions = new LibraryRevision[keepNumRevisions];
        this.itemName.setValue(name);
        this.contentCodes = new ContentCodesResponseImpl().getBytes();
    }

    public synchronized int getRevision() {
        return this.revision;
    }

    public void setName(Transaction txn, String name) {
        if (!txn.isOpen()) {
            throw new DaapException("Transaction is not open");
        }
        LibraryTxn obj = (LibraryTxn)txn.getAttribute(this);
        if (obj == null) {
            throw new DaapException();
        }
        obj.setName(name);
    }

    public String getName() {
        return this.itemName.getValue();
    }

    public void add(Transaction txn, Database database) throws DaapException {
        if (!txn.isOpen()) {
            throw new DaapException("Transaction is not open");
        }
        LibraryTxn obj = (LibraryTxn)txn.getAttribute(this);
        if (obj == null) {
            throw new DaapException();
        }
        obj.add(database);
    }

    public void remove(Transaction txn, Database database) throws DaapException {
        if (!txn.isOpen()) {
            throw new DaapException("Transaction is not open");
        }
        LibraryTxn obj = (LibraryTxn)txn.getAttribute(this);
        if (obj == null) {
            throw new DaapException();
        }
        obj.remove(database);
    }

    public boolean contains(Database database) {
        return this.databases.contains(database);
    }

    public synchronized Transaction open() {
        return this.open(true);
    }

    public synchronized Transaction open(boolean autoCommit) {
        LibraryTxn rootTxn = new LibraryTxn(this);
        Transaction txn = new Transaction(this, rootTxn, autoCommit);
        Iterator it = this.databases.iterator();
        while (it.hasNext()) {
            ((Database)it.next()).openTxn(txn);
        }
        return txn;
    }

    public synchronized Object select(DaapRequest request) {
        if (request.isServerInfoRequest()) {
            DaapConnection connection = request.getConnection();
            int version = connection.getProtocolVersion();
            if (version >= 196608) {
                LibraryRevision currentRevision = this.getLibraryRevision(request);
                if (currentRevision == null) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)("Unknown revision: " + request.getRevisionNumber()));
                    }
                    return null;
                }
                return currentRevision.serverInfo;
            }
            return null;
        }
        if (request.isContentCodesRequest()) {
            return this.contentCodes;
        }
        if (request.isUpdateRequest()) {
            int delta = request.getDelta();
            if (delta == 0) {
                return new Integer(this.getRevision());
            }
            if (delta < this.getRevision()) {
                return new Integer(++delta);
            }
            return new Integer(delta);
        }
        if (request.isDatabasesRequest()) {
            LibraryRevision currentRevision = this.getLibraryRevision(request);
            if (currentRevision == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Unknown revision: " + request.getRevisionNumber()));
                }
                return null;
            }
            if (request.isUpdateType()) {
                return currentRevision.serverDatabasesUpdate;
            }
            return currentRevision.serverDatabases;
        }
        if (request.isSongRequest() || request.isDatabaseSongsRequest() || request.isDatabasePlaylistsRequest() || request.isPlaylistSongsRequest()) {
            LibraryRevision currentRevision = this.getLibraryRevision(request);
            if (currentRevision == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Unknown revision: " + request.getRevisionNumber()));
                }
                return null;
            }
            Database database = currentRevision.getDatabase(request);
            if (database == null) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("No database with this revision known: " + request.getRevisionNumber()));
                }
                return null;
            }
            return database.select(request);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Unknown request: " + request));
        }
        return null;
    }

    private LibraryRevision getLibraryRevision(DaapRequest request) {
        LibraryRevision rev;
        int revisionNumber = request.getRevisionNumber();
        if (revisionNumber == 0) {
            revisionNumber = this.revision;
        }
        if ((rev = this.revisions[revisionNumber % this.revisions.length]) != null && rev.revision == revisionNumber) {
            return rev;
        }
        return null;
    }

    public int size() {
        return this.databases.size();
    }

    static synchronized long nextPersistentId() {
        return ++persistentId;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ContentCodesResponseImpl
    extends ContentCodesResponse {
        public ContentCodesResponseImpl() {
            this.add(new Status(200));
            String[] names = ChunkImpls.classes;
            Class[] arg1 = new Class[]{};
            Object[] arg2 = new Object[]{};
            for (int i = 0; i < names.length; ++i) {
                try {
                    Class<?> clazz = Class.forName(names[i]);
                    Method methodContentCode = clazz.getMethod("getContentCode", arg1);
                    Method methodName = clazz.getMethod("getName", arg1);
                    Method methodType = clazz.getMethod("getType", arg1);
                    Object inst = clazz.newInstance();
                    String contentCode = (String)methodContentCode.invoke(inst, arg2);
                    String name = (String)methodName.invoke(inst, arg2);
                    int type = (Integer)methodType.invoke(inst, arg2);
                    this.add(new ContentCode(contentCode, name, type));
                    continue;
                }
                catch (ClassNotFoundException err) {
                    LOG.error((Object)err);
                    continue;
                }
                catch (NoSuchMethodException err) {
                    LOG.error((Object)err);
                    continue;
                }
                catch (InstantiationException err) {
                    LOG.error((Object)err);
                    continue;
                }
                catch (IllegalAccessException err) {
                    LOG.error((Object)err);
                    continue;
                }
                catch (IllegalArgumentException err) {
                    LOG.error((Object)err);
                    continue;
                }
                catch (InvocationTargetException err) {
                    LOG.error((Object)err);
                    continue;
                }
                catch (SecurityException err) {
                    LOG.error((Object)err);
                }
            }
        }

        public byte[] getBytes() {
            return this.getBytes(true);
        }

        public byte[] getBytes(boolean compress) {
            try {
                return DaapUtil.serialize(this, compress);
            }
            catch (IOException err) {
                LOG.error((Object)err);
                return null;
            }
        }
    }

    private static final class LibraryGC
    extends TimerTask {
        private Library library;

        private LibraryGC(Library library) {
            this.library = library;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Library library = this.library;
            synchronized (library) {
                int index = this.library.revision % this.library.revisions.length;
                int i = (index + 1) % this.library.revisions.length;
                while (i != index) {
                    if (this.library.revisions[i] != null) {
                        ((Library)this.library).revisions[i] = null;
                        break;
                    }
                    i = (i + 1) % this.library.revisions.length;
                }
                if (i == index) {
                    this.cancel();
                    this.library.gcTimer.cancel();
                    this.library.gcTimer = null;
                }
            }
        }
    }

    private static final class LibraryRevision {
        private final int revision;
        private ArrayList databases;
        private byte[] serverInfo;
        private byte[] serverDatabases;
        private byte[] serverDatabasesUpdate;

        private LibraryRevision(int revision) {
            this.revision = revision;
        }

        private Database getDatabase(DaapRequest request) {
            int revisionNumber = request.getRevisionNumber();
            if (revisionNumber == 0) {
                revisionNumber = this.revision;
            }
            if (this.databases != null && !this.databases.isEmpty()) {
                int databaseId = request.getDatabaseId();
                if (databaseId == 0) {
                    return (Database)this.databases.get(0);
                }
                Iterator it = this.databases.iterator();
                while (it.hasNext()) {
                    Database database = (Database)it.next();
                    if (database.getId() != databaseId) continue;
                    return database;
                }
            }
            return null;
        }

        public String toString() {
            return "LibraryRevision: " + this.revision;
        }

        static /* synthetic */ byte[] access$402(LibraryRevision x0, byte[] x1) {
            x0.serverInfo = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$602(LibraryRevision x0, byte[] x1) {
            x0.serverDatabases = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$502(LibraryRevision x0, byte[] x1) {
            x0.serverDatabasesUpdate = x1;
            return x1;
        }
    }

    private static final class LibraryTxn
    implements Txn {
        private Library library;
        private String name;
        private HashSet databases = new HashSet();
        private HashSet deletedDatabases = new HashSet();

        private LibraryTxn(Library library) {
            this.library = library;
            this.name = library.getName();
        }

        private void setName(String name) {
            this.name = name;
        }

        private void add(Database database) {
            if (!this.databases.contains(database)) {
                this.databases.add(database);
                this.deletedDatabases.remove(database);
            }
        }

        private void remove(Database database) {
            if (!this.deletedDatabases.contains(database)) {
                this.deletedDatabases.add(database);
                this.databases.remove(database);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commit(Transaction txn) {
            Library library = this.library;
            synchronized (library) {
                Database database;
                if (this.library.getName() != this.name) {
                    this.library.itemName.setValue(this.name);
                }
                Iterator it = this.databases.iterator();
                while (it.hasNext()) {
                    database = (Database)it.next();
                    if (this.library.databases.contains(database)) continue;
                    this.library.databases.add(database);
                }
                it = this.deletedDatabases.iterator();
                while (it.hasNext()) {
                    database = (Database)it.next();
                    this.library.databases.remove(database);
                }
                LibraryRevision current = this.library.revisions[this.library.revision % this.library.revisions.length];
                if (current != null) {
                    current.databases = new ArrayList();
                }
                try {
                    it = this.library.databases.iterator();
                    while (it.hasNext()) {
                        Txn obj;
                        Database database2 = (Database)it.next();
                        if (current != null) {
                            current.databases.add(database2.clone());
                        }
                        if ((obj = txn.getAttribute(database2)) == null) continue;
                        obj.commit(txn);
                    }
                }
                catch (CloneNotSupportedException err) {
                    throw new DaapException(err);
                }
                this.library.revision++;
                LibraryRevision newRevision = new LibraryRevision(this.library.revision);
                newRevision.databases = this.library.databases;
                LibraryRevision.access$402(newRevision, new ServerInfoResponseImpl(this.library, 196608).getBytes());
                LibraryRevision.access$602(newRevision, new ServerDatabasesImpl(this.library, false).getBytes());
                LibraryRevision.access$502(newRevision, new ServerDatabasesImpl(this.library, true).getBytes());
                ((Library)this.library).revisions[((Library)this.library).revision % ((Library)this.library).revisions.length] = newRevision;
                if (this.library.useLibraryGC && this.library.gcTimer == null) {
                    this.library.gcTimer = new Timer(true);
                    this.library.gcTimer.scheduleAtFixedRate((TimerTask)new LibraryGC(this.library), 10000L, 10000L);
                }
            }
            this.databases.clear();
            this.deletedDatabases.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void rollback(Transaction txn) {
            Library library = this.library;
            synchronized (library) {
                Iterator it = this.library.databases.iterator();
                while (it.hasNext()) {
                    Database database = (Database)it.next();
                    Txn obj = txn.getAttribute(database);
                    if (obj == null) continue;
                    obj.rollback(txn);
                }
            }
            this.databases.clear();
            this.deletedDatabases.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup(Transaction txn) {
            Library library = this.library;
            synchronized (library) {
                Iterator it = this.databases.iterator();
                while (it.hasNext()) {
                    Database database = (Database)it.next();
                    Txn obj = txn.getAttribute(database);
                    if (obj == null) continue;
                    obj.cleanup(txn);
                }
            }
            this.databases.clear();
            this.deletedDatabases.clear();
        }

        public void join(Txn value) {
            LibraryTxn obj = (LibraryTxn)value;
            if (obj.name != this.name) {
                this.name = obj.name;
            }
            Iterator it = obj.databases.iterator();
            while (it.hasNext()) {
                this.add((Database)it.next());
            }
            it = obj.deletedDatabases.iterator();
            while (it.hasNext()) {
                this.remove((Database)it.next());
            }
        }
    }

    private static final class ServerDatabasesImpl
    extends ServerDatabases {
        public ServerDatabasesImpl(Library library, boolean updateType) {
            this.add(new Status(200));
            this.add(new UpdateType(updateType));
            this.add(new SpecifiedTotalCount(library.databases.size()));
            this.add(new ReturnedCount(library.databases.size()));
            Listing listing = new Listing();
            Iterator it = library.databases.iterator();
            while (it.hasNext()) {
                ListingItem listingItem = new ListingItem();
                Database database = (Database)it.next();
                listingItem.add(new ItemId(database.getId()));
                listingItem.add(new PersistentId(database.getPersistentId()));
                listingItem.add(new ItemName(database.getName()));
                Playlist playlist = database.getMasterPlaylist();
                int itemCount = (updateType ? playlist.getNewSongs() : playlist.getSongs()).size();
                int containerCount = database.getPlaylists().size();
                listingItem.add(new ItemCount(itemCount));
                listingItem.add(new ContainerCount(containerCount));
                listing.add(listingItem);
            }
            this.add(listing);
        }

        public byte[] getBytes() {
            return this.getBytes(true);
        }

        public byte[] getBytes(boolean compress) {
            try {
                return DaapUtil.serialize(this, compress);
            }
            catch (IOException err) {
                LOG.error((Object)err);
                return null;
            }
        }
    }

    private static final class ServerInfoResponseImpl
    extends ServerInfoResponse {
        public ServerInfoResponseImpl(Library library, int version) {
            this.add(new Status(200));
            this.add(new TimeoutInterval(1800));
            this.add(new DmapProtocolVersion(version));
            this.add(new DaapProtocolVersion(version));
            this.add(library.itemName);
            this.add(new LoginRequired(false));
            this.add(new SupportsAutoLogout(false));
            this.add(new SupportsUpdate(false));
            this.add(new SupportsPersistentIds(false));
            this.add(new SupportsExtensions(false));
            this.add(new SupportsBrowse(false));
            this.add(new SupportsQuery(false));
            this.add(new SupportsIndex(false));
            this.add(new SupportsResolve(false));
            this.add(new DatabaseCount(library.databases.size()));
        }

        public byte[] getBytes() {
            return this.getBytes(true);
        }

        public byte[] getBytes(boolean compress) {
            try {
                return DaapUtil.serialize(this, compress);
            }
            catch (IOException err) {
                LOG.error((Object)err);
                return null;
            }
        }
    }
}

