/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.bio;

import de.kapsi.net.daap.DaapAudioResponse;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapStreamException;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.bio.DaapConnectionBIO;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketException;

public class DaapAudioResponseBIO
extends DaapAudioResponse {
    private boolean headerWritten = false;
    private boolean audioWritten = false;
    private OutputStream out;

    public DaapAudioResponseBIO(DaapRequest request, Song song, FileInputStream in, int pos, int end) throws IOException {
        super(request, song, in, pos, end);
        DaapConnectionBIO connection = (DaapConnectionBIO)request.getConnection();
        this.out = connection.getOutputStream();
    }

    public boolean hasRemainig() {
        return !this.headerWritten || !this.audioWritten;
    }

    public boolean write() throws IOException {
        try {
            if (!this.headerWritten) {
                try {
                    this.out.write(this.header, 0, this.header.length);
                    this.out.flush();
                    this.headerWritten = true;
                }
                catch (IOException err) {
                    this.in.close();
                    throw err;
                }
            }
            return this.stream();
        }
        catch (SocketException err) {
            throw new DaapStreamException(err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean stream() throws IOException {
        try {
            byte[] buffer = new byte[512];
            int total = 0;
            int len = -1;
            if (this.pos != 0) {
                this.in.skip(this.pos);
            }
            while ((len = this.in.read(buffer, 0, buffer.length)) != -1 && total < this.end) {
                this.out.write(buffer, 0, len);
                total += len;
            }
            this.out.flush();
            this.in.close();
        }
        finally {
            this.in.close();
        }
        return true;
    }
}

