/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.bio;

import de.kapsi.net.daap.DaapAuthenticator;
import de.kapsi.net.daap.DaapConfig;
import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapFilter;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapStreamSource;
import de.kapsi.net.daap.DaapThreadFactory;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.SimpleConfig;
import de.kapsi.net.daap.bio.DaapConnectionBIO;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaapServerBIO
implements DaapServer {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$bio$DaapServerBIO == null ? (class$de$kapsi$net$daap$bio$DaapServerBIO = DaapServerBIO.class$("de.kapsi.net.daap.bio.DaapServerBIO")) : class$de$kapsi$net$daap$bio$DaapServerBIO));
    private int threadNo = 0;
    private Library library;
    private DaapFilter filter;
    private HashSet sessionIds;
    private HashSet connections;
    private HashSet streams;
    private DaapConfig config;
    private DaapAuthenticator authenticator;
    private DaapStreamSource streamSource;
    private DaapThreadFactory threadFactory;
    private ServerSocket ssocket;
    private boolean running = false;
    static /* synthetic */ Class class$de$kapsi$net$daap$bio$DaapServerBIO;

    public DaapServerBIO(Library library) {
        this(library, new SimpleConfig());
    }

    public DaapServerBIO(Library library, int port) {
        this(library, new SimpleConfig(port));
    }

    public DaapServerBIO(Library library, DaapConfig config) {
        this.library = library;
        this.config = config;
        this.threadFactory = new DaapThreadFactoryImpl();
        this.sessionIds = new HashSet();
        this.connections = new HashSet();
        this.streams = new HashSet();
    }

    public Library getLibrary() {
        return this.library;
    }

    public void setConfig(DaapConfig config) {
        this.config = config;
    }

    public DaapConfig getConfig() {
        return this.config;
    }

    public void setAuthenticator(DaapAuthenticator authenticator) {
        this.authenticator = authenticator;
    }

    public DaapAuthenticator getAuthenticator() {
        return this.authenticator;
    }

    public void setStreamSource(DaapStreamSource streamSource) {
        this.streamSource = streamSource;
    }

    public DaapStreamSource getStreamSource() {
        return this.streamSource;
    }

    public void setFilter(DaapFilter filter) {
        this.filter = filter;
    }

    public DaapFilter getFilter() {
        return this.filter;
    }

    public void setThreadFactory(DaapThreadFactory factory) {
        this.threadFactory = factory == null ? new DaapThreadFactoryImpl() : factory;
    }

    public synchronized void bind() throws IOException {
        if (this.running) {
            return;
        }
        InetSocketAddress bindAddr = this.config.getInetSocketAddress();
        int backlog = this.config.getBacklog();
        this.ssocket = new ServerSocket();
        this.ssocket.bind(bindAddr, backlog);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("DaapServerBIO bound to " + bindAddr));
        }
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void stop() {
        if (!this.running) {
            return;
        }
        this.running = false;
        try {
            if (this.ssocket != null) {
                this.ssocket.close();
            }
        }
        catch (IOException err) {
            LOG.error((Object)err);
        }
        this.disconnectAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void disconnectAll() {
        Iterator it;
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            it = this.connections.iterator();
            while (it.hasNext()) {
                ((DaapConnectionBIO)it.next()).disconnect();
            }
            this.connections.clear();
        }
        hashSet = this.streams;
        synchronized (hashSet) {
            it = this.streams.iterator();
            while (it.hasNext()) {
                ((DaapConnectionBIO)it.next()).disconnect();
            }
            this.streams.clear();
        }
        hashSet = this.sessionIds;
        synchronized (hashSet) {
            this.sessionIds.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean addConnection(DaapConnectionBIO connection) {
        if (!this.isRunning()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"Server is down.");
            }
            return false;
        }
        if (connection.isAudioStream()) {
            HashSet hashSet = this.streams;
            synchronized (hashSet) {
                if (this.streams.size() >= this.config.getMaxConnections()) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)"Connection limit reached");
                    }
                    return false;
                }
                this.streams.add(connection);
            }
        }
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            if (this.connections.size() >= this.config.getMaxConnections()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)"Connection limit reached");
                }
                return false;
            }
            this.connections.add(connection);
        }
        return true;
    }

    private boolean accept(Socket socket) throws IOException {
        if (this.filter != null && !this.filter.accept(socket.getInetAddress())) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("DaapFilter refused connection from " + socket));
            }
            return false;
        }
        DaapConnectionBIO connection = new DaapConnectionBIO(this, socket);
        Thread connThread = this.threadFactory.createDaapThread(connection, "DaapConnectionThread-" + ++this.threadNo);
        connThread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update() {
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            Iterator it = this.connections.iterator();
            while (it.hasNext()) {
                DaapConnectionBIO conn = (DaapConnectionBIO)it.next();
                try {
                    conn.update();
                }
                catch (IOException err) {
                    LOG.error((Object)err);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeConnection(DaapConnectionBIO connection) {
        if (connection.isAudioStream()) {
            HashSet hashSet = this.streams;
            synchronized (hashSet) {
                this.streams.remove(connection);
            }
        }
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            this.connections.remove(connection);
        }
        DaapSession session = connection.getSession(false);
        if (session != null) {
            session.invalidate();
            HashSet hashSet2 = this.sessionIds;
            synchronized (hashSet2) {
                this.sessionIds.remove(session.getSessionId());
            }
        }
    }

    boolean isSessionIdValid(int sessionId) {
        return this.isSessionIdValid(new Integer(sessionId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSessionIdValid(Integer sessionId) {
        HashSet hashSet = this.sessionIds;
        synchronized (hashSet) {
            return this.sessionIds.contains(sessionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DaapConnection getConnection(Integer sessionId) {
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            Iterator it = this.connections.iterator();
            while (it.hasNext()) {
                Integer sid;
                DaapConnection connection = (DaapConnection)it.next();
                DaapSession session = connection.getSession(false);
                if (session == null || !(sid = session.getSessionId()).equals(sessionId)) continue;
                return connection;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer createSessionId() {
        HashSet hashSet = this.sessionIds;
        synchronized (hashSet) {
            Integer sid = DaapUtil.createSessionId(this.sessionIds);
            this.sessionIds.add(sid);
            return sid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfConnections() {
        if (this.connections == null) {
            return 0;
        }
        HashSet hashSet = this.connections;
        synchronized (hashSet) {
            return this.connections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfStreams() {
        if (this.streams == null) {
            return 0;
        }
        HashSet hashSet = this.streams;
        synchronized (hashSet) {
            return this.streams.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.threadNo = 0;
        this.running = true;
        try {
            while (this.running) {
                Socket socket = this.ssocket.accept();
                try {
                    if (this.running && !this.accept(socket)) {
                        socket.close();
                    }
                }
                catch (IOException err) {
                    LOG.error((Object)err);
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException err) {
            LOG.error((Object)err);
        }
        catch (SocketException err) {
            if (this.running) {
                LOG.error((Object)err);
            }
        }
        catch (IOException err) {
            LOG.error((Object)err);
        }
        finally {
            this.stop();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DaapThreadFactoryImpl
    implements DaapThreadFactory {
        private DaapThreadFactoryImpl() {
        }

        public Thread createDaapThread(Runnable runnable, String name) {
            Thread thread = new Thread(runnable, name);
            thread.setDaemon(true);
            return thread;
        }
    }
}

