/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.nio;

import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.nio.DaapConnectionNIO;
import de.kapsi.net.daap.nio.DaapLineReaderNIO;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.httpclient.Header;

public class DaapRequestReaderNIO {
    private long bytesRead = 0L;
    private DaapConnectionNIO connection;
    private ByteBuffer in;
    private String requestLine;
    private ArrayList headers;
    private DaapLineReaderNIO lineReader;
    private LinkedList pending;

    public DaapRequestReaderNIO(DaapConnectionNIO connection) {
        this.connection = connection;
        this.in = ByteBuffer.allocate(1024);
        this.in.clear();
        this.in.flip();
        this.lineReader = new DaapLineReaderNIO(connection.getChannel());
        this.headers = new ArrayList();
        this.pending = new LinkedList();
    }

    public long getBytesRead() {
        return this.bytesRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DaapRequest read() throws IOException {
        DaapRequest ret = null;
        if (!this.pending.isEmpty()) {
            ret = (DaapRequest)this.pending.removeFirst();
        }
        String line = null;
        while ((line = this.lineReader.read(this.in)) != null) {
            this.bytesRead += (long)this.in.position();
            if (this.requestLine == null) {
                this.requestLine = line;
                continue;
            }
            int p = line.indexOf(58);
            if (p == -1) {
                this.requestLine = null;
                this.headers.clear();
                this.lineReader = null;
                throw new IOException("Malformed Header");
            }
            String name = line.substring(0, p).trim();
            String value = line.substring(++p).trim();
            this.headers.add(new Header(name, value));
        }
        if (this.lineReader.isComplete()) {
            DaapRequest request = null;
            try {
                request = new DaapRequest(this.connection, this.requestLine);
                request.addHeaders(this.headers);
            }
            finally {
                this.requestLine = null;
                this.headers.clear();
            }
            if (ret == null) {
                ret = request;
            } else {
                this.pending.addLast(request);
            }
        }
        return ret;
    }
}

