/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.modes;

import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.modes.EncryptMode;

public class EncryptECB
extends EncryptMode {
    private CipherKey key;
    private int ibs;
    private int obs;
    private byte[] buffer;
    private int bufPos;

    public CipherKey getKey() {
        return this.key;
    }

    public void setKey(CipherKey cipherKey) {
        this.key = cipherKey;
        this.ibs = cipherKey.plainBlockSize();
        this.obs = cipherKey.cipherBlockSize();
        this.buffer = new byte[cipherKey.plainBlockSize()];
    }

    public int plainBlockSize() {
        return this.key.plainBlockSize();
    }

    public synchronized byte[] flush() {
        if (this.bufPos == 0) {
            return EMPTY_ARRAY;
        }
        byte[] byArray = new byte[this.buffer.length - this.bufPos];
        random.nextBytes(byArray);
        byte[] byArray2 = this.encrypt(byArray, 0, byArray.length);
        return byArray2;
    }

    public synchronized byte[] encrypt(byte[] byArray, int n, int n2) {
        int n3;
        int n4 = (this.bufPos + n2) / this.ibs;
        byte[] byArray2 = new byte[n4 * this.obs];
        int n5 = 0;
        if (this.bufPos > 0) {
            n3 = Math.min(n2, this.buffer.length - this.bufPos);
            System.arraycopy(byArray, n, this.buffer, this.bufPos, n3);
            this.bufPos += n3;
            n += n3;
            n2 -= n3;
            --n4;
            if (this.bufPos == this.buffer.length) {
                this.key.encrypt(this.buffer, 0, byArray2, 0);
                n5 += this.obs;
                this.bufPos = 0;
            } else {
                return byArray2;
            }
        }
        n3 = n;
        int n6 = 0;
        while (n6 < n4) {
            this.key.encrypt(byArray, n, byArray2, n5);
            n += this.ibs;
            n5 += this.obs;
            ++n6;
        }
        this.bufPos = n2 - (n - n3);
        if (this.bufPos != 0) {
            System.arraycopy(byArray, n, this.buffer, 0, this.bufPos);
        }
        return byArray2;
    }

    public EncryptECB(CipherKey cipherKey) {
        this.setKey(cipherKey);
    }

    public EncryptECB() {
    }
}

