/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.util.Iterator;
import java.util.Vector;
import org.kbinani.cadencii.BezierChain;
import org.kbinani.cadencii.BezierControlType;
import org.kbinani.cadencii.CurveType;
import org.kbinani.cadencii.Utility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierCurves
implements Cloneable {
    public Vector<BezierChain> Dynamics = new Vector();
    public Vector<BezierChain> Brethiness = new Vector();
    public Vector<BezierChain> Brightness = new Vector();
    public Vector<BezierChain> Clearness = new Vector();
    public Vector<BezierChain> Opening = new Vector();
    public Vector<BezierChain> GenderFactor = new Vector();
    public Vector<BezierChain> PortamentoTiming = new Vector();
    public Vector<BezierChain> VibratoRate = new Vector();
    public Vector<BezierChain> VibratoDepth = new Vector();
    public Vector<BezierChain> Harmonics = new Vector();
    public Vector<BezierChain> FX2Depth = new Vector();
    public Vector<BezierChain> Reso1Freq = new Vector();
    public Vector<BezierChain> Reso1BW = new Vector();
    public Vector<BezierChain> Reso1Amp = new Vector();
    public Vector<BezierChain> Reso2Freq = new Vector();
    public Vector<BezierChain> Reso2BW = new Vector();
    public Vector<BezierChain> Reso2Amp = new Vector();
    public Vector<BezierChain> Reso3Freq = new Vector();
    public Vector<BezierChain> Reso3BW = new Vector();
    public Vector<BezierChain> Reso3Amp = new Vector();
    public Vector<BezierChain> Reso4Freq = new Vector();
    public Vector<BezierChain> Reso4BW = new Vector();
    public Vector<BezierChain> Reso4Amp = new Vector();
    public Vector<BezierChain> PitchBend = new Vector();
    public Vector<BezierChain> PitchBendSensitivity = new Vector();

    public BezierChain getBezierChain(CurveType curveType, int n) {
        Vector<BezierChain> vector = this.get(curveType);
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            if (vector.get((int)i).id != n) continue;
            return vector.get(i);
        }
        return null;
    }

    public void setBezierChain(CurveType curveType, int n, BezierChain bezierChain) {
        Vector<BezierChain> vector = this.get(curveType);
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            if (vector.get((int)i).id != n) continue;
            vector.set(i, bezierChain);
            break;
        }
    }

    public void mergeBezierChain(CurveType curveType, BezierChain bezierChain) {
        int n;
        if (bezierChain.points.size() <= 1) {
            return;
        }
        int n2 = (int)bezierChain.getStart();
        int n3 = (int)bezierChain.getEnd();
        Vector<Integer> vector = new Vector<Integer>();
        Vector<BezierChain> vector2 = this.get(curveType);
        for (int i = 0; i < vector2.size(); ++i) {
            BezierChain bezierChain2 = vector2.get(i);
            if (bezierChain2.points.size() <= 0) continue;
            n = (int)bezierChain2.getStart();
            int n4 = (int)bezierChain2.getEnd();
            if (n2 > n || n4 > n3) continue;
            vector.add(bezierChain2.id);
        }
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            int n5 = (Integer)iterator.next();
            this.remove(curveType, n5);
        }
        boolean bl = true;
        block10: while (bl) {
            bl = false;
            Vector<BezierChain> vector3 = this.get(curveType);
            for (n = 0; n < vector3.size(); ++n) {
                int n6;
                int n7;
                BezierChain bezierChain3;
                BezierChain bezierChain4 = vector3.get(n);
                int n8 = bezierChain4.id;
                int n9 = (int)bezierChain4.getStart();
                int n10 = (int)bezierChain4.getEnd();
                if (n9 < n2 && n2 <= n10 && n10 < n3) {
                    bezierChain3 = null;
                    try {
                        bezierChain3 = bezierChain4.extractPartialBezier(n9, n2);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    bezierChain3.id = bezierChain4.id;
                    int n11 = bezierChain3.size() - 1;
                    bezierChain3.points.get(n11).setControlRightType(BezierControlType.None);
                    bezierChain.points.get(0).setControlLeftType(BezierControlType.None);
                    int n12 = 0;
                    if (bezierChain3.points.get(n11).getBase().getY() == bezierChain.points.get(0).getBase().getY()) {
                        if (bezierChain3.points.get(n11).getControlLeftType() != BezierControlType.None) {
                            bezierChain3.points.get(n11).setControlLeftType(BezierControlType.Master);
                        }
                        bezierChain3.points.get(n11).setControlRight(bezierChain.points.get((int)0).controlLeft);
                        if (bezierChain.points.get(0).getControlRightType() != BezierControlType.None) {
                            bezierChain3.points.get(n11).setControlLeftType(BezierControlType.Master);
                        }
                        n12 = 1;
                    }
                    for (n7 = n12; n7 < bezierChain.points.size(); ++n7) {
                        bezierChain.points.get(n7).setID(bezierChain3.getNextId());
                        bezierChain3.add(bezierChain.points.get(n7));
                    }
                    this.remove(curveType, n8);
                    bezierChain = bezierChain3;
                    n2 = (int)bezierChain.getStart();
                    n3 = (int)bezierChain.getEnd();
                    bl = true;
                    continue block10;
                }
                if (n2 < n9 && n9 <= n3 && n3 < n10) {
                    bezierChain3 = null;
                    try {
                        bezierChain3 = bezierChain4.extractPartialBezier(n3, n10);
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    bezierChain3.id = bezierChain4.id;
                    int n13 = bezierChain.size() - 1;
                    bezierChain3.points.get(0).setControlLeftType(BezierControlType.None);
                    bezierChain.points.get(n13).setControlRightType(BezierControlType.None);
                    int n14 = n13;
                    if (bezierChain.points.get(n13).getBase().getY() == bezierChain3.points.get(0).getBase().getY()) {
                        if (bezierChain.points.get(n13).getControlLeftType() != BezierControlType.None) {
                            bezierChain.points.get(n13).setControlLeftType(BezierControlType.Master);
                        }
                        bezierChain.points.get(n13).setControlRight(bezierChain3.points.get((int)0).controlLeft);
                        if (bezierChain3.points.get(0).getControlRightType() != BezierControlType.None) {
                            bezierChain.points.get(n13).setControlLeftType(BezierControlType.Master);
                        }
                        n14 = n13 - 1;
                    }
                    for (n7 = 0; n7 <= n14; ++n7) {
                        bezierChain.points.get(n7).setID(bezierChain3.getNextId());
                        bezierChain3.add(bezierChain.points.get(n7));
                    }
                    this.remove(curveType, n8);
                    bezierChain = bezierChain3;
                    n2 = (int)bezierChain.getStart();
                    n3 = (int)bezierChain.getEnd();
                    bl = true;
                    continue block10;
                }
                if (n9 >= n2 || n3 >= n10) continue;
                bezierChain3 = null;
                try {
                    bezierChain3 = bezierChain4.extractPartialBezier(n9, n2);
                }
                catch (Exception exception) {
                    continue;
                }
                BezierChain bezierChain5 = null;
                try {
                    bezierChain5 = bezierChain4.extractPartialBezier(n3, n10);
                }
                catch (Exception exception) {
                    continue;
                }
                bezierChain3.id = bezierChain4.id;
                bezierChain3.points.get(bezierChain3.size() - 1).setControlRightType(BezierControlType.None);
                bezierChain.points.get(0).setControlLeftType(BezierControlType.None);
                bezierChain.points.get(bezierChain.size() - 1).setControlRightType(BezierControlType.None);
                bezierChain5.points.get(0).setControlLeftType(BezierControlType.None);
                int n15 = 0;
                n7 = bezierChain.size() - 1;
                if (bezierChain3.points.get(bezierChain3.size() - 1).getBase().getY() == bezierChain.points.get(0).getBase().getY()) {
                    if (bezierChain3.points.get(bezierChain3.size() - 1).getControlLeftType() != BezierControlType.None) {
                        bezierChain3.points.get(bezierChain3.size() - 1).setControlLeftType(BezierControlType.Master);
                    }
                    bezierChain3.points.get(bezierChain3.size() - 1).setControlRight(bezierChain.points.get((int)0).controlLeft);
                    if (bezierChain.points.get(0).getControlRightType() != BezierControlType.None) {
                        bezierChain3.points.get(bezierChain3.size() - 1).setControlLeftType(BezierControlType.Master);
                    }
                    n15 = 1;
                }
                if (bezierChain.points.get(bezierChain.size() - 1).getBase().getY() == bezierChain5.points.get(0).getBase().getY()) {
                    if (bezierChain.points.get(bezierChain.size() - 1).getControlLeftType() != BezierControlType.None) {
                        bezierChain.points.get(bezierChain.size() - 1).setControlLeftType(BezierControlType.Master);
                    }
                    bezierChain.points.get(bezierChain.size() - 1).setControlRight(bezierChain5.points.get((int)0).controlLeft);
                    if (bezierChain5.points.get(0).getControlRightType() != BezierControlType.None) {
                        bezierChain.points.get(bezierChain.size() - 1).setControlLeftType(BezierControlType.Master);
                    }
                    n7 = bezierChain.size() - 2;
                }
                for (n6 = n15; n6 <= n7; ++n6) {
                    bezierChain.points.get(n6).setID(bezierChain3.getNextId());
                    bezierChain3.add(bezierChain.points.get(n6));
                }
                for (n6 = 0; n6 < bezierChain5.points.size(); ++n6) {
                    bezierChain5.points.get(n6).setID(bezierChain3.getNextId());
                    bezierChain3.add(bezierChain5.points.get(n6));
                }
                this.remove(curveType, n8);
                bezierChain = bezierChain3;
                n2 = (int)bezierChain.getStart();
                n3 = (int)bezierChain.getEnd();
                bl = true;
                continue block10;
            }
        }
        if (!bl) {
            bezierChain.id = this.getNextId(curveType);
        }
        this.addBezierChain(curveType, bezierChain, bezierChain.id);
    }

    public boolean deleteBeziers(Vector<CurveType> vector, int n, int n2) {
        boolean bl = false;
        for (CurveType curveType : vector) {
            if (curveType.isScalar() || curveType.isAttachNote()) continue;
            Vector<BezierChain> vector2 = new Vector<BezierChain>();
            for (BezierChain bezierChain : this.get(curveType)) {
                BezierChain bezierChain2;
                int n3 = bezierChain.points.size();
                if (n3 < 1) continue;
                int n4 = (int)bezierChain.points.get(0).getBase().getX();
                int n5 = n3 < 2 ? n4 : (int)bezierChain.points.get(n3 - 1).getBase().getX();
                if (n < n4 && n4 < n2 && n2 < n5) {
                    try {
                        bezierChain2 = bezierChain.extractPartialBezier(n2, n5);
                        bezierChain2.id = bezierChain.id;
                        vector2.add(bezierChain2);
                        bl = true;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (n4 <= n && n2 <= n5) {
                    try {
                        bezierChain2 = bezierChain.extractPartialBezier(n4, n);
                        bezierChain2.id = bezierChain.id;
                        BezierChain bezierChain3 = bezierChain.extractPartialBezier(n2, n5);
                        bezierChain3.id = -1;
                        vector2.add(bezierChain2);
                        vector2.add(bezierChain3);
                        bl = true;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (n4 < n && n < n5 && n5 < n2) {
                    try {
                        bezierChain2 = bezierChain.extractPartialBezier(n4, n);
                        bezierChain2.id = bezierChain.id;
                        vector2.add(bezierChain2);
                        bl = true;
                    }
                    catch (Exception exception) {}
                    continue;
                }
                if (n <= n4 && n5 <= n2) {
                    bl = true;
                    continue;
                }
                vector2.add((BezierChain)bezierChain.clone());
            }
            this.get(curveType).clear();
            for (BezierChain bezierChain : vector2) {
                if (bezierChain.id < 0) continue;
                this.addBezierChain(curveType, bezierChain, bezierChain.id);
            }
            for (BezierChain bezierChain : vector2) {
                if (bezierChain.id >= 0) continue;
                bezierChain.id = this.getNextId(curveType);
                this.addBezierChain(curveType, bezierChain, bezierChain.id);
            }
        }
        return bl;
    }

    public void remove(CurveType curveType, int n) {
        Vector<BezierChain> vector = this.get(curveType);
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get((int)i).id != n) continue;
            vector.removeElementAt(i);
            break;
        }
    }

    public void addBezierChain(CurveType curveType, BezierChain bezierChain, int n) {
        int n2 = curveType.getIndex();
        BezierChain bezierChain2 = (BezierChain)bezierChain.clone();
        bezierChain2.id = n;
        this.get(curveType).add(bezierChain2);
    }

    public Object clone() {
        BezierCurves bezierCurves = new BezierCurves();
        for (int i = 0; i < Utility.CURVE_USAGE.length; ++i) {
            CurveType curveType = Utility.CURVE_USAGE[i];
            Vector<BezierChain> vector = this.get(curveType);
            bezierCurves.set(curveType, new Vector<BezierChain>());
            int n = vector.size();
            for (int j = 0; j < n; ++j) {
                bezierCurves.get(curveType).add((BezierChain)vector.get(j).clone());
            }
        }
        return bezierCurves;
    }

    public int getNextId(CurveType curveType) {
        int n = curveType.getIndex();
        Vector<BezierChain> vector = this.get(curveType);
        int n2 = vector.size();
        boolean bl = true;
        block0: while (bl) {
            bl = false;
            for (int i = 0; i < vector.size(); ++i) {
                if (vector.get((int)i).id != n2) continue;
                bl = true;
                ++n2;
                continue block0;
            }
        }
        return n2;
    }

    public Vector<BezierChain> get(CurveType curveType) {
        if (curveType.equals(CurveType.BRE)) {
            return this.Brethiness;
        }
        if (curveType.equals(CurveType.BRI)) {
            return this.Brightness;
        }
        if (curveType.equals(CurveType.CLE)) {
            return this.Clearness;
        }
        if (curveType.equals(CurveType.DYN)) {
            return this.Dynamics;
        }
        if (curveType.equals(CurveType.fx2depth)) {
            return this.FX2Depth;
        }
        if (curveType.equals(CurveType.GEN)) {
            return this.GenderFactor;
        }
        if (curveType.equals(CurveType.harmonics)) {
            return this.Harmonics;
        }
        if (curveType.equals(CurveType.OPE)) {
            return this.Opening;
        }
        if (curveType.equals(CurveType.POR)) {
            return this.PortamentoTiming;
        }
        if (curveType.equals(CurveType.PIT)) {
            return this.PitchBend;
        }
        if (curveType.equals(CurveType.PBS)) {
            return this.PitchBendSensitivity;
        }
        if (curveType.equals(CurveType.reso1amp)) {
            return this.Reso1Amp;
        }
        if (curveType.equals(CurveType.reso1bw)) {
            return this.Reso1BW;
        }
        if (curveType.equals(CurveType.reso1freq)) {
            return this.Reso1Freq;
        }
        if (curveType.equals(CurveType.reso2amp)) {
            return this.Reso2Amp;
        }
        if (curveType.equals(CurveType.reso2bw)) {
            return this.Reso2BW;
        }
        if (curveType.equals(CurveType.reso2freq)) {
            return this.Reso2Freq;
        }
        if (curveType.equals(CurveType.reso3amp)) {
            return this.Reso3Amp;
        }
        if (curveType.equals(CurveType.reso3bw)) {
            return this.Reso3BW;
        }
        if (curveType.equals(CurveType.reso3freq)) {
            return this.Reso3Freq;
        }
        if (curveType.equals(CurveType.reso4amp)) {
            return this.Reso4Amp;
        }
        if (curveType.equals(CurveType.reso4bw)) {
            return this.Reso4BW;
        }
        if (curveType.equals(CurveType.reso4freq)) {
            return this.Reso4Freq;
        }
        if (curveType.equals(CurveType.VibratoDepth)) {
            return this.VibratoDepth;
        }
        if (curveType.equals(CurveType.VibratoRate)) {
            return this.VibratoRate;
        }
        return null;
    }

    public void set(CurveType curveType, Vector<BezierChain> vector) {
        if (curveType.equals(CurveType.BRE)) {
            this.Brethiness = vector;
        } else if (curveType.equals(CurveType.BRI)) {
            this.Brightness = vector;
        } else if (curveType.equals(CurveType.CLE)) {
            this.Clearness = vector;
        } else if (curveType.equals(CurveType.DYN)) {
            this.Dynamics = vector;
        } else if (curveType.equals(CurveType.fx2depth)) {
            this.FX2Depth = vector;
        } else if (curveType.equals(CurveType.GEN)) {
            this.GenderFactor = vector;
        } else if (curveType.equals(CurveType.harmonics)) {
            this.Harmonics = vector;
        } else if (curveType.equals(CurveType.OPE)) {
            this.Opening = vector;
        } else if (curveType.equals(CurveType.POR)) {
            this.PortamentoTiming = vector;
        } else if (curveType.equals(CurveType.PIT)) {
            this.PitchBend = vector;
        } else if (curveType.equals(CurveType.PBS)) {
            this.PitchBendSensitivity = vector;
        } else if (curveType.equals(CurveType.reso1amp)) {
            this.Reso1Amp = vector;
        } else if (curveType.equals(CurveType.reso1bw)) {
            this.Reso1BW = vector;
        } else if (curveType.equals(CurveType.reso1freq)) {
            this.Reso1Freq = vector;
        } else if (curveType.equals(CurveType.reso2amp)) {
            this.Reso2Amp = vector;
        } else if (curveType.equals(CurveType.reso2bw)) {
            this.Reso2BW = vector;
        } else if (curveType.equals(CurveType.reso2freq)) {
            this.Reso2Freq = vector;
        } else if (curveType.equals(CurveType.reso3amp)) {
            this.Reso3Amp = vector;
        } else if (curveType.equals(CurveType.reso3bw)) {
            this.Reso3BW = vector;
        } else if (curveType.equals(CurveType.reso3freq)) {
            this.Reso3Freq = vector;
        } else if (curveType.equals(CurveType.reso4amp)) {
            this.Reso4Amp = vector;
        } else if (curveType.equals(CurveType.reso4bw)) {
            this.Reso4BW = vector;
        } else if (curveType.equals(CurveType.reso4freq)) {
            this.Reso4Freq = vector;
        } else if (curveType.equals(CurveType.VibratoDepth)) {
            this.VibratoDepth = vector;
        } else if (curveType.equals(CurveType.VibratoRate)) {
            this.VibratoRate = vector;
        }
    }
}

