/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import org.kbinani.cadencii.BezierControlType;
import org.kbinani.cadencii.BezierPickedSide;
import org.kbinani.cadencii.PointD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BezierPoint
implements Comparable<BezierPoint>,
Cloneable {
    PointD center;
    public PointD controlLeft;
    public PointD controlRight;
    BezierControlType m_type_left;
    BezierControlType m_type_right;
    int m_id;

    public static boolean isXmlIgnored(String string) {
        return string.equals("ID");
    }

    public int getID() {
        return this.m_id;
    }

    public void setID(int n) {
        this.m_id = n;
    }

    public String toString() {
        return "m_super=" + this.center.getX() + "," + this.center.getY() + "\n" + "m_control_left=" + this.controlLeft.getX() + "," + this.controlLeft.getY() + "\n" + "m_control_right=" + this.controlRight.getX() + "," + this.controlRight.getY() + "\n" + "m_type_left=" + (Object)((Object)this.m_type_left) + "\n" + "m_type_right=" + (Object)((Object)this.m_type_right) + "\n";
    }

    private BezierPoint() {
    }

    public BezierPoint(PointD pointD) {
        this(pointD.getX(), pointD.getY());
    }

    public BezierPoint(double d, double d2) {
        PointD pointD;
        this.center = pointD = new PointD(d, d2);
        this.controlLeft = pointD;
        this.controlRight = pointD;
        this.m_type_left = BezierControlType.None;
        this.m_type_right = BezierControlType.None;
    }

    public BezierPoint(PointD pointD, PointD pointD2, PointD pointD3) {
        this.center = pointD;
        this.controlLeft = new PointD(pointD2.getX() - this.center.getX(), pointD2.getY() - this.center.getY());
        this.controlRight = new PointD(pointD3.getX() - this.center.getX(), pointD3.getY() - this.center.getY());
        this.m_type_left = BezierControlType.None;
        this.m_type_right = BezierControlType.None;
    }

    public Object clone() {
        BezierPoint bezierPoint = new BezierPoint(this.getBase(), this.getControlLeft(), this.getControlRight());
        bezierPoint.controlLeft = this.controlLeft;
        bezierPoint.controlRight = this.controlRight;
        bezierPoint.m_type_left = this.m_type_left;
        bezierPoint.m_type_right = this.m_type_right;
        bezierPoint.m_id = this.m_id;
        return bezierPoint;
    }

    @Override
    public int compareTo(BezierPoint bezierPoint) {
        double d;
        double d2 = this.getBase().getX();
        if (d2 > (d = bezierPoint.getBase().getX())) {
            return 1;
        }
        if (d2 < d) {
            return -1;
        }
        if (this.getID() > bezierPoint.getID()) {
            return 1;
        }
        if (this.getID() < bezierPoint.getID()) {
            return -1;
        }
        return 0;
    }

    public PointD getBase() {
        return this.center;
    }

    public void setBase(PointD pointD) {
        this.center = pointD;
    }

    public void setPosition(BezierPickedSide bezierPickedSide, PointD pointD) {
        if (bezierPickedSide == BezierPickedSide.BASE) {
            this.setBase(pointD);
        } else if (bezierPickedSide == BezierPickedSide.LEFT) {
            this.controlLeft = new PointD(pointD.getX() - this.getBase().getX(), pointD.getY() - this.getBase().getY());
        } else {
            this.controlRight = new PointD(pointD.getX() - this.getBase().getX(), pointD.getY() - this.getBase().getY());
        }
    }

    public PointD getPosition(BezierPickedSide bezierPickedSide) {
        if (bezierPickedSide == BezierPickedSide.BASE) {
            return this.getBase();
        }
        if (bezierPickedSide == BezierPickedSide.LEFT) {
            return this.getControlLeft();
        }
        return this.getControlRight();
    }

    public BezierControlType getControlType(BezierPickedSide bezierPickedSide) {
        if (bezierPickedSide == BezierPickedSide.LEFT) {
            return this.getControlLeftType();
        }
        if (bezierPickedSide == BezierPickedSide.RIGHT) {
            return this.getControlRightType();
        }
        return BezierControlType.None;
    }

    public PointD getControlLeft() {
        if (this.m_type_left != BezierControlType.None) {
            return new PointD(this.center.getX() + this.controlLeft.getX(), this.center.getY() + this.controlLeft.getY());
        }
        return this.center;
    }

    public void setControlLeft(PointD pointD) {
        this.controlLeft = new PointD(pointD.getX() - this.center.getX(), pointD.getY() - this.center.getY());
    }

    public PointD getControlRight() {
        if (this.m_type_right != BezierControlType.None) {
            return new PointD(this.center.getX() + this.controlRight.getX(), this.center.getY() + this.controlRight.getY());
        }
        return this.center;
    }

    public void setControlRight(PointD pointD) {
        this.controlRight = new PointD(pointD.getX() - this.center.getX(), pointD.getY() - this.center.getY());
    }

    public BezierControlType getControlLeftType() {
        return this.m_type_left;
    }

    public void setControlLeftType(BezierControlType bezierControlType) {
        this.m_type_left = bezierControlType;
        if (this.m_type_left == BezierControlType.Master && this.m_type_right != BezierControlType.None) {
            this.m_type_right = BezierControlType.Master;
        }
    }

    public BezierControlType getControlRightType() {
        return this.m_type_right;
    }

    public void setControlRightType(BezierControlType bezierControlType) {
        this.m_type_right = bezierControlType;
        if (this.m_type_right == BezierControlType.Master && this.m_type_left != BezierControlType.None) {
            this.m_type_left = BezierControlType.Master;
        }
    }
}

