/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.apputil.Messaging;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.NumericUpDownEx;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.vsq.Timesig;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BCheckBox;
import org.kbinani.windows.forms.BComboBox;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BLabel;

public class FormRandomize
extends BDialog {
    private static boolean lastPositionRandomizeEnabled = true;
    private static int lastPositionRandomizeValue = 3;
    private static boolean lastPitRandomizeEnabled = true;
    private static int lastResolution = 5;
    private static int lastPitRandomizeValue = 3;
    private static int lastPitRandomizePattern = 1;
    private static int lastStartBar = 1;
    private static int lastStartBeat = 1;
    private static int lastEndBar = 2;
    private static int lastEndBeat = 1;
    private boolean synchronizedRequired = false;
    private static final long serialVersionUID = 5210609912644248288L;
    private JPanel jPanel = null;
    private BLabel lblStartBar = null;
    private BLabel lblStart = null;
    private NumericUpDownEx numStartBar = null;
    private BLabel lblStartBeat = null;
    private NumericUpDownEx numStartBeat = null;
    private BLabel jLabel11 = null;
    private BLabel lblEnd = null;
    private NumericUpDownEx numEndBar = null;
    private BLabel lblEndBar = null;
    private NumericUpDownEx numEndBeat = null;
    private BLabel lblEndBeat = null;
    private BCheckBox chkShift = null;
    private JPanel jPanel1 = null;
    private JPanel jPanel2 = null;
    private BLabel lblShiftValue = null;
    private BComboBox comboShiftValue = null;
    private BCheckBox chkPit = null;
    private BLabel lblResolution = null;
    private NumericUpDownEx numResolution = null;
    private JPanel jPanel21 = null;
    private BLabel lblPitPattern = null;
    private BComboBox comboPitPattern = null;
    private JPanel jPanel22 = null;
    private BLabel lblPitValue = null;
    private BComboBox comboPitValue = null;
    private JPanel jPanel3 = null;
    private BButton btnCancel = null;
    private BButton btnOK = null;
    private BLabel jLabel1212 = null;

    public FormRandomize() {
        this.initialize();
        this.registerEventHandlers();
        this.applyLanguage();
        this.chkShift.setSelected(lastPositionRandomizeEnabled);
        this.comboShiftValue.setSelectedIndex(lastPositionRandomizeValue - 1);
        this.chkPit.setSelected(lastPitRandomizeEnabled);
        this.numResolution.setValue(lastResolution);
        this.comboPitPattern.setSelectedIndex(lastPitRandomizePattern - 1);
        this.comboPitValue.setSelectedIndex(lastPitRandomizeValue - 1);
        this.synchronizedRequired = true;
        this.numStartBar.setValue(lastStartBar);
        this.numStartBeat.setValue(lastStartBeat);
        this.numEndBar.setValue(lastEndBar);
        this.numEndBeat.setValue(lastEndBeat);
        this.synchronizedRequired = false;
    }

    private void validateNumRange() {
        int n;
        int n2 = this.getStartBar();
        int n3 = this.getStartBeat();
        int n4 = this.getEndBar();
        int n5 = this.getEndBeat();
        VsqFileEx vsqFileEx = AppManager.getVsqFile();
        if (vsqFileEx == null) {
            return;
        }
        int n6 = vsqFileEx.getPreMeasure();
        --n5;
        int n7 = vsqFileEx.getClockFromBarCount(n2 += n6 - 1);
        Timesig timesig = vsqFileEx.getTimesigAt(n7);
        int n8 = n7 + --n3 * 480 * 4 / timesig.denominator;
        int n9 = vsqFileEx.getClockFromBarCount(n4 += n6 - 1);
        Timesig timesig2 = vsqFileEx.getTimesigAt(n9);
        int n10 = n9 + n5 * 480 * 4 / timesig2.denominator;
        if (n10 <= n8) {
            n10 = n8 + 1920 / timesig.denominator;
            n4 = vsqFileEx.getBarCountFromClock(n10);
            n = n10 - vsqFileEx.getClockFromBarCount(n4);
            timesig2 = vsqFileEx.getTimesigAt(n10);
            n5 = n / (1920 / timesig2.denominator);
        }
        n = n4 - 1;
        if (n3 < n5) {
            n = n4;
        }
        boolean bl = true;
        int n11 = timesig.numerator;
        if (n2 == n4) {
            n11 = n5 - 1;
        }
        boolean bl2 = true;
        int n12 = Integer.MAX_VALUE;
        int n13 = n2 + 1;
        if (n3 < n5) {
            n13 = n2;
        }
        int n14 = timesig2.numerator;
        int n15 = 1;
        if (n2 == n4) {
            n15 = n3 + 1;
        }
        this.synchronizedRequired = true;
        this.numStartBar.setMaximum(n);
        this.numStartBar.setMinimum((float)bl);
        this.numStartBeat.setMaximum(n11);
        this.numStartBeat.setMinimum((float)bl2);
        this.numEndBar.setMaximum(n12);
        this.numEndBar.setMinimum(n13);
        this.numEndBeat.setMaximum(n14);
        this.numEndBeat.setMinimum(n15);
        this.synchronizedRequired = false;
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void registerEventHandlers() {
        this.btnOK.clickEvent.add(new BEventHandler(this, "btnOK_Click"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
        this.numStartBar.valueChangedEvent.add(new BEventHandler(this, "numCommon_ValueChanged"));
        this.numStartBeat.valueChangedEvent.add(new BEventHandler(this, "numCommon_ValueChanged"));
        this.numEndBar.valueChangedEvent.add(new BEventHandler(this, "numCommon_ValueChanged"));
        this.numEndBeat.valueChangedEvent.add(new BEventHandler(this, "numCommon_ValueChanged"));
        this.chkShift.checkedChangedEvent.add(new BEventHandler(this, "chkShift_CheckedChanged"));
        this.chkPit.checkedChangedEvent.add(new BEventHandler(this, "chkPit_CheckedChanged"));
    }

    public void chkShift_CheckedChanged(Object object, BEventArgs bEventArgs) {
        boolean bl = this.chkShift.isSelected();
        this.comboShiftValue.setEnabled(bl);
    }

    public void chkPit_CheckedChanged(Object object, BEventArgs bEventArgs) {
        boolean bl = this.chkPit.isSelected();
        this.numResolution.setEnabled(bl);
        this.comboPitPattern.setEnabled(bl);
        this.comboPitValue.setEnabled(bl);
    }

    public void numCommon_ValueChanged(Object object, BEventArgs bEventArgs) {
        if (this.synchronizedRequired) {
            return;
        }
        this.validateNumRange();
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    public void btnOK_Click(Object object, BEventArgs bEventArgs) {
        lastPositionRandomizeEnabled = this.isPositionRandomizeEnabled();
        lastPositionRandomizeValue = this.getPositionRandomizeValue();
        lastPitRandomizeEnabled = this.isPitRandomizeEnabled();
        lastPitRandomizePattern = this.getPitRandomizePattern();
        lastPitRandomizeValue = this.getPitRandomizeValue();
        lastResolution = this.getResolution();
        lastStartBar = this.getStartBar();
        lastStartBeat = this.getStartBeat();
        lastEndBar = this.getEndBar();
        lastEndBeat = this.getEndBeat();
        this.setDialogResult(BDialogResult.OK);
    }

    public int getResolution() {
        return (int)this.numResolution.getValue();
    }

    public int getStartBar() {
        return (int)this.numStartBar.getValue();
    }

    public int getStartBeat() {
        return (int)this.numStartBeat.getValue();
    }

    public int getEndBar() {
        return (int)this.numEndBar.getValue();
    }

    public int getEndBeat() {
        return (int)this.numEndBeat.getValue();
    }

    public boolean isPositionRandomizeEnabled() {
        return this.chkShift.isSelected();
    }

    public int getPositionRandomizeValue() {
        int n = this.comboShiftValue.getSelectedIndex() + 1;
        if (n <= 0) {
            n = 1;
        }
        return n;
    }

    public boolean isPitRandomizeEnabled() {
        return this.chkPit.isSelected();
    }

    public int getPitRandomizeValue() {
        int n = this.comboPitValue.getSelectedIndex() + 1;
        if (n <= 0) {
            n = 1;
        }
        return n;
    }

    public int getPitRandomizePattern() {
        int n = this.comboPitPattern.getSelectedIndex() + 1;
        if (n <= 0) {
            n = 1;
        }
        return n;
    }

    public void applyLanguage() {
        this.lblStart.setText(FormRandomize._("Start"));
        this.lblStartBar.setText(FormRandomize._("bar"));
        this.lblStartBeat.setText(FormRandomize._("beat"));
        this.lblEnd.setText(FormRandomize._("End"));
        this.lblEndBar.setText(FormRandomize._("bar"));
        this.lblEndBeat.setText(FormRandomize._("beat"));
        this.chkShift.setText(FormRandomize._("Note Shift"));
        this.lblShiftValue.setText(FormRandomize._("Value"));
        this.chkPit.setText(FormRandomize._("Pitch Fluctuation"));
        this.lblResolution.setText(FormRandomize._("Resolution"));
        this.lblPitPattern.setText(FormRandomize._("Pattern"));
        this.lblPitValue.setText(FormRandomize._("Value"));
        this.btnOK.setText(FormRandomize._("OK"));
        this.btnCancel.setText(FormRandomize._("Cancel"));
        this.setTitle(FormRandomize._("Randomize"));
    }

    private void initialize() {
        this.setSize(new Dimension(361, 289));
        this.setTitle("Randomize");
        this.setContentPane(this.getJPanel1());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 7;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 1;
            this.jLabel1212 = new BLabel();
            this.jLabel1212.setText(" ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 6;
            gridBagConstraints2.gridy = 0;
            this.lblEndBeat = new BLabel();
            this.lblEndBeat.setText("beat");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 6;
            gridBagConstraints3.insets = new Insets(4, 4, 4, 8);
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 5;
            gridBagConstraints4.gridy = 0;
            this.lblEndBar = new BLabel();
            this.lblEndBar.setText("bar");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 5;
            gridBagConstraints5.insets = new Insets(4, 8, 4, 4);
            gridBagConstraints5.gridy = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 4;
            gridBagConstraints6.gridy = 1;
            this.lblEnd = new BLabel();
            this.lblEnd.setText("end");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 3;
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 2;
            gridBagConstraints8.insets = new Insets(4, 4, 4, 8);
            gridBagConstraints8.gridy = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 2;
            gridBagConstraints9.gridy = 0;
            this.lblStartBeat = new BLabel();
            this.lblStartBeat.setText("beat");
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 3;
            gridBagConstraints10.gridy = 1;
            gridBagConstraints10.weightx = 0.0;
            gridBagConstraints10.insets = new Insets(4, 8, 4, 4);
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints11.gridy = 1;
            this.lblStart = new BLabel();
            this.lblStart.setText("start");
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.gridy = 0;
            this.lblStartBar = new BLabel();
            this.lblStartBar.setText("bar");
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.lblStartBar, gridBagConstraints12);
            this.jPanel.add((Component)this.lblStart, gridBagConstraints11);
            this.jPanel.add((Component)this.getNumStartBar(), gridBagConstraints10);
            this.jPanel.add((Component)this.lblStartBeat, gridBagConstraints9);
            this.jPanel.add((Component)this.getNumStartBeat(), gridBagConstraints8);
            this.jPanel.add((Component)this.jLabel11, gridBagConstraints7);
            this.jPanel.add((Component)this.lblEnd, gridBagConstraints6);
            this.jPanel.add((Component)this.getNumEndBar(), gridBagConstraints5);
            this.jPanel.add((Component)this.lblEndBar, gridBagConstraints4);
            this.jPanel.add((Component)this.getNumEndBeat(), gridBagConstraints3);
            this.jPanel.add((Component)this.lblEndBeat, gridBagConstraints2);
            this.jPanel.add((Component)this.jLabel1212, gridBagConstraints);
        }
        return this.jPanel;
    }

    private NumericUpDownEx getNumStartBar() {
        if (this.numStartBar == null) {
            this.numStartBar = new NumericUpDownEx();
            this.numStartBar.setPreferredSize(new Dimension(54, 19));
        }
        return this.numStartBar;
    }

    private NumericUpDownEx getNumStartBeat() {
        if (this.numStartBeat == null) {
            this.jLabel11 = new BLabel();
            this.jLabel11.setText("-");
            this.numStartBeat = new NumericUpDownEx();
            this.numStartBeat.setPreferredSize(new Dimension(54, 19));
        }
        return this.numStartBeat;
    }

    private NumericUpDownEx getNumEndBar() {
        if (this.numEndBar == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = -1;
            gridBagConstraints.gridy = -1;
            this.numEndBar = new NumericUpDownEx();
            this.numEndBar.setPreferredSize(new Dimension(54, 19));
        }
        return this.numEndBar;
    }

    private NumericUpDownEx getNumEndBeat() {
        if (this.numEndBeat == null) {
            this.numEndBeat = new NumericUpDownEx();
            this.numEndBeat.setPreferredSize(new Dimension(54, 19));
        }
        return this.numEndBeat;
    }

    private BCheckBox getChkShift() {
        if (this.chkShift == null) {
            this.chkShift = new BCheckBox();
            this.chkShift.setText("Note Shift");
        }
        return this.chkShift;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 6;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridwidth = 3;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(4, 0, 4, 0);
            gridBagConstraints2.gridy = 5;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 3;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(4, 0, 4, 0);
            gridBagConstraints3.gridy = 4;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.anchor = 13;
            gridBagConstraints4.insets = new Insets(16, 0, 0, 16);
            gridBagConstraints4.gridy = 3;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.anchor = 13;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.insets = new Insets(16, 0, 0, 4);
            gridBagConstraints5.gridy = 3;
            this.lblResolution = new BLabel();
            this.lblResolution.setText("Resolution");
            this.lblResolution.setHorizontalTextPosition(4);
            this.lblResolution.setHorizontalAlignment(4);
            this.lblResolution.setVerticalAlignment(0);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(16, 16, 0, 0);
            gridBagConstraints6.gridy = 3;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridwidth = 3;
            gridBagConstraints7.insets = new Insets(4, 0, 4, 0);
            gridBagConstraints7.gridy = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(16, 16, 0, 0);
            gridBagConstraints8.gridy = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.fill = 2;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.gridwidth = 3;
            gridBagConstraints9.insets = new Insets(16, 16, 0, 0);
            gridBagConstraints9.gridy = 0;
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.getJPanel(), gridBagConstraints9);
            this.jPanel1.add((Component)this.getChkShift(), gridBagConstraints8);
            this.jPanel1.add((Component)this.getJPanel2(), gridBagConstraints7);
            this.jPanel1.add((Component)this.getChkPit(), gridBagConstraints6);
            this.jPanel1.add((Component)this.lblResolution, gridBagConstraints5);
            this.jPanel1.add((Component)this.getNumResolution(), gridBagConstraints4);
            this.jPanel1.add((Component)this.getJPanel21(), gridBagConstraints3);
            this.jPanel1.add((Component)this.getJPanel22(), gridBagConstraints2);
            this.jPanel1.add((Component)this.getJPanel3(), gridBagConstraints);
        }
        return this.jPanel1;
    }

    private JPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 8, 0, 16);
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 32, 0, 0);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 0;
            this.lblShiftValue = new BLabel();
            this.lblShiftValue.setText("Value");
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.lblShiftValue, gridBagConstraints2);
            this.jPanel2.add((Component)this.getComboShiftValue(), gridBagConstraints);
        }
        return this.jPanel2;
    }

    private BComboBox getComboShiftValue() {
        if (this.comboShiftValue == null) {
            this.comboShiftValue = new BComboBox();
            this.comboShiftValue.setPreferredSize(new Dimension(218, 19));
        }
        return this.comboShiftValue;
    }

    private BCheckBox getChkPit() {
        if (this.chkPit == null) {
            this.chkPit = new BCheckBox();
            this.chkPit.setText("Pitch Fluctuation");
        }
        return this.chkPit;
    }

    private NumericUpDownEx getNumResolution() {
        if (this.numResolution == null) {
            this.numResolution = new NumericUpDownEx();
            this.numResolution.setPreferredSize(new Dimension(54, 19));
        }
        return this.numResolution;
    }

    private JPanel getJPanel21() {
        if (this.jPanel21 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 8, 0, 16);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 32, 0, 0);
            this.lblPitPattern = new BLabel();
            this.lblPitPattern.setText("Pattern");
            this.jPanel21 = new JPanel();
            this.jPanel21.setLayout(new GridBagLayout());
            this.jPanel21.add((Component)this.lblPitPattern, gridBagConstraints2);
            this.jPanel21.add((Component)this.getComboPitPattern(), gridBagConstraints);
        }
        return this.jPanel21;
    }

    private BComboBox getComboPitPattern() {
        if (this.comboPitPattern == null) {
            this.comboPitPattern = new BComboBox();
            this.comboPitPattern.setPreferredSize(new Dimension(218, 19));
        }
        return this.comboPitPattern;
    }

    private JPanel getJPanel22() {
        if (this.jPanel22 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 8, 0, 16);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 32, 0, 0);
            this.lblPitValue = new BLabel();
            this.lblPitValue.setText("Value");
            this.jPanel22 = new JPanel();
            this.jPanel22.setLayout(new GridBagLayout());
            this.jPanel22.add((Component)this.lblPitValue, gridBagConstraints2);
            this.jPanel22.add((Component)this.getComboPitValue(), gridBagConstraints);
        }
        return this.jPanel22;
    }

    private BComboBox getComboPitValue() {
        if (this.comboPitValue == null) {
            this.comboPitValue = new BComboBox();
            this.comboPitValue.setPreferredSize(new Dimension(218, 19));
        }
        return this.comboPitValue;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 2;
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.add((Component)this.getBtnCancel(), gridBagConstraints2);
            this.jPanel3.add((Component)this.getBtnOK(), gridBagConstraints);
        }
        return this.jPanel3;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }

    private BButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }
}

