/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.AutoVibratoMinLengthEnum;
import org.kbinani.cadencii.AutoVibratoMinLengthUtil;
import org.kbinani.cadencii.ClockResolution;
import org.kbinani.cadencii.ClockResolutionUtility;
import org.kbinani.cadencii.DefaultVibratoLengthEnum;
import org.kbinani.cadencii.DefaultVibratoLengthUtil;
import org.kbinani.cadencii.PlatformEnum;
import org.kbinani.vsq.SingerConfig;
import org.kbinani.vsq.SynthesizerType;
import org.kbinani.vsq.VibratoHandle;
import org.kbinani.vsq.VocaloSysUtil;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BCheckBox;
import org.kbinani.windows.forms.BComboBox;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BFileChooser;
import org.kbinani.windows.forms.BFolderBrowser;
import org.kbinani.windows.forms.BFontChooser;
import org.kbinani.windows.forms.BFormClosingEventArgs;
import org.kbinani.windows.forms.BFormClosingEventHandler;
import org.kbinani.windows.forms.BGroupBox;
import org.kbinani.windows.forms.BLabel;
import org.kbinani.windows.forms.BListView;
import org.kbinani.windows.forms.BListViewItem;
import org.kbinani.windows.forms.BNumericUpDown;
import org.kbinani.windows.forms.BPanel;
import org.kbinani.windows.forms.BRadioButton;
import org.kbinani.windows.forms.BTextBox;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Preference
extends BDialog {
    Font m_super_font;
    Font m_screen_font;
    Font m_counter_font;
    Vector<String> m_program_change = null;
    private PlatformEnum m_platform = PlatformEnum.Windows;
    private Vector<SingerConfig> m_utau_singers = new Vector();
    private BFileChooser openUtauCore;
    private static int columnWidthHeaderProgramChange = 60;
    private static int columnWidthHeaderName = 100;
    private static int columnWidthHeaderPath = 250;
    private BFontChooser fontDialog;
    private BFolderBrowser folderBrowserSingers;
    private static final long serialVersionUID = 1L;
    private BPanel tabSequence = null;
    private BLabel lblResolution = null;
    private BPanel BPanel = null;
    private BLabel lblDynamics = null;
    private BComboBox comboDynamics = null;
    private BLabel lblAmplitude = null;
    private BComboBox comboAmplitude = null;
    private BLabel lblPeriod = null;
    private BComboBox comboPeriod = null;
    private BLabel jLabel1 = null;
    private BLabel jLabel11 = null;
    private BLabel jLabel12 = null;
    private BLabel lblVibratoConfig = null;
    private BPanel jPanel1 = null;
    private BLabel lblVibratoLength = null;
    private BComboBox comboVibratoLength = null;
    private BLabel jLabel13 = null;
    private BGroupBox groupAutoVibratoConfig = null;
    private BPanel jPanel3 = null;
    private BCheckBox chkEnableAutoVibrato = null;
    private BLabel lblAutoVibratoMinLength = null;
    private BComboBox comboAutoVibratoMinLength = null;
    private BLabel jLabel4 = null;
    private BPanel jPanel4 = null;
    private BLabel lblAutoVibratoType1 = null;
    private BComboBox comboAutoVibratoType1 = null;
    private BLabel lblAutoVibratoType2 = null;
    private BComboBox comboAutoVibratoType2 = null;
    private BPanel tabAnother = null;
    private BLabel lblDefaultSinger = null;
    private BComboBox comboDefualtSinger = null;
    private BLabel lblPreSendTime = null;
    private BNumericUpDown numPreSendTime = null;
    private BLabel jLabel8 = null;
    private BLabel lblWait = null;
    private BNumericUpDown numWait = null;
    private BLabel jLabel81 = null;
    private BLabel lblDefaultPremeasure = null;
    private BComboBox comboDefaultPremeasure = null;
    private BLabel jLabel9 = null;
    private BPanel tabAppearance = null;
    private BGroupBox groupFont = null;
    private BLabel labelMenu = null;
    private BLabel labelMenuFontName = null;
    private BButton btnChangeMenuFont = null;
    private BLabel labelScreen = null;
    private BLabel labelScreenFontName = null;
    private BButton btnChangeScreenFont = null;
    private BPanel jPanel7 = null;
    private BLabel lblLanguage = null;
    private BComboBox comboLanguage = null;
    private BPanel jPanel71 = null;
    private BLabel lblTrackHeight = null;
    private BNumericUpDown numTrackHeight = null;
    private BGroupBox groupVisibleCurve = null;
    private BCheckBox chkAccent = null;
    private BCheckBox chkDecay = null;
    private BCheckBox chkVibratoRate = null;
    private BCheckBox chkVibratoDepth = null;
    private BCheckBox chkVel = null;
    private BCheckBox chkDyn = null;
    private BCheckBox chkBre = null;
    private BCheckBox chkBri = null;
    private BCheckBox chkCle = null;
    private BCheckBox chkOpe = null;
    private BCheckBox chkGen = null;
    private BCheckBox chkPor = null;
    private BCheckBox chkPit = null;
    private BCheckBox chkPbs = null;
    private BCheckBox chkHarmonics = null;
    private BCheckBox chkFx2Depth = null;
    private BCheckBox chkReso1 = null;
    private BCheckBox chkReso2 = null;
    private BCheckBox chkReso3 = null;
    private BCheckBox chkReso4 = null;
    private BCheckBox chkEnvelope = null;
    private BPanel tabOperation = null;
    private BGroupBox groupPianoroll = null;
    private BLabel labelWheelOrder = null;
    private BNumericUpDown numericUpDownEx1 = null;
    private BCheckBox chkCursorFix = null;
    private BCheckBox chkScrollHorizontal = null;
    private BCheckBox chkKeepLyricInputMode = null;
    private BCheckBox chkPlayPreviewWhenRightClick = null;
    private BCheckBox chkCurveSelectingQuantized = null;
    private BCheckBox chkUseSpaceKeyAsMiddleButtonModifier = null;
    private BGroupBox groupMisc = null;
    private BLabel lblMaximumFrameRate = null;
    private BNumericUpDown numMaximumFrameRate = null;
    private BLabel lblMilliSecond = null;
    private BLabel lblMouseHoverTime = null;
    private BNumericUpDown numMouseHoverTime = null;
    private BLabel lblMidiInPort = null;
    private BComboBox comboMidiInPortNumber = null;
    private BPanel tabPlatform = null;
    private BGroupBox groupPlatform = null;
    private BLabel lblPlatform = null;
    private BComboBox comboPlatform = null;
    private BCheckBox chkCommandKeyAsControl = null;
    private BCheckBox chkTranslateRoman = null;
    private BGroupBox groupVsti = null;
    private BLabel lblVOCALOID1 = null;
    private BTextBox txtVOCALOID1 = null;
    private BLabel lblVOCALOID2 = null;
    private BTextBox txtVOCALOID2 = null;
    private BGroupBox groupUtauCores = null;
    private BLabel lblResampler = null;
    private BTextBox txtResampler = null;
    private BButton btnResampler = null;
    private BLabel lblWavtool = null;
    private BTextBox txtWavtool = null;
    private BButton btnWavtool = null;
    private BCheckBox chkInvokeWithWine = null;
    private BPanel tabUtauSingers = null;
    private BListView listSingers = null;
    private BButton btnAdd = null;
    private BButton btnRemove = null;
    private BButton btnUp = null;
    private BButton btnDown = null;
    private BPanel jPanel17 = null;
    private BPanel jPanel18 = null;
    private BPanel tabFile = null;
    private BCheckBox chkAutoBackup = null;
    private BLabel lblAutoBackupInterval = null;
    private BLabel lblAutoBackupMinutes = null;
    private BPanel jPanel20 = null;
    private BPanel panelLower = null;
    private BButton btnOK = null;
    private BButton btnCancel = null;
    private BPanel jPanel5 = null;
    private BPanel panelUpper = null;
    private JTabbedPane tabPane = null;
    private BNumericUpDown numAutoBackupInterval = null;
    private JCheckBox chkChasePastEvent = null;
    private BLabel lblAquesTone = null;
    private BTextBox txtAquesTone = null;
    private BButton btnAquesTone = null;
    private BLabel lblBuffer = null;
    private BNumericUpDown numBuffer = null;
    private BLabel jLabel811 = null;
    private BGroupBox groupWaveFileOutput = null;
    private BLabel lblChannel = null;
    private BComboBox comboChannel = null;
    private BRadioButton radioMasterTrack = null;
    private BRadioButton radioCurrentTrack = null;
    private JPanel jPanel = null;
    private JPanel jPanel2 = null;
    private BLabel labelMtcMidiInPort = null;
    private BComboBox comboMtcMidiInPortNumber = null;
    private BPanel tabSingingSynth = null;
    private BGroupBox groupSynthesizerDll = null;
    private BCheckBox chkLoadSecondaryVOCALOID1 = null;
    private BCheckBox chkLoadVocaloid100 = null;
    private BCheckBox chkLoadVocaloid101 = null;
    private BCheckBox chkLoadVocaloid2 = null;
    private BCheckBox chkLoadAquesTone = null;
    private BCheckBox chkKeepProjectCache = null;

    public Preference() {
        this.initialize();
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab("Sequence", this.getTabSequence());
        this.tabPane.addTab("Other Settings", this.getTabAnother());
        this.tabPane.addTab("Appearance", this.getTabAppearance());
        this.tabPane.addTab("Operation", this.getTabOperation());
        this.tabPane.addTab("Platform", this.getTabPlatform());
        this.tabPane.addTab("UTAU Singers", this.getTabUtauSingers());
        this.tabPane.addTab("File", this.getTabFile());
        this.tabPane.addTab("Synthesizer", this.getTabSingingSynth());
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.getPanelUpper().setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints.fill = 1;
        gridBagLayout.setConstraints(this.tabPane, gridBagConstraints);
        this.getPanelUpper().add(this.tabPane);
        this.fontDialog = new BFontChooser();
        this.openUtauCore = new BFileChooser("");
        this.folderBrowserSingers = new BFolderBrowser();
        this.folderBrowserSingers.setNewFolderButtonVisible(false);
        this.applyLanguage();
        this.comboVibratoLength.removeAllItems();
        for (DefaultVibratoLengthEnum singerConfigArray2 : DefaultVibratoLengthEnum.values()) {
            this.comboVibratoLength.addItem(DefaultVibratoLengthUtil.toString(singerConfigArray2));
        }
        this.comboVibratoLength.setSelectedIndex(1);
        this.comboAutoVibratoMinLength.removeAllItems();
        for (Enum enum_ : AutoVibratoMinLengthEnum.values()) {
            this.comboAutoVibratoMinLength.addItem(AutoVibratoMinLengthUtil.toString((AutoVibratoMinLengthEnum)enum_));
        }
        this.comboAutoVibratoMinLength.setSelectedIndex(0);
        this.comboAutoVibratoType1.removeAllItems();
        Object object = VocaloSysUtil.vibratoConfigIterator(SynthesizerType.VOCALOID1);
        while (object.hasNext()) {
            VibratoHandle vibratoHandle = (VibratoHandle)object.next();
            this.comboAutoVibratoType1.addItem(vibratoHandle);
        }
        if (this.comboAutoVibratoType1.getItemCount() > 0) {
            this.comboAutoVibratoType1.setSelectedIndex(0);
        }
        this.comboAutoVibratoType2.removeAllItems();
        object = VocaloSysUtil.vibratoConfigIterator(SynthesizerType.VOCALOID2);
        while (object.hasNext()) {
            VibratoHandle vibratoHandle = (VibratoHandle)object.next();
            this.comboAutoVibratoType2.addItem(vibratoHandle);
        }
        if (this.comboAutoVibratoType2.getItemCount() > 0) {
            this.comboAutoVibratoType2.setSelectedIndex(0);
        }
        this.comboDynamics.removeAllItems();
        this.comboAmplitude.removeAllItems();
        this.comboPeriod.removeAllItems();
        object = ClockResolutionUtility.iterator();
        while (object.hasNext()) {
            ClockResolution clockResolution = (ClockResolution)((Object)object.next());
            this.comboDynamics.addItem(ClockResolutionUtility.toString(clockResolution));
            this.comboAmplitude.addItem(ClockResolutionUtility.toString(clockResolution));
            this.comboPeriod.addItem(ClockResolutionUtility.toString(clockResolution));
        }
        this.comboDynamics.setSelectedIndex(0);
        this.comboAmplitude.setSelectedIndex(0);
        this.comboPeriod.setSelectedIndex(0);
        this.comboLanguage.removeAllItems();
        object = Messaging.getRegisteredLanguage();
        int n = 0;
        this.comboLanguage.addItem("Default");
        int n2 = 0;
        for (Object object2 : object) {
            ++n2;
            this.comboLanguage.addItem(object2);
            if (!((String)object2).equals(Messaging.getLanguage())) continue;
            n = n2;
        }
        this.comboLanguage.setSelectedIndex(n);
        SingerConfig[] singerConfigArray = VocaloSysUtil.getSingerConfigs(SynthesizerType.VOCALOID2);
        this.m_program_change = new Vector();
        this.comboDefualtSinger.removeAllItems();
        for (SingerConfig singerConfig : singerConfigArray) {
            this.m_program_change.add(singerConfig.VOICENAME);
            this.comboDefualtSinger.addItem(singerConfig.VOICENAME);
        }
        this.comboDefualtSinger.setEnabled(this.comboDefualtSinger.getItemCount() > 0);
        if (this.comboDefualtSinger.getItemCount() > 0) {
            this.comboDefualtSinger.setSelectedIndex(0);
        }
        this.comboPlatform.removeAllItems();
        String string = System.getProperty("os.name");
        if (string.indexOf("Windows") >= 0) {
            this.comboPlatform.addItem((Object)((Object)PlatformEnum.Windows) + "");
            this.comboPlatform.setEnabled(false);
            this.chkCommandKeyAsControl.setEnabled(false);
        } else {
            for (PlatformEnum platformEnum : PlatformEnum.values()) {
                this.comboPlatform.addItem((Object)((Object)platformEnum) + "");
            }
        }
        this.comboMidiInPortNumber.removeAllItems();
        this.comboMidiInPortNumber.setEnabled(false);
        this.comboMtcMidiInPortNumber.setEnabled(false);
        this.txtVOCALOID1.setText(VocaloSysUtil.getDllPathVsti(SynthesizerType.VOCALOID1));
        this.txtVOCALOID2.setText(VocaloSysUtil.getDllPathVsti(SynthesizerType.VOCALOID2));
        this.listSingers.setColumnWidth(0, columnWidthHeaderProgramChange);
        this.listSingers.setColumnWidth(1, columnWidthHeaderName);
        this.listSingers.setColumnWidth(2, columnWidthHeaderPath);
        if (VocaloSysUtil.getDefaultDseVersion() == 100) {
            this.chkLoadVocaloid100.setText("VOCALOID1 [1.0] (" + Preference._("primary") + ")");
            this.chkLoadVocaloid101.setText("VOCALOID1 [1.1] (" + Preference._("secondary") + ")");
        } else {
            this.chkLoadVocaloid100.setText("VOCALOID1 [1.0] (" + Preference._("secondary") + ")");
            this.chkLoadVocaloid101.setText("VOCALOID1 [1.1] (" + Preference._("primary") + ")");
        }
        if (VocaloSysUtil.isDSEVersion101Available()) {
            this.chkLoadSecondaryVOCALOID1.setEnabled(true);
        } else {
            this.chkLoadSecondaryVOCALOID1.setEnabled(false);
            this.chkLoadVocaloid101.setEnabled(false);
        }
        this.chkLoadSecondaryVOCALOID1_CheckedChanged(null, null);
        this.comboDefaultPremeasure.removeAllItems();
        for (int i = 1; i <= 8; ++i) {
            this.comboDefaultPremeasure.addItem(i + "");
        }
        this.comboChannel.removeAllItems();
        this.comboChannel.addItem(Preference._("Monoral"));
        this.comboChannel.addItem(Preference._("Stereo"));
        this.registerEventHandlers();
        this.setResources();
    }

    public int getBufferSize() {
        return (int)this.numBuffer.getValue();
    }

    public void setBufferSize(int n) {
        this.numBuffer.setValue(n);
    }

    public boolean isLoadSecondaryVocaloid1Dll() {
        return this.chkLoadSecondaryVOCALOID1.isSelected();
    }

    public void setLoadSecondaryVocaloid1Dll(boolean bl) {
        this.chkLoadSecondaryVOCALOID1.setSelected(bl);
    }

    public boolean isLoadVocaloid100() {
        if (this.chkLoadVocaloid100.isEnabled()) {
            return this.chkLoadVocaloid100.isSelected();
        }
        return false;
    }

    public void setLoadVocaloid100(boolean bl) {
        if (this.chkLoadVocaloid100.isEnabled()) {
            this.chkLoadVocaloid100.setSelected(bl);
        }
    }

    public boolean isLoadVocaloid101() {
        if (this.chkLoadVocaloid101.isEnabled()) {
            return this.chkLoadVocaloid101.isSelected();
        }
        return false;
    }

    public void setLoadVocaloid101(boolean bl) {
        if (this.chkLoadVocaloid101.isEnabled()) {
            this.chkLoadVocaloid101.setSelected(bl);
        }
    }

    public boolean isLoadVocaloid2() {
        return this.chkLoadVocaloid2.isSelected();
    }

    public void setLoadVocaloid2(boolean bl) {
        this.chkLoadVocaloid2.setSelected(bl);
    }

    public boolean isLoadAquesTone() {
        return this.chkLoadAquesTone.isSelected();
    }

    public void setLoadAquesTone(boolean bl) {
        this.chkLoadAquesTone.setSelected(bl);
    }

    public boolean isUseProjectCache() {
        return this.chkKeepProjectCache.isSelected();
    }

    public void setUseProjectCache(boolean bl) {
        this.chkKeepProjectCache.setSelected(bl);
    }

    public boolean isUseSpaceKeyAsMiddleButtonModifier() {
        return this.chkUseSpaceKeyAsMiddleButtonModifier.isSelected();
    }

    public void setUseSpaceKeyAsMiddleButtonModifier(boolean bl) {
        this.chkUseSpaceKeyAsMiddleButtonModifier.setSelected(bl);
    }

    public int getAutoBackupIntervalMinutes() {
        if (this.chkAutoBackup.isSelected()) {
            return (int)this.numAutoBackupInterval.getValue();
        }
        return 0;
    }

    public void setAutoBackupIntervalMinutes(int n) {
        if (n <= 0) {
            this.chkAutoBackup.setSelected(false);
        } else {
            this.chkAutoBackup.setSelected(true);
            this.numAutoBackupInterval.setValue(n);
        }
    }

    public boolean isSelfDeRomantization() {
        return this.chkTranslateRoman.isSelected();
    }

    public void setSelfDeRomantization(boolean bl) {
        this.chkTranslateRoman.setSelected(bl);
    }

    public boolean isInvokeWithWine() {
        return this.chkInvokeWithWine.isSelected();
    }

    public void setInvokeWithWine(boolean bl) {
        this.chkInvokeWithWine.setSelected(bl);
    }

    public boolean isCurveVisibleVel() {
        return this.chkVel.isSelected();
    }

    public void setCurveVisibleVel(boolean bl) {
        this.chkVel.setSelected(bl);
    }

    public boolean isCurveVisibleAccent() {
        return this.chkAccent.isSelected();
    }

    public void setCurveVisibleAccent(boolean bl) {
        this.chkAccent.setSelected(bl);
    }

    public boolean isCurveVisibleDecay() {
        return this.chkDecay.isSelected();
    }

    public void setCurveVisibleDecay(boolean bl) {
        this.chkDecay.setSelected(bl);
    }

    public boolean isCurveVisibleVibratoRate() {
        return this.chkVibratoRate.isSelected();
    }

    public void setCurveVisibleVibratoRate(boolean bl) {
        this.chkVibratoRate.setSelected(bl);
    }

    public boolean isCurveVisibleVibratoDepth() {
        return this.chkVibratoDepth.isSelected();
    }

    public void setCurveVisibleVibratoDepth(boolean bl) {
        this.chkVibratoDepth.setSelected(bl);
    }

    public boolean isCurveVisibleDyn() {
        return this.chkDyn.isSelected();
    }

    public void setCurveVisibleDyn(boolean bl) {
        this.chkDyn.setSelected(bl);
    }

    public boolean isCurveVisibleBre() {
        return this.chkBre.isSelected();
    }

    public void setCurveVisibleBre(boolean bl) {
        this.chkBre.setSelected(bl);
    }

    public boolean isCurveVisibleBri() {
        return this.chkBri.isSelected();
    }

    public void setCurveVisibleBri(boolean bl) {
        this.chkBri.setSelected(bl);
    }

    public boolean isCurveVisibleCle() {
        return this.chkCle.isSelected();
    }

    public void setCurveVisibleCle(boolean bl) {
        this.chkCle.setSelected(bl);
    }

    public boolean isCurveVisibleOpe() {
        return this.chkOpe.isSelected();
    }

    public void setCurveVisibleOpe(boolean bl) {
        this.chkOpe.setSelected(bl);
    }

    public boolean isCurveVisiblePor() {
        return this.chkPor.isSelected();
    }

    public void setCurveVisiblePor(boolean bl) {
        this.chkPor.setSelected(bl);
    }

    public boolean isCurveVisibleGen() {
        return this.chkGen.isSelected();
    }

    public void setCurveVisibleGen(boolean bl) {
        this.chkGen.setSelected(bl);
    }

    public boolean isCurveVisiblePit() {
        return this.chkPit.isSelected();
    }

    public void setCurveVisiblePit(boolean bl) {
        this.chkPit.setSelected(bl);
    }

    public boolean isCurveVisiblePbs() {
        return this.chkPbs.isSelected();
    }

    public void setCurveVisiblePbs(boolean bl) {
        this.chkPbs.setSelected(bl);
    }

    public boolean isCurveVisibleFx2Depth() {
        return this.chkFx2Depth.isSelected();
    }

    public void setCurveVisibleFx2Depth(boolean bl) {
        this.chkFx2Depth.setSelected(bl);
    }

    public boolean isCurveVisibleHarmonics() {
        return this.chkHarmonics.isSelected();
    }

    public void setCurveVisibleHarmonics(boolean bl) {
        this.chkHarmonics.setSelected(bl);
    }

    public boolean isCurveVisibleReso1() {
        return this.chkReso1.isSelected();
    }

    public void setCurveVisibleReso1(boolean bl) {
        this.chkReso1.setSelected(bl);
    }

    public boolean isCurveVisibleReso2() {
        return this.chkReso2.isSelected();
    }

    public void setCurveVisibleReso2(boolean bl) {
        this.chkReso2.setSelected(bl);
    }

    public boolean isCurveVisibleReso3() {
        return this.chkReso3.isSelected();
    }

    public void setCurveVisibleReso3(boolean bl) {
        this.chkReso3.setSelected(bl);
    }

    public boolean isCurveVisibleReso4() {
        return this.chkReso4.isSelected();
    }

    public void setCurveVisibleReso4(boolean bl) {
        this.chkReso4.setSelected(bl);
    }

    public boolean isCurveVisibleEnvelope() {
        return this.chkEnvelope.isSelected();
    }

    public void setCurveVisibleEnvelope(boolean bl) {
        this.chkEnvelope.setSelected(bl);
    }

    public boolean isCurveSelectingQuantized() {
        return this.chkCurveSelectingQuantized.isSelected();
    }

    public void setCurveSelectingQuantized(boolean bl) {
        this.chkCurveSelectingQuantized.setSelected(bl);
    }

    public boolean isPlayPreviewWhenRightClick() {
        return this.chkPlayPreviewWhenRightClick.isSelected();
    }

    public void setPlayPreviewWhenRightClick(boolean bl) {
        this.chkPlayPreviewWhenRightClick.setSelected(bl);
    }

    public int getMouseHoverTime() {
        return (int)this.numMouseHoverTime.getValue();
    }

    public void setMouseHoverTime(int n) {
        this.numMouseHoverTime.setValue(n);
    }

    public int getPxTrackHeight() {
        return (int)this.numTrackHeight.getValue();
    }

    public void setPxTrackHeight(int n) {
        this.numTrackHeight.setValue(n);
    }

    public boolean isKeepLyricInputMode() {
        return this.chkKeepLyricInputMode.isSelected();
    }

    public void setKeepLyricInputMode(boolean bl) {
        this.chkKeepLyricInputMode.setSelected(bl);
    }

    public PlatformEnum getPlatform() {
        return this.m_platform;
    }

    public void setPlatform(PlatformEnum platformEnum) {
        this.m_platform = platformEnum;
        for (int i = 0; i < this.comboPlatform.getItemCount(); ++i) {
            String string = (String)this.comboPlatform.getItemAt(i);
            if (!string.equals((Object)((Object)this.m_platform) + "")) continue;
            this.comboPlatform.setSelectedIndex(i);
            break;
        }
    }

    public int getMaximumFrameRate() {
        return (int)this.numMaximumFrameRate.getValue();
    }

    public void setMaximumFrameRate(int n) {
        this.numMaximumFrameRate.setValue(n);
    }

    public boolean isScrollHorizontalOnWheel() {
        return this.chkScrollHorizontal.isSelected();
    }

    public void setScrollHorizontalOnWheel(boolean bl) {
        this.chkScrollHorizontal.setSelected(bl);
    }

    public void applyLanguage() {
        this.setTitle(Preference._("Preference"));
        this.btnCancel.setText(Preference._("Cancel"));
        this.btnOK.setText(Preference._("OK"));
        this.openUtauCore.clearChoosableFileFilter();
        try {
            this.openUtauCore.addFileFilter(Preference._("Executable(*.exe)|*.exe"));
            this.openUtauCore.addFileFilter(Preference._("All Files(*.*)|*.*"));
        }
        catch (Exception exception) {
            this.openUtauCore.addFileFilter("Executable(*.exe)|*.exe");
            this.openUtauCore.addFileFilter("All Files(*.*)|*.*");
        }
        this.folderBrowserSingers.setDescription(Preference._("Select Singer Directory"));
        int n = this.tabPane.getTabCount();
        for (int i = 0; i < n; ++i) {
            Component component = this.tabPane.getComponentAt(i);
            if (!(component instanceof BPanel)) continue;
            BPanel bPanel = (BPanel)component;
            if (bPanel == this.tabSequence) {
                this.tabPane.setTitleAt(i, Preference._("Sequence"));
                continue;
            }
            if (bPanel == this.tabAnother) {
                this.tabPane.setTitleAt(i, Preference._("Other Settings"));
                continue;
            }
            if (bPanel == this.tabAppearance) {
                this.tabPane.setTitleAt(i, Preference._("Appearance"));
                continue;
            }
            if (bPanel == this.tabOperation) {
                this.tabPane.setTitleAt(i, Preference._("Operation"));
                continue;
            }
            if (bPanel == this.tabPlatform) {
                this.tabPane.setTitleAt(i, Preference._("Platform"));
                continue;
            }
            if (bPanel == this.tabUtauSingers) {
                this.tabPane.setTitleAt(i, Preference._("UTAU Singers"));
                continue;
            }
            if (bPanel != this.tabFile) continue;
            this.tabPane.setTitleAt(i, Preference._("File"));
        }
        this.lblResolution.setText(Preference._("Resolution(VSTi)"));
        this.lblDynamics.setText(Preference._("Dynamics") + "(&D)");
        this.lblAmplitude.setText(Preference._("Vibrato Depth") + "(&R)");
        this.lblPeriod.setText(Preference._("Vibrato Rate") + "(&V)");
        this.lblVibratoConfig.setText(Preference._("Vibrato Settings"));
        this.lblVibratoLength.setText(Preference._("Default Vibrato Length") + "(&L)");
        this.groupAutoVibratoConfig.setTitle(Preference._("Auto Vibrato Settings"));
        this.chkEnableAutoVibrato.setText(Preference._("Enable Automatic Vibrato") + "(&E)");
        this.lblAutoVibratoMinLength.setText(Preference._("Minimum note length for Automatic Vibrato") + "(&M)");
        this.lblAutoVibratoType1.setText(Preference._("Vibrato Type") + ": VOCALOID1 (&T)");
        this.lblAutoVibratoType2.setText(Preference._("Vibrato Type") + ": VOCALOID2 (&T)");
        this.lblDefaultSinger.setText(Preference._("Default Singer") + "(&S)");
        this.lblPreSendTime.setText(Preference._("Pre-Send time") + "(&P)");
        this.lblWait.setText(Preference._("Waiting Time") + "(&W)");
        this.lblDefaultPremeasure.setText(Preference._("Default Pre-measure") + "(&M)");
        this.chkChasePastEvent.setText(Preference._("Chase Event") + "(&C)");
        this.groupWaveFileOutput.setTitle(Preference._("Wave File Output"));
        this.lblChannel.setText(Preference._("Channel") + "(&C)");
        this.radioMasterTrack.setText(Preference._("Master Track"));
        this.radioCurrentTrack.setText(Preference._("Current Track"));
        this.groupFont.setTitle(Preference._("Font"));
        this.labelMenu.setText(Preference._("Menu / Lyrics"));
        this.labelScreen.setText(Preference._("Screen"));
        this.lblLanguage.setText(Preference._("UI Language"));
        this.btnChangeMenuFont.setText(Preference._("Change"));
        this.btnChangeScreenFont.setText(Preference._("Change"));
        this.lblTrackHeight.setText(Preference._("Track Height (pixel)"));
        this.groupVisibleCurve.setTitle(Preference._("Visible Control Curve"));
        this.labelWheelOrder.setText(Preference._("Mouse wheel Rate"));
        this.chkCursorFix.setText(Preference._("Fix Play Cursor to Center"));
        this.chkScrollHorizontal.setText(Preference._("Horizontal Scroll when Mouse wheel"));
        this.lblMaximumFrameRate.setText(Preference._("Maximum Frame Rate"));
        this.chkKeepLyricInputMode.setText(Preference._("Keep Lyric Input Mode"));
        this.lblMouseHoverTime.setText(Preference._("Waiting Time for Preview"));
        this.lblMilliSecond.setText(Preference._("milli second"));
        this.chkPlayPreviewWhenRightClick.setText(Preference._("Play Preview On Right Click"));
        this.chkCurveSelectingQuantized.setText(Preference._("Enable Quantize for Curve Selecting"));
        this.lblMidiInPort.setText(Preference._("MIDI In Port Number"));
        this.chkUseSpaceKeyAsMiddleButtonModifier.setText(Preference._("Use space key as Middle button modifier"));
        this.groupPianoroll.setTitle(Preference._("Piano Roll"));
        this.groupMisc.setTitle(Preference._("Misc"));
        this.groupPlatform.setTitle(Preference._("Platform"));
        this.lblPlatform.setText(Preference._("Current Platform"));
        this.chkCommandKeyAsControl.setText(Preference._("Use Command key as Control key"));
        this.chkTranslateRoman.setText(Preference._("Translate Roman letters into Kana"));
        this.groupUtauCores.setTitle(Preference._("UTAU Cores"));
        this.chkInvokeWithWine.setText(Preference._("Invoke UTAU cores with Wine"));
        this.listSingers.setColumnHeaders(new String[]{Preference._("Program Change"), Preference._("Name"), Preference._("Path")});
        this.btnAdd.setText(Preference._("Add"));
        this.btnRemove.setText(Preference._("Remove"));
        this.btnUp.setText(Preference._("Up"));
        this.btnDown.setText(Preference._("Down"));
        this.chkAutoBackup.setText(Preference._("Automatical Backup"));
        this.lblAutoBackupInterval.setText(Preference._("interval"));
        this.lblAutoBackupMinutes.setText(Preference._("minute(s)"));
        this.chkKeepProjectCache.setText(Preference._("Keep Project Cache"));
        this.groupSynthesizerDll.setTitle(Preference._("Synthesizer DLL Usage"));
        this.chkLoadSecondaryVOCALOID1.setText(Preference._("Load secondary VOCALOID1 DLL"));
    }

    public boolean isWaveFileOutputFromMasterTrack() {
        return this.radioMasterTrack.isSelected();
    }

    public void setWaveFileOutputFromMasterTrack(boolean bl) {
        this.radioMasterTrack.setSelected(bl);
        this.radioCurrentTrack.setSelected(!bl);
    }

    public int getWaveFileOutputChannel() {
        if (this.comboChannel.getSelectedIndex() <= 0) {
            return 1;
        }
        return 2;
    }

    public void setWaveFileOutputChannel(int n) {
        if (n == 1) {
            this.comboChannel.setSelectedIndex(0);
        } else {
            this.comboChannel.setSelectedIndex(1);
        }
    }

    public String getLanguage() {
        int n = this.comboLanguage.getSelectedIndex();
        if (0 <= n && n < this.comboLanguage.getItemCount()) {
            String string = (String)this.comboLanguage.getItemAt(n);
            if (string.equals("Default")) {
                return "";
            }
            return string;
        }
        return "";
    }

    public ClockResolution getControlCurveResolution() {
        int n = -1;
        int n2 = this.comboDynamics.getSelectedIndex();
        Iterator<ClockResolution> iterator = ClockResolutionUtility.iterator();
        while (iterator.hasNext()) {
            ClockResolution clockResolution = iterator.next();
            if (++n != n2) continue;
            return clockResolution;
        }
        this.comboDynamics.setSelectedIndex(0);
        return ClockResolution.L30;
    }

    public void setControlCurveResolution(ClockResolution clockResolution) {
        int n = -1;
        Iterator<ClockResolution> iterator = ClockResolutionUtility.iterator();
        while (iterator.hasNext()) {
            ClockResolution clockResolution2 = iterator.next();
            ++n;
            if (!clockResolution2.equals((Object)clockResolution)) continue;
            this.comboDynamics.setSelectedIndex(n);
            break;
        }
    }

    public int getPreSendTime() {
        return (int)this.numPreSendTime.getValue();
    }

    public void setPreSendTime(int n) {
        this.numPreSendTime.setValue(n);
    }

    public int getPreMeasure() {
        return this.comboDefaultPremeasure.getSelectedIndex() + 1;
    }

    public void setPreMeasure(int n) {
        this.comboDefaultPremeasure.setSelectedIndex(n - 1);
    }

    public boolean isEnableAutoVibrato() {
        return this.chkEnableAutoVibrato.isSelected();
    }

    public void setEnableAutoVibrato(boolean bl) {
        this.chkEnableAutoVibrato.setSelected(bl);
    }

    public String getAutoVibratoType1() {
        int n = -1;
        int n2 = this.comboAutoVibratoType1.getSelectedIndex();
        if (0 <= n2) {
            VibratoHandle vibratoHandle = (VibratoHandle)this.comboAutoVibratoType1.getSelectedItem();
            return vibratoHandle.IconID;
        }
        return "$04040001";
    }

    public void setAutoVibratoType1(String string) {
        for (int i = 0; i < this.comboAutoVibratoType1.getItemCount(); ++i) {
            VibratoHandle vibratoHandle = (VibratoHandle)this.comboAutoVibratoType1.getItemAt(i);
            if (!vibratoHandle.IconID.equals(string)) continue;
            this.comboAutoVibratoType1.setSelectedIndex(i);
            return;
        }
        if (this.comboAutoVibratoType1.getItemCount() > 0) {
            this.comboAutoVibratoType1.setSelectedIndex(0);
        }
    }

    public String getAutoVibratoType2() {
        int n = -1;
        int n2 = this.comboAutoVibratoType2.getSelectedIndex();
        if (0 <= n2) {
            VibratoHandle vibratoHandle = (VibratoHandle)this.comboAutoVibratoType2.getSelectedItem();
            return vibratoHandle.IconID;
        }
        return "$04040001";
    }

    public void setAutoVibratoType2(String string) {
        for (int i = 0; i < this.comboAutoVibratoType2.getItemCount(); ++i) {
            VibratoHandle vibratoHandle = (VibratoHandle)this.comboAutoVibratoType2.getItemAt(i);
            if (!vibratoHandle.IconID.equals(string)) continue;
            this.comboAutoVibratoType2.setSelectedIndex(i);
            return;
        }
        if (this.comboAutoVibratoType2.getItemCount() > 0) {
            this.comboAutoVibratoType2.setSelectedIndex(0);
        }
    }

    public AutoVibratoMinLengthEnum getAutoVibratoMinimumLength() {
        int n = -1;
        int n2 = this.comboAutoVibratoMinLength.getSelectedIndex();
        for (AutoVibratoMinLengthEnum autoVibratoMinLengthEnum : AutoVibratoMinLengthEnum.values()) {
            if (++n != n2) continue;
            return autoVibratoMinLengthEnum;
        }
        this.comboAutoVibratoMinLength.setSelectedIndex(0);
        return AutoVibratoMinLengthEnum.L1;
    }

    public void setAutoVibratoMinimumLength(AutoVibratoMinLengthEnum autoVibratoMinLengthEnum) {
        int n = -1;
        for (AutoVibratoMinLengthEnum autoVibratoMinLengthEnum2 : AutoVibratoMinLengthEnum.values()) {
            ++n;
            if (autoVibratoMinLengthEnum2 != autoVibratoMinLengthEnum) continue;
            this.comboAutoVibratoMinLength.setSelectedIndex(n);
            break;
        }
    }

    public DefaultVibratoLengthEnum getDefaultVibratoLength() {
        int n = -1;
        int n2 = this.comboVibratoLength.getSelectedIndex();
        for (DefaultVibratoLengthEnum defaultVibratoLengthEnum : DefaultVibratoLengthEnum.values()) {
            if (n2 != ++n) continue;
            return defaultVibratoLengthEnum;
        }
        this.comboVibratoLength.setSelectedIndex(1);
        return DefaultVibratoLengthEnum.L66;
    }

    public void setDefaultVibratoLength(DefaultVibratoLengthEnum defaultVibratoLengthEnum) {
        int n = -1;
        for (DefaultVibratoLengthEnum defaultVibratoLengthEnum2 : DefaultVibratoLengthEnum.values()) {
            ++n;
            if (defaultVibratoLengthEnum2 != defaultVibratoLengthEnum) continue;
            this.comboVibratoLength.setSelectedIndex(n);
            break;
        }
    }

    public boolean isCursorFixed() {
        return this.chkCursorFix.isSelected();
    }

    public void setCursorFixed(boolean bl) {
        this.chkCursorFix.setSelected(bl);
    }

    public int getWheelOrder() {
        return (int)this.numericUpDownEx1.getValue();
    }

    public void setWheelOrder(int n) {
        if ((float)n < this.numericUpDownEx1.getMinimum()) {
            this.numericUpDownEx1.setValue(this.numericUpDownEx1.getMinimum());
        } else if (this.numericUpDownEx1.getMaximum() < (float)n) {
            this.numericUpDownEx1.setValue(this.numericUpDownEx1.getMaximum());
        } else {
            this.numericUpDownEx1.setValue(n);
        }
    }

    public Font getScreenFont() {
        return this.m_screen_font;
    }

    public void setScreenFont(Font font) {
        this.m_screen_font = font;
        this.labelScreenFontName.setText(this.m_screen_font.getName());
    }

    public Font getBaseFont() {
        return this.m_super_font;
    }

    public void setBaseFont(Font font) {
        this.m_super_font = font;
        this.labelMenuFontName.setText(this.m_super_font.getName());
        this.UpdateFonts(this.m_super_font.getName());
    }

    public String getDefaultSingerName() {
        if (this.comboDefualtSinger.getSelectedIndex() >= 0) {
            return this.m_program_change.get(this.comboDefualtSinger.getSelectedIndex());
        }
        return "Miku";
    }

    public void setDefaultSingerName(String string) {
        int n = -1;
        for (int i = 0; i < this.m_program_change.size(); ++i) {
            if (!this.m_program_change.get(i).equals(string)) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            this.comboDefualtSinger.setSelectedIndex(n);
        }
    }

    public boolean isCommandKeyAsControl() {
        return this.chkCommandKeyAsControl.isSelected();
    }

    public void setCommandKeyAsControl(boolean bl) {
        this.chkCommandKeyAsControl.setSelected(bl);
    }

    public String getPathResampler() {
        return this.txtResampler.getText();
    }

    public void setPathResampler(String string) {
        this.txtResampler.setText(string);
    }

    public String getPathWavtool() {
        return this.txtWavtool.getText();
    }

    public void setPathWavtool(String string) {
        this.txtWavtool.setText(string);
    }

    public String getPathAquesTone() {
        return this.txtAquesTone.getText();
    }

    public void setPathAquesTone(String string) {
        this.txtAquesTone.setText(string);
    }

    public Vector<SingerConfig> getUtauSingers() {
        return this.m_utau_singers;
    }

    public void setUtauSingers(Vector<SingerConfig> vector) {
        this.m_utau_singers.clear();
        for (int i = 0; i < vector.size(); ++i) {
            this.m_utau_singers.add((SingerConfig)vector.get(i).clone());
        }
        this.UpdateUtauSingerList();
    }

    public void chkLoadSecondaryVOCALOID1_CheckedChanged(Object object, BEventArgs bEventArgs) {
        if (VocaloSysUtil.isDSEVersion101Available()) {
            if (this.chkLoadSecondaryVOCALOID1.isSelected()) {
                this.chkLoadVocaloid100.setEnabled(true);
                this.chkLoadVocaloid101.setEnabled(true);
            } else if (VocaloSysUtil.getDefaultDseVersion() == 100) {
                this.chkLoadVocaloid100.setEnabled(true);
                this.chkLoadVocaloid101.setEnabled(false);
            } else {
                this.chkLoadVocaloid100.setEnabled(false);
                this.chkLoadVocaloid101.setEnabled(true);
            }
        }
    }

    public void btnChangeMenuFont_Click(Object object, BEventArgs bEventArgs) {
        this.fontDialog.setSelectedFont(this.getBaseFont());
        this.fontDialog.setVisible(true);
        if (this.fontDialog.getDialogResult() == BDialogResult.OK) {
            this.m_super_font = this.fontDialog.getSelectedFont();
        }
    }

    public void btnOK_Click(Object object, BEventArgs bEventArgs) {
        boolean bl = false;
        if (AppManager.editorConfig.DoNotUseVocaloid2 != !this.isLoadVocaloid2()) {
            bl = true;
        }
        if (AppManager.editorConfig.DoNotUseVocaloid101 != !this.isLoadVocaloid101()) {
            bl = true;
        }
        if (AppManager.editorConfig.DoNotUseVocaloid100 != !this.isLoadVocaloid100()) {
            bl = true;
        }
        if (bl) {
            AppManager.showMessageBox(Preference._("Restart Cadencii to complete your changes"), "Cadencii", 0, 1);
        }
        this.setDialogResult(BDialogResult.OK);
    }

    public void btnChangeScreenFont_Click(Object object, BEventArgs bEventArgs) {
        this.fontDialog.setSelectedFont(this.m_screen_font);
        this.fontDialog.setVisible(true);
        if (this.fontDialog.getDialogResult() == BDialogResult.OK) {
            this.m_screen_font = this.fontDialog.getSelectedFont();
        }
    }

    public void comboPlatform_SelectedIndexChanged(Object object, BEventArgs bEventArgs) {
        String string = (String)this.comboPlatform.getSelectedItem();
        for (PlatformEnum platformEnum : PlatformEnum.values()) {
            if (!string.equals((Object)((Object)platformEnum) + "")) continue;
            this.m_platform = platformEnum;
            this.chkCommandKeyAsControl.setEnabled(platformEnum != PlatformEnum.Windows);
            break;
        }
    }

    public void btnResampler_Click(Object object, BEventArgs bEventArgs) {
        if (!this.txtResampler.getText().equals("") && PortUtil.isDirectoryExists(PortUtil.getDirectoryName(this.txtResampler.getText()))) {
            this.openUtauCore.setInitialDirectory(PortUtil.getDirectoryName(this.txtResampler.getText()));
        }
        this.openUtauCore.setSelectedFile("resampler.exe");
        int n = this.openUtauCore.showOpenDialog(this);
        if (n == 0) {
            String string;
            String string2 = this.openUtauCore.getSelectedFile();
            this.txtResampler.setText(string2);
            if (this.txtWavtool.getText().equals("") && PortUtil.isFileExists(string = PortUtil.combinePath(PortUtil.getDirectoryName(string2), "wavtool.exe"))) {
                this.txtWavtool.setText(string);
            }
        }
    }

    public void btnWavtool_Click(Object object, BEventArgs bEventArgs) {
        if (!this.txtWavtool.getText().equals("") && PortUtil.isDirectoryExists(PortUtil.getDirectoryName(this.txtWavtool.getText()))) {
            this.openUtauCore.setInitialDirectory(PortUtil.getDirectoryName(this.txtWavtool.getText()));
        }
        this.openUtauCore.setSelectedFile("wavtool.exe");
        int n = this.openUtauCore.showOpenDialog(this);
        if (n == 0) {
            String string;
            String string2 = this.openUtauCore.getSelectedFile();
            this.txtWavtool.setText(string2);
            if (this.txtResampler.getText().equals("") && PortUtil.isFileExists(string = PortUtil.combinePath(PortUtil.getDirectoryName(string2), "resampler.exe"))) {
                this.txtResampler.setText(string);
            }
        }
    }

    public void btnAquesTone_Click(Object object, BEventArgs bEventArgs) {
        BFileChooser bFileChooser = new BFileChooser("");
        if (!this.txtAquesTone.getText().equals("") && PortUtil.isDirectoryExists(PortUtil.getDirectoryName(this.txtAquesTone.getText()))) {
            bFileChooser.setInitialDirectory(PortUtil.getDirectoryName(this.txtAquesTone.getText()));
        }
        bFileChooser.setSelectedFile("AquesTone.dll");
        int n = bFileChooser.showOpenDialog(this);
        if (n == 0) {
            String string = bFileChooser.getSelectedFile();
            this.txtAquesTone.setText(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void btnAdd_Click(Object object, BEventArgs bEventArgs) {
        this.folderBrowserSingers.setVisible(true);
        if (this.folderBrowserSingers.getDialogResult() == BDialogResult.OK) {
            String string = this.folderBrowserSingers.getSelectedPath();
            SingerConfig singerConfig = new SingerConfig();
            String string2 = PortUtil.combinePath(string, "character.txt");
            String string3 = "";
            singerConfig.VOICEIDSTR = string;
            if (PortUtil.isFileExists(string2)) {
                BufferedReader bufferedReader = null;
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string2), "Shift_JIS"));
                    String string4 = "";
                    while ((string4 = bufferedReader.readLine()) != null) {
                        String[] stringArray = PortUtil.splitString(string4, '=');
                        if (stringArray.length < 2 || !stringArray[0].toLowerCase().equals("name")) continue;
                        string3 = stringArray[1];
                        break;
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (string3.equals("")) {
                string3 = "Unknown";
            }
            singerConfig.VOICENAME = string3;
            this.m_utau_singers.add(singerConfig);
            this.UpdateUtauSingerList();
        }
    }

    public void listSingers_SelectedIndexChanged(Object object, BEventArgs bEventArgs) {
        int n = this.getUtauSingersSelectedIndex();
        if (n < 0) {
            this.btnRemove.setEnabled(false);
            this.btnUp.setEnabled(false);
            this.btnDown.setEnabled(false);
        } else {
            this.btnRemove.setEnabled(true);
            this.btnUp.setEnabled(0 <= n - 1 && n - 1 < this.m_utau_singers.size());
            this.btnDown.setEnabled(0 <= n + 1 && n + 1 < this.m_utau_singers.size());
        }
    }

    public void btnRemove_Click(Object object, BEventArgs bEventArgs) {
        int n = this.getUtauSingersSelectedIndex();
        if (0 <= n && n < this.m_utau_singers.size()) {
            this.m_utau_singers.removeElementAt(n);
        }
        this.UpdateUtauSingerList();
    }

    public void btnDown_Click(Object object, BEventArgs bEventArgs) {
        int n = this.getUtauSingersSelectedIndex();
        if (0 <= n && n + 1 < this.m_utau_singers.size()) {
            SingerConfig singerConfig = (SingerConfig)this.m_utau_singers.get(n).clone();
            this.m_utau_singers.set(n, (SingerConfig)this.m_utau_singers.get(n + 1).clone());
            this.m_utau_singers.set(n + 1, singerConfig);
            this.UpdateUtauSingerList();
            this.listSingers.setItemSelectedAt("", n + 1, true);
        }
    }

    public void btnUp_Click(Object object, BEventArgs bEventArgs) {
        int n = this.getUtauSingersSelectedIndex();
        if (0 <= n - 1 && n < this.m_utau_singers.size()) {
            SingerConfig singerConfig = (SingerConfig)this.m_utau_singers.get(n).clone();
            this.m_utau_singers.set(n, (SingerConfig)this.m_utau_singers.get(n - 1).clone());
            this.m_utau_singers.set(n - 1, singerConfig);
            this.UpdateUtauSingerList();
            this.listSingers.setItemSelectedAt("", n - 1, true);
        }
    }

    public void chkAutoBackup_CheckedChanged(Object object, BEventArgs bEventArgs) {
        this.numAutoBackupInterval.setEnabled(this.chkAutoBackup.isSelected());
    }

    public void Preference_FormClosing(Object object, BFormClosingEventArgs bFormClosingEventArgs) {
        columnWidthHeaderProgramChange = this.listSingers.getColumnWidth(0);
        columnWidthHeaderName = this.listSingers.getColumnWidth(1);
        columnWidthHeaderPath = this.listSingers.getColumnWidth(2);
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void UpdateFonts(String string) {
        if (string.equals("")) {
            return;
        }
        Font font = new Font(string, 0, this.getFont().getSize());
        Util.applyFontRecurse(this, font);
    }

    private void UpdateUtauSingerList() {
        this.listSingers.clear();
        for (int i = 0; i < this.m_utau_singers.size(); ++i) {
            this.m_utau_singers.get((int)i).Program = i;
            this.listSingers.addItem("", new BListViewItem(new String[]{this.m_utau_singers.get((int)i).Program + "", this.m_utau_singers.get((int)i).VOICENAME, this.m_utau_singers.get((int)i).VOICEIDSTR}));
        }
    }

    private int getUtauSingersSelectedIndex() {
        return this.listSingers.getSelectedIndex("");
    }

    private void registerEventHandlers() {
        this.btnChangeScreenFont.clickEvent.add(new BEventHandler(this, "btnChangeScreenFont_Click"));
        this.btnChangeMenuFont.clickEvent.add(new BEventHandler(this, "btnChangeMenuFont_Click"));
        this.btnWavtool.clickEvent.add(new BEventHandler(this, "btnWavtool_Click"));
        this.btnResampler.clickEvent.add(new BEventHandler(this, "btnResampler_Click"));
        this.btnAquesTone.clickEvent.add(new BEventHandler(this, "btnAquesTone_Click"));
        this.comboPlatform.selectedIndexChangedEvent.add(new BEventHandler(this, "comboPlatform_SelectedIndexChanged"));
        this.btnRemove.clickEvent.add(new BEventHandler(this, "btnRemove_Click"));
        this.btnAdd.clickEvent.add(new BEventHandler(this, "btnAdd_Click"));
        this.btnUp.clickEvent.add(new BEventHandler(this, "btnUp_Click"));
        this.btnDown.clickEvent.add(new BEventHandler(this, "btnDown_Click"));
        this.listSingers.selectedIndexChangedEvent.add(new BEventHandler(this, "listSingers_SelectedIndexChanged"));
        this.chkAutoBackup.checkedChangedEvent.add(new BEventHandler(this, "chkAutoBackup_CheckedChanged"));
        this.btnOK.clickEvent.add(new BEventHandler(this, "btnOK_Click"));
        this.formClosingEvent.add(new BFormClosingEventHandler(this, "Preference_FormClosing"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
        this.chkLoadSecondaryVOCALOID1.checkedChangedEvent.add(new BEventHandler(this, "chkLoadSecondaryVOCALOID1_CheckedChanged"));
    }

    private void setResources() {
    }

    private void initialize() {
        this.setSize(504, 496);
        this.setContentPane(this.getJPanel5());
        this.setTitle("Preference");
    }

    private BPanel getTabSequence() {
        if (this.tabSequence == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints.anchor = 18;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridy = 2;
            this.lblVibratoConfig = new BLabel();
            this.lblVibratoConfig.setText("Vibrato Setting");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(12, 12, 3, 0);
            this.lblResolution = new BLabel();
            this.lblResolution.setText("Resolution(VSTi)");
            this.tabSequence = new BPanel();
            this.tabSequence.setLayout(new GridBagLayout());
            this.tabSequence.add((Component)this.lblResolution, gridBagConstraints4);
            this.tabSequence.add((Component)this.getJPanel(), gridBagConstraints3);
            this.tabSequence.add((Component)this.lblVibratoConfig, gridBagConstraints2);
            this.tabSequence.add((Component)this.getJPanel1(), gridBagConstraints);
        }
        return this.tabSequence;
    }

    private BPanel getJPanel() {
        if (this.BPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 4;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints.gridy = 3;
            this.jLabel12 = new BLabel();
            this.jLabel12.setText("clocks");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 4;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints2.gridy = 1;
            this.jLabel11 = new BLabel();
            this.jLabel11.setText("clocks");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 4;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints3.gridy = 0;
            this.jLabel1 = new BLabel();
            this.jLabel1.setText("clocks");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(3, 24, 3, 0);
            gridBagConstraints4.gridx = 3;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints5.gridy = 3;
            this.lblPeriod = new BLabel();
            this.lblPeriod.setText("Vibrato Rate");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(3, 24, 3, 0);
            gridBagConstraints6.gridx = 3;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints7.gridy = 1;
            this.lblAmplitude = new BLabel();
            this.lblAmplitude.setText("Vibrato Depth");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 0;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(3, 24, 3, 0);
            gridBagConstraints8.gridx = 3;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints9.gridy = 0;
            this.lblDynamics = new BLabel();
            this.lblDynamics.setText("Dynamics");
            this.BPanel = new BPanel();
            this.BPanel.setLayout(new GridBagLayout());
            this.BPanel.add((Component)this.lblDynamics, gridBagConstraints9);
            this.BPanel.add((Component)this.getComboDynamics(), gridBagConstraints8);
            this.BPanel.add((Component)this.lblAmplitude, gridBagConstraints7);
            this.BPanel.add((Component)this.getComboAmplitude(), gridBagConstraints6);
            this.BPanel.add((Component)this.lblPeriod, gridBagConstraints5);
            this.BPanel.add((Component)this.getComboPeriod(), gridBagConstraints4);
            this.BPanel.add((Component)this.jLabel1, gridBagConstraints3);
            this.BPanel.add((Component)this.jLabel11, gridBagConstraints2);
            this.BPanel.add((Component)this.jLabel12, gridBagConstraints);
        }
        return this.BPanel;
    }

    private BComboBox getComboDynamics() {
        if (this.comboDynamics == null) {
            this.comboDynamics = new BComboBox();
            this.comboDynamics.setPreferredSize(new Dimension(101, 20));
        }
        return this.comboDynamics;
    }

    private BComboBox getComboAmplitude() {
        if (this.comboAmplitude == null) {
            this.comboAmplitude = new BComboBox();
            this.comboAmplitude.setPreferredSize(new Dimension(101, 20));
        }
        return this.comboAmplitude;
    }

    private BComboBox getComboPeriod() {
        if (this.comboPeriod == null) {
            this.comboPeriod = new BComboBox();
            this.comboPeriod.setPreferredSize(new Dimension(101, 20));
        }
        return this.comboPeriod;
    }

    private BPanel getJPanel1() {
        if (this.jPanel1 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 5;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 24, 3, 12);
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 4;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
            this.jLabel13 = new BLabel();
            this.jLabel13.setText("%");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(3, 24, 3, 0);
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.fill = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.insets = new Insets(0, 24, 0, 0);
            this.lblVibratoLength = new BLabel();
            this.lblVibratoLength.setText("Default Vibrato Length");
            this.jPanel1 = new BPanel();
            this.jPanel1.setLayout(new GridBagLayout());
            this.jPanel1.add((Component)this.lblVibratoLength, gridBagConstraints4);
            this.jPanel1.add((Component)this.getComboVibratoLength(), gridBagConstraints3);
            this.jPanel1.add((Component)this.jLabel13, gridBagConstraints2);
            this.jPanel1.add((Component)this.getGroupAutoVibratoConfig(), gridBagConstraints);
        }
        return this.jPanel1;
    }

    private BComboBox getComboVibratoLength() {
        if (this.comboVibratoLength == null) {
            this.comboVibratoLength = new BComboBox();
            this.comboVibratoLength.setPreferredSize(new Dimension(101, 20));
        }
        return this.comboVibratoLength;
    }

    private BGroupBox getGroupAutoVibratoConfig() {
        if (this.groupAutoVibratoConfig == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints3.gridy = 0;
            this.groupAutoVibratoConfig = new BGroupBox();
            this.groupAutoVibratoConfig.setLayout(new GridBagLayout());
            this.groupAutoVibratoConfig.setBorder(BorderFactory.createTitledBorder(null, "Auto Vibrato Settings", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.groupAutoVibratoConfig.add((Component)this.getChkEnableAutoVibrato(), gridBagConstraints3);
            this.groupAutoVibratoConfig.add((Component)this.getJPanel3(), gridBagConstraints2);
            this.groupAutoVibratoConfig.add((Component)this.getJPanel4(), gridBagConstraints);
        }
        return this.groupAutoVibratoConfig;
    }

    private BPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            this.jLabel4 = new BLabel();
            this.jLabel4.setText("beat");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 12);
            gridBagConstraints2.gridx = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 0;
            this.lblAutoVibratoMinLength = new BLabel();
            this.lblAutoVibratoMinLength.setText("Minimum note length for Automatic Vibrato");
            this.jPanel3 = new BPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.add((Component)this.lblAutoVibratoMinLength, gridBagConstraints3);
            this.jPanel3.add((Component)this.getComboAutoVibratoMinLength(), gridBagConstraints2);
            this.jPanel3.add((Component)this.jLabel4, gridBagConstraints);
        }
        return this.jPanel3;
    }

    private BCheckBox getChkEnableAutoVibrato() {
        if (this.chkEnableAutoVibrato == null) {
            this.chkEnableAutoVibrato = new BCheckBox();
            this.chkEnableAutoVibrato.setText("Enable Automatic Vibrato");
        }
        return this.chkEnableAutoVibrato;
    }

    private BComboBox getComboAutoVibratoMinLength() {
        if (this.comboAutoVibratoMinLength == null) {
            this.comboAutoVibratoMinLength = new BComboBox();
            this.comboAutoVibratoMinLength.setPreferredSize(new Dimension(66, 20));
        }
        return this.comboAutoVibratoMinLength;
    }

    private BPanel getJPanel4() {
        if (this.jPanel4 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 1;
            this.lblAutoVibratoType2 = new BLabel();
            this.lblAutoVibratoType2.setText("Vibrato Class VOCALOID2");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 0;
            this.lblAutoVibratoType1 = new BLabel();
            this.lblAutoVibratoType1.setText("Vibrato Class VOCALOID1");
            this.jPanel4 = new BPanel();
            this.jPanel4.setLayout(new GridBagLayout());
            this.jPanel4.add((Component)this.lblAutoVibratoType1, gridBagConstraints4);
            this.jPanel4.add((Component)this.getComboAutoVibratoType1(), gridBagConstraints3);
            this.jPanel4.add((Component)this.lblAutoVibratoType2, gridBagConstraints2);
            this.jPanel4.add((Component)this.getComboAutoVibratoType2(), gridBagConstraints);
        }
        return this.jPanel4;
    }

    private BComboBox getComboAutoVibratoType1() {
        if (this.comboAutoVibratoType1 == null) {
            this.comboAutoVibratoType1 = new BComboBox();
            this.comboAutoVibratoType1.setPreferredSize(new Dimension(101, 20));
        }
        return this.comboAutoVibratoType1;
    }

    private BComboBox getComboAutoVibratoType2() {
        if (this.comboAutoVibratoType2 == null) {
            this.comboAutoVibratoType2 = new BComboBox();
            this.comboAutoVibratoType2.setPreferredSize(new Dimension(101, 20));
        }
        return this.comboAutoVibratoType2;
    }

    private BPanel getTabAnother() {
        if (this.tabAnother == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 16, 0, 16);
            gridBagConstraints.gridy = 6;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 2;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints2.gridy = 5;
            this.jLabel811 = new BLabel();
            this.jLabel811.setText("msec(100-1000)");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints3.gridy = 5;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(3, 24, 3, 0);
            gridBagConstraints4.gridy = 5;
            this.lblBuffer = new BLabel();
            this.lblBuffer.setText("Buffer Size");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints5.gridwidth = 3;
            gridBagConstraints5.gridy = 4;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.weighty = 1.0;
            gridBagConstraints6.gridy = 9;
            this.jLabel9 = new BLabel();
            this.jLabel9.setText("   ");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.gridy = 3;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridwidth = 2;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(3, 24, 3, 0);
            gridBagConstraints8.gridy = 3;
            this.lblDefaultPremeasure = new BLabel();
            this.lblDefaultPremeasure.setText("Default Pre-measure");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 2;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints9.gridy = 2;
            this.jLabel81 = new BLabel();
            this.jLabel81.setText("msec(200-2000)");
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 0;
            gridBagConstraints10.gridy = 2;
            gridBagConstraints10.weightx = 0.0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints11.gridy = 2;
            this.lblWait = new BLabel();
            this.lblWait.setText("Waiting Time");
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 2;
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints12.weightx = 1.0;
            gridBagConstraints12.gridy = 1;
            this.jLabel8 = new BLabel();
            this.jLabel8.setText("msec(500-5000)");
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.fill = 0;
            gridBagConstraints13.gridy = 1;
            gridBagConstraints13.weightx = 0.0;
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints13.gridx = 1;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 0;
            gridBagConstraints14.anchor = 17;
            gridBagConstraints14.insets = new Insets(0, 24, 0, 0);
            gridBagConstraints14.gridy = 1;
            this.lblPreSendTime = new BLabel();
            this.lblPreSendTime.setText("Pre-Send time");
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.fill = 0;
            gridBagConstraints15.gridy = 0;
            gridBagConstraints15.weightx = 1.0;
            gridBagConstraints15.anchor = 17;
            gridBagConstraints15.insets = new Insets(12, 12, 3, 0);
            gridBagConstraints15.gridwidth = 2;
            gridBagConstraints15.gridx = 1;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 0;
            gridBagConstraints16.anchor = 17;
            gridBagConstraints16.insets = new Insets(12, 24, 0, 0);
            gridBagConstraints16.gridy = 0;
            this.lblDefaultSinger = new BLabel();
            this.lblDefaultSinger.setText("Default Singer");
            this.tabAnother = new BPanel();
            this.tabAnother.setLayout(new GridBagLayout());
            this.tabAnother.setSize(new Dimension(420, 283));
            this.tabAnother.add((Component)this.lblDefaultSinger, gridBagConstraints16);
            this.tabAnother.add((Component)this.getComboDefualtSinger(), gridBagConstraints15);
            this.tabAnother.add((Component)this.lblPreSendTime, gridBagConstraints14);
            this.tabAnother.add((Component)this.getNumPreSendTime(), gridBagConstraints13);
            this.tabAnother.add((Component)this.jLabel8, gridBagConstraints12);
            this.tabAnother.add((Component)this.lblWait, gridBagConstraints11);
            this.tabAnother.add((Component)this.getNumWait(), gridBagConstraints10);
            this.tabAnother.add((Component)this.jLabel81, gridBagConstraints9);
            this.tabAnother.add((Component)this.lblDefaultPremeasure, gridBagConstraints8);
            this.tabAnother.add((Component)this.getComboDefaultPremeasure(), gridBagConstraints7);
            this.tabAnother.add((Component)this.jLabel9, gridBagConstraints6);
            this.tabAnother.add((Component)this.getChkChasePastEvent(), gridBagConstraints5);
            this.tabAnother.add((Component)this.lblBuffer, gridBagConstraints4);
            this.tabAnother.add((Component)this.getNumBuffer(), gridBagConstraints3);
            this.tabAnother.add((Component)this.jLabel811, gridBagConstraints2);
            this.tabAnother.add((Component)this.getGroupWaveFileOutput(), gridBagConstraints);
        }
        return this.tabAnother;
    }

    private BComboBox getComboDefualtSinger() {
        if (this.comboDefualtSinger == null) {
            this.comboDefualtSinger = new BComboBox();
            this.comboDefualtSinger.setPreferredSize(new Dimension(222, 20));
        }
        return this.comboDefualtSinger;
    }

    private BNumericUpDown getNumPreSendTime() {
        if (this.numPreSendTime == null) {
            this.numPreSendTime = new BNumericUpDown();
            this.numPreSendTime.setPreferredSize(new Dimension(68, 20));
        }
        return this.numPreSendTime;
    }

    private BNumericUpDown getNumWait() {
        if (this.numWait == null) {
            this.numWait = new BNumericUpDown();
            this.numWait.setPreferredSize(new Dimension(68, 20));
        }
        return this.numWait;
    }

    private BComboBox getComboDefaultPremeasure() {
        if (this.comboDefaultPremeasure == null) {
            this.comboDefaultPremeasure = new BComboBox();
            this.comboDefaultPremeasure.setPreferredSize(new Dimension(68, 20));
        }
        return this.comboDefaultPremeasure;
    }

    private BPanel getTabAppearance() {
        if (this.tabAppearance == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints3.gridy = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(12, 12, 3, 12);
            gridBagConstraints4.gridy = 0;
            this.tabAppearance = new BPanel();
            this.tabAppearance.setLayout(new GridBagLayout());
            this.tabAppearance.add((Component)this.getGroupFont(), gridBagConstraints4);
            this.tabAppearance.add((Component)this.getJPanel7(), gridBagConstraints3);
            this.tabAppearance.add((Component)this.getJPanel71(), gridBagConstraints2);
            this.tabAppearance.add((Component)this.getGroupVisibleCurve(), gridBagConstraints);
        }
        return this.tabAppearance;
    }

    private BGroupBox getGroupFont() {
        if (this.groupFont == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 1;
            this.labelScreenFontName = new BLabel();
            this.labelScreenFontName.setText("MS UI Gothic");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints3.gridy = 1;
            this.labelScreen = new BLabel();
            this.labelScreen.setText("Screen");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints4.gridy = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints5.gridy = 0;
            this.labelMenuFontName = new BLabel();
            this.labelMenuFontName.setText("MS UI Gothic");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints6.gridy = 0;
            this.labelMenu = new BLabel();
            this.labelMenu.setText("Menu/Lyrics");
            this.groupFont = new BGroupBox();
            this.groupFont.setLayout(new GridBagLayout());
            this.groupFont.setBorder(BorderFactory.createTitledBorder(null, "Font", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.groupFont.add((Component)this.labelMenu, gridBagConstraints6);
            this.groupFont.add((Component)this.labelMenuFontName, gridBagConstraints5);
            this.groupFont.add((Component)this.getBtnChangeMenuFont(), gridBagConstraints4);
            this.groupFont.add((Component)this.labelScreen, gridBagConstraints3);
            this.groupFont.add((Component)this.labelScreenFontName, gridBagConstraints2);
            this.groupFont.add((Component)this.getBtnChangeScreenFont(), gridBagConstraints);
        }
        return this.groupFont;
    }

    private BButton getBtnChangeMenuFont() {
        if (this.btnChangeMenuFont == null) {
            this.btnChangeMenuFont = new BButton();
            this.btnChangeMenuFont.setText("Change");
            this.btnChangeMenuFont.setPreferredSize(new Dimension(85, 23));
        }
        return this.btnChangeMenuFont;
    }

    private BButton getBtnChangeScreenFont() {
        if (this.btnChangeScreenFont == null) {
            this.btnChangeScreenFont = new BButton();
            this.btnChangeScreenFont.setPreferredSize(new Dimension(85, 23));
            this.btnChangeScreenFont.setText("Change");
        }
        return this.btnChangeScreenFont;
    }

    private BPanel getJPanel7() {
        if (this.jPanel7 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints2.gridy = 0;
            this.lblLanguage = new BLabel();
            this.lblLanguage.setText("UI Language");
            this.jPanel7 = new BPanel();
            this.jPanel7.setLayout(new GridBagLayout());
            this.jPanel7.add((Component)this.lblLanguage, gridBagConstraints2);
            this.jPanel7.add((Component)this.getComboLanguage(), gridBagConstraints);
        }
        return this.jPanel7;
    }

    private BComboBox getComboLanguage() {
        if (this.comboLanguage == null) {
            this.comboLanguage = new BComboBox();
            this.comboLanguage.setPreferredSize(new Dimension(121, 20));
        }
        return this.comboLanguage;
    }

    private BPanel getJPanel71() {
        if (this.jPanel71 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 0);
            this.lblTrackHeight = new BLabel();
            this.lblTrackHeight.setText("Track Height(pixel)");
            this.jPanel71 = new BPanel();
            this.jPanel71.setLayout(new GridBagLayout());
            this.jPanel71.add((Component)this.lblTrackHeight, gridBagConstraints2);
            this.jPanel71.add((Component)this.getNumTrackHeight(), gridBagConstraints);
        }
        return this.jPanel71;
    }

    private BNumericUpDown getNumTrackHeight() {
        if (this.numTrackHeight == null) {
            this.numTrackHeight = new BNumericUpDown();
            this.numTrackHeight.setPreferredSize(new Dimension(121, 20));
        }
        return this.numTrackHeight;
    }

    private BGroupBox getGroupVisibleCurve() {
        if (this.groupVisibleCurve == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints.gridy = 5;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints2.gridy = 4;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 2;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints3.gridy = 4;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 1;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints4.gridy = 4;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints5.gridy = 4;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 3;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints6.gridy = 3;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 2;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints7.gridy = 3;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 1;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints8.gridy = 3;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints9.gridy = 3;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 3;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints10.gridy = 2;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 2;
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints11.gridy = 2;
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 1;
            gridBagConstraints12.anchor = 17;
            gridBagConstraints12.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints12.gridy = 2;
            GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
            gridBagConstraints13.gridx = 0;
            gridBagConstraints13.anchor = 17;
            gridBagConstraints13.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints13.gridy = 2;
            GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
            gridBagConstraints14.gridx = 3;
            gridBagConstraints14.anchor = 17;
            gridBagConstraints14.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints14.gridy = 1;
            GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
            gridBagConstraints15.gridx = 2;
            gridBagConstraints15.anchor = 17;
            gridBagConstraints15.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints15.gridy = 1;
            GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
            gridBagConstraints16.gridx = 1;
            gridBagConstraints16.anchor = 17;
            gridBagConstraints16.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints16.gridy = 1;
            GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
            gridBagConstraints17.gridx = 0;
            gridBagConstraints17.anchor = 17;
            gridBagConstraints17.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints17.gridy = 1;
            GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
            gridBagConstraints18.gridx = 3;
            gridBagConstraints18.anchor = 17;
            gridBagConstraints18.weightx = 0.25;
            gridBagConstraints18.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints18.gridy = 0;
            GridBagConstraints gridBagConstraints19 = new GridBagConstraints();
            gridBagConstraints19.gridx = 2;
            gridBagConstraints19.anchor = 17;
            gridBagConstraints19.weightx = 0.25;
            gridBagConstraints19.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints19.gridy = 0;
            GridBagConstraints gridBagConstraints20 = new GridBagConstraints();
            gridBagConstraints20.gridx = 1;
            gridBagConstraints20.anchor = 17;
            gridBagConstraints20.weightx = 0.25;
            gridBagConstraints20.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints20.gridy = 0;
            GridBagConstraints gridBagConstraints21 = new GridBagConstraints();
            gridBagConstraints21.gridx = 0;
            gridBagConstraints21.anchor = 17;
            gridBagConstraints21.weightx = 0.25;
            gridBagConstraints21.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints21.gridy = 0;
            this.groupVisibleCurve = new BGroupBox();
            this.groupVisibleCurve.setLayout(new GridBagLayout());
            this.groupVisibleCurve.setBorder(BorderFactory.createTitledBorder(null, "Visible Control Curve", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.groupVisibleCurve.add((Component)this.getChkAccent(), gridBagConstraints21);
            this.groupVisibleCurve.add((Component)this.getChkDecay(), gridBagConstraints20);
            this.groupVisibleCurve.add((Component)this.getChkVibratoRate(), gridBagConstraints19);
            this.groupVisibleCurve.add((Component)this.getChkVibratoDepth(), gridBagConstraints18);
            this.groupVisibleCurve.add((Component)this.getChkVel(), gridBagConstraints17);
            this.groupVisibleCurve.add((Component)this.getChkDyn(), gridBagConstraints16);
            this.groupVisibleCurve.add((Component)this.getChkBre(), gridBagConstraints15);
            this.groupVisibleCurve.add((Component)this.getChkBri(), gridBagConstraints14);
            this.groupVisibleCurve.add((Component)this.getChkCle(), gridBagConstraints13);
            this.groupVisibleCurve.add((Component)this.getChkOpe(), gridBagConstraints12);
            this.groupVisibleCurve.add((Component)this.getChkGen(), gridBagConstraints11);
            this.groupVisibleCurve.add((Component)this.getChkPor(), gridBagConstraints10);
            this.groupVisibleCurve.add((Component)this.getChkPit(), gridBagConstraints9);
            this.groupVisibleCurve.add((Component)this.getChkPbs(), gridBagConstraints8);
            this.groupVisibleCurve.add((Component)this.getChkHarmonics(), gridBagConstraints7);
            this.groupVisibleCurve.add((Component)this.getChkFx2Depth(), gridBagConstraints6);
            this.groupVisibleCurve.add((Component)this.getChkReso1(), gridBagConstraints5);
            this.groupVisibleCurve.add((Component)this.getChkReso2(), gridBagConstraints4);
            this.groupVisibleCurve.add((Component)this.getChkReso3(), gridBagConstraints3);
            this.groupVisibleCurve.add((Component)this.getChkReso4(), gridBagConstraints2);
            this.groupVisibleCurve.add((Component)this.getChkEnvelope(), gridBagConstraints);
        }
        return this.groupVisibleCurve;
    }

    private BCheckBox getChkAccent() {
        if (this.chkAccent == null) {
            this.chkAccent = new BCheckBox();
            this.chkAccent.setText("Accent");
        }
        return this.chkAccent;
    }

    private BCheckBox getChkDecay() {
        if (this.chkDecay == null) {
            this.chkDecay = new BCheckBox();
            this.chkDecay.setText("Decay");
        }
        return this.chkDecay;
    }

    private BCheckBox getChkVibratoRate() {
        if (this.chkVibratoRate == null) {
            this.chkVibratoRate = new BCheckBox();
            this.chkVibratoRate.setText("VibratoRate");
        }
        return this.chkVibratoRate;
    }

    private BCheckBox getChkVibratoDepth() {
        if (this.chkVibratoDepth == null) {
            this.chkVibratoDepth = new BCheckBox();
            this.chkVibratoDepth.setText("VibratoDepth");
        }
        return this.chkVibratoDepth;
    }

    private BCheckBox getChkVel() {
        if (this.chkVel == null) {
            this.chkVel = new BCheckBox();
            this.chkVel.setText("VEL");
        }
        return this.chkVel;
    }

    private BCheckBox getChkDyn() {
        if (this.chkDyn == null) {
            this.chkDyn = new BCheckBox();
            this.chkDyn.setText("DYN");
        }
        return this.chkDyn;
    }

    private BCheckBox getChkBre() {
        if (this.chkBre == null) {
            this.chkBre = new BCheckBox();
            this.chkBre.setText("BRE");
        }
        return this.chkBre;
    }

    private BCheckBox getChkBri() {
        if (this.chkBri == null) {
            this.chkBri = new BCheckBox();
            this.chkBri.setText("BRI");
        }
        return this.chkBri;
    }

    private BCheckBox getChkCle() {
        if (this.chkCle == null) {
            this.chkCle = new BCheckBox();
            this.chkCle.setText("CLE");
        }
        return this.chkCle;
    }

    private BCheckBox getChkOpe() {
        if (this.chkOpe == null) {
            this.chkOpe = new BCheckBox();
            this.chkOpe.setText("OPE");
        }
        return this.chkOpe;
    }

    private BCheckBox getChkGen() {
        if (this.chkGen == null) {
            this.chkGen = new BCheckBox();
            this.chkGen.setText("GEN");
        }
        return this.chkGen;
    }

    private BCheckBox getChkPor() {
        if (this.chkPor == null) {
            this.chkPor = new BCheckBox();
            this.chkPor.setText("POR");
        }
        return this.chkPor;
    }

    private BCheckBox getChkPit() {
        if (this.chkPit == null) {
            this.chkPit = new BCheckBox();
            this.chkPit.setText("PIT");
        }
        return this.chkPit;
    }

    private BCheckBox getChkPbs() {
        if (this.chkPbs == null) {
            this.chkPbs = new BCheckBox();
            this.chkPbs.setText("PBS");
        }
        return this.chkPbs;
    }

    private BCheckBox getChkHarmonics() {
        if (this.chkHarmonics == null) {
            this.chkHarmonics = new BCheckBox();
            this.chkHarmonics.setText("Harmonics");
        }
        return this.chkHarmonics;
    }

    private BCheckBox getChkFx2Depth() {
        if (this.chkFx2Depth == null) {
            this.chkFx2Depth = new BCheckBox();
            this.chkFx2Depth.setText("FX2Depth");
        }
        return this.chkFx2Depth;
    }

    private BCheckBox getChkReso1() {
        if (this.chkReso1 == null) {
            this.chkReso1 = new BCheckBox();
            this.chkReso1.setText("Reso1");
        }
        return this.chkReso1;
    }

    private BCheckBox getChkReso2() {
        if (this.chkReso2 == null) {
            this.chkReso2 = new BCheckBox();
            this.chkReso2.setText("Reso2");
        }
        return this.chkReso2;
    }

    private BCheckBox getChkReso3() {
        if (this.chkReso3 == null) {
            this.chkReso3 = new BCheckBox();
            this.chkReso3.setText("Reso3");
        }
        return this.chkReso3;
    }

    private BCheckBox getChkReso4() {
        if (this.chkReso4 == null) {
            this.chkReso4 = new BCheckBox();
            this.chkReso4.setText("Reso4");
        }
        return this.chkReso4;
    }

    private BCheckBox getChkEnvelope() {
        if (this.chkEnvelope == null) {
            this.chkEnvelope = new BCheckBox();
            this.chkEnvelope.setText("Envelope");
        }
        return this.chkEnvelope;
    }

    private BPanel getTabOperation() {
        if (this.tabOperation == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(12, 12, 3, 12);
            gridBagConstraints2.gridy = 0;
            this.tabOperation = new BPanel();
            this.tabOperation.setLayout(new GridBagLayout());
            this.tabOperation.setSize(new Dimension(441, 358));
            this.tabOperation.add((Component)this.getGroupPianoroll(), gridBagConstraints2);
            this.tabOperation.add((Component)this.getGroupMisc(), gridBagConstraints);
        }
        return this.tabOperation;
    }

    private BGroupBox getGroupPianoroll() {
        if (this.groupPianoroll == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints.gridy = 6;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints2.gridy = 5;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints3.gridy = 4;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridwidth = 2;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints4.gridy = 3;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints5.gridy = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints6.gridy = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints7.gridx = 1;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridy = 0;
            this.labelWheelOrder = new BLabel();
            this.labelWheelOrder.setText("Mouse wheel Rate");
            this.groupPianoroll = new BGroupBox();
            this.groupPianoroll.setLayout(new GridBagLayout());
            this.groupPianoroll.setBorder(BorderFactory.createTitledBorder(null, "Piano Roll", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.groupPianoroll.add((Component)this.labelWheelOrder, gridBagConstraints8);
            this.groupPianoroll.add((Component)this.getNumericUpDownEx1(), gridBagConstraints7);
            this.groupPianoroll.add((Component)this.getChkCursorFix(), gridBagConstraints6);
            this.groupPianoroll.add((Component)this.getChkScrollHorizontal(), gridBagConstraints5);
            this.groupPianoroll.add((Component)this.getChkKeepLyricInputMode(), gridBagConstraints4);
            this.groupPianoroll.add((Component)this.getChkPlayPreviewWhenRightClick(), gridBagConstraints3);
            this.groupPianoroll.add((Component)this.getChkCurveSelectingQuantized(), gridBagConstraints2);
            this.groupPianoroll.add((Component)this.getChkUseSpaceKeyAsMiddleButtonModifier(), gridBagConstraints);
        }
        return this.groupPianoroll;
    }

    private BNumericUpDown getNumericUpDownEx1() {
        if (this.numericUpDownEx1 == null) {
            this.numericUpDownEx1 = new BNumericUpDown();
            this.numericUpDownEx1.setPreferredSize(new Dimension(120, 20));
        }
        return this.numericUpDownEx1;
    }

    private BCheckBox getChkCursorFix() {
        if (this.chkCursorFix == null) {
            this.chkCursorFix = new BCheckBox();
            this.chkCursorFix.setText("Fix Play Cursor to Center");
        }
        return this.chkCursorFix;
    }

    private BCheckBox getChkScrollHorizontal() {
        if (this.chkScrollHorizontal == null) {
            this.chkScrollHorizontal = new BCheckBox();
            this.chkScrollHorizontal.setText("Horizontal Scroll when Mouse wheel");
        }
        return this.chkScrollHorizontal;
    }

    private BCheckBox getChkKeepLyricInputMode() {
        if (this.chkKeepLyricInputMode == null) {
            this.chkKeepLyricInputMode = new BCheckBox();
            this.chkKeepLyricInputMode.setText("Keep Lyric Input Mode");
        }
        return this.chkKeepLyricInputMode;
    }

    private BCheckBox getChkPlayPreviewWhenRightClick() {
        if (this.chkPlayPreviewWhenRightClick == null) {
            this.chkPlayPreviewWhenRightClick = new BCheckBox();
            this.chkPlayPreviewWhenRightClick.setText("Play Preview On Right Click");
        }
        return this.chkPlayPreviewWhenRightClick;
    }

    private BCheckBox getChkCurveSelectingQuantized() {
        if (this.chkCurveSelectingQuantized == null) {
            this.chkCurveSelectingQuantized = new BCheckBox();
            this.chkCurveSelectingQuantized.setText("Enable Quantize for Curve Selecting");
        }
        return this.chkCurveSelectingQuantized;
    }

    private BCheckBox getChkUseSpaceKeyAsMiddleButtonModifier() {
        if (this.chkUseSpaceKeyAsMiddleButtonModifier == null) {
            this.chkUseSpaceKeyAsMiddleButtonModifier = new BCheckBox();
            this.chkUseSpaceKeyAsMiddleButtonModifier.setText("Use space key as Middle button modifier");
        }
        return this.chkUseSpaceKeyAsMiddleButtonModifier;
    }

    private BGroupBox getGroupMisc() {
        if (this.groupMisc == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints.weightx = 1.0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 3;
            this.labelMtcMidiInPort = new BLabel();
            this.labelMtcMidiInPort.setText("MTC MIDI In Port Number");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints4.gridy = 2;
            this.lblMidiInPort = new BLabel();
            this.lblMidiInPort.setText("MIDI In Port Number");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints5.gridx = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints6.gridy = 1;
            this.lblMouseHoverTime = new BLabel();
            this.lblMouseHoverTime.setText("Waiting Time for Preview");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 2;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(3, 3, 3, 0);
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.gridy = 0;
            this.lblMilliSecond = new BLabel();
            this.lblMilliSecond.setText("milli second");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 0;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints9.gridy = 0;
            this.lblMaximumFrameRate = new BLabel();
            this.lblMaximumFrameRate.setText("Maximum Frame Rate");
            this.groupMisc = new BGroupBox();
            this.groupMisc.setLayout(new GridBagLayout());
            this.groupMisc.setBorder(BorderFactory.createTitledBorder(null, "Misc", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.groupMisc.add((Component)this.lblMaximumFrameRate, gridBagConstraints9);
            this.groupMisc.add((Component)this.getNumMaximumFrameRate(), gridBagConstraints8);
            this.groupMisc.add((Component)this.lblMilliSecond, gridBagConstraints7);
            this.groupMisc.add((Component)this.lblMouseHoverTime, gridBagConstraints6);
            this.groupMisc.add((Component)this.getNumMouseHoverTime(), gridBagConstraints5);
            this.groupMisc.add((Component)this.lblMidiInPort, gridBagConstraints4);
            this.groupMisc.add((Component)this.getComboMidiInPortNumber(), gridBagConstraints3);
            this.groupMisc.add((Component)this.labelMtcMidiInPort, gridBagConstraints2);
            this.groupMisc.add((Component)this.getComboMtcMidiInPortNumber(), gridBagConstraints);
        }
        return this.groupMisc;
    }

    private BNumericUpDown getNumMaximumFrameRate() {
        if (this.numMaximumFrameRate == null) {
            this.numMaximumFrameRate = new BNumericUpDown();
            this.numMaximumFrameRate.setPreferredSize(new Dimension(120, 20));
        }
        return this.numMaximumFrameRate;
    }

    private BNumericUpDown getNumMouseHoverTime() {
        if (this.numMouseHoverTime == null) {
            this.numMouseHoverTime = new BNumericUpDown();
            this.numMouseHoverTime.setPreferredSize(new Dimension(120, 20));
        }
        return this.numMouseHoverTime;
    }

    private BComboBox getComboMidiInPortNumber() {
        if (this.comboMidiInPortNumber == null) {
            this.comboMidiInPortNumber = new BComboBox();
            this.comboMidiInPortNumber.setPreferredSize(new Dimension(239, 20));
        }
        return this.comboMidiInPortNumber;
    }

    private BPanel getTabPlatform() {
        if (this.tabPlatform == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(12, 12, 3, 12);
            gridBagConstraints2.gridy = 0;
            this.tabPlatform = new BPanel();
            this.tabPlatform.setLayout(new GridBagLayout());
            this.tabPlatform.setSize(new Dimension(394, 267));
            this.tabPlatform.add((Component)this.getGroupPlatform(), gridBagConstraints2);
            this.tabPlatform.add((Component)this.getGroupUtauCores(), gridBagConstraints);
        }
        return this.tabPlatform;
    }

    private BGroupBox getGroupPlatform() {
        if (this.groupPlatform == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 3;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridwidth = 2;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints4.gridy = 0;
            this.lblPlatform = new BLabel();
            this.lblPlatform.setText("Current Platform");
            this.groupPlatform = new BGroupBox();
            this.groupPlatform.setLayout(new GridBagLayout());
            this.groupPlatform.setBorder(BorderFactory.createTitledBorder(null, "Platform", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.groupPlatform.add((Component)this.lblPlatform, gridBagConstraints4);
            this.groupPlatform.add((Component)this.getComboPlatform(), gridBagConstraints3);
            this.groupPlatform.add((Component)this.getChkCommandKeyAsControl(), gridBagConstraints2);
            this.groupPlatform.add((Component)this.getChkTranslateRoman(), gridBagConstraints);
        }
        return this.groupPlatform;
    }

    private BComboBox getComboPlatform() {
        if (this.comboPlatform == null) {
            this.comboPlatform = new BComboBox();
            this.comboPlatform.setPreferredSize(new Dimension(121, 20));
        }
        return this.comboPlatform;
    }

    private BCheckBox getChkCommandKeyAsControl() {
        if (this.chkCommandKeyAsControl == null) {
            this.chkCommandKeyAsControl = new BCheckBox();
            this.chkCommandKeyAsControl.setText("Use Command key as Control key");
        }
        return this.chkCommandKeyAsControl;
    }

    private BCheckBox getChkTranslateRoman() {
        if (this.chkTranslateRoman == null) {
            this.chkTranslateRoman = new BCheckBox();
            this.chkTranslateRoman.setText("Translate Roman letters into Kana");
        }
        return this.chkTranslateRoman;
    }

    private BGroupBox getGroupVsti() {
        if (this.groupVsti == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints3.weightx = 1.0;
            this.lblAquesTone = new BLabel();
            this.lblAquesTone.setText("AquesTone");
            this.lblAquesTone.setPreferredSize(new Dimension(72, 16));
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints5.gridy = 1;
            this.lblVOCALOID2 = new BLabel();
            this.lblVOCALOID2.setText("VOCALOID2");
            this.lblVOCALOID2.setPreferredSize(new Dimension(72, 16));
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints7.gridy = 0;
            this.lblVOCALOID1 = new BLabel();
            this.lblVOCALOID1.setText("VOCALOID1");
            this.lblVOCALOID1.setPreferredSize(new Dimension(72, 16));
            this.groupVsti = new BGroupBox();
            this.groupVsti.setLayout(new GridBagLayout());
            this.groupVsti.setBorder(BorderFactory.createTitledBorder(null, "VST Instruments", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.groupVsti.add((Component)this.lblVOCALOID1, gridBagConstraints7);
            this.groupVsti.add((Component)this.getTxtVOCALOID1(), gridBagConstraints6);
            this.groupVsti.add((Component)this.lblVOCALOID2, gridBagConstraints5);
            this.groupVsti.add((Component)this.getTxtVOCALOID2(), gridBagConstraints4);
            this.groupVsti.add((Component)this.lblAquesTone, gridBagConstraints2);
            this.groupVsti.add((Component)this.getTxtAquesTone(), gridBagConstraints3);
            this.groupVsti.add((Component)this.getBtnAquesTone(), gridBagConstraints);
        }
        return this.groupVsti;
    }

    private BTextBox getTxtVOCALOID1() {
        if (this.txtVOCALOID1 == null) {
            this.txtVOCALOID1 = new BTextBox();
        }
        return this.txtVOCALOID1;
    }

    private BTextBox getTxtVOCALOID2() {
        if (this.txtVOCALOID2 == null) {
            this.txtVOCALOID2 = new BTextBox();
        }
        return this.txtVOCALOID2;
    }

    private BGroupBox getGroupUtauCores() {
        if (this.groupUtauCores == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints3.gridx = 1;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 1;
            this.lblWavtool = new BLabel();
            this.lblWavtool.setText("wavtool");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 3;
            gridBagConstraints5.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints5.gridy = 0;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints7.gridy = 0;
            this.lblResampler = new BLabel();
            this.lblResampler.setText("resampler");
            this.groupUtauCores = new BGroupBox();
            this.groupUtauCores.setLayout(new GridBagLayout());
            this.groupUtauCores.setBorder(BorderFactory.createTitledBorder(null, "UTAU Cores", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.groupUtauCores.add((Component)this.lblResampler, gridBagConstraints7);
            this.groupUtauCores.add((Component)this.getTxtResampler(), gridBagConstraints6);
            this.groupUtauCores.add((Component)this.getBtnResampler(), gridBagConstraints5);
            this.groupUtauCores.add((Component)this.lblWavtool, gridBagConstraints4);
            this.groupUtauCores.add((Component)this.getTxtWavtool(), gridBagConstraints3);
            this.groupUtauCores.add((Component)this.getBtnWavtool(), gridBagConstraints2);
            this.groupUtauCores.add((Component)this.getChkInvokeWithWine(), gridBagConstraints);
        }
        return this.groupUtauCores;
    }

    private BTextBox getTxtResampler() {
        if (this.txtResampler == null) {
            this.txtResampler = new BTextBox();
        }
        return this.txtResampler;
    }

    private BButton getBtnResampler() {
        if (this.btnResampler == null) {
            this.btnResampler = new BButton();
            this.btnResampler.setText("...");
            this.btnResampler.setPreferredSize(new Dimension(41, 23));
        }
        return this.btnResampler;
    }

    private BTextBox getTxtWavtool() {
        if (this.txtWavtool == null) {
            this.txtWavtool = new BTextBox();
        }
        return this.txtWavtool;
    }

    private BButton getBtnWavtool() {
        if (this.btnWavtool == null) {
            this.btnWavtool = new BButton();
            this.btnWavtool.setPreferredSize(new Dimension(41, 23));
            this.btnWavtool.setText("...");
        }
        return this.btnWavtool;
    }

    private BCheckBox getChkInvokeWithWine() {
        if (this.chkInvokeWithWine == null) {
            this.chkInvokeWithWine = new BCheckBox();
            this.chkInvokeWithWine.setText("Invoke UTAU cores with Wine");
        }
        return this.chkInvokeWithWine;
    }

    private BPanel getTabUtauSingers() {
        if (this.tabUtauSingers == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 12, 12, 12);
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 12, 12, 12);
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.anchor = 11;
            gridBagConstraints3.insets = new Insets(12, 12, 12, 12);
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.gridx = 0;
            this.tabUtauSingers = new BPanel();
            this.tabUtauSingers.setLayout(new GridBagLayout());
            this.tabUtauSingers.add((Component)this.getListSingers(), gridBagConstraints3);
            this.tabUtauSingers.add((Component)this.getJPanel17(), gridBagConstraints2);
            this.tabUtauSingers.add((Component)this.getJPanel18(), gridBagConstraints);
        }
        return this.tabUtauSingers;
    }

    private BListView getListSingers() {
        if (this.listSingers == null) {
            this.listSingers = new BListView();
        }
        return this.listSingers;
    }

    private BButton getBtnAdd() {
        if (this.btnAdd == null) {
            this.btnAdd = new BButton();
            this.btnAdd.setText("Add");
            this.btnAdd.setPreferredSize(new Dimension(85, 23));
        }
        return this.btnAdd;
    }

    private BButton getBtnRemove() {
        if (this.btnRemove == null) {
            this.btnRemove = new BButton();
            this.btnRemove.setText("Remove");
            this.btnRemove.setPreferredSize(new Dimension(85, 23));
        }
        return this.btnRemove;
    }

    private BButton getBtnUp() {
        if (this.btnUp == null) {
            this.btnUp = new BButton();
            this.btnUp.setText("Up");
            this.btnUp.setPreferredSize(new Dimension(75, 23));
        }
        return this.btnUp;
    }

    private BButton getBtnDown() {
        if (this.btnDown == null) {
            this.btnDown = new BButton();
            this.btnDown.setText("Down");
            this.btnDown.setPreferredSize(new Dimension(75, 23));
        }
        return this.btnDown;
    }

    private BPanel getJPanel17() {
        if (this.jPanel17 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 0;
            this.jPanel17 = new BPanel();
            this.jPanel17.setLayout(new GridBagLayout());
            this.jPanel17.add((Component)this.getBtnAdd(), gridBagConstraints2);
            this.jPanel17.add((Component)this.getBtnRemove(), gridBagConstraints);
        }
        return this.jPanel17;
    }

    private BPanel getJPanel18() {
        if (this.jPanel18 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 13;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints2.gridx = 0;
            this.jPanel18 = new BPanel();
            this.jPanel18.setLayout(new GridBagLayout());
            this.jPanel18.add((Component)this.getBtnUp(), gridBagConstraints2);
            this.jPanel18.add((Component)this.getBtnDown(), gridBagConstraints);
        }
        return this.jPanel18;
    }

    private BPanel getTabFile() {
        if (this.tabFile == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridheight = 2;
            gridBagConstraints.gridy = 0;
            this.lblAutoBackupInterval = new BLabel();
            this.lblAutoBackupInterval.setText("interval");
            this.tabFile = new BPanel();
            this.tabFile.setLayout(new GridBagLayout());
            this.tabFile.add((Component)this.getJPanel20(), gridBagConstraints);
        }
        return this.tabFile;
    }

    private BCheckBox getChkAutoBackup() {
        if (this.chkAutoBackup == null) {
            this.chkAutoBackup = new BCheckBox();
            this.chkAutoBackup.setText("Automatical Backup");
        }
        return this.chkAutoBackup;
    }

    private BLabel getLblAutoBackupMinutes() {
        if (this.lblAutoBackupMinutes == null) {
            this.lblAutoBackupMinutes = new BLabel();
            this.lblAutoBackupMinutes.setText("minutes");
        }
        return this.lblAutoBackupMinutes;
    }

    private BPanel getJPanel20() {
        if (this.jPanel20 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(3, 6, 3, 12);
            gridBagConstraints2.gridx = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 0;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.gridx = 3;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.insets = new Insets(3, 6, 3, 6);
            gridBagConstraints4.gridx = 2;
            gridBagConstraints4.gridy = 0;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.fill = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridx = 1;
            gridBagConstraints5.gridy = 0;
            gridBagConstraints5.insets = new Insets(0, 24, 0, 0);
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.gridy = 0;
            gridBagConstraints6.insets = new Insets(3, 12, 3, 0);
            this.jPanel20 = new BPanel();
            this.jPanel20.setLayout(new GridBagLayout());
            this.jPanel20.add((Component)this.getChkAutoBackup(), gridBagConstraints6);
            this.jPanel20.add((Component)this.lblAutoBackupInterval, gridBagConstraints5);
            this.jPanel20.add((Component)this.getLblAutoBackupMinutes(), gridBagConstraints3);
            this.jPanel20.add((Component)this.getNumAutoBackupInterval(), gridBagConstraints2);
            this.jPanel20.add((Component)this.getChkKeepProjectCache(), gridBagConstraints);
        }
        return this.jPanel20;
    }

    private BPanel getPanelLower() {
        if (this.panelLower == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 12);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints2.gridy = 1;
            gridBagConstraints2.gridx = 0;
            this.panelLower = new BPanel();
            this.panelLower.setLayout(new GridBagLayout());
            this.panelLower.add((Component)this.getBtnOK(), gridBagConstraints2);
            this.panelLower.add((Component)this.getBtnCancel(), gridBagConstraints);
        }
        return this.panelLower;
    }

    private BButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }

    private BPanel getJPanel5() {
        if (this.jPanel5 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(12, 0, 12, 0);
            gridBagConstraints2.gridy = 1;
            this.jPanel5 = new BPanel();
            this.jPanel5.setLayout(new GridBagLayout());
            this.jPanel5.add((Component)this.getPanelUpper(), gridBagConstraints);
            this.jPanel5.add((Component)this.getPanelLower(), gridBagConstraints2);
        }
        return this.jPanel5;
    }

    private BPanel getPanelUpper() {
        if (this.panelUpper == null) {
            this.panelUpper = new BPanel();
            this.panelUpper.setLayout(new GridBagLayout());
        }
        return this.panelUpper;
    }

    private BNumericUpDown getNumAutoBackupInterval() {
        if (this.numAutoBackupInterval == null) {
            this.numAutoBackupInterval = new BNumericUpDown();
            this.numAutoBackupInterval.setPreferredSize(new Dimension(69, 20));
        }
        return this.numAutoBackupInterval;
    }

    private JCheckBox getChkChasePastEvent() {
        if (this.chkChasePastEvent == null) {
            this.chkChasePastEvent = new JCheckBox();
            this.chkChasePastEvent.setText("Chase Event");
        }
        return this.chkChasePastEvent;
    }

    private BTextBox getTxtAquesTone() {
        if (this.txtAquesTone == null) {
            this.txtAquesTone = new BTextBox();
        }
        return this.txtAquesTone;
    }

    private BButton getBtnAquesTone() {
        if (this.btnAquesTone == null) {
            this.btnAquesTone = new BButton();
            this.btnAquesTone.setPreferredSize(new Dimension(41, 23));
            this.btnAquesTone.setText("...");
        }
        return this.btnAquesTone;
    }

    private BNumericUpDown getNumBuffer() {
        if (this.numBuffer == null) {
            this.numBuffer = new BNumericUpDown();
            this.numBuffer.setPreferredSize(new Dimension(68, 20));
            this.numBuffer.setMinimum(100.0f);
            this.numBuffer.setDecimalPlaces(0);
            this.numBuffer.setMaximum(1000.0f);
        }
        return this.numBuffer;
    }

    private BGroupBox getGroupWaveFileOutput() {
        if (this.groupWaveFileOutput == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridy = 0;
            this.lblChannel = new BLabel();
            this.lblChannel.setText("Channel");
            this.groupWaveFileOutput = new BGroupBox();
            this.groupWaveFileOutput.setLayout(new GridBagLayout());
            this.groupWaveFileOutput.setTitle("Wave File Output");
            this.groupWaveFileOutput.add((Component)this.getJPanel2(), gridBagConstraints2);
            this.groupWaveFileOutput.add((Component)this.getJPanel22(), gridBagConstraints);
        }
        return this.groupWaveFileOutput;
    }

    private BComboBox getComboChannel() {
        if (this.comboChannel == null) {
            this.comboChannel = new BComboBox();
            this.comboChannel.setPreferredSize(new Dimension(97, 20));
        }
        return this.comboChannel;
    }

    private BRadioButton getJRadioButton() {
        if (this.radioMasterTrack == null) {
            this.radioMasterTrack = new BRadioButton();
            this.radioMasterTrack.setText("Master Track");
        }
        return this.radioMasterTrack;
    }

    private BRadioButton getRadioCurrentTrack() {
        if (this.radioCurrentTrack == null) {
            this.radioCurrentTrack = new BRadioButton();
            this.radioCurrentTrack.setText("Current");
        }
        return this.radioCurrentTrack;
    }

    private JPanel getJPanel2() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(3, 12, 3, 0);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 0);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.lblChannel, gridBagConstraints2);
            this.jPanel.add((Component)this.getComboChannel(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private JPanel getJPanel22() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(3, 12, 3, 0);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 0);
            this.jPanel2 = new JPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.getJRadioButton(), gridBagConstraints2);
            this.jPanel2.add((Component)this.getRadioCurrentTrack(), gridBagConstraints);
        }
        return this.jPanel2;
    }

    private BComboBox getComboMtcMidiInPortNumber() {
        if (this.comboMtcMidiInPortNumber == null) {
            this.comboMtcMidiInPortNumber = new BComboBox();
            this.comboMtcMidiInPortNumber.setPreferredSize(new Dimension(239, 20));
        }
        return this.comboMtcMidiInPortNumber;
    }

    private BPanel getTabSingingSynth() {
        if (this.tabSingingSynth == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.insets = new Insets(3, 12, 3, 12);
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.fill = 2;
            this.tabSingingSynth = new BPanel();
            this.tabSingingSynth.setLayout(new GridBagLayout());
            this.tabSingingSynth.setSize(new Dimension(422, 268));
            this.tabSingingSynth.add((Component)this.getGroupVsti(), gridBagConstraints2);
            this.tabSingingSynth.add((Component)this.getGroupSynthesizerDll(), gridBagConstraints);
        }
        return this.tabSingingSynth;
    }

    private BGroupBox getGroupSynthesizerDll() {
        if (this.groupSynthesizerDll == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridy = 4;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 64, 0, 0);
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridy = 3;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 64, 0, 0);
            gridBagConstraints2.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 64, 0, 0);
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(0, 64, 0, 0);
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints5.gridy = 0;
            this.groupSynthesizerDll = new BGroupBox();
            this.groupSynthesizerDll.setLayout(new GridBagLayout());
            this.groupSynthesizerDll.setBorder(BorderFactory.createTitledBorder(null, "Synthesizer DLL Usage", 0, 0, new Font("Dialog", 1, 12), new Color(51, 51, 51)));
            this.groupSynthesizerDll.setTitle("Synthesizer DLL Usage");
            this.groupSynthesizerDll.add((Component)this.getChkLoadSecondaryVOCALOID1(), gridBagConstraints5);
            this.groupSynthesizerDll.add((Component)this.getChkLoadVocaloid100(), gridBagConstraints4);
            this.groupSynthesizerDll.add((Component)this.getChkLoadVocaloid101(), gridBagConstraints3);
            this.groupSynthesizerDll.add((Component)this.getChkLoadVocaloid2(), gridBagConstraints2);
            this.groupSynthesizerDll.add((Component)this.getChkLoadAquesTone(), gridBagConstraints);
        }
        return this.groupSynthesizerDll;
    }

    private BCheckBox getChkLoadSecondaryVOCALOID1() {
        if (this.chkLoadSecondaryVOCALOID1 == null) {
            this.chkLoadSecondaryVOCALOID1 = new BCheckBox();
            this.chkLoadSecondaryVOCALOID1.setText("Load secondary VOCALOID1 VSTi DLL");
        }
        return this.chkLoadSecondaryVOCALOID1;
    }

    private BCheckBox getChkLoadVocaloid100() {
        if (this.chkLoadVocaloid100 == null) {
            this.chkLoadVocaloid100 = new BCheckBox();
            this.chkLoadVocaloid100.setText("VOCALOID1 [1.0]");
        }
        return this.chkLoadVocaloid100;
    }

    private BCheckBox getChkLoadVocaloid101() {
        if (this.chkLoadVocaloid101 == null) {
            this.chkLoadVocaloid101 = new BCheckBox();
            this.chkLoadVocaloid101.setText("VOCALOID1 [1.1]");
        }
        return this.chkLoadVocaloid101;
    }

    private BCheckBox getChkLoadVocaloid2() {
        if (this.chkLoadVocaloid2 == null) {
            this.chkLoadVocaloid2 = new BCheckBox();
            this.chkLoadVocaloid2.setText("VOCALOID2");
        }
        return this.chkLoadVocaloid2;
    }

    private BCheckBox getChkLoadAquesTone() {
        if (this.chkLoadAquesTone == null) {
            this.chkLoadAquesTone = new BCheckBox();
            this.chkLoadAquesTone.setText("AquesTone");
        }
        return this.chkLoadAquesTone;
    }

    private BCheckBox getChkKeepProjectCache() {
        if (this.chkKeepProjectCache == null) {
            this.chkKeepProjectCache = new BCheckBox();
            this.chkKeepProjectCache.setText("Keep Project Cache");
        }
        return this.chkKeepProjectCache;
    }
}

