/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Arrays;
import org.kbinani.PortUtil;
import org.kbinani.apputil.PolylineDrawer;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.UtauFreq;
import org.kbinani.media.Wave;
import org.kbinani.media.WaveRateConverter;
import org.kbinani.media.WaveReader;
import org.kbinani.vsq.TempoTableEntry;
import org.kbinani.vsq.TempoVector;

public class WaveDrawContext {
    private byte[] m_wave;
    private int m_sample_rate = 44100;
    private String m_name;
    public UtauFreq Freq;
    private float m_length;
    private PolylineDrawer drawer = null;

    public WaveDrawContext(String string) {
        this.load(string);
        this.drawer = new PolylineDrawer(null, 1024);
    }

    public WaveDrawContext() {
        this.m_wave = new byte[0];
        this.m_length = 0.0f;
        this.drawer = new PolylineDrawer(null, 1024);
    }

    public void unload() {
        this.drawer.clear();
        this.m_wave = new byte[0];
        this.m_length = 0.0f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadPartial(String string, double d, double d2) {
        if (!PortUtil.isFileExists(string)) {
            return;
        }
        WaveRateConverter waveRateConverter = null;
        try {
            int n;
            waveRateConverter = new WaveRateConverter(new WaveReader(string), this.m_sample_rate);
            int n2 = (int)(d * (double)this.m_sample_rate);
            int n3 = (int)(d2 * (double)this.m_sample_rate);
            int n4 = this.m_wave.length;
            if (n4 < n3) {
                this.m_wave = Arrays.copyOf(this.m_wave, n3);
                n2 = n4;
            }
            int n5 = 1024;
            double[] dArray = new double[n5];
            double[] dArray2 = new double[n5];
            int n6 = n2;
            for (int i = n3 - n2; i > 0; i -= n) {
                n = i > n5 ? n5 : i;
                waveRateConverter.read(n6, n, dArray, dArray2);
                for (int j = 0; j < n; ++j) {
                    byte by;
                    double d3 = (dArray[j] + dArray2[j]) * 0.5;
                    this.m_wave[n6 + j] = by = (byte)((d3 + 1.0) * 0.5 * 127.0);
                }
                n6 += n;
            }
            dArray = null;
            dArray2 = null;
        }
        catch (Exception exception) {
            PortUtil.stderr.println("WaveDrawContext#reloadPartial; ex=" + exception);
        }
        finally {
            if (waveRateConverter != null) {
                try {
                    waveRateConverter.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("WaveDrawContext#reloadPartial; ex2=" + exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(String string) {
        if (!PortUtil.isFileExists(string)) {
            this.m_wave = new byte[0];
            this.m_length = 0.0f;
            return;
        }
        Wave wave = null;
        try {
            wave = new Wave(string);
            this.m_wave = new byte[(int)wave.getTotalSamples()];
            this.m_sample_rate = (int)wave.getSampleRate();
            this.m_length = (float)wave.getTotalSamples() / (float)wave.getSampleRate();
            int n = (int)wave.getTotalSamples();
            for (int i = 0; i < n; ++i) {
                double d = wave.getDouble(i);
                this.m_wave[i] = (byte)((d + 1.0) * 0.5 * 127.0);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (wave != null) {
                try {
                    wave.dispose();
                }
                catch (Exception exception) {}
            }
        }
        if (this.m_wave == null) {
            this.m_wave = new byte[0];
            this.m_sample_rate = 44100;
            this.m_length = 0.0f;
        }
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String string) {
        this.m_name = string;
    }

    public float getLength() {
        return this.m_length;
    }

    public void dispose() {
        this.m_wave = null;
        System.gc();
    }

    public void draw(Graphics2D graphics2D, Color color, Rectangle rectangle, int n, int n2, TempoVector tempoVector, float f) {
        int n3;
        int n4;
        if (this.m_wave.length == 0) {
            return;
        }
        this.drawer.setGraphics(graphics2D);
        this.drawer.clear();
        double d = tempoVector.getSecFromClock(n);
        double d2 = tempoVector.getSecFromClock(n2);
        int n5 = (int)(d * (double)this.m_sample_rate) - 1;
        int n6 = (int)(d2 * (double)this.m_sample_rate) + 1;
        int n7 = tempoVector.size();
        int n8 = 0;
        double d3 = 0.0;
        float f2 = (float)rectangle.height / 127.0f;
        int n9 = rectangle.x;
        int n10 = rectangle.y + rectangle.height;
        byte by = this.m_wave[0];
        int n11 = n9;
        int n12 = n4 = (n3 = n10 - (int)((float)by * f2));
        int n13 = n4;
        boolean bl = false;
        this.drawer.append(n9, n12);
        int n14 = rectangle.x + rectangle.width;
        int n15 = 500000;
        for (int i = 0; i <= n7; ++i) {
            int n16;
            int n17;
            int n18;
            double d4 = 0.0;
            int n19 = 500000;
            int n20 = 0;
            if (i < n7) {
                TempoTableEntry tempoTableEntry = (TempoTableEntry)tempoVector.get(i);
                d4 = tempoTableEntry.Time;
                n19 = tempoTableEntry.Tempo;
                n20 = tempoTableEntry.Clock;
            } else {
                d4 = tempoVector.getSecFromClock(n2);
                n19 = ((TempoTableEntry)tempoVector.get((int)(i - 1))).Tempo;
                n20 = n2;
            }
            int n21 = (int)(d4 * (double)this.m_sample_rate);
            if (n21 < n5) {
                n8 = n21;
                d3 = n20;
                n15 = n19;
                continue;
            }
            if (n6 < n8) break;
            int n22 = (int)(d3 * (double)f) - AppManager.startToDrawX + 6;
            double d5 = (double)n15 * 1.0E-6 / 480.0;
            n15 = n19;
            double d6 = 1.0 / (double)this.m_sample_rate / d5 * (double)f;
            int n23 = n8;
            if (n23 < 0) {
                n23 = 0;
            }
            if (this.m_wave.length < (n18 = n21)) {
                n18 = this.m_wave.length;
            }
            if ((n17 = n22 + (int)((double)(n23 - n8) * d6)) < rectangle.x) {
                n23 = (int)((double)(rectangle.x - n22) / d6) + n8;
            }
            if (rectangle.x + rectangle.width < (n16 = n22 + (int)((double)(n18 - n8) * d6))) {
                n18 = (int)((double)(rectangle.x + rectangle.width - n22) / d6) + n8;
            }
            boolean bl2 = false;
            for (int j = n23; j < n18; ++j) {
                byte by2 = this.m_wave[j];
                if (by2 == by) {
                    bl = true;
                    continue;
                }
                int n24 = n22 + (int)((double)(j - n8) * d6);
                if (n14 < n24) {
                    bl2 = true;
                    break;
                }
                if (n24 < rectangle.x) continue;
                int n25 = n10 - (int)((float)by2 * f2);
                if (n11 == n24) {
                    n3 = Math.max(n3, n25);
                    n4 = Math.min(n4, n25);
                    continue;
                }
                if (bl) {
                    this.drawer.append(n24 - 1, n12);
                    n11 = n24 - 1;
                }
                if (n3 == n4) {
                    this.drawer.append(n24, n25);
                } else {
                    if (n13 != n4) {
                        this.drawer.append(n11, n4);
                    }
                    this.drawer.append(n11, n3);
                    if (n3 != n12) {
                        this.drawer.append(n11, n12);
                    }
                    this.drawer.append(n24, n25);
                }
                n13 = n12;
                n11 = n24;
                n4 = n25;
                n3 = n25;
                n12 = n25;
                by = by2;
                bl = false;
            }
            n8 = n21;
            d3 = n20;
            if (bl2) break;
        }
        this.drawer.append(rectangle.x + rectangle.width, n12);
        this.drawer.flush();
    }

    public void draw(Graphics2D graphics2D, Color color, Rectangle rectangle, float f, float f2) {
        int n = (int)(f * (float)this.m_sample_rate) - 1;
        int n2 = (int)(f2 * (float)this.m_sample_rate) + 1;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = rectangle.x;
        int n6 = rectangle.y + n4;
        float f3 = (float)rectangle.height / 127.0f;
        float f4 = (float)rectangle.width / (f2 - f) / (float)this.m_sample_rate;
        int n7 = n;
        if (n7 < 0) {
            n7 = 0;
        }
        if (this.m_wave.length < n2) {
            n2 = this.m_wave.length - 1;
        }
        byte by = 0;
        if (this.m_wave == null || this.m_wave != null && this.m_wave.length <= 0) {
            return;
        }
        by = this.m_wave[0];
        int n8 = n5;
        int n9 = n6 - (int)((float)by * f3);
        boolean bl = false;
        graphics2D.setColor(color);
        for (int i = n7 + 1; i <= n2; ++i) {
            byte by2 = this.m_wave[i];
            if (by2 == by) continue;
            bl = true;
            int n10 = n5 + (int)((float)(i - n) * f4);
            int n11 = n6 - (int)((float)by2 * f3);
            graphics2D.drawLine(n8, n9, n10, n9);
            graphics2D.drawLine(n10, n9, n10, n11);
            n8 = n10;
            n9 = n11;
            by = by2;
        }
        if (!bl) {
            graphics2D.drawLine(rectangle.x, n9, rectangle.x + rectangle.width, n9);
        }
    }
}

