/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.media;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.kbinani.PortUtil;

public class Wave {
    private WaveChannel m_channel;
    private int m_bit_per_sample;
    private long m_sample_rate;
    private long m_total_samples;
    private byte[] L8;
    private byte[] R8;
    private short[] L16;
    private short[] R16;

    public void getNormalizedWave(int n, double[] dArray) {
        int n2;
        int n3 = dArray.length;
        int n4 = n;
        int n5 = n + n3;
        if (n < 0) {
            for (n2 = 0; n2 < n4 - n; ++n2) {
                dArray[n2] = 0.0;
            }
            n4 = 0;
        }
        if (this.m_total_samples <= (long)n5) {
            for (n2 = n5 - n; n2 < n3; ++n2) {
                dArray[n2] = 0.0;
            }
            n5 = (int)this.m_total_samples - 1;
        }
        if (this.m_channel == WaveChannel.Monoral) {
            if (this.m_bit_per_sample == 8) {
                for (n2 = n4; n2 < n5; ++n2) {
                    dArray[n2 - n] = ((double)this.L8[n2] - 64.0) / 64.0;
                }
            } else {
                for (n2 = n4; n2 < n5; ++n2) {
                    dArray[n2 - n] = (double)this.L16[n2] / 32768.0;
                }
            }
        } else if (this.m_bit_per_sample == 8) {
            for (n2 = n4; n2 < n5; ++n2) {
                dArray[n2 - n] = ((double)(this.L8[n2] + this.R8[n2]) * 0.5 - 64.0) / 64.0;
            }
        } else {
            for (n2 = n4; n2 < n5; ++n2) {
                dArray[n2 - n] = (double)(this.L16[n2] + this.R16[n2]) * 0.5 / 32768.0;
            }
        }
    }

    public double[] getNormalizedWave() {
        return this.getNormalizedWave(0, this.m_total_samples);
    }

    public double[] getNormalizedWave(int n, long l) {
        double[] dArray = new double[(int)l];
        this.getNormalizedWave(n, dArray);
        return dArray;
    }

    private void set(int n, Channel channel, int n2) {
        if (this.m_channel == WaveChannel.Monoral || channel == Channel.Left) {
            if (this.m_bit_per_sample == 8) {
                this.L8[n] = (byte)n2;
            } else {
                this.L16[n] = (short)n2;
            }
        } else if (this.m_bit_per_sample == 8) {
            this.R8[n] = (byte)n2;
        } else {
            this.R16[n] = (short)n2;
        }
    }

    private int get(int n, Channel channel) {
        if (this.m_channel == WaveChannel.Monoral || channel == Channel.Left) {
            if (this.m_bit_per_sample == 8) {
                return this.L8[n];
            }
            return this.L16[n];
        }
        if (this.m_bit_per_sample == 8) {
            return this.R8[n];
        }
        return this.R16[n];
    }

    private void set(int n, int n2) {
        this.set(n, Channel.Left, n2);
        if (this.m_channel == WaveChannel.Stereo) {
            this.set(n, Channel.Right, n2);
        }
    }

    public double getDouble(int n) {
        if (this.m_channel == WaveChannel.Monoral) {
            if (this.m_bit_per_sample == 8) {
                return ((double)this.L8[n] - 64.0) / 64.0;
            }
            return (double)this.L16[n] / 32768.0;
        }
        if (this.m_bit_per_sample == 8) {
            return ((double)(this.L8[n] + this.R8[n]) * 0.5 - 64.0) / 64.0;
        }
        return (double)(this.L16[n] + this.R16[n]) * 0.5 / 32768.0;
    }

    public long getSampleRate() {
        return this.m_sample_rate;
    }

    private void setTotalSamples(long l) {
        this.m_total_samples = l;
        if (this.m_channel == WaveChannel.Monoral) {
            if (this.m_bit_per_sample == 8) {
                this.L8 = this.L8 == null ? new byte[(int)this.m_total_samples] : Wave.resizeArray(this.L8, (int)this.m_total_samples);
            } else {
                this.L16 = this.L16 == null ? new short[(int)this.m_total_samples] : Wave.resizeArray(this.L16, (int)this.m_total_samples);
            }
        } else if (this.m_bit_per_sample == 8) {
            if (this.L8 == null) {
                this.L8 = new byte[(int)this.m_total_samples];
                this.R8 = new byte[(int)this.m_total_samples];
            } else {
                this.L8 = Wave.resizeArray(this.L8, (int)this.m_total_samples);
                this.R8 = Wave.resizeArray(this.R8, (int)this.m_total_samples);
            }
        } else if (this.L16 == null) {
            this.L16 = new short[(int)this.m_total_samples];
            this.R16 = new short[(int)this.m_total_samples];
        } else {
            this.L16 = Wave.resizeArray(this.L16, (int)this.m_total_samples);
            this.R16 = Wave.resizeArray(this.R16, (int)this.m_total_samples);
        }
    }

    public long getTotalSamples() {
        return this.m_total_samples;
    }

    public void replace(Wave wave, int n, int n2, int n3) {
        if (this.m_channel != wave.m_channel || this.m_bit_per_sample != wave.m_bit_per_sample) {
            return;
        }
        if (this.m_channel == WaveChannel.Monoral ? (this.m_bit_per_sample == 8 ? this.L8 == null || wave.L8 == null : this.L16 == null || wave.L16 == null) : (this.m_bit_per_sample == 8 ? this.L8 == null || this.R8 == null || wave.L8 == null || wave.R8 == null : this.L16 == null || this.R16 == null || wave.L16 == null || wave.R16 == null)) {
            return;
        }
        long l = n2 + (n3 = (int)((long)n3 > wave.getTotalSamples() - (long)n ? wave.getTotalSamples() - (long)n : (long)n3));
        if (this.m_total_samples < l) {
            if (this.m_channel == WaveChannel.Monoral) {
                if (this.m_bit_per_sample == 8) {
                    this.L8 = Wave.resizeArray(this.L8, (int)l);
                } else {
                    this.L16 = Wave.resizeArray(this.L16, (int)l);
                }
            } else if (this.m_bit_per_sample == 8) {
                this.L8 = Wave.resizeArray(this.L8, (int)l);
                this.R8 = Wave.resizeArray(this.R8, (int)l);
            } else {
                this.L16 = Wave.resizeArray(this.L16, (int)l);
                this.R16 = Wave.resizeArray(this.R16, (int)l);
            }
            this.m_total_samples = l;
        }
        if (this.m_channel == WaveChannel.Monoral) {
            if (this.m_bit_per_sample == 8) {
                Wave.copyArray(wave.L8, n, this.L8, n2, n3);
            } else {
                Wave.copyArray(wave.L16, n, this.L16, n2, n3);
            }
        } else if (this.m_bit_per_sample == 8) {
            Wave.copyArray(wave.L8, n, this.L8, n2, n3);
            Wave.copyArray(wave.R8, n, this.R8, n2, n3);
        } else {
            Wave.copyArray(wave.L16, n, this.L16, n2, n3);
            Wave.copyArray(wave.R16, n, this.R16, n2, n3);
        }
    }

    public void replace(byte[] byArray, int n) {
        if (this.m_channel != WaveChannel.Monoral || this.m_bit_per_sample != 8 || this.L8 == null) {
            return;
        }
        long l = n + byArray.length;
        if (this.m_total_samples < l) {
            this.L8 = Wave.resizeArray(this.L8, (int)l);
            this.m_total_samples = l;
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.L8[i + n] = byArray[i];
        }
    }

    public void replace(short[] sArray, int n) {
        if (this.m_channel != WaveChannel.Monoral || this.m_bit_per_sample != 16 || this.L16 == null) {
            return;
        }
        long l = n + sArray.length;
        if (this.m_total_samples < l) {
            this.L16 = Wave.resizeArray(this.L16, (int)l);
            this.m_total_samples = l;
        }
        for (int i = 0; i < sArray.length; ++i) {
            this.L16[i + n] = sArray[i];
        }
    }

    public void replace(byte[] byArray, byte[] byArray2, int n) {
        if (this.m_channel != WaveChannel.Stereo || this.m_bit_per_sample != 8 || this.L8 == null || this.R8 == null) {
            return;
        }
        long l = n + byArray.length;
        if (this.m_total_samples < l) {
            this.L8 = Wave.resizeArray(this.L8, (int)l);
            this.R8 = Wave.resizeArray(this.R8, (int)l);
            this.m_total_samples = l;
        }
        for (int i = 0; i < byArray.length; ++i) {
            this.L8[i + n] = byArray[i];
            this.R8[i + n] = byArray2[i];
        }
    }

    public void replace(short[] sArray, short[] sArray2, int n) {
        if (this.m_channel != WaveChannel.Stereo || this.m_bit_per_sample != 16 || this.L16 == null || this.R16 == null) {
            return;
        }
        long l = n + sArray.length;
        if (this.m_total_samples < l) {
            this.L16 = Wave.resizeArray(this.L16, (int)l);
            this.R16 = Wave.resizeArray(this.R16, (int)l);
            this.m_total_samples = l;
        }
        for (int i = 0; i < sArray.length; ++i) {
            this.L16[i + n] = sArray[i];
            this.R16[i + n] = sArray2[i];
        }
    }

    public void replace(float[] fArray, float[] fArray2, int n) {
        long l = n + fArray.length;
        if (this.m_total_samples < l) {
            if (this.m_channel == WaveChannel.Monoral) {
                if (this.m_bit_per_sample == 8) {
                    if (this.L8 == null) {
                        return;
                    }
                    this.L8 = Wave.resizeArray(this.L8, (int)l);
                } else {
                    if (this.L16 == null) {
                        return;
                    }
                    this.L16 = Wave.resizeArray(this.L16, (int)l);
                }
            } else if (this.m_bit_per_sample == 8) {
                if (this.L8 == null || this.R8 == null) {
                    return;
                }
                this.L8 = Wave.resizeArray(this.L8, (int)l);
                this.R8 = Wave.resizeArray(this.R8, (int)l);
            } else {
                if (this.L16 == null || this.R16 == null) {
                    return;
                }
                this.L16 = Wave.resizeArray(this.L16, (int)l);
                this.R16 = Wave.resizeArray(this.R16, (int)l);
            }
            this.m_total_samples = l;
        }
        if (this.m_channel == WaveChannel.Monoral) {
            int n2;
            float[] fArray3 = new float[fArray.length];
            for (n2 = 0; n2 < fArray.length; ++n2) {
                fArray3[n2] = (fArray[n2] + fArray2[n2]) / 2.0f;
            }
            if (this.m_bit_per_sample == 8) {
                for (n2 = 0; n2 < fArray3.length; ++n2) {
                    this.L8[n2 + n] = (byte)((fArray3[n2] + 1.0f) / 2.0f * 255.0f);
                }
            } else {
                for (n2 = 0; n2 < fArray3.length; ++n2) {
                    this.L16[n2 + n] = (short)(fArray3[n2] * 32768.0f);
                }
            }
        } else if (this.m_bit_per_sample == 8) {
            for (int i = 0; i < fArray.length; ++i) {
                this.L8[i + n] = (byte)((fArray[i] + 1.0f) / 2.0f * 255.0f);
                this.R8[i + n] = (byte)((fArray2[i] + 1.0f) / 2.0f * 255.0f);
            }
        } else {
            for (int i = 0; i < fArray.length; ++i) {
                this.L16[i + n] = (short)(fArray[i] * 32768.0f);
                this.R16[i + n] = (short)(fArray2[i] * 32768.0f);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printToText(String string) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            if (this.m_channel == WaveChannel.Monoral) {
                if (this.m_bit_per_sample == 8) {
                    int n = 0;
                    while ((long)n < this.m_total_samples) {
                        bufferedWriter.write(this.L8[n] + "");
                        bufferedWriter.newLine();
                        ++n;
                    }
                } else {
                    int n = 0;
                    while ((long)n < this.m_total_samples) {
                        bufferedWriter.write(this.L16[n] + "");
                        bufferedWriter.newLine();
                        ++n;
                    }
                }
            } else if (this.m_bit_per_sample == 8) {
                int n = 0;
                while ((long)n < this.m_total_samples) {
                    bufferedWriter.write(this.L8[n] + "\t" + this.R8[n]);
                    bufferedWriter.newLine();
                    ++n;
                }
            } else {
                int n = 0;
                while ((long)n < this.m_total_samples) {
                    bufferedWriter.write(this.L16[n] + "\t" + this.R16[n]);
                    bufferedWriter.newLine();
                    ++n;
                }
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void dispose() {
        this.L8 = null;
        this.R8 = null;
        this.L16 = null;
        this.R16 = null;
        System.gc();
    }

    public void convertTo8Bit() {
        double d;
        int n;
        if (this.m_bit_per_sample == 8) {
            return;
        }
        this.L8 = new byte[this.L16.length];
        for (n = 0; n < this.L16.length; ++n) {
            d = ((double)this.L16[n] + 32768.0) / 65535.0 * 255.0;
            this.L8[n] = (byte)d;
        }
        this.L16 = null;
        if (this.m_channel == WaveChannel.Stereo) {
            this.R8 = new byte[this.R16.length];
            for (n = 0; n < this.R16.length; ++n) {
                d = ((double)this.R16[n] + 32768.0) / 65535.0 * 255.0;
                this.R8[n] = (byte)d;
            }
            this.R16 = null;
        }
        this.m_bit_per_sample = 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "rw");
            randomAccessFile.write(82);
            randomAccessFile.write(73);
            randomAccessFile.write(70);
            randomAccessFile.write(70);
            randomAccessFile.write(0);
            randomAccessFile.write(0);
            randomAccessFile.write(0);
            randomAccessFile.write(0);
            randomAccessFile.write(87);
            randomAccessFile.write(65);
            randomAccessFile.write(86);
            randomAccessFile.write(69);
            randomAccessFile.write(102);
            randomAccessFile.write(109);
            randomAccessFile.write(116);
            randomAccessFile.write(32);
            randomAccessFile.write(18);
            randomAccessFile.write(0);
            randomAccessFile.write(0);
            randomAccessFile.write(0);
            randomAccessFile.write(1);
            randomAccessFile.write(0);
            if (this.m_channel == WaveChannel.Monoral) {
                randomAccessFile.write(1);
                randomAccessFile.write(0);
            } else {
                randomAccessFile.write(2);
                randomAccessFile.write(0);
            }
            byte[] byArray = PortUtil.getbytes_uint32_le(this.m_sample_rate);
            Wave.writeByteArray(randomAccessFile, byArray, 4);
            int n = this.m_channel == WaveChannel.Monoral ? 1 : 2;
            int n2 = this.m_bit_per_sample / 8 * n;
            long l = this.m_sample_rate * (long)n2;
            byArray = PortUtil.getbytes_uint32_le(l);
            Wave.writeByteArray(randomAccessFile, byArray, 4);
            byArray = PortUtil.getbytes_uint16_le(n2);
            Wave.writeByteArray(randomAccessFile, byArray, 2);
            byArray = PortUtil.getbytes_uint16_le(this.m_bit_per_sample);
            Wave.writeByteArray(randomAccessFile, byArray, 2);
            randomAccessFile.write(0);
            randomAccessFile.write(0);
            randomAccessFile.write(100);
            randomAccessFile.write(97);
            randomAccessFile.write(116);
            randomAccessFile.write(97);
            long l2 = (long)n2 * this.m_total_samples;
            byArray = PortUtil.getbytes_uint32_le(l2);
            Wave.writeByteArray(randomAccessFile, byArray, 4);
            int n3 = 0;
            while ((long)n3 < this.m_total_samples) {
                if (this.m_bit_per_sample == 8) {
                    randomAccessFile.write(this.L8[n3]);
                    if (this.m_channel == WaveChannel.Stereo) {
                        randomAccessFile.write(this.R8[n3]);
                    }
                } else {
                    byArray = PortUtil.getbytes_int16_le(this.L16[n3]);
                    Wave.writeByteArray(randomAccessFile, byArray, 2);
                    if (this.m_channel == WaveChannel.Stereo) {
                        byArray = PortUtil.getbytes_int16_le(this.R16[n3]);
                        Wave.writeByteArray(randomAccessFile, byArray, 2);
                    }
                }
                ++n3;
            }
            long l3 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(4L);
            byArray = PortUtil.getbytes_uint32_le(l3 - 8L);
            Wave.writeByteArray(randomAccessFile, byArray, 4);
        }
        catch (Exception exception) {
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static void writeByteArray(RandomAccessFile randomAccessFile, byte[] byArray, int n) throws IOException {
        randomAccessFile.write(byArray, 0, byArray.length > n ? n : byArray.length);
        if (byArray.length < n) {
            for (int i = 0; i < n - byArray.length; ++i) {
                randomAccessFile.write(0);
            }
        }
    }

    public void monoralize() {
        if (this.m_channel != WaveChannel.Stereo) {
            return;
        }
        if (this.m_bit_per_sample == 8) {
            for (int i = 0; i < this.L8.length; ++i) {
                this.L8[i] = (byte)((this.L8[i] + this.R8[i]) / 2);
            }
            this.R8 = null;
            this.m_channel = WaveChannel.Monoral;
        } else {
            for (int i = 0; i < this.L16.length; ++i) {
                this.L16[i] = (short)((this.L16[i] + this.R16[i]) / 2);
            }
            this.R16 = null;
            this.m_channel = WaveChannel.Monoral;
        }
    }

    public void trimSilence() {
        if (this.m_bit_per_sample == 8) {
            if (this.m_channel == WaveChannel.Monoral) {
                int n;
                int n2;
                int n3 = 1;
                for (n2 = 1; n2 < this.L8.length; ++n2) {
                    if (this.L8[n2] == 128) continue;
                    n3 = n2;
                    break;
                }
                n2 = this.L8.length - 1;
                for (n = this.L8.length - 1; n >= 0; --n) {
                    if (this.L8[n] == 128) continue;
                    n2 = n;
                    break;
                }
                n = n2 - n3 + 1;
                this.R8 = new byte[n];
                Wave.copyArray(this.L8, n3, this.R8, 0, n);
                this.L8 = null;
                this.L8 = new byte[n];
                Wave.copyArray(this.R8, 0, this.L8, 0, n);
                this.R8 = null;
            } else {
                int n;
                int n4;
                int n5 = 1;
                for (n4 = 1; n4 < this.L8.length; ++n4) {
                    if (this.L8[n4] == 128 && this.R8[n4] == 128) continue;
                    n5 = n4;
                    break;
                }
                n4 = this.L8.length - 1;
                for (n = this.L8.length - 1; n >= 0; --n) {
                    if (this.L8[n] == 128 && this.R8[n] == 128) continue;
                    n4 = n;
                    break;
                }
                n = n4 - n5 + 1;
                byte[] byArray = new byte[n];
                Wave.copyArray(this.L8, n5, byArray, 0, n);
                this.L8 = null;
                this.L8 = new byte[n];
                Wave.copyArray(byArray, 0, this.L8, 0, n);
                Wave.copyArray(this.R8, n5, byArray, 0, n);
                this.R8 = null;
                this.R8 = new byte[n];
                Wave.copyArray(byArray, 0, this.R8, 0, n);
                byArray = null;
            }
        } else if (this.m_channel == WaveChannel.Monoral) {
            int n;
            int n6;
            int n7 = 1;
            for (n6 = 1; n6 < this.L16.length; ++n6) {
                if (this.L16[n6] == 0) continue;
                n7 = n6;
                break;
            }
            n6 = this.L16.length - 1;
            for (n = this.L16.length - 1; n >= 0; --n) {
                if (this.L16[n] == 0) continue;
                n6 = n;
                break;
            }
            n = n6 - n7 + 1;
            this.R16 = new short[n];
            Wave.copyArray(this.L16, n7, this.R16, 0, n);
            this.L16 = Wave.resizeArray(this.L16, n);
            Wave.copyArray(this.R16, 0, this.L16, 0, n);
            this.R16 = null;
        } else {
            int n;
            int n8;
            int n9 = 1;
            for (n8 = 1; n8 < this.L16.length; ++n8) {
                if (this.L16[n8] == 0 && this.R16[n8] == 0) continue;
                n9 = n8;
                break;
            }
            n8 = this.L16.length - 1;
            for (n = this.L16.length - 1; n >= 0; --n) {
                if (this.L16[n] == 0 && this.R16[n] == 0) continue;
                n8 = n;
                break;
            }
            n = n8 - n9 + 1;
            short[] sArray = new short[n];
            Wave.copyArray(this.L16, n9, sArray, 0, n);
            this.L16 = Wave.resizeArray(this.L16, n);
            Wave.copyArray(sArray, 0, this.L16, 0, n);
            Wave.copyArray(this.R16, n9, sArray, 0, n);
            this.R16 = Wave.resizeArray(this.R16, n);
            Wave.copyArray(sArray, 0, this.R16, 0, n);
            sArray = null;
        }
        this.m_total_samples = this.m_bit_per_sample == 8 ? (long)this.L8.length : (long)this.L16.length;
    }

    public Wave() {
        this.m_channel = WaveChannel.Stereo;
        this.m_bit_per_sample = 16;
        this.m_sample_rate = 44100L;
    }

    public Wave(WaveChannel waveChannel, int n, int n2, int n3) {
        this.m_channel = waveChannel;
        this.m_bit_per_sample = n;
        this.m_sample_rate = n2;
        this.m_total_samples = n3;
        if (this.m_bit_per_sample == 8) {
            this.L8 = new byte[(int)this.m_total_samples];
            if (this.m_channel == WaveChannel.Stereo) {
                this.R8 = new byte[(int)this.m_total_samples];
            }
        } else if (this.m_bit_per_sample == 16) {
            this.L16 = new short[(int)this.m_total_samples];
            if (this.m_channel == WaveChannel.Stereo) {
                this.R16 = new short[(int)this.m_total_samples];
            }
        }
    }

    public void append(double[] dArray, double[] dArray2) {
        int n = Math.min(dArray.length, dArray2.length);
        int n2 = this.L16.length;
        if (this.m_bit_per_sample == 16 && this.m_channel == WaveChannel.Stereo) {
            this.L16 = Wave.resizeArray(this.L16, (int)(this.m_total_samples + (long)n));
            this.R16 = Wave.resizeArray(this.R16, (int)(this.m_total_samples + (long)n));
            this.m_total_samples += (long)n;
            int n3 = n2;
            while ((long)n3 < this.m_total_samples) {
                this.L16[n3] = (short)(dArray[n3 - n2] * 32768.0);
                this.R16[n3] = (short)(dArray2[n3 - n2] * 32768.0);
                ++n3;
            }
        }
    }

    public Wave(String string) {
        this.read(string);
    }

    private boolean parseAiffHeader(RandomAccessFile randomAccessFile) {
        try {
            byte[] byArray = new byte[4];
            randomAccessFile.read(byArray, 0, 4);
            long l = PortUtil.make_uint32_be(byArray);
            randomAccessFile.read(byArray, 0, 4);
            String string = new String(new char[]{(char)byArray[0], (char)byArray[1], (char)byArray[2], (char)byArray[3]});
            if (!string.equals("AIFF")) {
                return false;
            }
            randomAccessFile.read(byArray, 0, 4);
            string = new String(new char[]{(char)byArray[0], (char)byArray[1], (char)byArray[2], (char)byArray[3]});
            if (!string.equals("COMM")) {
                return false;
            }
            randomAccessFile.read(byArray, 0, 4);
            long l2 = PortUtil.make_uint32_be(byArray);
            long l3 = randomAccessFile.getFilePointer();
            randomAccessFile.read(byArray, 0, 2);
            int n = PortUtil.make_uint16_be(byArray);
            this.m_channel = n == 1 ? WaveChannel.Monoral : WaveChannel.Stereo;
            randomAccessFile.read(byArray, 0, 4);
            this.m_total_samples = PortUtil.make_uint32_be(byArray);
            randomAccessFile.read(byArray, 0, 2);
            this.m_bit_per_sample = PortUtil.make_uint16_be(byArray);
            byte[] byArray2 = new byte[10];
            randomAccessFile.read(byArray2, 0, 10);
            this.m_sample_rate = (long)Wave.make_double_from_extended(byArray2);
            randomAccessFile.seek(l3 + l2);
            randomAccessFile.read(byArray, 0, 4);
            string = new String(new char[]{(char)byArray[0], (char)byArray[1], (char)byArray[2], (char)byArray[3]});
            if (!string.equals("SSND")) {
                return false;
            }
            randomAccessFile.read(byArray, 0, 4);
            long l4 = PortUtil.make_uint32_be(byArray);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static double make_double_from_extended(byte[] byArray) {
        double d;
        int n = (byArray[0] & 0x7F) << 8 | byArray[1] & 0xFF;
        long l = (long)(byArray[2] & 0xFF) << 24 | (long)(byArray[3] & 0xFF) << 16 | (long)(byArray[4] & 0xFF) << 8 | (long)(byArray[5] & 0xFF);
        long l2 = (long)(byArray[6] & 0xFF) << 24 | (long)(byArray[7] & 0xFF) << 16 | (long)(byArray[8] & 0xFF) << 8 | (long)(byArray[9] & 0xFF);
        if (n == 0 && l == 0L && l2 == 0L) {
            d = 0.0;
        } else if (n == Short.MAX_VALUE) {
            d = Double.MAX_VALUE;
        } else {
            d = Math.pow(2.0, (n -= 16383) - 31) * Wave.double_from_uint(l);
            d += Math.pow(2.0, n - 32) * Wave.double_from_uint(l2);
        }
        if ((byArray[0] & 0x80) != 0) {
            return -d;
        }
        return d;
    }

    private static double double_from_uint(long l) {
        return (double)((int)(l - Integer.MAX_VALUE - 1L)) + 2.147483648E9;
    }

    private boolean parseWaveHeader(RandomAccessFile randomAccessFile) {
        try {
            long l;
            byte[] byArray = new byte[4];
            randomAccessFile.read(byArray, 0, 4);
            long l2 = PortUtil.make_uint32_le(byArray);
            randomAccessFile.seek(8L);
            randomAccessFile.read(byArray, 0, 4);
            if (byArray[0] != 87 || byArray[1] != 65 || byArray[2] != 86 || byArray[3] != 69) {
                randomAccessFile.close();
                return false;
            }
            randomAccessFile.read(byArray, 0, 4);
            if (byArray[0] != 102 || byArray[1] != 109 || byArray[2] != 116 || byArray[3] != 32) {
                randomAccessFile.close();
                return false;
            }
            randomAccessFile.read(byArray, 0, 4);
            long l3 = PortUtil.make_uint32_le(byArray);
            randomAccessFile.read(byArray, 0, 2);
            int n = PortUtil.make_uint16_le(byArray);
            if (n != 1) {
                randomAccessFile.close();
                return false;
            }
            randomAccessFile.read(byArray, 0, 2);
            int n2 = PortUtil.make_uint16_le(byArray);
            if (n2 == 1) {
                this.m_channel = WaveChannel.Monoral;
            } else if (n2 == 2) {
                this.m_channel = WaveChannel.Stereo;
            } else {
                randomAccessFile.close();
                return false;
            }
            randomAccessFile.read(byArray, 0, 4);
            this.m_sample_rate = PortUtil.make_uint32_le(byArray);
            randomAccessFile.seek(34L);
            randomAccessFile.read(byArray, 0, 2);
            this.m_bit_per_sample = PortUtil.make_uint16_le(byArray);
            if (this.m_bit_per_sample != 8 && this.m_bit_per_sample != 16) {
                randomAccessFile.close();
                return false;
            }
            randomAccessFile.seek(20L + l3);
            randomAccessFile.read(byArray, 0, 4);
            String string = new String(new char[]{(char)byArray[0], (char)byArray[1], (char)byArray[2], (char)byArray[3]});
            while (string != "data") {
                randomAccessFile.read(byArray, 0, 4);
                l = PortUtil.make_uint32_le(byArray);
                randomAccessFile.seek(randomAccessFile.getFilePointer() + l);
                randomAccessFile.read(byArray, 0, 4);
                string = new String(new char[]{(char)byArray[0], (char)byArray[1], (char)byArray[2], (char)byArray[3]});
            }
            randomAccessFile.read(byArray, 0, 4);
            l = PortUtil.make_uint32_le(byArray);
            this.m_total_samples = l / (long)(n2 * this.m_bit_per_sample / 8);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean read(String string) {
        RandomAccessFile randomAccessFile = null;
        boolean bl = false;
        try {
            randomAccessFile = new RandomAccessFile(string, "r");
            byte[] byArray = new byte[4];
            randomAccessFile.read(byArray, 0, 4);
            boolean bl2 = false;
            if (byArray[0] == 82 && byArray[1] == 73 && byArray[2] == 70 && byArray[3] == 70) {
                bl = this.parseWaveHeader(randomAccessFile);
            } else if (byArray[0] == 70 && byArray[1] == 79 && byArray[2] == 82 && byArray[3] == 77) {
                bl = this.parseAiffHeader(randomAccessFile);
                bl2 = true;
            } else {
                bl = false;
            }
            if (this.m_bit_per_sample == 8) {
                this.L8 = new byte[(int)this.m_total_samples];
                if (this.m_channel == WaveChannel.Stereo) {
                    this.R8 = new byte[(int)this.m_total_samples];
                }
            } else {
                this.L16 = new short[(int)this.m_total_samples];
                if (this.m_channel == WaveChannel.Stereo) {
                    this.R16 = new short[(int)this.m_total_samples];
                }
            }
            byte[] byArray2 = new byte[2];
            int n = 0;
            while ((long)n < this.m_total_samples) {
                if (this.m_bit_per_sample == 8) {
                    randomAccessFile.read(byArray, 0, 1);
                    this.L8[n] = byArray[0];
                    if (this.m_channel == WaveChannel.Stereo) {
                        randomAccessFile.read(byArray, 0, 1);
                        this.R8[n] = byArray[0];
                    }
                } else {
                    byte by;
                    randomAccessFile.read(byArray2, 0, 2);
                    if (bl2) {
                        by = byArray2[0];
                        byArray2[0] = byArray2[1];
                        byArray2[1] = by;
                    }
                    this.L16[n] = PortUtil.make_int16_le(byArray2);
                    if (this.m_channel == WaveChannel.Stereo) {
                        randomAccessFile.read(byArray2, 0, 2);
                        if (bl2) {
                            by = byArray2[0];
                            byArray2[0] = byArray2[1];
                            byArray2[1] = by;
                        }
                        this.R16[n] = PortUtil.make_int16_le(byArray2);
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    private static short[] resizeArray(short[] sArray, int n) {
        short[] sArray2 = new short[n];
        if (sArray.length <= n) {
            for (int i = 0; i < sArray.length; ++i) {
                sArray2[i] = sArray[i];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                sArray2[i] = sArray[i];
            }
        }
        return sArray2;
    }

    private static byte[] resizeArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        if (byArray.length <= n) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray2[i] = byArray[i];
            }
        } else {
            for (int i = 0; i < n; ++i) {
                byArray2[i] = byArray[i];
            }
        }
        return byArray2;
    }

    private static void copyArray(short[] sArray, int n, short[] sArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            sArray2[i + n2] = sArray[i + n];
        }
    }

    private static void copyArray(byte[] byArray, int n, byte[] byArray2, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            byArray2[i + n2] = byArray[i + n];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum WaveChannel {
        Monoral,
        Stereo;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Channel {
        Right,
        Left;

    }
}

