/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.media;

import java.io.IOException;
import org.kbinani.math;
import org.kbinani.media.WaveReader;

public class WaveRateConverter {
    private WaveReader reader = null;
    private int aRate;
    private int bUnit = 1;
    private int aUnit = 1;
    private int bRate;
    private long aTotalSamples;
    private double[] bufLeft;
    private double[] bufRight;
    private int bBuflen;
    static final int MAX_BUFLEN = 1024;

    public WaveRateConverter(WaveReader waveReader, int n) {
        this.reader = waveReader;
        this.aRate = n;
        this.bRate = this.reader.getSampleRate();
        int n2 = (int)math.gcd(this.aRate, this.bRate);
        this.bUnit = this.bRate / n2;
        this.aUnit = this.aRate / n2;
        this.aTotalSamples = (long)((double)this.aRate * (double)this.reader.getTotalSamples() / (double)this.bRate);
        int n3 = 1024 / this.bUnit;
        if (n3 <= 0) {
            n3 = 1;
        }
        this.bBuflen = n3 * this.bUnit;
        this.bufLeft = new double[this.bBuflen];
        this.bufRight = new double[this.bBuflen];
    }

    public String getFilePath() {
        return this.reader.getFilePath();
    }

    public Object getTag() {
        if (this.reader == null) {
            return null;
        }
        return this.reader.getTag();
    }

    public void setTag(Object object) {
        if (this.reader != null) {
            this.reader.setTag(object);
        }
    }

    public long getTotalSamples() {
        return this.aTotalSamples;
    }

    public void read(long l, int n, double[] dArray, double[] dArray2) throws IOException {
        if (this.bRate == this.aRate) {
            this.reader.read(l, n, dArray, dArray2);
        } else {
            double d = (double)l / (double)this.aRate;
            double d2 = (double)(l + (long)n) / (double)this.aRate;
            int n2 = 0;
            block0: while (n2 < n) {
                int n3;
                int n4;
                int n5 = (int)((double)this.bRate * (double)(l + (long)n) / (double)this.aRate) + 1;
                int n6 = (int)((double)this.bRate * (double)(l + (long)n2) / (double)this.aRate);
                int n7 = n5 - n6;
                n7 = n7 > this.bBuflen ? this.bBuflen : n7;
                this.reader.read((long)n6, n7, this.bufLeft, this.bufRight);
                while ((n4 = (n3 = (int)((double)this.bRate * (double)(l + (long)n2) / (double)this.aRate)) - n6) >= 0 && n4 + 1 < this.bBuflen) {
                    double d3;
                    double d4 = (double)n3 / (double)this.bRate;
                    double d5 = (double)(n3 + 1) / (double)this.bRate;
                    double d6 = this.bufLeft[n4];
                    double d7 = this.bufLeft[n4 + 1];
                    double d8 = (double)(l + (long)n2) / (double)this.aRate;
                    double d9 = (d7 - d6) / (d5 - d4);
                    dArray[n2] = d3 = d6 + d9 * (d8 - d4);
                    d6 = this.bufRight[n4];
                    d7 = this.bufRight[n4 + 1];
                    d9 = (d7 - d6) / (d5 - d4);
                    dArray2[n2] = d3 = d6 + d9 * (d8 - d4);
                    if (++n2 < n) continue;
                    continue block0;
                }
            }
        }
    }

    public void close() throws IOException {
        if (this.reader == null) {
            return;
        }
        this.reader.close();
        this.reader = null;
    }
}

