/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.media;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.kbinani.PortUtil;

public class WaveWriter {
    private int m_channel = 1;
    private int m_bit_per_sample;
    private int m_sample_rate;
    private long m_total_samples = 0L;
    private RandomAccessFile m_stream = null;
    private String m_path = "";
    private long m_pos_data_chunk;

    public WaveWriter(String string) throws IOException {
        this(string, 2, 16, 44100);
    }

    public WaveWriter(String string, int n, int n2, int n3) throws IOException {
        this.m_path = string;
        this.m_stream = new RandomAccessFile(this.m_path, "rw");
        this.m_channel = n;
        this.m_bit_per_sample = n2;
        this.m_sample_rate = n3;
        this.writeHeader();
        this.m_total_samples = (this.m_stream.length() - this.m_pos_data_chunk) / (long)this.m_channel / (long)(this.m_bit_per_sample / 8);
    }

    public void replace(long l, int n, double[] dArray, double[] dArray2) throws IOException {
        long l2 = this.m_stream.getFilePointer();
        long l3 = l * (long)this.m_channel * (long)this.m_bit_per_sample / 8L + this.m_pos_data_chunk;
        long l4 = this.m_stream.length();
        if (l4 < l3) {
            int n2;
            this.m_stream.seek(l4 - 1L);
            int n3 = 1024;
            byte[] byArray = new byte[n3];
            for (long i = l3 - l4; i > 0L; i -= (long)n2) {
                n2 = i > (long)n3 ? n3 : (int)i;
                this.m_stream.write(byArray, 0, n2);
            }
            this.m_total_samples = l;
        }
        this.m_stream.seek(l3);
        if (this.m_bit_per_sample == 8) {
            if (this.m_channel == 1) {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte((int)((dArray[i] + dArray2[i] + 2.0) * 63.75));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte((int)((dArray[i] + 1.0) * 127.5));
                    this.m_stream.writeByte((int)((dArray2[i] + 1.0) * 127.5));
                }
            }
        } else if (this.m_channel == 1) {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le((short)((dArray[i] + dArray2[i]) * 16384.0));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le((short)(dArray[i] * 32768.0));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
                byArray = PortUtil.getbytes_int16_le((short)(dArray2[i] * 32768.0));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        }
        this.m_total_samples = this.m_total_samples < l + (long)n ? l + (long)n : this.m_total_samples;
        this.m_stream.seek(l2);
    }

    private void writeHeader() throws IOException {
        this.m_stream.writeByte(82);
        this.m_stream.writeByte(73);
        this.m_stream.writeByte(70);
        this.m_stream.writeByte(70);
        this.m_stream.writeByte(0);
        this.m_stream.writeByte(0);
        this.m_stream.writeByte(0);
        this.m_stream.writeByte(0);
        this.m_stream.writeByte(87);
        this.m_stream.writeByte(65);
        this.m_stream.writeByte(86);
        this.m_stream.writeByte(69);
        this.m_stream.writeByte(102);
        this.m_stream.writeByte(109);
        this.m_stream.writeByte(116);
        this.m_stream.writeByte(32);
        this.m_stream.writeByte(18);
        this.m_stream.writeByte(0);
        this.m_stream.writeByte(0);
        this.m_stream.writeByte(0);
        this.m_stream.writeByte(1);
        this.m_stream.writeByte(0);
        if (this.m_channel == 1) {
            this.m_stream.writeByte(1);
            this.m_stream.writeByte(0);
        } else {
            this.m_stream.writeByte(2);
            this.m_stream.writeByte(0);
        }
        byte[] byArray = PortUtil.getbytes_uint32_le(this.m_sample_rate);
        WaveWriter.writeByteArray(this.m_stream, byArray, 4);
        int n = this.m_bit_per_sample / 8 * this.m_channel;
        int n2 = this.m_sample_rate * n;
        byArray = PortUtil.getbytes_uint32_le(n2);
        WaveWriter.writeByteArray(this.m_stream, byArray, 4);
        byArray = PortUtil.getbytes_uint16_le(n);
        WaveWriter.writeByteArray(this.m_stream, byArray, 2);
        byArray = PortUtil.getbytes_uint16_le(this.m_bit_per_sample);
        WaveWriter.writeByteArray(this.m_stream, byArray, 2);
        this.m_stream.writeByte(0);
        this.m_stream.writeByte(0);
        this.m_stream.writeByte(100);
        this.m_stream.writeByte(97);
        this.m_stream.writeByte(116);
        this.m_stream.writeByte(97);
        long l = (long)n * this.m_total_samples;
        byArray = PortUtil.getbytes_uint32_le(l);
        WaveWriter.writeByteArray(this.m_stream, byArray, 4);
        this.m_pos_data_chunk = this.m_stream.getFilePointer();
    }

    public void close() throws IOException {
        if (this.m_stream != null) {
            int n = (int)this.m_stream.getFilePointer();
            this.m_stream.seek(4L);
            byte[] byArray = PortUtil.getbytes_uint32_le(n - 8);
            WaveWriter.writeByteArray(this.m_stream, byArray, 4);
            int n2 = this.m_bit_per_sample / 8 * this.m_channel;
            long l = (long)n2 * this.m_total_samples;
            this.m_stream.seek(42L);
            byArray = PortUtil.getbytes_uint32_le(l);
            WaveWriter.writeByteArray(this.m_stream, byArray, 4);
            this.m_stream.close();
        }
    }

    public int getSampleRate() {
        return this.m_sample_rate;
    }

    public void append(float[] fArray) throws IOException {
        int n = fArray.length;
        if (this.m_bit_per_sample == 8) {
            if (this.m_channel == 1) {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte((int)((fArray[i] + 1.0f) * 127.5f));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    int n2 = (int)((fArray[i] + 1.0f) * 127.5f);
                    this.m_stream.writeByte(n2);
                    this.m_stream.writeByte(n2);
                }
            }
        } else if (this.m_channel == 1) {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le((short)(fArray[i] * 32768.0f));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le((short)(fArray[i] * 32768.0f));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        }
        this.m_total_samples += (long)n;
    }

    public void append(double[] dArray) throws IOException {
        int n = dArray.length;
        if (this.m_bit_per_sample == 8) {
            if (this.m_channel == 1) {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte((int)((dArray[i] + 1.0) * 127.5));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    int n2 = (int)((dArray[i] + 1.0) * 127.5);
                    this.m_stream.writeByte(n2);
                    this.m_stream.writeByte(n2);
                }
            }
        } else if (this.m_channel == 1) {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le((short)(dArray[i] * 32768.0));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le((short)(dArray[i] * 32768.0));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        }
        this.m_total_samples += (long)n;
    }

    public void append(float[] fArray, float[] fArray2) throws IOException {
        int n = Math.min(fArray.length, fArray2.length);
        if (this.m_bit_per_sample == 8) {
            if (this.m_channel == 1) {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte((byte)((fArray[i] + fArray2[i] + 2.0f) * 63.75f));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte((byte)((fArray[i] + 1.0f) * 127.5f));
                    this.m_stream.writeByte((byte)((fArray2[i] + 1.0f) * 127.5f));
                }
            }
        } else if (this.m_channel == 1) {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le((short)((fArray[i] + fArray2[i]) * 16384.0f));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le((short)(fArray[i] * 32768.0f));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
                byArray = PortUtil.getbytes_int16_le((short)(fArray2[i] * 32768.0f));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        }
        this.m_total_samples += (long)n;
    }

    public void append(double[] dArray, double[] dArray2) throws IOException {
        int n = Math.min(dArray.length, dArray2.length);
        this.append(dArray, dArray2, n);
    }

    public void append(double[] dArray, double[] dArray2, int n) throws IOException {
        if (this.m_bit_per_sample == 8) {
            if (this.m_channel == 1) {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte((int)((dArray[i] + dArray2[i] + 2.0) * 63.75));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte((int)((dArray[i] + 1.0) * 127.5));
                    this.m_stream.writeByte((int)((dArray2[i] + 1.0) * 127.5));
                }
            }
        } else if (this.m_channel == 1) {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le((short)((dArray[i] + dArray2[i]) * 16384.0));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le((short)(dArray[i] * 32768.0));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
                byArray = PortUtil.getbytes_int16_le((short)(dArray2[i] * 32768.0));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        }
        this.m_total_samples += (long)n;
    }

    public void append(byte[] byArray, byte[] byArray2) throws IOException {
        int n = Math.min(byArray.length, byArray2.length);
        if (this.m_bit_per_sample == 8) {
            if (this.m_channel == 1) {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte(0xFF & (byArray[i] + byArray2[i]) / 2);
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte(0xFF & byArray[i]);
                    this.m_stream.writeByte(0xFF & byArray2[i]);
                }
            }
        } else if (this.m_channel == 1) {
            for (int i = 0; i < n; ++i) {
                byte[] byArray3 = PortUtil.getbytes_int16_le((short)((float)(byArray[i] + byArray2[i]) * 128.5f - 32768.0f));
                WaveWriter.writeByteArray(this.m_stream, byArray3, 2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                byte[] byArray4 = PortUtil.getbytes_int16_le((short)((float)byArray[i] * 257.0f - 32768.0f));
                WaveWriter.writeByteArray(this.m_stream, byArray4, 2);
                byArray4 = PortUtil.getbytes_int16_le((short)((float)byArray2[i] * 257.0f - 32768.0f));
                WaveWriter.writeByteArray(this.m_stream, byArray4, 2);
            }
        }
        this.m_total_samples += (long)n;
    }

    public void append(short[] sArray, short[] sArray2) throws IOException {
        int n = Math.min(sArray.length, sArray2.length);
        if (this.m_bit_per_sample == 8) {
            if (this.m_channel == 1) {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte((int)(((float)(sArray[i] + sArray2[i]) / 2.0f + 32768.0f) / 255.0f));
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    this.m_stream.writeByte((int)(((float)sArray[i] + 32768.0f) / 255.0f));
                    this.m_stream.writeByte((int)(((float)sArray2[i] + 32768.0f) / 255.0f));
                }
            }
        } else if (this.m_channel == 1) {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le((short)((sArray[i] + sArray2[i]) / 2));
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                byte[] byArray = PortUtil.getbytes_int16_le(sArray[i]);
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
                byArray = PortUtil.getbytes_int16_le(sArray2[i]);
                WaveWriter.writeByteArray(this.m_stream, byArray, 2);
            }
        }
        this.m_total_samples += (long)n;
    }

    private static void writeByteArray(RandomAccessFile randomAccessFile, byte[] byArray, int n) throws IOException {
        randomAccessFile.write(byArray, 0, byArray.length > n ? n : byArray.length);
        if (byArray.length < n) {
            for (int i = 0; i < n - byArray.length; ++i) {
                randomAccessFile.writeByte(0);
            }
        }
    }
}

