/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.FileNotFoundException;
import java.io.RandomAccessFile;
import java.util.Vector;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.vsq.MidiEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiFile {
    private Vector<Vector<MidiEvent>> m_events;
    private int m_format;
    private int m_time_format;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MidiFile(String string) throws FileNotFoundException {
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "r");
        try {
            byte[] byArray = new byte[4];
            randomAccessFile.read(byArray, 0, 4);
            if (PortUtil.make_uint32_be(byArray) != 1297377380L) {
                throw new Exception("header error: MThd");
            }
            randomAccessFile.read(byArray, 0, 4);
            long l = PortUtil.make_uint32_be(byArray);
            randomAccessFile.read(byArray, 0, 2);
            this.m_format = PortUtil.make_uint16_be(byArray);
            int n = 0;
            randomAccessFile.read(byArray, 0, 2);
            n = PortUtil.make_uint16_be(byArray);
            randomAccessFile.read(byArray, 0, 2);
            this.m_time_format = PortUtil.make_uint16_be(byArray);
            this.m_events = new Vector();
            for (int i = 0; i < n; ++i) {
                Vector<MidiEvent> vector = new Vector<MidiEvent>();
                randomAccessFile.read(byArray, 0, 4);
                if (PortUtil.make_uint32_be(byArray) != 1297379947L) {
                    throw new Exception("header error; MTrk");
                }
                randomAccessFile.read(byArray, 0, 4);
                long l2 = PortUtil.make_uint32_be(byArray);
                long l3 = randomAccessFile.getFilePointer();
                ByRef<Long> byRef = new ByRef<Long>(0L);
                ByRef<Byte> byRef2 = new ByRef<Byte>((byte)0);
                while (randomAccessFile.getFilePointer() < l3 + l2) {
                    MidiEvent midiEvent = MidiEvent.read(randomAccessFile, byRef, byRef2);
                    vector.add(midiEvent);
                }
                if (this.m_time_format != 480) {
                    int n2 = vector.size();
                    for (int j = 0; j < n2; ++j) {
                        MidiEvent midiEvent = (MidiEvent)vector.get(j);
                        midiEvent.clock = midiEvent.clock * 480L / (long)this.m_time_format;
                        vector.set(j, midiEvent);
                    }
                }
                this.m_events.add(vector);
            }
            this.m_time_format = 480;
        }
        catch (Exception exception) {
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public Vector<MidiEvent> getMidiEventList(int n) {
        if (this.m_events == null) {
            return new Vector<MidiEvent>();
        }
        if (0 <= n && n < this.m_events.size()) {
            return this.m_events.get(n);
        }
        return new Vector<MidiEvent>();
    }

    public int getTrackCount() {
        if (this.m_events == null) {
            return 0;
        }
        return this.m_events.size();
    }

    public void close() {
        if (this.m_events != null) {
            int n = this.m_events.size();
            for (int i = 0; i < n; ++i) {
                this.m_events.get(i).clear();
            }
            this.m_events.clear();
        }
    }
}

