/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.Serializable;
import java.util.Collections;
import java.util.Vector;
import org.kbinani.vsq.TempoTableEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempoVector
extends Vector<TempoTableEntry>
implements Serializable {
    protected static final int gatetimePerQuater = 480;
    protected static final int superTempo = 500000;

    public double getClockFromSec(double d) {
        int n = 500000;
        double d2 = 0.0;
        double d3 = 0.0;
        int n2 = this.size();
        if (n2 == 0) {
            n = 500000;
            d2 = 0.0;
            d3 = 0.0;
        } else if (n2 == 1) {
            n = ((TempoTableEntry)this.get((int)0)).Tempo;
            d2 = ((TempoTableEntry)this.get((int)0)).Clock;
            d3 = ((TempoTableEntry)this.get((int)0)).Time;
        } else {
            for (int i = n2 - 1; i >= 0; --i) {
                TempoTableEntry tempoTableEntry = (TempoTableEntry)this.get(i);
                if (!(tempoTableEntry.Time < d)) continue;
                return (double)tempoTableEntry.Clock + (d - tempoTableEntry.Time) * 480.0 * 1000000.0 / (double)tempoTableEntry.Tempo;
            }
        }
        double d4 = d - d3;
        return d2 + d4 * 480.0 * 1000000.0 / (double)n;
    }

    public void updateTempoInfo() {
        int n = this.size();
        if (n == 0) {
            this.add(new TempoTableEntry(0, 500000, 0.0));
        }
        Collections.sort(this);
        TempoTableEntry tempoTableEntry = (TempoTableEntry)this.get(0);
        tempoTableEntry.Time = tempoTableEntry.Clock != 0 ? 500000.0 * (double)tempoTableEntry.Clock / 4.8E8 : 0.0;
        double d = tempoTableEntry.Time;
        int n2 = tempoTableEntry.Clock;
        int n3 = tempoTableEntry.Tempo;
        double d2 = 2.0833333333333334E-9;
        for (int i = 1; i < n; ++i) {
            TempoTableEntry tempoTableEntry2 = (TempoTableEntry)this.get(i);
            d = tempoTableEntry2.Time = d + (double)n3 * (double)(tempoTableEntry2.Clock - n2) * d2;
            n3 = tempoTableEntry2.Tempo;
            n2 = tempoTableEntry2.Clock;
        }
    }

    public double getSecFromClock(double d) {
        int n = this.size();
        for (int i = n - 1; i >= 0; --i) {
            TempoTableEntry tempoTableEntry = (TempoTableEntry)this.get(i);
            if (!((double)tempoTableEntry.Clock < d)) continue;
            double d2 = tempoTableEntry.Time;
            double d3 = d - (double)tempoTableEntry.Clock;
            double d4 = (double)tempoTableEntry.Tempo * 1.0E-6 / 480.0;
            return d2 + d3 * d4;
        }
        double d5 = 0.0010416666666666667;
        return d * d5;
    }
}

