/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.Vector;
import org.kbinani.PortUtil;
import org.kbinani.vsq.TempoTableEntry;
import org.kbinani.vsq.UstEnvelope;
import org.kbinani.vsq.UstEvent;
import org.kbinani.vsq.UstFileWriteOptions;
import org.kbinani.vsq.UstPortamento;
import org.kbinani.vsq.UstTrack;
import org.kbinani.vsq.UstVibrato;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqFile;
import org.kbinani.vsq.VsqTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UstFile
implements Cloneable {
    public static final int PREV_INDEX = Integer.MIN_VALUE;
    public static final int NEXT_INDEX = Integer.MAX_VALUE;
    public Object Tag;
    private float m_tempo = 120.0f;
    private String m_project_name = "";
    private String m_voice_dir = "";
    private String m_out_file = "";
    private String m_cache_dir = "";
    private String m_tool1 = "";
    private String m_tool2 = "";
    private Vector<UstTrack> m_tracks = new Vector();
    private Vector<TempoTableEntry> m_tempo_table;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UstFile(String string) {
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(string), "Shift_JIS"));
            String string2 = bufferedReader.readLine();
            UstTrack ustTrack = new UstTrack();
            boolean bl = false;
            while (true) {
                String[] stringArray;
                UstEvent ustEvent = null;
                if (bl) {
                    ustEvent = new UstEvent();
                }
                int n = 0;
                if (string2.equals("[#TRACKEND]")) break;
                if (string2.toUpperCase().equals("[#NEXT]")) {
                    n = Integer.MAX_VALUE;
                } else if (string2.toUpperCase().equals("[#PREV]")) {
                    n = Integer.MIN_VALUE;
                } else {
                    if (!bl) {
                        ustEvent = new UstEvent();
                        bl = true;
                    }
                    stringArray = string2.replace("[#", "").replace("]", "").trim();
                    try {
                        n = PortUtil.parseInt((String)stringArray);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                string2 = bufferedReader.readLine();
                if (string2 == null) break;
                while (!string2.startsWith("[#")) {
                    stringArray = PortUtil.splitString(string2, new char[]{'='}, 2);
                    if (!bl) {
                        if (stringArray[0].equals("Tempo")) {
                            this.m_tempo = 125.0f;
                            float f = 125.0f;
                            try {
                                this.m_tempo = f = PortUtil.parseFloat(stringArray[1]);
                            }
                            catch (Exception exception) {}
                        } else if (stringArray[0].equals("ProjectName")) {
                            this.m_project_name = stringArray[1];
                        } else if (stringArray[0].equals("VoiceDir")) {
                            this.m_voice_dir = stringArray[1];
                        } else if (stringArray[0].equals("OutFile")) {
                            this.m_out_file = stringArray[1];
                        } else if (stringArray[0].equals("CacheDir")) {
                            this.m_cache_dir = stringArray[1];
                        } else if (stringArray[0].equals("Tool1")) {
                            this.m_tool1 = stringArray[1];
                        } else if (stringArray[0].equals("Tool2")) {
                            this.m_tool2 = stringArray[1];
                        }
                    } else if (bl) {
                        if (stringArray[0].equals("Length")) {
                            ustEvent.setLength(0);
                            int n2 = 0;
                            try {
                                n2 = PortUtil.parseInt(stringArray[1]);
                                ustEvent.setLength(n2);
                            }
                            catch (Exception exception) {}
                        } else if (stringArray[0].equals("Lyric")) {
                            ustEvent.Lyric = stringArray[1];
                        } else if (stringArray[0].equals("NoteNum")) {
                            ustEvent.Note = 0;
                            int n3 = 0;
                            try {
                                ustEvent.Note = n3 = PortUtil.parseInt(stringArray[1]);
                            }
                            catch (Exception exception) {}
                        } else if (stringArray[0].equals("Intensity")) {
                            ustEvent.Intensity = 64;
                            int n4 = 64;
                            try {
                                ustEvent.Intensity = n4 = PortUtil.parseInt(stringArray[1]);
                            }
                            catch (Exception exception) {}
                        } else if (stringArray[0].equals("PBType")) {
                            ustEvent.PBType = 5;
                            int n5 = 5;
                            try {
                                ustEvent.PBType = n5 = PortUtil.parseInt(stringArray[1]);
                            }
                            catch (Exception exception) {}
                        } else if (stringArray[0].equals("Piches")) {
                            String[] stringArray2 = PortUtil.splitString(stringArray[1], ',');
                            float[] fArray = new float[stringArray2.length];
                            for (int i = 0; i < stringArray2.length; ++i) {
                                float f = 0.0f;
                                try {
                                    fArray[i] = f = PortUtil.parseFloat(stringArray2[i]);
                                    continue;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            ustEvent.Pitches = fArray;
                        } else if (stringArray[0].equals("Tempo")) {
                            ustEvent.Tempo = 125.0f;
                            try {
                                float f;
                                ustEvent.Tempo = f = PortUtil.parseFloat(stringArray[1]);
                            }
                            catch (Exception exception) {}
                        } else if (stringArray[0].equals("VBR")) {
                            ustEvent.Vibrato = new UstVibrato(string2);
                        } else if (stringArray[0].equals("PBW") || stringArray[0].equals("PBS") || stringArray[0].equals("PBY") || stringArray[0].equals("PBM")) {
                            if (ustEvent.Portamento == null) {
                                ustEvent.Portamento = new UstPortamento();
                            }
                            ustEvent.Portamento.ParseLine(string2);
                        } else if (stringArray[0].equals("Envelope")) {
                            ustEvent.Envelope = new UstEnvelope(string2);
                        } else if (stringArray[0].equals("VoiceOverlap")) {
                            if (stringArray[1] != "") {
                                ustEvent.VoiceOverlap = PortUtil.parseInt(stringArray[1]);
                            }
                        } else if (stringArray[0].equals("PreUtterance")) {
                            if (stringArray[1] != "") {
                                ustEvent.PreUtterance = PortUtil.parseInt(stringArray[1]);
                            }
                        } else if (stringArray[0].equals("Flags")) {
                            ustEvent.Flags = string2.substring(6);
                        }
                    }
                    if (!bufferedReader.ready()) break;
                    string2 = bufferedReader.readLine();
                }
                if (!bl) {
                    bl = true;
                    continue;
                }
                if (!bl) continue;
                ustEvent.Index = n;
                ustTrack.addEvent(ustEvent);
            }
            this.m_tracks.add(ustTrack);
            this.updateTempoInfo();
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public UstFile(VsqFile vsqFile, int n) {
        this(vsqFile, n, false);
    }

    public UstFile(VsqFile vsqFile, int n, boolean bl) {
        UstEvent ustEvent;
        Object object;
        VsqTrack vsqTrack = vsqFile.Track.get(n);
        this.m_tempo = vsqFile.TempoTable.size() <= 0 ? 120.0f : (float)(6.0E7 / (double)((TempoTableEntry)vsqFile.TempoTable.get((int)0)).Tempo);
        this.updateTempoInfo();
        int n2 = 5;
        UstEvent ustEvent2 = new UstEvent();
        ustEvent2.Lyric = "R";
        ustEvent2.Note = 60;
        ustEvent2.PreUtterance = 0.0f;
        ustEvent2.VoiceOverlap = 0.0f;
        ustEvent2.Intensity = 100;
        ustEvent2.Moduration = 0;
        UstTrack ustTrack = new UstTrack();
        int n3 = 0;
        int n4 = 0;
        Iterator<VsqEvent> iterator = vsqTrack.getNoteEventIterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (n3 < ((VsqEvent)object).Clock) {
                ustEvent = (UstEvent)ustEvent2.clone();
                ustEvent.setLength(((VsqEvent)object).Clock - n3);
                ustEvent.Index = n4++;
                if (bl) {
                    ustEvent.Tag = "-1";
                }
                ustTrack.addEvent(ustEvent);
            }
            ustEvent = new UstEvent();
            ustEvent.setLength(((VsqEvent)object).ID.getLength());
            ustEvent.Lyric = ((VsqEvent)object).ID.LyricHandle.L0.Phrase;
            ustEvent.Note = ((VsqEvent)object).ID.Note;
            ustEvent.Index = n4;
            ustEvent.Intensity = ((VsqEvent)object).ID.Dynamics;
            ustEvent.Moduration = ((VsqEvent)object).UstEvent.Moduration;
            ustEvent.PreUtterance = ((VsqEvent)object).UstEvent.PreUtterance;
            ustEvent.VoiceOverlap = ((VsqEvent)object).UstEvent.VoiceOverlap;
            if (bl) {
                ustEvent.Tag = ((VsqEvent)object).InternalID + "";
            }
            if (((VsqEvent)object).UstEvent.Envelope != null) {
                ustEvent.Envelope = (UstEnvelope)((VsqEvent)object).UstEvent.Envelope.clone();
            }
            ++n4;
            ustTrack.addEvent(ustEvent);
            n3 = ((VsqEvent)object).Clock + ((VsqEvent)object).ID.getLength();
        }
        int n5 = 0;
        object = ustTrack.getNoteEventIterator();
        while (object.hasNext()) {
            ustEvent = (UstEvent)object.next();
            int n6 = n5;
            int n7 = n5 + ustEvent.getLength();
            Vector<Float> vector = new Vector<Float>();
            boolean bl2 = true;
            for (int i = n6; i <= n7; i += n2) {
                float f = (float)vsqTrack.getPitchAt(i);
                if ((double)f != 0.0) {
                    bl2 = false;
                }
                vector.add(Float.valueOf(f));
            }
            if (!bl2) {
                ustEvent.Pitches = PortUtil.convertFloatArray(vector.toArray(new Float[0]));
                ustEvent.PBType = n2;
            } else {
                ustEvent.PBType = -1;
            }
            n5 += ustEvent.getLength();
        }
        this.m_tracks.add(ustTrack);
    }

    private UstFile() {
    }

    public void setVoiceDir(String string) {
        this.m_voice_dir = string;
    }

    public String getVoiceDir() {
        return this.m_voice_dir;
    }

    public String getProjectName() {
        return this.m_project_name;
    }

    public int getBaseTempo() {
        return (int)(6.0E7 / (double)this.m_tempo);
    }

    public double getTotalSec() {
        int n = 0;
        for (int i = 0; i < this.m_tracks.size(); ++i) {
            int n2 = 0;
            for (int j = 0; j < this.m_tracks.get(i).getEventCount(); ++j) {
                n2 += this.m_tracks.get(i).getEvent(j).getLength();
            }
            n = Math.max(n, n2);
        }
        return this.getSecFromClock(n);
    }

    public Vector<TempoTableEntry> getTempoList() {
        return this.m_tempo_table;
    }

    public UstTrack getTrack(int n) {
        return this.m_tracks.get(n);
    }

    public int getTrackCount() {
        return this.m_tracks.size();
    }

    public void updateTempoInfo() {
        this.m_tempo_table = new Vector();
        if (this.m_tracks.size() <= 0) {
            return;
        }
        int n = 0;
        double d = 0.0;
        int n2 = 0;
        float f = this.m_tempo;
        for (int i = 0; i < this.m_tracks.get(0).getEventCount(); ++i) {
            if (this.m_tracks.get((int)0).getEvent((int)i).Tempo > 0.0f) {
                d += (double)(n - n2) / (8.0 * (double)f);
                if (this.m_tempo_table.size() == 0 && n != 0) {
                    this.m_tempo_table.add(new TempoTableEntry(0, (int)(6.0E7 / (double)this.m_tempo), 0.0));
                }
                this.m_tempo_table.add(new TempoTableEntry(n, (int)(6.0E7 / (double)this.m_tracks.get((int)0).getEvent((int)i).Tempo), d));
                f = this.m_tracks.get((int)0).getEvent((int)i).Tempo;
                n2 = n;
            }
            n += this.m_tracks.get(0).getEvent(i).getLength();
        }
    }

    public double getSecFromClock(int n) {
        int n2 = this.m_tempo_table.size();
        for (int i = n2 - 1; i >= 0; --i) {
            TempoTableEntry tempoTableEntry = this.m_tempo_table.get(i);
            if (tempoTableEntry.Clock >= n) continue;
            double d = tempoTableEntry.Time;
            int n3 = n - tempoTableEntry.Clock;
            double d2 = (double)tempoTableEntry.Tempo * 1.0E-6 / 480.0;
            return d + (double)n3 * d2;
        }
        double d = 0.125 / (double)this.m_tempo;
        return (double)n * d;
    }

    public void write(String string) {
        UstFileWriteOptions ustFileWriteOptions = new UstFileWriteOptions();
        ustFileWriteOptions.settingCacheDir = true;
        ustFileWriteOptions.settingOutFile = true;
        ustFileWriteOptions.settingProjectName = true;
        ustFileWriteOptions.settingTempo = true;
        ustFileWriteOptions.settingTool1 = true;
        ustFileWriteOptions.settingTool2 = true;
        ustFileWriteOptions.settingTracks = true;
        ustFileWriteOptions.settingVoiceDir = true;
        ustFileWriteOptions.trackEnd = true;
        this.write(string, ustFileWriteOptions);
    }

    public void write(String string, boolean bl) {
        UstFileWriteOptions ustFileWriteOptions = new UstFileWriteOptions();
        ustFileWriteOptions.settingCacheDir = true;
        ustFileWriteOptions.settingOutFile = true;
        ustFileWriteOptions.settingProjectName = true;
        ustFileWriteOptions.settingTempo = true;
        ustFileWriteOptions.settingTool1 = true;
        ustFileWriteOptions.settingTool2 = true;
        ustFileWriteOptions.settingTracks = true;
        ustFileWriteOptions.settingVoiceDir = true;
        ustFileWriteOptions.trackEnd = bl;
        this.write(string, ustFileWriteOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, UstFileWriteOptions ustFileWriteOptions) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "Shift_JIS"));
            bufferedWriter.write("[#SETTING]");
            bufferedWriter.newLine();
            if (ustFileWriteOptions.settingTempo) {
                bufferedWriter.write("Tempo=" + this.m_tempo);
                bufferedWriter.newLine();
            }
            if (ustFileWriteOptions.settingTracks) {
                bufferedWriter.write("Tracks=1");
                bufferedWriter.newLine();
            }
            if (ustFileWriteOptions.settingProjectName) {
                bufferedWriter.write("ProjectName=" + this.m_project_name);
                bufferedWriter.newLine();
            }
            if (ustFileWriteOptions.settingVoiceDir) {
                bufferedWriter.write("VoiceDir=" + this.m_voice_dir);
                bufferedWriter.newLine();
            }
            if (ustFileWriteOptions.settingOutFile) {
                bufferedWriter.write("OutFile=" + this.m_out_file);
                bufferedWriter.newLine();
            }
            if (ustFileWriteOptions.settingCacheDir) {
                bufferedWriter.write("CacheDir=" + this.m_cache_dir);
                bufferedWriter.newLine();
            }
            if (ustFileWriteOptions.settingTool1) {
                bufferedWriter.write("Tool1=" + this.m_tool1);
                bufferedWriter.newLine();
            }
            if (ustFileWriteOptions.settingTool2) {
                bufferedWriter.write("Tool2=" + this.m_tool2);
                bufferedWriter.newLine();
            }
            UstTrack ustTrack = this.m_tracks.get(0);
            int n = ustTrack.getEventCount();
            for (int i = 0; i < n; ++i) {
                ustTrack.getEvent(i).print(bufferedWriter);
            }
            if (ustFileWriteOptions.trackEnd) {
                bufferedWriter.write("[#TRACKEND]");
            }
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            PortUtil.stderr.println("UstFile#write; ex=" + exception);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("UstFile#write; ex2=" + exception);
                }
            }
        }
    }

    public Object clone() {
        int n;
        UstFile ustFile = new UstFile();
        ustFile.m_tempo = this.m_tempo;
        ustFile.m_project_name = this.m_project_name;
        ustFile.m_voice_dir = this.m_voice_dir;
        ustFile.m_out_file = this.m_out_file;
        ustFile.m_cache_dir = this.m_cache_dir;
        ustFile.m_tool1 = this.m_tool1;
        ustFile.m_tool2 = this.m_tool2;
        for (n = 0; n < this.m_tracks.size(); ++n) {
            ustFile.m_tracks.set(n, (UstTrack)this.m_tracks.get(n).clone());
        }
        ustFile.m_tempo_table = new Vector();
        for (n = 0; n < this.m_tempo_table.size(); ++n) {
            ustFile.m_tempo_table.add((TempoTableEntry)this.m_tempo_table.get(n).clone());
        }
        return ustFile;
    }
}

