#include <windows.h>
#include "CBString.h"
#include "CBIniCfg.h"
#include "CBArcDll.h"
#include "CBExtLst.h"
#include "CaldBase.h"

#define		CALDBASE_INI_FILENAME	"CaldBase.ini"
#define		CALDBASE_DLL_FILENAME	"CaldBase.dll"

HINSTANCE hInstance;
//CBArcDll ArcDllDefault;

#define  MAX_ARCDLL_NUM 64
#define  MAX_EXTLST_NUM 256
CBArcDll ArcDll[MAX_ARCDLL_NUM];
CBExtLst ExtLst[MAX_EXTLST_NUM];

//QƂĂ DLL CfbNX
static int  iArcDll_Idx=0;
//DLL CfbNXŒ肷邩ǂB
static bool isStaticArcDll=false;

static CBString strIniFileName;

//vg^Cv錾 (DllMain ŎgpĂ邽)
static void LoadIni(void);

//DLL̓ǍȄ
int WINAPI DllMain(HINSTANCE hInst, DWORD fdwReason, PVOID /*pvReserved*/)
{ 
	switch(fdwReason)
	{
		case DLL_PROCESS_ATTACH:
			//DLL Ǎ
			::hInstance = hInst;
			::LoadIni();			
			break;
		case    DLL_PROCESS_DETACH:
			//DLL 
			break;
	}
	return TRUE; 
}


//CaldBase.ini ǂݍ DLL \z
static void LoadIni(void)
{
	//INI t@C߂
	::GetModuleFileName(::hInstance,strIniFileName.Text,strIniFileName.GetSize());
	strIniFileName.PathGetDirectoryName();
	strIniFileName.Cat(CALDBASE_INI_FILENAME);

	//INI t@Cǂݍݏ
	CBIniCfg CaldBaseIni;
	CaldBaseIni.SetFileName(strIniFileName.Text);

	//DLLꗗ߂
	{
		CBString strDllList;
		CaldBaseIni.SetSection("Global");
		CaldBaseIni.Get("DllList","",strDllList.Text,(DWORD)strDllList.GetSize());
		bool bLoop = true;
		int  iLoop = 1;
		while(bLoop)
		{
			CBString strDllName;
			if(strDllList.GetParse(iLoop,strDllName.Text,strDllName.GetSize()))
			{
				CBString strApiPrefix;		//API Prefix
				CBString strExtractCommand; //𓀃R}h
				CaldBaseIni.SetSection(strDllName.Text);
				CaldBaseIni.Get("ApiPrefix", "", strApiPrefix.Text,(DWORD)strApiPrefix.GetSize());
				CaldBaseIni.Get("ExtractCommand", "", strExtractCommand.Text,(DWORD)strExtractCommand.GetSize());
				//DLLAPI Prefix  ArcDll NXɂēo^Ă
				::ArcDll[iLoop].Init(strDllName.Text,strApiPrefix.Text);
				//𓀃R}h ArcDll NXɒǉo^
				::ArcDll[iLoop].SetExtractCommand(strExtractCommand.Text);

				iLoop++;
				if(iLoop >= MAX_ARCDLL_NUM)
				{
					bLoop = false;
				}
			}
			else
			{
				bLoop = false;
			}
		}
	}

	//gqꗗ(𓀗p)߂
	{
		CBString strExtList;
		CaldBaseIni.SetSection("Global");
		CaldBaseIni.Get("CheckExtensionForExtract","",strExtList.Text,(DWORD)strExtList.GetSize());
		bool bLoop = true;
		int  iLoop = 1;
		while(bLoop)
		{
			CBString strExtName;
			if(strExtList.GetParse(iLoop,strExtName.Text,strExtName.GetSize()))
			{
				CBString strDllName;
				CaldBaseIni.SetSection("ExtensionForExtract");
				CaldBaseIni.Get(strExtName.Text, "", strDllName.Text,(DWORD)strDllName.GetSize());
				//gqƑΉDLL DllLst NXɂēo^Ă
				::ExtLst[iLoop].Init(strExtName.Text,strDllName.Text);
				iLoop++;
				if(iLoop >= MAX_EXTLST_NUM)
				{
					bLoop = false;
				}
			}
			else
			{
				bLoop = false;
			}
		}
	}
}

//DLLIndex߂
static int GetArcIndexByDllName(const char *dllname)
{
	int iRet = 0;

	CBString strCheckDllName;

	for(int i=0; i< MAX_ARCDLL_NUM;i++)
	{
		if(ArcDll[i].IsEnable())
		{
			ArcDll[i].GetDllName(strCheckDllName.Text, strCheckDllName.GetSize());
			if(::lstrcmp(dllname,strCheckDllName.Text) == 0)
			{
				iRet = i;
				break;
			}
		}
	}
	return iRet;
}

//gqDLL Index߂
static int GetArcIndexByExt(const char *ext)
{
	int iRet = 0;

	CBString strChkExt;
	CBString strDllName;

	//DLL߂
	for(int i=0; i< MAX_EXTLST_NUM;i++)
	{
		if(ExtLst[i].IsEnable())
		{
			ExtLst[i].GetExt(strChkExt.Text,strChkExt.GetSize());
			if(::lstrcmp(strChkExt.Text,ext) == 0)
			{
				ExtLst[i].GetDllName(strDllName.Text,strDllName.GetSize());
				break;
			}
		}
	}

	iRet = ::GetArcIndexByDllName(strDllName.Text);

	return iRet;
}

//gqXg(ExtLst)ΉDLLXg߂
static int GetArcIndexByAll(const int idx)
{
	CBString strExt;
	ExtLst[idx].GetExt(strExt.Text, strExt.GetSize());

	int iRet = GetArcIndexByExt(strExt.Text);
	return iRet;
}

////////////////////////////////////////////////////////////////////////////////
// CaldBase.dll Ǝ API
BOOL WINAPI CaldGetDllName(LPSTR _szDllName, const DWORD _dwSize)
{
	bool bRet = ArcDll[::iArcDll_Idx].GetDllName(_szDllName,_dwSize);
	return bRet;
}

void WINAPI CaldGetExtractCommand(LPSTR _szExtractCommand, const DWORD _dwSize)
{
	ArcDll[::iArcDll_Idx].GetExtractCommand(_szExtractCommand,(int)_dwSize);
}

BOOL WINAPI CaldSetDllName(LPCSTR _szDllName)
{
	int iRet = ::GetArcIndexByDllName(_szDllName);

	if(iRet == 0)
	{
		//DLL蓮ݒĎݒɈڍs
		::isStaticArcDll = false;
	}
	else
	{
		::iArcDll_Idx    = iRet;
		::isStaticArcDll = true;
	}

	return iRet;
}

BOOL WINAPI CaldSetDllIndex(const unsigned int idx)
{
	bool bRet = false;

	if(ArcDll[idx].IsEnable())
	{
		::isStaticArcDll = true;
		::iArcDll_Idx    = idx;
		bRet = true;
	}
	else
	{
		::isStaticArcDll = false;
		::iArcDll_Idx    = 0;
		bRet = false;
	}
	return false;
}

BOOL WINAPI CaldIsApiCalled(void)
{
	bool bRet = ArcDll[::iArcDll_Idx].IsApiCalled();
	return bRet;
}

////////////////////////////////////////////////////////////////////////////////
// UNLHA32.DLL ݊ API
int   WINAPI Cald(const HWND _hwnd, LPCSTR _szCmdLine, LPSTR _szOutput, const DWORD _dwSize)
{
	int iRet = ArcDll[::iArcDll_Idx].Exec(_hwnd, _szCmdLine, _szOutput, _dwSize);
	return iRet;
}

BOOL  WINAPI CaldCheckArchive(LPCSTR _szFileName, const int _iMode)
{
	BOOL bRet = FALSE;
	if(::isStaticArcDll)
	{
		bRet = ArcDll[::iArcDll_Idx].CheckArchive(_szFileName,_iMode);
	}
	else if(::lstrcmp(_szFileName,"") == 0)
	{
		::iArcDll_Idx = 0;
		bRet = FALSE;
	}
	else
	{
		CBString strExt;
		lstrcpy(strExt.Text,_szFileName);
		strExt.PathGetExtension();
		int iFirstDllIdx = GetArcIndexByExt(strExt.Text);
		bRet = ArcDll[iFirstDllIdx].CheckArchive(_szFileName,_iMode);

		if(bRet != FALSE)
		{
			::iArcDll_Idx    = iFirstDllIdx;
		}
		else
		{
			int iDllIdx = 0;
			for(int i=1; i<MAX_EXTLST_NUM;i++)
			{
				iDllIdx = GetArcIndexByAll(i);
				if(ArcDll[iDllIdx].IsEnable())
				{
					if(ArcDll[iDllIdx].CheckArchive(_szFileName,_iMode) != FALSE)
					{
						::iArcDll_Idx    = iDllIdx;
						bRet = TRUE;
						break;
					}
				}
			}
		}
	}
	return bRet;
}

int   WINAPI CaldCloseArchive(HARC _harc)
{
	int iRet = ArcDll[::iArcDll_Idx].CloseArchive(_harc);
	return iRet;
}

BOOL  WINAPI CaldConfigDialog(const HWND _hwnd, LPSTR _szOptionBuffer, const int _iMode)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].ConfigDialog(_hwnd, _szOptionBuffer, _iMode);
	return bRet;
}

int   WINAPI CaldFindFirst(HARC _harc, LPCSTR _szWildName, INDIVIDUALINFO *_lpSubInfo)
{
	int iRet = ArcDll[::iArcDll_Idx].FindFirst(_harc, _szWildName, _lpSubInfo);
	return iRet;
}

int   WINAPI CaldFindNext(HARC _harc, INDIVIDUALINFO *_lpSubInfo)
{
	int iRet = ArcDll[::iArcDll_Idx].FindNext(_harc, _lpSubInfo);
	return iRet;
}

DWORD WINAPI CaldGetAccessTime(HARC _harc)
{
	DWORD dwRet = ArcDll[::iArcDll_Idx].GetAccessTime(_harc);
	return dwRet;
}

DWORD WINAPI CaldGetArcCompressedSize(HARC _harc)
{
	DWORD dwRet = ArcDll[::iArcDll_Idx].GetArcCompressedSize(_harc);
	return dwRet;
}
WORD  WINAPI CaldGetArcDate(HARC _harc)
{
	WORD wRet = ArcDll[::iArcDll_Idx].GetArcDate(_harc);
	return wRet;
}
WORD  WINAPI CaldGetArcTime(HARC _harc)
{
	WORD wRet = ArcDll[::iArcDll_Idx].GetArcTime(_harc);
	return wRet;
}

int   WINAPI CaldGetArcFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	int iRet = ArcDll[::iArcDll_Idx].GetArcFileName(_harc, _lpBuffer, _nSize);
	return iRet;
}


DWORD WINAPI CaldGetArcFileSize(HARC _harc)
{
	DWORD dwRet = ArcDll[::iArcDll_Idx].GetArcFileSize(_harc);
	return dwRet;
}

DWORD WINAPI CaldGetArcOriginalSize(HARC _harc)
{
	DWORD dwRet = ArcDll[::iArcDll_Idx].GetArcOriginalSize(_harc);
	return dwRet;
}

DWORD WINAPI CaldGetArcReadSize(HARC _harc)
{
	DWORD dwRet = ArcDll[::iArcDll_Idx].GetArcReadSize(_harc);
	return dwRet;
}

int   WINAPI CaldGetAttribute(HARC _harc)
{
	int iRet = ArcDll[::iArcDll_Idx].GetAttribute(_harc);
	return iRet;
}

int   WINAPI CaldGetArcOSType(HARC _harc)
{
	int iRet = ArcDll[::iArcDll_Idx].GetArcOSType(_harc);
	return iRet;
}
int   WINAPI CaldGetOSType(HARC _harc)
{
	int iRet = ArcDll[::iArcDll_Idx].GetOSType(_harc);
	return iRet;
}
int   WINAPI CaldIsSFXFile(HARC _harc)
{
	int iRet = ArcDll[::iArcDll_Idx].IsSFXFile(_harc);
	return iRet;
}



DWORD WINAPI CaldGetCompressedSize(HARC _harc)
{
	DWORD dwRet = ArcDll[::iArcDll_Idx].GetCompressedSize(_harc);
	return dwRet;
}
DWORD WINAPI CaldGetCreateTime(HARC _harc)
{
	DWORD dwRet = ArcDll[::iArcDll_Idx].GetCreateTime(_harc);
	return dwRet;
}

DWORD WINAPI CaldGetCRC(HARC _harc)
{
	DWORD dwRet = ArcDll[::iArcDll_Idx].GetCRC(_harc);
	return dwRet;
}

WORD  WINAPI CaldGetDate(HARC _harc)
{
	WORD wRet = ArcDll[::iArcDll_Idx].GetDate(_harc);
	return wRet;
}

int   WINAPI CaldGetFileCount(LPCSTR _szArcFile)
{
	int iRet =  ArcDll[::iArcDll_Idx].GetFileCount(_szArcFile);
	return iRet;
}

int   WINAPI CaldGetFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	int iRet = ArcDll[::iArcDll_Idx].GetFileName(_harc, _lpBuffer, _nSize);
	return iRet;
}

int   WINAPI CaldGetMethod(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	int iRet = ArcDll[::iArcDll_Idx].GetMethod(_harc, _lpBuffer, _nSize);
	return iRet;
}

DWORD WINAPI CaldGetOriginalSize(HARC _harc)
{
	DWORD dwRet = ArcDll[::iArcDll_Idx].GetOriginalSize(_harc);
	return dwRet;
}

WORD  WINAPI CaldGetRatio(HARC _harc)
{
	WORD wRet = ArcDll[::iArcDll_Idx].GetRatio(_harc);
	return wRet;
}
WORD  WINAPI CaldGetArcRatio(HARC _harc)
{
	WORD wRet = ArcDll[::iArcDll_Idx].GetArcRatio(_harc);
	return wRet;
}


BOOL  WINAPI CaldGetRunning(VOID)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetRunning();
	return bRet;
}

BOOL  WINAPI CaldGetBackGroundMode(VOID)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetBackGroundMode();
	return bRet;
}

BOOL  WINAPI CaldGetCursorMode(VOID)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetCursorMode();
	return bRet;
}


WORD  WINAPI CaldGetSubVersion(VOID)
{
	WORD wRet=0;

	//DLL ŒL邢DLL Index 1`̏ꍇ
	if(::isStaticArcDll || (iArcDll_Idx != 0))
	{
		wRet = ArcDll[::iArcDll_Idx].GetSubVersion();
	}
	else
	{
		//DLLŒ薳DLL Index ݒ̏ꍇ CaldBase ̃o[WԂ
		wRet = CALDBASE_SUBVER;
	}
	return wRet;
}

WORD  WINAPI CaldGetCursorInterval(VOID)
{
	WORD wRet = ArcDll[::iArcDll_Idx].GetCursorInterval();
	return wRet;
}

WORD  WINAPI CaldGetTime(HARC _harc)
{
	WORD wRet = ArcDll[::iArcDll_Idx].GetTime(_harc);
	return wRet;
}

BOOL  WINAPI CaldGetArcAccessTimeEx(HARC _harc, FILETIME *_lpftLastAccessTime)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetArcAccessTimeEx(_harc, _lpftLastAccessTime);
	return bRet;
}
BOOL  WINAPI CaldGetArcCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetArcCompressedSizeEx(_harc, _lpllSize);
	return bRet;
}
BOOL  WINAPI CaldGetArcCreateTimeEx(HARC _harc, FILETIME *_lpftCreationTime)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetArcCreateTimeEx(_harc, _lpftCreationTime);
	return bRet;
}
BOOL  WINAPI CaldGetArcFileSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetArcFileSizeEx(_harc, _lpllSize);
	return bRet;
}
BOOL  WINAPI CaldGetArcOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetArcOriginalSizeEx(_harc, _lpllSize);
	return bRet;
}
BOOL  WINAPI CaldGetArcReadSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetArcReadSizeEx(_harc, _lpllSize);
	return bRet;
}
BOOL  WINAPI CaldGetArcWriteTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetArcWriteTimeEx(_harc, _lpftLastWriteTime);
	return bRet;
}
BOOL  WINAPI CaldGetAccessTimeEx(HARC _harc, FILETIME *_lpftLastAccessTime)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetAccessTimeEx(_harc, _lpftLastAccessTime);
	return bRet;
}
BOOL  WINAPI CaldGetCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetCompressedSizeEx(_harc, _lpllSize);
	return bRet;
}
BOOL  WINAPI CaldGetCreateTimeEx(HARC _harc, FILETIME *_lpftCreationTime)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetCreateTimeEx(_harc, _lpftCreationTime);
	return bRet;
}
BOOL  WINAPI CaldGetOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetOriginalSizeEx(_harc, _lpllSize);
	return bRet;
}
BOOL  WINAPI CaldGetWriteTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].GetWriteTimeEx(_harc, _lpftLastWriteTime);
	return bRet;
}

WORD  WINAPI CaldGetVersion(VOID)
{
	WORD wRet=0;

	//DLL ŒL邢DLL Index 1`̏ꍇ
	if(::isStaticArcDll || (iArcDll_Idx != 0))
	{
		wRet = ArcDll[::iArcDll_Idx].GetVersion();
	}
	else
	{
		//DLLŒ薳DLL Index ݒ̏ꍇ CaldBase ̃o[WԂ
		wRet = CALDBASE_VER;
	}

	return wRet;
}

DWORD WINAPI CaldGetWriteTime(HARC _harc)
{
	DWORD dwRet = ArcDll[::iArcDll_Idx].GetWriteTime(_harc);
	return dwRet;
}


HARC  WINAPI CaldOpenArchive(const HWND _hwnd, LPCSTR _szFileName, const DWORD _dwMode)
{
	HARC hRet = ArcDll[::iArcDll_Idx].OpenArchive(_hwnd,_szFileName,_dwMode);
	return hRet;
}

HARC  WINAPI CaldOpenArchive2(const HWND _hwnd, LPCSTR _szFileName, const DWORD _dwMode, LPCSTR _szOption)
{
	HARC hRet = ArcDll[::iArcDll_Idx].OpenArchive2(_hwnd,_szFileName,_dwMode, _szOption);
	return hRet;
}

BOOL  WINAPI CaldQueryFunctionList(const int _iFunction)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].QueryFunctionList(_iFunction);
	return bRet;
}

BOOL  WINAPI CaldSetPriority(const int _nPriority)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].SetPriority(_nPriority);
	return bRet;
}

BOOL  WINAPI CaldSetCursorMode(const BOOL _CursorMode)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].SetCursorMode(_CursorMode);
	return bRet;
}

BOOL  WINAPI CaldSetBackGroundMode(const BOOL _bBackGroundMode)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].SetBackGroundMode(_bBackGroundMode);
	return bRet;
}

BOOL  WINAPI CaldSetCursorInterval(const WORD _Interval)
{
	BOOL bRet = ArcDll[::iArcDll_Idx].SetCursorInterval(_Interval);
	return bRet;
}

int   WINAPI CaldExtractMem(const HWND _hwnd, LPCSTR _szCmdLine, LPBYTE _szBuffer, const DWORD _dwSize, time_t *_lpTime, LPWORD _lpwAttr, LPDWORD _lpdwWriteSize)
{
	int iRet = ArcDll[::iArcDll_Idx].ExtractMem(_hwnd, _szCmdLine, _szBuffer, _dwSize, _lpTime, _lpwAttr, _lpdwWriteSize);
	return iRet;
}
int   WINAPI CaldCompressMem(const HWND _hwnd, LPCSTR _szCmdLine,const LPBYTE _szBuffer, const DWORD _dwSize, const time_t *_lpTime, const LPWORD _lpwAttr, LPDWORD _lpdwWriteSize)
{
	int iRet = ArcDll[::iArcDll_Idx].CompressMem(_hwnd, _szCmdLine, _szBuffer, _dwSize, _lpTime, _lpwAttr, _lpdwWriteSize);
	return iRet;
}
