#include "CBArcDll.h"

//DLL  API  typedef `Ă

//GetRunning, GetBackGroundMode, GetCursorMode
typedef BOOL (WINAPI *PGETRUNFUNC   )();
//CheckArchive
typedef BOOL (WINAPI *PCHKARCFUNC   )(LPCSTR, const int);
//Get*TimeEx
typedef BOOL (WINAPI *PGETTIMEXFUNC )(HARC, FILETIME *);
//Get*SizeEx
typedef BOOL (WINAPI *PGETSIZEXFUNC )(HARC, ULHA_INT64 *);
//ConfigDialog
typedef BOOL (WINAPI *PCNFDLG       )(const HWND, LPSTR, const int);
//OpenArchive
typedef HARC (WINAPI *POPNARCFUNC   )(const HWND, LPCSTR, const DWORD);
//CloseArchive
typedef int  (WINAPI *PCLSARCFUNC   )(HARC);
//Exec (Unlha() )
typedef int  (WINAPI *PARCEXECFUNC  )(const HWND, LPCSTR, LPSTR, const DWORD);
//Exec (ISH32.DLL p!)
typedef int  (WINAPI *PISHEXECFUNC  )(const HWND, LPCSTR);
//FindFirst
typedef int  (WINAPI *PFND1STFUNC   )(HARC, LPCSTR ,INDIVIDUALINFO *);
//FindNext
typedef int  (WINAPI *PFNDNXTFUNC   )(HARC, INDIVIDUALINFO *);
//GetAttribute / GetArcOSType / GetOSType
typedef int  (WINAPI *PGETATTRFUNC  )(HARC);
//GetFileName, GetArcFileName
typedef int  (WINAPI *PGETFILNFUNC  )(HARC, LPSTR, const int);
//GetFileCount
typedef int  (WINAPI *PGETFILCNTFUNC)(LPCSTR);
//GetMethod
typedef int  (WINAPI *PGETMTD       )(HARC, LPSTR, const int);
//GetVersion, SubGetVersion, GetCursorInterval
typedef WORD (WINAPI *PGETVERFUNC   )();
//GetArc*Date
//(GetArcDate / GetArcRatio / GetArcDate / GetDate / GetTime / GetRatio / GetDate / GetCreateTime / 
// GetAccessTime)
typedef WORD (WINAPI *PGETDTFUNC    )(HARC);
//Get*Size / Get*Time (GetArc* ܂)
//(GetArcFileSize / GetArcOriginalSize / GetArcCompressedSize / 
// GetArcReadSize / GetOriginalSize / GetCompressedSize / GetCRC  / 
// GetArcDate / GetArcTime / GetWriteTime)
typedef DWORD (WINAPI *PGETSIZFUNC  )(HARC);
//QueryFunctionList, SetPriority
typedef BOOL (WINAPI *PQRYFLSTFUNC  )(const int);
//SetCursorMode, SetBackGroundMode
typedef BOOL (WINAPI *PSETMODEFUNC  )(const BOOL);
//SetCursorInterval 
typedef BOOL (WINAPI *PSETCINTFUNC  )(const WORD);
//OpenArchive2
typedef HARC (WINAPI *POPNARC2FUNC )(const HWND, LPCSTR, const DWORD, LPCSTR);
//ExtractMem
typedef int  (WINAPI *PEXTMEMFUNC  )(const HWND, LPCSTR,      LPBYTE, const DWORD,       time_t *,       LPWORD, LPDWORD);
//CompressMem
typedef int  (WINAPI *PCMPMEMFUNC  )(const HWND, LPCSTR,const LPBYTE, const DWORD, const time_t *, const LPWORD, LPDWORD);


////////////////////////////////////////////////////////////////////////////////
//RXgN^
CBArcDll::CBArcDll()
{
	this->isEnable  = false;
	this->hInstance = NULL;
	this->fpCurrentProcAddr = NULL;
}

////////////////////////////////////////////////////////////////////////////////
//fXgN^
CBArcDll::~CBArcDll()
{
	this->isEnable = false;
	this->Free();
}

////////////////////////////////////////////////////////////////////////////////
// DLL 
BOOL CBArcDll::Free(void)
{
	BOOL bRet = FALSE;
	if(this->hInstance != NULL)
	{
		bRet = ::FreeLibrary(this->hInstance);
		if(bRet)
		{
			this->hInstance = NULL;
		}
	}
	this->fpCurrentProcAddr = NULL;

	return bRet;
}

////////////////////////////////////////////////////////////////////////////////
// DLL [h
BOOL CBArcDll::Load(void)
{
	BOOL bRet = FALSE;
	if(this->hInstance == NULL)
	{
		this->hInstance = ::LoadLibrary(this->strDllName.Text);
	}
	this->fpCurrentProcAddr = NULL;

	bRet = (BOOL)(this->hInstance != NULL);

	return bRet;
}


////////////////////////////////////////////////////////////////////////////////
// .ini ɋLqꂽ DLL `Kɗp\Ԃ
bool CBArcDll::IsEnable(void)
{
	return this->isEnable;
}

////////////////////////////////////////////////////////////////////////////////
// DLL 
void CBArcDll::Init(char *dllname, char *apiprefix)
{
	if(this->hInstance != NULL)
	{
		this->Free();
	}

	this->strDllName.Copy(dllname);
	this->strApiPrefix.Copy(apiprefix);

	if(lstrlen(this->strDllName.Text)   > 0 &&
	   lstrlen(this->strApiPrefix.Text) > 0)
	{
		//DLLAPI Prefix `Ăėp\łB
		this->isEnable = true;
	}
	else
	{
		//DLL API Prefix ̂ǂ炩Ăꍇ͗płȂB
		this->isEnable = false;
	}
}

////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// CALDBASE.DLL Ǝ API

////////////////////////////////////////////////////////////////////////////////
// ꔭ𓀗pR}hݒ肷
void CBArcDll::SetExtractCommand(char *command)
{
	this->strExtractCommand.Copy(command);
}

////////////////////////////////////////////////////////////////////////////////
// ꔭ𓀗pR}ho
void CBArcDll::GetExtractCommand(char *command, int nsize)
{
	::lstrcpyn(command,this->strExtractCommand.Text,nsize);
}

////////////////////////////////////////////////////////////////////////////////
// OɎs API gpłǂԂ
bool CBArcDll::IsApiCalled(void)
{
	bool bRet = (this->fpCurrentProcAddr != NULL);
	this->fpCurrentProcAddr = NULL;
	return bRet;
}

////////////////////////////////////////////////////////////////////////////////
// NX̒S DLL o
bool CBArcDll::GetDllName(char *dllname, int nsize)
{
	bool bRet = false;

	if(lstrlen(this->strDllName.Text) < nsize)
	{
		::lstrcpyn(dllname, this->strDllName.Text, nsize);
		bRet = true;
	}

	return bRet;
}


////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////
// UNLHA32.DLL ݊ API

////////////////////////////////////////////////////////////////////////////////
// DLL  CheckArchive Ăяo
BOOL CBArcDll::CheckArchive(LPCSTR _szFileName, const int _iMode)
{
	BOOL bRet = FALSE;

	CBString strChkArc;
	strChkArc.Copy(this->strApiPrefix.Text);
	strChkArc.Cat("CheckArchive");

	if(this->Load())
	{
		PCHKARCFUNC ChkArc = (PCHKARCFUNC)GetProcAddress(this->hInstance, strChkArc.Text);
		this->fpCurrentProcAddr = (FARPROC) ChkArc;

		if(ChkArc != NULL)
		{
			bRet = (*ChkArc)(_szFileName,_iMode);
		}
	}

	return bRet;
}


////////////////////////////////////////////////////////////////////////////////
// DLL  GetVersion / GetSubVersion Ăяo
WORD CBArcDll::_GetVer(const char *apiname)
{
	CBString strGetVer;
	strGetVer.Copy(this->strApiPrefix.Text);
	strGetVer.Cat(apiname);

	WORD wRet = 0;
	if(this->Load())
	{
		PGETVERFUNC GetVer = (PGETVERFUNC)GetProcAddress(this->hInstance, strGetVer.Text);
		this->fpCurrentProcAddr = (FARPROC) GetVer;

		if(GetVer != NULL)
		{
			wRet = (*GetVer)();
		}
	}

	return wRet;
}

// DLL  GetVersion Ăяo
WORD CBArcDll::GetVersion(void)
{
	return this->_GetVer("GetVersion");
}

// DLL  GetSubVersion Ăяo
WORD CBArcDll::GetSubVersion(void)
{
	return this->_GetVer("GetSubVersion");
}

// DLL  GetCursorInterval Ăяo
WORD CBArcDll::GetCursorInterval(void)
{
	return this->_GetVer("GetCursorInterval");
}


////////////////////////////////////////////////////////////////////////////////
// DLL  GetFileCount Ăяo
int CBArcDll::GetFileCount(LPCSTR _szArcFile)
{
	int iRet = -1;

	CBString strGetFileCount;
	strGetFileCount.Copy(this->strApiPrefix.Text);
	strGetFileCount.Cat("GetFileCount");

	if(this->Load())
	{
		PGETFILCNTFUNC GetFilCnt = (PGETFILCNTFUNC)GetProcAddress(this->hInstance, strGetFileCount.Text);
		this->fpCurrentProcAddr = (FARPROC) GetFilCnt;

		if(GetFilCnt != NULL)
		{
			iRet = (*GetFilCnt)(_szArcFile);
		}
	}

	return iRet;
}

////////////////////////////////////////////////////////////////////////////////
// DLL  OpenArchive / OpenArchive2 Ăяo
HARC CBArcDll::OpenArchive(const HWND _hwnd, LPCSTR _szFileName,const DWORD _dwMode)
{
	HARC hRet = NULL;

	CBString strOpenArc;
	strOpenArc.Copy(this->strApiPrefix.Text);
	strOpenArc.Cat("OpenArchive");

	if(this->Load())
	{
		POPNARCFUNC OpenArc = (POPNARCFUNC)GetProcAddress(this->hInstance, strOpenArc.Text);
		this->fpCurrentProcAddr = (FARPROC) OpenArc;

		if(OpenArc != NULL)
		{
			hRet = (*OpenArc)(_hwnd,_szFileName,_dwMode);
		}
	}

	return hRet;
}

HARC CBArcDll::OpenArchive2(const HWND _hwnd, LPCSTR _szFileName,const DWORD _dwMode,LPCSTR _szOption)
{
	HARC hRet = NULL;

	CBString strOpenArc;
	strOpenArc.Copy(this->strApiPrefix.Text);
	strOpenArc.Cat("OpenArchive2");

	if(this->Load())
	{
		POPNARC2FUNC OpenArc2 = (POPNARC2FUNC)GetProcAddress(this->hInstance, strOpenArc.Text);
		this->fpCurrentProcAddr = (FARPROC) OpenArc2;

		if(OpenArc2 != NULL)
		{
			hRet = (*OpenArc2)(_hwnd,_szFileName,_dwMode,_szOption);
		}
	}

	return hRet;
}


////////////////////////////////////////////////////////////////////////////////
// DLL  CloseArchive Ăяo
int CBArcDll::CloseArchive(HARC _harc)
{
	int iRet = 0;

	CBString strCloseArc;
	strCloseArc.Copy(this->strApiPrefix.Text);
	strCloseArc.Cat("CloseArchive");

	if(this->Load())
	{
		PCLSARCFUNC CloseArc = (PCLSARCFUNC)GetProcAddress(this->hInstance, strCloseArc.Text);
		this->fpCurrentProcAddr = (FARPROC) CloseArc;

		if(CloseArc != NULL)
		{
			iRet = (*CloseArc)(_harc);
		}
	}
	return iRet;
}

////////////////////////////////////////////////////////////////////////////////
// DLL  FindFirst Ăяo
int CBArcDll::FindFirst(HARC _harc, LPCSTR _szWildName, INDIVIDUALINFO *_lpSubInfo)
{
	int iRet = -1;
	
	CBString strFindFirst;
	strFindFirst.Copy(this->strApiPrefix.Text);
	strFindFirst.Cat("FindFirst");

	if(this->Load())
	{
		PFND1STFUNC Fnd1st = (PFND1STFUNC)::GetProcAddress(this->hInstance,strFindFirst.Text);
		this->fpCurrentProcAddr = (FARPROC) Fnd1st;

		if(Fnd1st != NULL)
		{
			iRet = (*Fnd1st)(_harc,_szWildName,_lpSubInfo);
		}
	}

	return iRet;
}

////////////////////////////////////////////////////////////////////////////////
// DLL  FindNext Ăяo
int CBArcDll::FindNext(HARC _harc, INDIVIDUALINFO *_lpSubInfo)
{
	int iRet = -1;

	CBString strFindNext;
	strFindNext.Copy(this->strApiPrefix.Text);
	strFindNext.Cat("FindNext");

	if(this->Load())
	{
		PFNDNXTFUNC FndNxt = (PFNDNXTFUNC)::GetProcAddress(this->hInstance,strFindNext.Text);
		this->fpCurrentProcAddr = (FARPROC) FndNxt;

		if(FndNxt != NULL)
		{
			iRet = (*FndNxt)(_harc,_lpSubInfo);
		}
	}

	return iRet;
}

////////////////////////////////////////////////////////////////////////////////
// DLL  GetRunning Ăяo
BOOL CBArcDll::_GetRunning(const char *apiname)
{
	BOOL bRet = FALSE;

	CBString strGetRun;
	strGetRun.Copy(this->strApiPrefix.Text);
	strGetRun.Cat(apiname);

	if(this->Load())
	{
		PGETRUNFUNC GetRun = (PGETRUNFUNC)::GetProcAddress(this->hInstance,strGetRun.Text);
		this->fpCurrentProcAddr = (FARPROC) GetRun;

		if(GetRun != NULL)
		{
			bRet = (*GetRun)();
		}
	}

	return bRet;
}

BOOL CBArcDll::GetRunning(void)
{
	return this->_GetRunning("GetRunning");
}

BOOL CBArcDll::GetBackGroundMode(void)
{
	return this->_GetRunning("GetBackGroundMode");
}

BOOL CBArcDll::GetCursorMode(void)
{
	return this->_GetRunning("GetCursorMode");
}

////////////////////////////////////////////////////////////////////////////////
// DLL  GetFileName / GetArcFileName Ăяo
int CBArcDll::_GetFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize,const char *apiname)
{
	int iRet = -1;

	CBString strGetFileName;
	strGetFileName.Copy(this->strApiPrefix.Text);
	strGetFileName.Cat(apiname);

	if(this->Load())
	{
		PGETFILNFUNC GetFilN = (PGETFILNFUNC)::GetProcAddress(this->hInstance,strGetFileName.Text);
		this->fpCurrentProcAddr = (FARPROC) GetFilN;

		if(GetFilN != NULL)
		{
			iRet = (*GetFilN)(_harc, _lpBuffer, _nSize);
		}
	}

	return iRet;
}

int CBArcDll::GetFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	return this->_GetFileName(_harc, _lpBuffer, _nSize,"GetFileName");
}

int CBArcDll::GetArcFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	return this->_GetFileName(_harc, _lpBuffer, _nSize,"GetArcFileName");
}

////////////////////////////////////////////////////////////////////////////////
// DLL  GetAttrib  API Ăяo
int CBArcDll::_GetAttr(HARC _harc, const char *apiname)
{
	CBString strGetAttr;
	strGetAttr.Copy(this->strApiPrefix.Text);
	strGetAttr.Cat(apiname);

	//int hogehoge(HARC) ̊֐̃G[l -1 ŒB
	int iRet = -1;

	if(this->Load())
	{
		PGETATTRFUNC GetAttr = (PGETATTRFUNC)GetProcAddress(this->hInstance, strGetAttr.Text);
		this->fpCurrentProcAddr = (FARPROC) GetAttr;

		if(GetAttr != NULL)
		{
			iRet = (*GetAttr)(_harc);
		}
	}
	return iRet;
}

int CBArcDll::GetAttribute(HARC _harc)
{
	return this->_GetAttr(_harc, "GetAttribute");
}

int CBArcDll::GetArcOSType(HARC _harc)
{
	return this->_GetAttr(_harc, "GetArcOSType");
}

int CBArcDll::GetOSType(HARC _harc)
{
	return this->_GetAttr(_harc, "GetOSType");
}

int CBArcDll::IsSFXFile(HARC _harc)
{
	return this->_GetAttr(_harc, "IsSFXFile");
}



////////////////////////////////////////////////////////////////////////////////
// DLL  GetArcOriginalSize  API Ăяo
DWORD CBArcDll::_GetSize(HARC _harc, const char *apiname)
{
	CBString strGetSize;
	strGetSize.Copy(this->strApiPrefix.Text);
	strGetSize.Cat(apiname);

	//WORD hogehoge(HARC) ̊֐̃G[l -1 ŒB
	DWORD dwRet = (DWORD) -1;

	if(this->Load())
	{
		PGETSIZFUNC GetSiz = (PGETSIZFUNC)GetProcAddress(this->hInstance, strGetSize.Text);
		this->fpCurrentProcAddr = (FARPROC) GetSiz;

		if(GetSiz != NULL)
		{
			dwRet = (*GetSiz)(_harc);
		}
	}
	return dwRet;
}

// DLL  GetArcFileSize Ăяo
DWORD CBArcDll::GetArcFileSize(HARC _harc)
{
	return this->_GetSize(_harc, "GetArcFileSize");
}

// DLL  GetArcOriginalSize Ăяo
DWORD CBArcDll::GetArcOriginalSize(HARC _harc)
{
	return this->_GetSize(_harc, "GetArcOriginalSize");
}
// DLL  GetArcCompressedSize Ăяo
DWORD CBArcDll::GetArcCompressedSize(HARC _harc)
{
	return this->_GetSize(_harc, "GetArcCompressedSize");
}
// DLL  GetArcReadSize Ăяo
DWORD CBArcDll::GetArcReadSize(HARC _harc)
{
	return this->_GetSize(_harc, "GetArcReadSize");
}
// DLL  GetOriginalSize Ăяo
DWORD CBArcDll::GetOriginalSize(HARC _harc)
{
	return this->_GetSize(_harc, "GetOriginalSize");
}
// DLL  GetCompressedSize Ăяo
DWORD CBArcDll::GetCompressedSize(HARC _harc)
{
	return this->_GetSize(_harc, "GetCompressedSize");
}

// DLL  GetCRC Ăяo
DWORD CBArcDll::GetCRC(HARC _harc)
{
	return this->_GetSize(_harc, "GetCRC");
}

// DLL  GetWriteTime Ăяo
DWORD CBArcDll::GetWriteTime(HARC _harc)
{
	return this->_GetSize(_harc, "GetWriteTime");
}

// DLL  GetCreateTime Ăяo
DWORD CBArcDll::GetCreateTime(HARC _harc)
{
	return this->_GetSize(_harc, "GetCreateTime");
}
// DLL  GetAccessTime Ăяo
DWORD CBArcDll::GetAccessTime(HARC _harc)
{
	return this->_GetSize(_harc, "GetAccessTime");
}


////////////////////////////////////////////////////////////////////////////////
// DLL  GetDate (DateTimen) API Ăяo
WORD CBArcDll::_GetDt(HARC _harc, const char *apiname)
{
	CBString strGetDt;
	strGetDt.Copy(this->strApiPrefix.Text);
	strGetDt.Cat(apiname);

	//WORD hogehoge(HARC) ̊֐̃G[l -1 ŒB
	WORD wRet = (WORD)-1;

	if(this->Load())
	{
		PGETDTFUNC GetDt = (PGETDTFUNC)GetProcAddress(this->hInstance, strGetDt.Text);
		this->fpCurrentProcAddr = (FARPROC) GetDt;

		if(GetDt != NULL)
		{
			wRet = (*GetDt)(_harc);
		}
	}
	return wRet;
}

// DLL  GetArcDate Ăяo
WORD CBArcDll::GetArcDate(HARC _harc)
{
	return this->_GetDt(_harc, "GetArcDate");
}
// DLL  GetDate Ăяo
WORD CBArcDll::GetDate(HARC _harc)
{
	return this->_GetDt(_harc, "GetDate");
}

// DLL  GetArcTime Ăяo
WORD CBArcDll::GetArcTime(HARC _harc)
{
	return this->_GetDt(_harc, "GetArcTime");
}

// DLL  GetTime Ăяo
WORD CBArcDll::GetTime(HARC _harc)
{
	return this->_GetDt(_harc, "GetTime");
}

// DLL  GetArcRatio Ăяo
WORD CBArcDll::GetArcRatio(HARC _harc)
{
	return this->_GetDt(_harc, "GetArcRatio");
}

// DLL  GetRatio Ăяo
WORD CBArcDll::GetRatio(HARC _harc)
{
	return this->_GetDt(_harc, "GetRatio");
}

////////////////////////////////////////////////////////////////////////////////
// DLL  GetMethod Ăяo
int CBArcDll::GetMethod(HARC _harc, LPSTR _lpBuffer, const int _nSize)
{
	int iRet = 0x8021; //ERROR_HARC_ISNOT_OPENED

	CBString strGetMethod;
	strGetMethod.Copy(this->strApiPrefix.Text);
	strGetMethod.Cat("GetMethod");

	if(this->Load())
	{
		PGETMTD GetMtd = (PGETMTD)GetProcAddress(this->hInstance, strGetMethod.Text);
		this->fpCurrentProcAddr = (FARPROC) GetMtd;

		if(GetMtd != NULL)
		{
			iRet = (*GetMtd)(_harc, _lpBuffer, _nSize);
		}
	}

	return iRet;
}

////////////////////////////////////////////////////////////////////////////////
// DLL  ConfigDialog Ăяo
BOOL CBArcDll::ConfigDialog(const HWND _hwnd, LPSTR _szOptionBuffer, const int _iMode)
{
	BOOL bRet = -1;

	CBString strConfigDialog;
	strConfigDialog.Copy(this->strApiPrefix.Text);
	strConfigDialog.Cat("ConfigDialog");

	if(this->Load())
	{
		PCNFDLG CnfDlg = (PCNFDLG)GetProcAddress(this->hInstance, strConfigDialog.Text);
		this->fpCurrentProcAddr = (FARPROC) CnfDlg;

		if(CnfDlg != NULL)
		{
			bRet = (*CnfDlg)(_hwnd, _szOptionBuffer, _iMode);
		}
	}

	return bRet;
}

////////////////////////////////////////////////////////////////////////////////
// DLL  API Prefix Ɠ API Ăяo
int CBArcDll::Exec(const HWND _hwnd, LPCSTR _szCmdLine, LPSTR _szOutput, const DWORD _dwSize)
{
	int iRet = 0x8019; //ERROR_NOT_ARC_FILE

	CBString strExec;
	strExec.Copy(this->strApiPrefix.Text);

	//UNLANJ.DLL O (API A[JCo DLL KiOĂ)
	if(lstrcmp(this->strDllName.Text,"UNKANJ.DLL")==0)
	{
		strExec.Cat("Command");	//API Prefix : "cc", Exec API : "ccCommand"
	}

	if(this->Load())
	{
		//ISH32.DLL O (API A[JCo DLL KiOĂ)
		if(lstrcmp(this->strDllName.Text,"ISH32.DLL") == 0)
		{
			PISHEXECFUNC IshExec = (PISHEXECFUNC)GetProcAddress(this->hInstance, strExec.Text);
			this->fpCurrentProcAddr = (FARPROC) IshExec;
			if(IshExec != NULL)
			{
				iRet = (*IshExec)(_hwnd, _szCmdLine);
			}

		}
		//ʏ̓A[JCo DLL p
		else
		{
			PARCEXECFUNC Exec = (PARCEXECFUNC)GetProcAddress(this->hInstance, strExec.Text);
			this->fpCurrentProcAddr = (FARPROC) Exec;
			if(Exec != NULL)
			{
				iRet = (*Exec)(_hwnd, _szCmdLine, _szOutput, _dwSize);
			}
		}

	}

	return iRet;
}


////////////////////////////////////////////////////////////////////////////////
// DLL  GetSizeEx n API Ăяo
BOOL CBArcDll::_GetSizeEx(HARC _harc, ULHA_INT64 *_lpllSize, const char *apiname)
{
	CBString strGetSizeEx;
	strGetSizeEx.Copy(this->strApiPrefix.Text);
	strGetSizeEx.Cat(apiname);

	BOOL bRet = FALSE;

	if(this->Load())
	{
		PGETSIZEXFUNC GetSizEx = (PGETSIZEXFUNC)GetProcAddress(this->hInstance, strGetSizeEx.Text);
		this->fpCurrentProcAddr = (FARPROC) GetSizEx;

		if(GetSizEx != NULL)
		{
			bRet = (*GetSizEx)(_harc,_lpllSize);
		}
	}
	return bRet;
}

BOOL CBArcDll::GetArcCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	return this->_GetSizeEx(_harc, _lpllSize,"GetArcCompressedSizeEx");
}
BOOL CBArcDll::GetArcFileSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	return this->_GetSizeEx(_harc, _lpllSize, "GetArcFileSizeEx");
}
BOOL CBArcDll::GetArcOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	return this->_GetSizeEx(_harc, _lpllSize, "GetArcOriginalSizeEx");
}
BOOL CBArcDll::GetArcReadSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	return this->_GetSizeEx(_harc, _lpllSize, "GetArcReadSizeEx");
}
BOOL CBArcDll::GetCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	return this->_GetSizeEx(_harc, _lpllSize, "GetCompressedSizeEx");
}
BOOL CBArcDll::GetOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize)
{
	return this->_GetSizeEx(_harc, _lpllSize, "GetOriginalSizeEx");
}


////////////////////////////////////////////////////////////////////////////////
// DLL  GetTimeEx n API Ăяo
BOOL CBArcDll::_GetTimeEx(HARC _harc, FILETIME *_lpftTime, const char *apiname)
{
	CBString strGetTimeEx;
	strGetTimeEx.Copy(this->strApiPrefix.Text);
	strGetTimeEx.Cat(apiname);

	BOOL bRet = FALSE;

	if(this->Load())
	{
		PGETTIMEXFUNC GetTimEx = (PGETTIMEXFUNC)GetProcAddress(this->hInstance, strGetTimeEx.Text);
		this->fpCurrentProcAddr = (FARPROC) GetTimEx;

		if(GetTimEx != NULL)
		{
			bRet = (*GetTimEx)(_harc,_lpftTime);
		}
	}
	return bRet;
}

BOOL CBArcDll::GetAccessTimeEx(HARC _harc, FILETIME *_lpftLastAccessTime)
{
	return this->_GetTimeEx(_harc, _lpftLastAccessTime, "GetAccessTimeEx");
}
BOOL CBArcDll::GetArcAccessTimeEx(HARC _harc, FILETIME *_lpftLastAccessTime)
{
	return this->_GetTimeEx(_harc, _lpftLastAccessTime, "GetArcAccessTimeEx");
}
BOOL CBArcDll::GetArcCreateTimeEx(HARC _harc, FILETIME *_lpftCreationTime)
{
	return this->_GetTimeEx(_harc, _lpftCreationTime, "GetArcCreateTimeEx");
}
BOOL CBArcDll::GetArcWriteTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime)
{
	return this->_GetTimeEx(_harc, _lpftLastWriteTime, "GetArcWriteTimeEx");
}
BOOL CBArcDll::GetCreateTimeEx(HARC _harc, FILETIME *_lpftCreationTime)
{
	return this->_GetTimeEx(_harc, _lpftCreationTime, "GetCreateTimeEx");
}
BOOL CBArcDll::GetWriteTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime)
{
	return this->_GetTimeEx(_harc, _lpftLastWriteTime, "GetWriteTimeEx");
}

////////////////////////////////////////////////////////////////////////////////
// DLL  QueryFunctionList, SetPriority  API Ăяo
BOOL CBArcDll::_QueryFuncList(const int iSwitch, const char *apiname)
{
	CBString strQueryFuncList;
	strQueryFuncList.Copy(this->strApiPrefix.Text);
	strQueryFuncList.Cat(apiname);

	BOOL bRet = FALSE;

	if(this->Load())
	{
		PQRYFLSTFUNC QryFLst = (PQRYFLSTFUNC)GetProcAddress(this->hInstance, strQueryFuncList.Text);
		this->fpCurrentProcAddr = (FARPROC) QryFLst;

		if(QryFLst != NULL)
		{
			bRet = (*QryFLst)(iSwitch);
		}
	}
	return bRet;
}

BOOL CBArcDll::QueryFunctionList(const int _iFunction)
{
	return this->_QueryFuncList(_iFunction,"QueryFunctionList");
}
BOOL CBArcDll::SetPriority(const int _nPriority)
{
	return this->_QueryFuncList(_nPriority,"SetPriority");
}

////////////////////////////////////////////////////////////////////////////////
// DLL  SetCursorMode, SetBackGroundMode  API Ăяo

BOOL  CBArcDll::_SetMode(const BOOL bMode, const char *apiname)
{
	CBString strSetMode;
	strSetMode.Copy(this->strApiPrefix.Text);
	strSetMode.Cat(apiname);

	BOOL bRet = FALSE;

	if(this->Load())
	{
		PSETMODEFUNC SetMode = (PSETMODEFUNC)GetProcAddress(this->hInstance, strSetMode.Text);
		this->fpCurrentProcAddr = (FARPROC) SetMode;

		if(SetMode != NULL)
		{
			bRet = (*SetMode)(bMode);
		}
	}
	return bRet;
}

BOOL CBArcDll::SetCursorMode(const BOOL _CursorMode)
{
	return this->_QueryFuncList(_CursorMode,"SetCursorMode");
}

BOOL CBArcDll::SetBackGroundMode(const BOOL _bBackGroundMode)
{
	return this->_QueryFuncList(_bBackGroundMode,"SetBackGroundMode");
}


////////////////////////////////////////////////////////////////////////////////
// DLL  SetCursorInterval  API Ăяo
BOOL CBArcDll::SetCursorInterval(const WORD _Interval)
{
	CBString strSetCInt;
	strSetCInt.Copy(this->strApiPrefix.Text);
	strSetCInt.Cat("SetCursorInterval");

	BOOL bRet = FALSE;

	if(this->Load())
	{
		PSETCINTFUNC SetCInt = (PSETCINTFUNC)GetProcAddress(this->hInstance, strSetCInt.Text);
		this->fpCurrentProcAddr = (FARPROC) SetCInt;

		if(SetCInt != NULL)
		{
			bRet = (*SetCInt)(_Interval);
		}
	}
	return bRet;
}

////////////////////////////////////////////////////////////////////////////////
// DLL  ExtractMem  API Ăяo
int CBArcDll::ExtractMem(const HWND _hwnd, LPCSTR _szCmdLine,
                         LPBYTE _szBuffer, const DWORD _dwSize, time_t *_lpTime,
                         LPWORD _lpwAttr, LPDWORD _lpdwWriteSize)
{
	CBString strExtractMem;
	strExtractMem.Copy(this->strApiPrefix.Text);
	strExtractMem.Cat("ExtractMem");

	int iRet = -1;

	if(this->Load())
	{
		PEXTMEMFUNC ExtMem = (PEXTMEMFUNC)GetProcAddress(this->hInstance, strExtractMem.Text);
		this->fpCurrentProcAddr = (FARPROC) ExtMem;

		if(ExtMem != NULL)
		{
			iRet = (*ExtMem)(_hwnd, _szCmdLine, _szBuffer, _dwSize, _lpTime, _lpwAttr, _lpdwWriteSize);
		}
	}
	return iRet;
}

////////////////////////////////////////////////////////////////////////////////
// DLL  ExtractMem  API Ăяo
int CBArcDll::CompressMem(const HWND _hwnd, LPCSTR _szCmdLine,
                          const LPBYTE _szBuffer, const DWORD _dwSize,
                          const time_t *_lpTime, const LPWORD _lpwAttr,
                          LPDWORD _lpdwWriteSize)
{
	CBString strCompressMem;
	strCompressMem.Copy(this->strApiPrefix.Text);
	strCompressMem.Cat("CompressMem");

	int iRet = -1;

	if(this->Load())
	{
		PCMPMEMFUNC CmpMem = (PCMPMEMFUNC)GetProcAddress(this->hInstance, strCompressMem.Text);
		this->fpCurrentProcAddr = (FARPROC) CmpMem;

		if(CmpMem != NULL)
		{
			iRet = (*CmpMem)(_hwnd, _szCmdLine, _szBuffer, _dwSize, _lpTime, _lpwAttr, _lpdwWriteSize);
		}
	}
	return iRet;
}
