#if !defined(CBARCDLL_H)
#define CBARCDLL_H

#include <windows.h>
#include <time.h>		//time_t

#include "CaldBase.h"
#include "CBString.h"

#ifndef FNAME_MAX32
#define FNAME_MAX32		512
#endif

class CBArcDll
{
private:
	bool      isEnable;				//DLL ͎gp\
	HINSTANCE hInstance;			//DLL ̃CX^Xێ
	FARPROC   fpCurrentProcAddr;	//O܂ŎsĂ API ̃vZXAhXێ
	CBString  strDllName;			//DLL ̖
	CBString  strApiPrefix;			//DLL  API Prefix
	CBString  strExtractCommand;	//ꔭ𓀃R}hێ

	//NXIɌĂяo֐Q (apiname wt)
	int   _GetAttr(HARC _harc, const char *apiname);
	WORD  _GetDt(HARC _harc, const char *apiname);
	int   _GetFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize,const char *apiname);
	BOOL  _QueryFuncList(const int iSwitch, const char *apiname);
	BOOL  _GetRunning(const char *apiname);
	DWORD _GetSize(HARC _harc, const char *apiname);
	BOOL  _GetSizeEx(HARC _harc, ULHA_INT64 *_lpllSize, const char *apiname);
	BOOL  _GetTimeEx(HARC _harc, FILETIME *_lpftTime, const char *apiname);
    WORD  _GetVer(const char *apiname);
	BOOL  _SetMode(const BOOL bMode, const char *apiname);

public:
	CBArcDll();
    ~CBArcDll();
	bool IsEnable(void);
    void Init(char *dllname, char *apiprefix);
    BOOL Load(void);
    BOOL Free(void);

	//UNLHA32.DLL ݊ API n (At@xbg)
	BOOL  CheckArchive(LPCSTR _szFileName, const int _iMode);
	int   CloseArchive(HARC _harc);
	BOOL  ConfigDialog(const HWND _hwnd, LPSTR _szOptionBuffer, const int _iMode);
	int   Exec(const HWND _hwnd, LPCSTR _szCmdLine, LPSTR _szOutput, const DWORD _dwSize);
	int   FindFirst(HARC _harc, LPCSTR _szWildName, INDIVIDUALINFO *lpSubInfo);
	int   FindNext(HARC _harc, INDIVIDUALINFO *_lpSubInfo);
	DWORD GetAccessTime(HARC _harc);
	BOOL  GetAccessTimeEx(HARC _harc, FILETIME *_lpftLastAccessTime);
	BOOL  GetArcAccessTimeEx(HARC _harc, FILETIME *_lpftLastAccessTime);
	DWORD GetArcCompressedSize(HARC _harc);
	BOOL  GetArcCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize);
	BOOL  GetArcCreateTimeEx(HARC _harc, FILETIME *_lpftCreationTime);
	WORD  GetArcDate(HARC _harc);
	int   GetArcFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize);
	DWORD GetArcFileSize(HARC _harc);
	BOOL  GetArcFileSizeEx(HARC _harc, ULHA_INT64 *_lpllSize);
	DWORD GetArcOriginalSize(HARC _harc);
	BOOL  GetArcOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize);
	int   GetArcOSType(HARC _harc);
	WORD  GetArcRatio(HARC _harc);
	DWORD GetArcReadSize(HARC _harc);
	BOOL  GetArcReadSizeEx(HARC _harc, ULHA_INT64 *_lpllSize);
	WORD  GetArcTime(HARC _harc);
	BOOL  GetArcWriteTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime);
	int   GetAttribute(HARC _harc);
	BOOL  GetBackGroundMode(void);
	DWORD GetCompressedSize(HARC _harc);
	BOOL  GetCompressedSizeEx(HARC _harc, ULHA_INT64 *_lpllSize);
	DWORD GetCRC(HARC _harc);
	DWORD GetCreateTime(HARC _harc);
	BOOL  GetCreateTimeEx(HARC _harc, FILETIME *_lpftCreationTime);
	WORD  GetCursorInterval(void);
	BOOL  GetCursorMode(void);
	WORD  GetDate(HARC _harc);
	int   GetFileCount(LPCSTR _szArcFile);
	int   GetFileName(HARC _harc, LPSTR _lpBuffer, const int _nSize);
	int   GetMethod(HARC _harc, LPSTR _lpBuffer, const int _nSize);
	DWORD GetOriginalSize(HARC _harc);
	BOOL  GetOriginalSizeEx(HARC _harc, ULHA_INT64 *_lpllSize);
	int   GetOSType(HARC _harc);
	WORD  GetRatio(HARC _harc);
	BOOL  GetRunning(void);
    WORD  GetSubVersion(void);
	WORD  GetTime(HARC _harc);
	WORD  GetVersion(void);
	DWORD GetWriteTime(HARC _harc);
	BOOL  GetWriteTimeEx(HARC _harc, FILETIME *_lpftLastWriteTime);
	int   IsSFXFile(HARC _harc);
	HARC  OpenArchive(const HWND _hwnd, LPCSTR _szFileName,const DWORD _dwMode);
	HARC  OpenArchive2(const HWND _hwnd, LPCSTR _szFileName,const DWORD _dwMode, LPCSTR _szOption);
	BOOL  QueryFunctionList(const int _iFunction);
	BOOL  SetBackGroundMode(const BOOL _bBackGroundMode);
	BOOL  SetCursorInterval(const WORD _Interval);
	BOOL  SetCursorMode(const BOOL _CursorMode);
	BOOL  SetPriority(const int _nPriority);

	//ǉr...(WAPI)
	//ǂ悤... (WAPI)
	int ExtractMem(const HWND _hwnd, LPCSTR _szCmdLine,
                   LPBYTE _szBuffer, const DWORD _dwSize, time_t *_lpTime,
                   LPWORD _lpwAttr, LPDWORD _lpdwWriteSize);
	int CompressMem(const HWND _hwnd, LPCSTR _szCmdLine,
                    const LPBYTE _szBuffer, const DWORD _dwSize,
                    const time_t *_lpTime, const LPWORD _lpwAttr,
                    LPDWORD _lpdwWriteSize);


	//g API n
	bool  GetDllName(char *dllname, int nsize);
	void  GetExtractCommand(char *command, int nsize);
	void  SetExtractCommand(char *command);

	//ǉr...(gAPI)
	//fpCurrentProcAddr  NULL Ȃ false, ȊOȂ true.
	//(DLL  Export ꂽ API 邩ǂ̗Lp)
	bool  IsApiCalled(void);  

};

#endif  //CBARCDLL_H
