#include "CBString.h"
#include "CBExtLst.h"

void CBExtLst::Init(char *Ext, char *dllname)
{
	this->strDllName.Copy(dllname);
	this->strExt.Copy(Ext);

	this->strDllName.ToUpper();
	this->strExt.ToLower();

	if(lstrlen(this->strDllName.Text) > 0 && lstrlen(this->strExt.Text) > 0)
	{
		this->isEnable = true;
	}
}

bool CBExtLst::IsEnable(void)
{
	return this->isEnable;
}

bool CBExtLst::GetDllName(char *dllname, int nsize)
{
	bool bRet = false;
	if(this->isEnable)
	{
		if(nsize > lstrlen(this->strDllName.Text))
		{
			lstrcpy(dllname,this->strDllName.Text);
			bRet = true;
		}
	}

	return bRet;
}

bool CBExtLst::GetExt(char *Ext, int nsize)
{
	bool bRet = false;
	if(this->isEnable)
	{
		if(nsize > lstrlen(this->strExt.Text))
		{
			lstrcpy(Ext,this->strExt.Text);
			bRet = true;
		}
	}

	return bRet;
}
