#include	"CBString.h"

CBString::CBString()
{
	this->Init(4096);
}

CBString::CBString(const unsigned int iStrLen)
{
	this->Init(iStrLen);
}

void CBString::Init(unsigned int iStrLen)
{
	this->hMemory = ::GlobalAlloc(GHND,sizeof(char)*iStrLen);
	this->Text    = (char *)::GlobalLock(hMemory);
	this->iMemSize = iStrLen;

	this->hWorkMemory = NULL;
	this->strWorkText = NULL;
}

void CBString::Copy(const char *str)
{
	unsigned int iMaxSize = lstrlen(str)+2;

	if(iMaxSize < this->iMemSize)
	{
		::lstrcpy(this->Text, str);
	}
	else
	{
		//j
		::GlobalUnlock(this->hMemory);
		::GlobalFree(this->hMemory);

		//Vm
		this->iMemSize = iMaxSize;
		this->hMemory = ::GlobalAlloc(GHND,sizeof(char)*iMaxSize);
		this->Text    = (char *)::GlobalLock(this->hMemory);

		//ăRs[B
		::lstrcpy(this->Text, str);
	}
}

void CBString::Cat(const char *str)
{
	unsigned int iMaxSize = lstrlen(this->Text) + lstrlen(str) + 2;

	if(iMaxSize < this->iMemSize)
	{
		::lstrcat(this->Text, str);
	}
	else
	{
		this->SetSize(iMaxSize);
		::lstrcat(this->Text, str);
	}
}

void CBString::Clear(void)
{
	lstrcpy(this->Text, "");
}

int  CBString::GetSize(void)
{
	return this->iMemSize;
}

void CBString::SetSize(const unsigned int iNewSize)
{
	//Vm
	this->hWorkMemory = ::GlobalAlloc(GHND,sizeof(char)*iNewSize);
	this->strWorkText = (char *)::GlobalLock(this->hWorkMemory);

	//V Text ̓eRs[
	::lstrcpyn(this->strWorkText, this->Text,iNewSize);

	//jƃQƐړ
	::GlobalUnlock(this->hMemory);
	::GlobalFree(this->hMemory);

	//|C^ړƐVTCYw
	this->iMemSize = iNewSize;
	this->Text     = this->strWorkText;
	this->hMemory  = this->hWorkMemory;

	//svƂȂ|C^QƂ NULL ɍď
	this->strWorkText = NULL;
	this->hWorkMemory = NULL;
}

CBString::~CBString()
{
	::GlobalUnlock(this->hMemory);
	::GlobalFree(this->hMemory);
}

/*
char * CBString::operator+(char *str)
{
	if( this->iMemSize > (strlen(this->Text)+strlen(str)+1) )
	{
		lstrcat(this->Text,str);
	}
	return this->Text;
}

char * CBString::operator=(char *str)
{
	if( this->iMemSize > (strlen(str)+1) )
	{
		lstrcpy(this->Text,str);
	}else
	{
		lstrcpy(this->Text, "");
	}
	return this->Text;
}
*/

char * CBString::ToString(void)
{
	return this->Text;
}

char * CBString::ToUpper(void)
{
	::CharUpper(this->Text);
	return this->Text;
}

char * CBString::ToLower(void)
{
	::CharLower(this->Text);
	return this->Text;
}

char * CBString::PathAddBackSlash(void)
{
	return (*CharPrev(this->Text,this->Text+lstrlen(this->Text) )=='\\' ? this->Text :  + lstrcat(this->Text,"\\"));
}

char * CBString::PathRemoveBackSlash(void)
{
	int iLastBs=0; //'\\' Last Backslash flag.
	int iBsHeaven=0; // '\\ \\ \\ \\ ..." Count.
	//C:\ -> return C:\ (not "c:" !)
	if(lstrlen(this->Text) <= 3) return this->Text;

	this->PathAddBackSlash();

	for(int i=0;i<lstrlen(this->Text);i++)
	{
		if(*(this->Text+i) == '\\')
		{
			iLastBs=i;
			iBsHeaven++;
		}else{
			iBsHeaven=0;
		}
		
		if(IsDBCSLeadByte(*(this->Text+i))==1)
		{
			iBsHeaven=0;
			i++; // i+=2!
		}
	}

	lstrcpyn(this->Text,this->Text,iLastBs-iBsHeaven+2); //+2 -> NULL BYTE + (-1[forHeaven])

	return this->Text;
}

char * CBString::PathGetDirectoryName(void)
{
	char *lpszPtr      = this->Text;
	char *lpszFinalPtr = this->Text;

	while(*lpszPtr != '\0'){
		//skiped for 2byte(left) character 
		if(IsDBCSLeadByte(*lpszPtr) == 0){
			//if [\],[/] found, save current pointer.
			if( (*lpszPtr == '\\') || (*lpszPtr == '/') ){
				lpszFinalPtr = lpszPtr;
			}
		}
		//next character.
		lpszPtr=CharNext(lpszPtr);
	}
	
	*lpszFinalPtr = '\0'; // final \\ pointer overwrited.

	this->PathAddBackSlash();

	return this->Text;
}

char * CBString::PathGetFileName(void)
{
	char *lpszPtr      = this->Text;
	char *lpszFinalPtr = this->Text;

	while(*lpszPtr != '\0'){
		//skiped for 2byte(left) character 
		if(IsDBCSLeadByte(*lpszPtr) == 0){
			//if [\],[/] found, save current pointer.
			if( (*lpszPtr == '\\') || (*lpszPtr == '/') ){
				lpszFinalPtr = lpszPtr;
			}
		}
		//next character.
		lpszPtr=CharNext(lpszPtr);
	}
	
	if(lpszFinalPtr != this->Text)
	{
		lstrcpy(this->Text,(lpszFinalPtr+1));
	}

	return this->Text;
}
char * CBString::PathGetExtension(void)
{
	this->PathGetFileName();

	char *lpszPtr      = this->Text;
	char *lpszFinalPtr = this->Text;
	bool isExtension   = false;

	while(*lpszPtr != '\0'){
		//skiped for 2byte(left) character 
		if(IsDBCSLeadByte(*lpszPtr) == 0){
			//if [.] found, save current pointer.
			if( *lpszPtr == '.' ){
				lpszFinalPtr = lpszPtr;
				isExtension  = true;
			}
		}
		//next character.
		lpszPtr=CharNext(lpszPtr);
	}

	if(isExtension)
	{
		lstrcpy(this->Text,lpszFinalPtr);
	}
	else
	{
		this->Clear();
	}

	return this->Text;
}


//idx: 1`B 0 ͎g܂B
bool CBString::GetParse(unsigned int idx, char *parsedstr,int iSize)
{
	bool bRet = false;
	lstrcpy(parsedstr,"");

	if(idx >= 1)
	{
		unsigned int iLoop = 1;
		char *CurrentStr; CurrentStr=parsedstr; //݂̕
		char *NextStr;    NextStr   =parsedstr; //̕
		char *WorkingStr; WorkingStr=parsedstr; //ƗpB
		if( (this->GetSize()) > iSize)
		{
			lstrcpy(parsedstr,"");
			return false;
		}

		lstrcpy(parsedstr,this->Text);
		while(*WorkingStr)
		{
			if(*WorkingStr == ',')
			{
				NextStr=WorkingStr+1;
				*WorkingStr = '\0';
				if(iLoop == idx)
				{
					break;
				}
				iLoop++;
				CurrentStr = NextStr;
			}
			WorkingStr++;
		}

		lstrcpy(parsedstr,CurrentStr);
		if(iLoop == idx && lstrlen(parsedstr) != 0) bRet = true;
	}
	return bRet;
}