using System;
using System.Text;
//DLLImportp
using System.Runtime.InteropServices;

namespace Archiver.Cald
{
    /// <summary>
    /// <see href="http://www.csdinc.co.jp/archiver/">A[JCoKi DLL</see>
    /// 舵{NXłB
    /// </summary>
    /// <preliminary>
    /// <para>̃NX Visual C# 2005 ł̂݌؂Ă܂B</para>
    /// </preliminary>
    /// <threadsafety static="false" instance="false" />
    /// <remarks>A[JCoKĩbp[ DLL ł CaldBase.dll oR UNLHA32.DLL  
    /// API ɃANZXł܂B<br />CaldBase.dll Ȃꍇ́A
    /// O𖳎ă_~[̕ԒlԂ܂B<br />
    /// {IɓA[JCoKi DLL Ăяo API `Ă܂A
    /// bp[ DLL Ǝ [CaldBase.NET g API] ɂẴNXŒ`Ă܂B
    /// </remarks>
    /// <seealso href="http://caldbase.sourceforge.jp/">CaldBase.NET</seealso>
    public class CaldBase
    {
        /// <summary>
        /// A[JCoKĩbp[ DLL ̂`Ă܂B
        /// </summary>
        private const string DllName = "CaldBase.dll";
        #region UNLHA32.DLL R̒`
        /// <summary>
        /// t@C̍ő咷`Ă܂B
        /// </summary>
        /// <remarks>
        /// t@C̃pX̍ő̒`Ă܂B(UNLHA32.H ɗRĂ܂)
        /// </remarks>
        public const int FNAME_MAX32 = 512;

        /// <summary>
        /// ɓ̃t@Cێ\̂łB
        /// </summary>
        /// <remarks>
        /// <see cref="FindFirst">FindFirst</see> / <see cref="FindNext">FindNext</see>
        /// Ŋi[t@Cێ\̂łB<br />
        /// t@CTCY : 32bit (4GB ܂)A : DOS `Ƃ邽߁A
        /// API ̏ڍ׏擾߂܂B<br />
        /// (UNLHA32.H ɗRĂ܂)
        /// </remarks>
        [StructLayout(LayoutKind.Sequential)]
        public struct INDIVIDUALINFO
        {
            /// <summary>
            /// kÕt@CTCYłB
            /// </summary>
            public UInt32 dwOriginalSize;
            /// <summary>
            /// k̃t@CTCYłB
            /// </summary>
            public UInt32 dwCompressedSize;
            /// <summary>
            /// i[t@C̃`FbNTp CRC łB
            /// </summary>
            /// <remarks>
            /// UNLHA32.DLL ɂĂ͏ 16 bit ͏ 0 ƂȂ܂A
            ///  DLL ł 32bit tɎgĂ邱Ƃ܂B
            /// </remarks>
            public UInt32 dwCRC;
            /// <summary>
            /// WJeXgsꍇAi[t@C̏ʂԂ܂B
            /// </summary>
            /// <remarks>
            /// R[h <see cref="Exec">Exec</see> n API Ԃ̂ƓA 0 i[܂B
            /// </remarks>
            public UInt32 uFlag;
            /// <summary>
            /// ̃t@C̍쐬Ɏgꂽ OS łB
            /// ڍׂ<see cref="GetArcOSType">GetArcOSType</see> ̖߂l̍ڂQƁB
            /// </summary>
            public UInt32 uOSType;
            /// <summary>
            /// p[~ (番) ŕ\ꂽki[܂B
            /// </summary>
            public UInt16 wRatio;
            /// <summary>
            /// ftime ̏ʃoCgƓ̍\ŌꂽtłB
            /// </summary>
            /// <remarks>
            /// C ŉL̂悤ɒ`ꂽlłB
            /// <code lang="C">
            /// struct {
            ///     unsigned ft_day   : 5;
            ///     unsigned ft_month : 4;
            ///     unsigned ft_year  : 7;
            /// } _DosDate;
            /// </code>
            /// ft_year Ɋi[l 1980 ŇoߔNłB
            /// āC_Iɂ 2107 Nς܂ŕ\ł邱ƂɂȂ܂B
            /// </remarks>
            public UInt16 wDate;
            /// <summary>
            /// ftime ̉ʃoCgƓ̍\ŌꂽłB
            /// </summary>
            /// <remarks>
            /// C ŉL̂悤ɒ`ꂽlłB
            /// <code lang="C">
            /// struct {
            ///     unsigned ft_tsec : 5;
            ///     unsigned ft_min  : 6;
            ///     unsigned ft_hour : 5;
            /// } _DosTime;
            /// </code>
            /// ft_tsec  Ɋi[lb 2 Ŋ̂ł_ɒӂĂB
            /// </remarks>
            public UInt16 wTime;
            /// <summary>
            /// t@Ci[܂B
            /// </summary>
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = FNAME_MAX32 + 1)]
            public string szFileName;
            /// <summary>
            /// gpłB
            /// </summary>
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 3)]
            public string dummy1;
            /// <summary>
            /// i[t@C̑i[܂B
            /// </summary>
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 8)]
            public string szAttribute;
            /// <summary>
            /// UNLHA32.DLL ł͈k`̕񂪊i[܂B<br />
            /// A[JCoKił́A̒l̓_~[ƂĂ܂B
            /// </summary>
            [MarshalAs(UnmanagedType.ByValTStr, SizeConst = 8)]
            public string szMode;
        }
        /// <summary>
        /// ɓ̃t@Cێs܂B
        /// </summary>
        /// <remarks>
        /// ֋X̂߂ɃNX <see cref="INDIVIDUALINFO">INDIVIDUALINFO \</see>
        /// ЂƂێĂ܂B
        /// </remarks>
        public INDIVIDUALINFO SubInfo;

        /// <summary>
        /// DLL Ԃl񋓑̂ƂĒ`Ă܂B
        /// </summary>
        /// <remarks><see cref="Exec">Exec</see> ԂxEG[̒l`Ă܂B<br />
        /// ̗񋓑̂̃hLg UNLHA32.DLL  API.TXT 甲̂Ȃ̂ŁA
        /// s_΃IWił UNLHA32.DLL  API.TXT QƂĂB<br />
        /// (UNLHA32.H ɗRĂ܂B)
        /// </remarks>
        public enum DllErrorResult
        {
            /// <summary>
            /// 0x8000 : G[`Jn̐lłB
            /// </summary>
            ERROR_START = 0x8000,
            /// <summary>
            /// 0x8005 : ɂ쐬t@CWJ邽߂̋󂫗eʂȂƂ܂B
            /// i[̓G[ƂȂ܂A
            /// WJ͓Yi[t@C̓WJXLbvĎ̃t@C̓WJɈڂ܂B
            /// </summary>
            ERROR_DISK_SPACE = 0x8005,  //WARNING START
            /// <summary>
            /// 0x8006 : Ǎp̊̃t@C݂邽߁A
            /// t@C̓WJsȂƂ܂B
            /// CD-ROM ɏƂcƂp^[ɂ̂Y܂B
            ///</summary>
            ERROR_READ_ONLY,
            /// <summary>
            /// 0x8007 : WJ̃fBNg`FbNi[t@C̃pXɂ
            /// fBNgč\z̃fBNg쐬mFɑ΂āA
            /// [U쐬𗹏ȂƂ܂B
            /// </summary>
            ERROR_USER_SKIP,
            /// <summary>
            ///0x8008 : i[t@C̎ނ MS-DOS ň`iBINARY y TEXTjȊOłB
            /// </summary>
            ERROR_UNKNOWN_TYPE,
            /// <summary>
            /// 0x8009 : DLL ňȂi[[hŊi[Ă܂B
            /// </summary>
            ERROR_METHOD,
            /// <summary>
            /// 0x800a : i[t@CɃpX[hĂ܂B
            /// </summary>
            ERROR_PASSWORD_FILE,
            /// <summary>
            /// 0x800b : i[t@C DLL ΉĂȂo[W̌`łB
            /// </summary>
            ERROR_VERSION,
            /// <summary>
            /// 0x800c : WJꂽ  (܂̓`FbN) t@C CRC ɂ̏
            /// قȂĂ邱Ƃ܂Bv͏Ƀt@C̃f[^łB
            /// </summary>
            ERROR_FILE_CRC,
            /// <summary>
            /// 0x800d : (ɂ) et@C̃I[v GetFileTime() API Ăяô߂ȂǁA
            /// I CreateFile() API ĂяosƂ܂B<br />
            /// kEi[悤Ƃt@Cl̃G[ƂȂꍇɂ ERROR_SHARING Ԃ܂B
            /// </summary>
            ERROR_FILE_OPEN,
            /// <summary>
            /// 0x800e : Vt@CȂǁAWJɊ̃t@C݂邱Ƃ܂B
            /// </summary>
            ERROR_MORE_FRESH,
            /// <summary>
            /// 0x800f : KvȊ̃t@CWJɑ݂ȂƂ܂B
            /// </summary>
            ERROR_NOT_EXIST,
            /// <summary>
            /// 0x8010 : (^CX^vɂ炸)
            /// ̊̃t@CWJɑ݂Ă邱Ƃ܂B
            /// </summary>
            ERROR_ALREADY_EXIST,
            /// <summary>
            /// 0x8011 : i[t@CEzĂ܂B
            /// ͐ɍsĂ܂AEzɂĂ͏͓Ă܂B
            /// </summary>
            ERROR_TOO_MANY_FILES,
            /// <summary>
            /// 0x8012 : fBNg̍쐬ɎsƂ܂B
            /// </summary>
            ERROR_MAKEDIRECTORY	= 0x8012,   //ERROR START
            /// <summary>
            /// 0x8013 : WriteFile() API Ăяo̎sɂt@C݃G[Sʂ܂B<br />
            /// ɑ쒆ɍƃfBNg݂̑fBXN̋󂫂ȂȂʁA
            /// Ƃp^[łB
            /// </summary>
            ERROR_CANNOT_WRITE,
            /// <summary>
            /// 0x8014 : i[t@CĂ܂B
            /// </summary>
            ERROR_HUFFMAN_CODE,
            /// <summary>
            /// 0x8015 : Ƀt@C̃Rgwb_Ă܂B
            /// </summary>
            ERROR_COMMENT_HEADER,
            /// <summary>
            /// 0x8016 : ɂ̃wb_ɋL^Ă 
            /// CRC Ǝۂɓǂݍ񂾃wb_ CRC vȂƂ܂B<br />
            /// wb_̃f[^łB
            /// </summary>
            ERROR_HEADER_CRC,
            /// <summary>
            /// 0x8017 : ɂ̃wb_jĂ邱Ƃ܂B
            /// </summary>
            ERROR_HEADER_BROKEN,
            /// <summary>
            /// 0x8018 : VKɂɂ̃I[vɎsƂ܂B<br />
            /// ڍׂ UNLHA32.DLL  API.TXT QƂĂB
            /// </summary>
            ERROR_ARC_FILE_OPEN,
            /// <summary>
            /// 0x8019 : <see cref="Exec">Exec</see> ɓnꂽR}hŏɂw肳ĂȂA
            /// DLL ɖFł܂łB
            /// </summary>
            ERROR_NOT_ARC_FILE,
            /// <summary>
            /// 0x801a : ReadFile() API  Ăяo̎sɂt@Cǂݍ݃G[Sʂ܂B
            /// </summary>
            ERROR_CANNOT_READ,
            /// <summary>
            /// 0x801b : w肳ꂽɂΉĂȂ`Ƃ܂B
            /// </summary>
            ERROR_FILE_STYLE,
            /// <summary>
            /// 0x801c : <see cref="Exec">Exec</see> ɓnꂽR}hɌ肪邱Ƃ܂B
            /// </summary>
            ERROR_COMMAND_NAME,
            /// <summary>
            /// 0x801d : Ɨpq[v̊m (^C malloc Ăяo) 
            /// ɎsƂ܂B
            /// </summary>
            ERROR_MORE_HEAP_MEMORY,
            /// <summary>
            /// 0x801e : ʂԂ߂̃obt@̊m  (GlobalAlloc() API Ăяo) 
            /// ɎsƂ܂B
            /// </summary>
            ERROR_ENOUGH_MEMORY,
            /// <summary>
            /// 0x801f : ł DLL 쒆 API ̑dĂяoƂ܂B
            /// </summary>
            ERROR_ALREADY_RUNNING,
            /// <summary>
            /// 0x8020 : [UIɏ𒆎~Ƃ܂B
            /// </summary>
            ERROR_USER_CANCEL,
            /// <summary>
            /// 0x8021 : <see cref="OpenArchive">OpenArchive</see> API Ăяo 
            /// HARC nhgp ( HARC nh̎f[^̈悪j󂳂ꂽ) Ƃ܂B
            /// <see cref="OpenArchive">OpenArchive</see> ŏɂƃnh֘AtO 
            /// <see cref="FindFirst">FindFirst</see>  API gpcƂႪwǂ߂܂B
            /// </summary>
            ERROR_HARC_ISNOT_OPENED,
            /// <summary>
            /// 0x8022 : <see cref="FindFirst">FindFirst</see> Ăяo 
            /// <see cref="FindNext">FindNext</see> ĂяoꂽB
            /// ܂́AĂяoO <see cref="GetFileName">GetFileName</see> 
            /// API ĂяoꂽƂ܂B
            /// </summary>
            ERROR_NOT_SEARCH_MODE,
            /// <summary>
            /// 0x8023 : DLL ŃT|[gĂȂ API gpꂽƂ܂B
            /// </summary>
            ERROR_NOT_SUPPORT,
            /// <summary>
            /// 0x8024 : wɌ肪邱Ƃ܂B
            /// </summary>
            ERROR_TIME_STAMP,
            /// <summary>
            /// 0x8025 : ɑ쎞Ɏgpƃt@CJȂƂ܂B<br />
            /// ڍׂ UNLHA32.DLL  API.TXT QƂĂB
            /// </summary>
            ERROR_TMP_OPEN,
            /// <summary>
            /// 0x8026 : (ChJ[hŎw肳ꂽꍇȂǂ)  i[t@CXg쐬ɁA
            /// YɂŐɈȂ\̂钷pX (t@C܂) 
            /// t@CƂ܂B
            /// </summary>
            ERROR_LONG_FILE_NAME,
            /// <summary>
            /// 0x8027 : Ǎp̏ɂɑ΂ďɑsƂƂ܂B
            /// </summary>
            ERROR_ARC_READ_ONLY,
            /// <summary>
            /// 0x8028 : (ɃpX𖳎ꍇȂǂ) 
            /// ɂɓOŊi[镡̃t@Ci[悤ƂƂ܂B
            /// </summary>
            ERROR_SAME_NAME_FILE,
            /// <summary>
            /// 0x8029 : ΏۏɂȂƂ܂B
            /// </summary>
            ERROR_NOT_FIND_ARC_FILE,
            /// <summary>
            /// 0x802a : (JȂꍇ܂߂) 
            /// w肳ꂽX|Xt@C̓ǍɎsƂ܂B
            /// </summary>
            ERROR_RESPONSE_READ,
            /// <summary>
            /// 0x802b : Ώۃt@Cw肷Kv̂鑀ɂāA
            /// Ώۃt@Cw肳ĂȂƂ܂B
            /// </summary>
            ERROR_NOT_FILENAME,
            /// <summary>
            /// 0x802c : ɑ̌ʂ𑀍ΏۏɂƂĕۑ邽߂̃Rs[Ɏs
            /// ܂B
            /// </summary>
            ERROR_TMP_COPY,
            /// <summary>
            /// 0x802d : ɂ̓ǍɁA\ȂӏŃt@C̏I肪mꂽƂ܂B
            /// </summary>
            ERROR_EOF,
            /// <summary>
            /// 0x802e : (UNLHA32.DLL p?) ΏۂƂĎw肳ꂽɂA
            /// ɑ̋ĂȂALARC  Lhasa ̎ȉ𓀏ɂł邱Ƃ܂B
            /// </summary>
            ERROR_ADD_TO_LARC,
            /// <summary>
            /// 0x802f : ɑ̌ʂ𑀍ΏۏɂƂĕۑ邽߂̋󂫗eʂ݂ĂȂ
            /// ܂B
            /// </summary>
            ERROR_TMP_BACK_SPACE,
            /// <summary>
            /// 0x8030 : kEi[悤Ƃt@CLG[Ȃǂ
            /// ANZXłȂƂ܂B
            /// </summary>
            ERROR_SHARING,
            /// <summary>
            /// 0x8031 : kEi[悤Ƃt@C 
            /// (O̊i[ΏۃXg쐬ɂ͌ɂ炸) 
            /// ȂƂ܂B
            /// </summary>
            ERROR_NOT_FIND_FILE,
            /// <summary>
            /// 0x8032 : Ot@Cւ݂̏sƂ܂B
            /// </summary>
            ERROR_LOG_FILE,
            /// <summary>
            /// 0x8033 : (CD-ROM  FD }ĂȂꍇȂ) foCX(hCu) 
            /// ɃANZXłȂƂ܂B
            /// </summary>
            ERROR_NO_DEVICE,
            /// <summary>
            /// 0x8034 : t@CSʂƂ  MyGetFileAttributes() sƂ܂B
            /// </summary>
            ERROR_GET_ATTRIBUTES,
            /// <summary>
            /// 0x8035 : t@CSʂƂ 
            /// SetFileAttributes() API ĂяoɎsƂ܂B
            /// </summary>
            ERROR_SET_ATTRIBUTES,
            /// <summary>
            /// 0x8036 : t@C̏擾Ă Myfindfirst()AGetDiskFreeSpace() APIA
            /// GetDiskFreeSpaceEx() APIAGetFileTime() API ĂяoɎsƂ܂B
            /// </summary>
            ERROR_GET_INFORMATION,
            /// <summary>
            /// 0x8037 : t@CSʂƂāAMyftell()A
            /// (|C^擾̂߂) SetFilePointer() API ̌ĂяosƂ܂B
            /// </summary>
            ERROR_GET_POINT,
            /// <summary>
            /// 0x8038 : t@CSʂƂ Myrewind()A
            /// MySetFilePointer2()AMyfseek() ̌ĂяosƂ܂B
            /// </summary>
            ERROR_SET_POINT,
            /// <summary>
            /// 0x8039 : FILETIMEAtime_t ԁAFILETIMEASYSTEMTIME ԁAftimeA FILETIME ԁA
            /// (FILETIME ł) [JAUTCԁAŁA^CX^v̕ϊsƂ܂B
            /// </summary>
            ERROR_CONVERT_TIME,
            /// <summary>
            /// 0x803a : et@C̃^CX^v擾ɎsƂ܂B
            /// </summary>
            ERROR_GET_TIME,
            /// <summary>
            /// 0x803b : et@C̃^CX^vݒɎsƂ܂B
            /// </summary>
            ERROR_SET_TIME,
            /// <summary>
            /// 0x803c : Jt@C邱ƂłȂƂ܂B
            /// </summary>
            ERROR_CLOSE_FILE,
            /// <summary>
            /// 0x803d : ERROR_MORE_HEAP_MEMORY Ƃ͈قȂA(ŏIIɃ^C malloc() ) 
            /// 擾q[v̉ɍsȂƂ܂B
            /// </summary>
            ERROR_HEAP_MEMORY,
            /// <summary>
            /// 0x803e : (DLL ŌĂяoĂ) FindClose() API 
            /// ̌ĂяoɎsƂ܂B
            /// </summary>
            ERROR_HANDLE,
            /// <summary>
            /// 0x803f : DLL  SłƔFĂ͈͊Õ^CX^vꂽƂ܂B
            /// </summary>
            ERROR_TIME_STAMP_RANGE,
            /// <summary>
            /// 0x8040 : ɑ̐퐫`FbNɒʂȂƂ܂B
            /// </summary>
            ERROR_MAKE_ARCHIVE,
            /// <summary>
            /// 0x8041 : gwb_tZpX  (yуt@C)̒ƁA
            /// ۂɋL^Ă閼O̒ƂvȂƂ܂B
            /// </summary>
            ERROR_NOT_CONFIRM_NAME,
            /// <summary>
            /// 0x8042 : wb_Ŏw肳ĂTCỸwb_ǂݍ݂ɎsƂ܂B
            /// </summary>
            ERROR_UNEXPECTED_EOF,
            /// <summary>
            /// 0x8043 : sȏI񂪏ɂ̃Gh}[NƂċL^Ă邱Ƃ܂B
            /// </summary>
            ERROR_INVALID_END_MARK,
            /// <summary>
            /// 0x8044 : ZIP ɂȂǁA ̏ɂɊi[Ă LZH ɂł 
            /// UNLHA32.DLL fƂ܂B
            /// </summary>
            ERROR_INVOLVED_LZH,
            /// <summary>
            /// 0x8045 : KvȏI񂪏ɂ̃Gh}[NƂċL^ĂȂƂ܂B
            /// </summary>
            ERROR_NO_END_MARK,
            /// <summary>
            /// 0x8046 : Ywb_̃TCYƂĕsȒlwb_ɋL^Ă邱Ƃ܂B
            /// </summary>
            ERROR_HDR_INVALID_SIZE,
            /// <summary>
            /// 0x8047 : DLL ňȂwb_`ł邱Ƃ܂B
            /// </summary>
            ERROR_UNKNOWN_LEVEL,
            /// <summary>
            /// 0x8048 : i[t@CĂƂ܂B
            /// </summary>
            ERROR_BROKEN_DATA,
            /// <summary>
            /// 0x8049 : fBNg⃋[gfBNgẑȂǁA
            /// 댯̂pXw肳ꂽƂ܂B
            /// </summary>
            ERROR_INVALID_PATH,
            /// <summary>
            /// 0x804a : t@C̑傫t@CVXeňTCY𒴂Ă邱Ƃ܂B
            /// </summary>
            ERROR_TOO_BIG,
            /// <summary>
            /// 0x804b : XCb`ŗ}wsgqt@C̓WJ
            /// sƂƂ܂B
            /// </summary>
            ERROR_EXECUTABLE_FILE = 0x804b,
            /// <summary>
            /// 0x804b : G[`I̐lłB
            /// </summary>
            ERROR_END = 0x804b
        }
        #endregion
        #region A[JCo API `
        //UNLHA32.DLL 
        [DllImport(DllName, CharSet=CharSet.Ansi)]
        private extern static UInt16 CaldGetVersion();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static UInt16 CaldGetSubVersion();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static UInt16 CaldGetCursorInterval();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetRunning();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetBackGroundMode();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetCursorMode();

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldQueryFunctionList(int _iFunction);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldSetPriority(int _nPriority);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldSetCursorMode(bool _CursorMode);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldSetBackGroundMode(bool _bBackGroundMode);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldSetCursorInterval(Int16 _Interval);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int Cald(IntPtr hwnd, string szCmdLine, 
            StringBuilder szOutput, UInt32 dwSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldConfigDialog(IntPtr hwnd, 
            StringBuilder szOptionBuffer, UInt32 iMode);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetMethod(IntPtr _harc, StringBuilder lpBuffer, UInt32 nSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldCheckArchive(string szFileName, int iMode);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetFileCount(string szArcFile);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static IntPtr CaldOpenArchive(IntPtr _hwnd, string szFileName, UInt32 dwMode);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static IntPtr CaldOpenArchive2(IntPtr _hwnd, string szFileName,
            UInt32 dwMode, string szOption);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldCloseArchive(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldFindFirst(IntPtr _harc, string szWildName, 
            ref INDIVIDUALINFO lpSubInfo);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldFindNext(IntPtr _harc, ref INDIVIDUALINFO lpSubInfo);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetFileName(IntPtr _harc, StringBuilder lpBuffer, UInt32 _nSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetArcFileName(IntPtr _harc, 
            StringBuilder lpBuffer, UInt32 _nSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetAccessTime(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetArcCompressedSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetArcFileSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetArcOriginalSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetCRC(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetCompressedSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetCreateTime(IntPtr _harc);
        
        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetOriginalSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetWriteTime(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetArcRatio(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static uint CaldGetArcReadSize(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetArcDate(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetArcTime(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetDate(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetTime(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetRatio(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetAttribute(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetArcOSType(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldGetOSType(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldIsSFXFile(IntPtr _harc);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcAccessTimeEx(IntPtr _harc, ref Int64 _lpftLastAccessTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcCreateTimeEx(IntPtr _harc, ref Int64 _lpftCreationTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcWriteTimeEx(IntPtr _harc, ref Int64 _lpftLastWriteTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetAccessTimeEx(IntPtr _harc, ref Int64 _lpftLastAccessTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetCreateTimeEx(IntPtr _harc, ref Int64 _lpftCreationTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetWriteTimeEx(IntPtr _harc, ref Int64 _lpftLastWriteTime);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcCompressedSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcFileSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcOriginalSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetArcReadSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetCompressedSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldGetOriginalSizeEx(IntPtr _harc, ref Int64 _lpllSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldExtractMem(IntPtr _hwnd, string _szCmdLine,
            StringBuilder _szBuffer, UInt32 _dwSize, ref UInt32 _lpTime, 
            ref UInt16 _lpwAttr, ref UInt32 lpdwWriteSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldCompressMem(IntPtr _hwnd, string _szCmdLine, string _szBuffer,
            UInt32 _dwSize, UInt32 _lpTime, UInt16 _lpwAttr, ref UInt32 lpdwWriteSize);
        #endregion
        #region CaldBase.dll ƎAPI `
        //CaldBase Ǝ API
        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static void CaldGetDllName(StringBuilder szDllName, UInt16 dwSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static int CaldSetDllName(string szDllName);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldSetDllIndex(UInt16 idx);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static void CaldGetExtractCommand(StringBuilder szExtractCommand, UInt32 dwSize);

        [DllImport(DllName, CharSet = CharSet.Ansi)]
        private extern static bool CaldIsApiCalled();
        #endregion


        /// <summary>
        /// CaldBase NX̃RXgN^łB
        /// </summary>
        /// <remarks>RXgN^łAg INDIVIDUALINFO ̏sĂ݂̂łB</remarks>
        public CaldBase()
        {
            SubInfo = new INDIVIDUALINFO();
        }

        #region UNLHA32.DLL ݊ API (OpenArchive svn) ̎
        /// <summary>
        /// ɂ̃`FbNs܂B
        /// </summary>
        /// <param name="FileName">`FbNׂɂ̃t@CB</param>
        /// <param name="Mode">`FbN[hBڍׂ͊e DLL ̃hLgQƂĂB</param>
        /// <returns>
        /// <paramref name="FileName"/> ȏɂ̏ꍇ <b>true</b>A
        /// sȏ(jɁAΉ`̏)̏ꍇ<b>false</b>Ԃ܂B
        /// </returns>
        /// <remarks>
        /// wt@CɂƂĐǂԂ܂B
        ///  API ̎dl\złƎv܂A
        /// ꂽɂPɃwb_ȂɂɂĂP false Ԃ܂B
        /// </remarks>
        /// <example>
        /// UNLHA32.DLL  lzh t@C̐sꍇ́Aȉ̃R[hƂȂ܂B
        /// <code lang="C#">
        /// CaldBase Cald = new CaldBase();
        /// Cald.SetDllName("UNLHA32.DLL");
        /// //CheckArchive  2  Mode = 0:CHECKARCHIVE_RAPID (ȈՃ[h)
        /// bool CheckFileValue = Cald.CheckArchive(@"D:\Sample.lzh",0); 
        /// </code>
        /// <code lang="VB">
        /// Visual Basic ̃Tv͂܂B
        /// </code>
        /// </example>
        public bool CheckArchive(string FileName, int Mode)
        {
            //[ " L菜B
            FileName = FileName.Trim('\"');
            try
            {
                //0:false / 1,2,3,... : true (BGA32.DLL AꕔCM[BOOLlԂDLL̂)
                return (CaldCheckArchive(FileName, Mode) != 0);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// DLL ̐ݒ_CAO / o[W_CAO\܂B
        /// </summary>
        /// <remarks>
        /// ݒ_CAO܂̓o[W_CAOĂяo܂B
        /// ݒ_CAOł͊fBNgXCb`w肳Ȃꍇ̓
        /// w肷邱Ƃł܂B
        /// DLL ɂĂ̓o[W\_CAOƂĎĂ邱Ƃ܂B
        /// </remarks>
        /// <param name="hwnd">_CAÕI[i[EEBhẼnhB</param>
        /// <param name="szOptionBuffer">
        /// WXgɏ܂eƓl̓sׂ̃R}h𓾂邽߂̃obt@B
        /// pӂobt@ 513 oCgȏƂ邱ƁB
        /// </param>
        /// <param name="iMode">
        /// WJƊi[̂ǂɂĂ̂̂w肵܂B
        /// (̎wɂ蓮؂ւ DLL ͏Ȃ悤ł)
        /// <list type="table">
        ///     <listheader>
        ///         <term><paramref name="iMode" /> ̒l</term>
        ///         <description>Ӗ</description>
        ///     </listheader>
        ///     <item>
        ///         <term>1 (UNPACK_CONFIG_MODE)</term>
        ///         <description>WJɂẴXCb`wB</description>
        ///     </item>
        ///     <item>
        ///         <term>2 (PACK_CONFIG_MODE)</term>
        ///         <description>i[ɂẴXCb`wB</description>
        ///     </item>
        /// </list>
        /// </param>
        /// <returns>
        /// ݒ肪ꍇ <b>0x1 (true )</b> A
        /// ݒ肪łȂꍇꂽꍇ <b>0x0 (false )</b> A
        /// DLL sŃ_CAOĂяoɎsꍇ 
        /// <b>0x801f (<see cref="DllErrorResult">DllErrorResult.ERROR_ALREADY_RUNNING</see>)</b>
        /// Ԃ܂B
        /// </returns>
        /// <example>
        /// C#  UNLHA32.DLL ̐ݒ_CAOĂяoꍇAȉ̂悤ɂ܂B
        /// <code lang="C#">
        /// StringBuilder Option = new StringBuilder(768);
        /// CaldBase Cald = new CaldBase();
        /// Cald.SetDllName("UNLHA32.DLL");
        /// Cald.ConfigDialog(this.Handle, Option, 1);
        /// </code>
        /// <code lang="VB">
        /// Visual Basic ̃Tv͂܂B
        /// </code>
        /// </example>
        public int ConfigDialog(IntPtr hwnd, StringBuilder szOptionBuffer, UInt32 iMode)
        {
            try
            {

                int iRet = CaldConfigDialog(hwnd, szOptionBuffer, iMode);

                //TAR32.DLL ̈ꕔ DLL  Output ɓĂ镶̉sR[h
                //CrLf ł͂Ȃ̂ŁACrLf ɒuB
                const string TempCrLf = "<br />";
                szOptionBuffer.Replace(Environment.NewLine, TempCrLf);
                szOptionBuffer.Replace("\r", TempCrLf);
                szOptionBuffer.Replace("\n", TempCrLf);
                szOptionBuffer.Replace(TempCrLf, Environment.NewLine);

                return iRet;
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// R}h^ďɑʂs܂B
        /// </summary>
        /// <remarks>
        /// R}h^āAȅɑs܂B
        /// A[JCoKi API Prefix  API ĂяoĂ܂
        /// (UNLHA32.DLL Ȃ Unlha() ɑ)B
        /// R}h̏ڍׂ́Ae DLL ̃hLgQƂĂB
        /// </remarks>
        /// <param name="hwnd">DLL ĂяoAṽEBhẼnhB</param>
        /// <param name="CommandLine">DLL ɓnR}h̕B
        /// ڍׂ͊e DLL ̃hLgQƂĂB</param>
        /// <param name="Output">DLL ʂԂ߂̃obt@B
        /// Ŏw肷obt@ɂẮA
        /// dwSize ŎTCYۏ؂ĂKv܂B</param>
        /// <param name="dwSize"> obt@̃TCYB
        /// DLL Ԃʂ̃TCYw肳ꂽTCYꍇ͎wTCY܂ŏo͂܂B</param>
        /// <returns>
        /// I̎ <b>0x0</b> Ԃ܂B
        /// G[ꍇ <b><see cref="DllErrorResult">0x8000` ̃G[R[h</see></b>
        /// Ԃ܂B
        /// </returns>
        /// <example>
        /// R}hɂđ푽lȏs邽߁ATv͂܂B
        /// </example>
        public int Exec(IntPtr hwnd, string CommandLine, StringBuilder Output, uint dwSize)
        {
            try
            {

                int iRet = Cald(hwnd, CommandLine, Output, dwSize/*(uint)Output.Capacity*/);

                //TAR32.DLL ̈ꕔ DLL  Output ɓĂ镶̉sR[h
                //CrLf ł͂Ȃ̂ŁACrLf ɒuB
                const string TempCrLf = "<br />";
                Output.Replace(Environment.NewLine, TempCrLf);
                Output.Replace("\r", TempCrLf);
                Output.Replace("\n", TempCrLf);
                Output.Replace(TempCrLf, Environment.NewLine);

                return iRet;
            }
            catch
            {
                return 0;
            }
        }
        /// <summary>
        /// J[\\[h̎擾s܂B
        /// </summary>
        /// <remarks>
        /// DLL ̓쒆ɃJ[\\郂[hۂ𓾂܂B
        /// </remarks>
        /// <returns>J[\\[hł <b>true</b> Ԃ܂B<br />
        /// J[\\[hł <b>false</b> Ԃ܂B</returns>
        public bool GetCursorMode()
        {
            try
            {
                return CaldGetCursorMode();
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// i[t@C̎擾s܂B
        /// </summary>
        /// <remarks>
        /// w肳ꂽɃt@CɊi[Ăt@C𓾂܂B
        /// </remarks>
        /// <param name="FileName">i[t@C𓾂Ƀt@CB</param>
        /// <returns>
        /// <paramref name="FileName"/> Ɋi[ꂽt@C𓾂܂B
        /// G[̂Ƃ <b>-1</b> Ԃ܂B
        /// </returns>
        public int GetFileCount(string FileName)
        {
            //[ " L菜B
            FileName = FileName.Trim('\"');
            try
            {
                return CaldGetFileCount(FileName);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// DLL ̓샂[h̎擾s܂B
        /// </summary>
        /// <remarks>DLL obNOEh[hۂ𓾂܂B</remarks>
        /// <returns>obNOEh[hł <b>true</b> Ԃ܂B<br />
        /// obNOEh[hł <b>false</b> Ԃ܂B</returns>
        public bool GetBackGroundMode()
        {
            try
            {
                return CaldGetBackGroundMode();
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// ]^C~O̎擾s܂B
        /// </summary>
        /// <returns>J[\̉]ximsec)</returns>
        /// <remarks>
        /// J[\̉]x𓾂܂A
        /// ]J[\T|[gĂȂ DLL (UNLHA32.DLL )ł͖ӖłB
        /// </remarks>
        public int GetCursorInterval()
        {
            try
            {
                return CaldGetCursorInterval();
            }
            catch
            {
                return 0;
            }

        }
        /// <summary>
        /// DLL ̎s󋵂̎擾s܂B
        /// </summary>
        /// <remarks>
        ///  DLL 쒆ۂ𓾂܂B
        /// sɑΉĂȂ DLL 邽߁A
        /// Ɏs\ꍇ̓Av API 
        /// ĂяoOɃ`FbNs悤ɂĂB
        /// </remarks>
        /// <returns>
        /// sł <b>true</b> Ԃ܂B
        /// słȂ <b>false</b> Ԃ܂B
        /// </returns>
        public bool GetRunning()
        {
            try
            {
                return CaldGetRunning();
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// DLL ̔ł̎擾s܂B(ʂQ[h)
        /// </summary>
        /// <returns>DLL ̃o[W 1.45.3.9 ȂA309 Ԃ܂B<br />
        /// o[W a.bc.d.e ƂȂAd * 100 + e ̒lԂƂɂȂ܂B<br />
        /// <note type="implementnotes"><br />
        /// a.bc ̎擾ɂ <see cref="GetVersion">GetVersion</see> gpĂB
        /// </note>
        /// </returns>
        public int GetSubVersion()
        {
            try
            {
                return CaldGetSubVersion();
            }
            catch
            {
                return 0;
            }

        }
        /// <summary>
        /// DLL ̔ł̎擾s܂B
        /// </summary>
        /// <remarks>DLL ̃o[WԂ܂B</remarks>
        /// <returns>Ő 100 |̂ԂĂ܂B
        /// <list type="table">
        ///     <listheader>
        ///         <term>o[W̗</term>
        ///         <description>API ̖߂l</description>
        ///     </listheader>
        ///     <item>
        ///         <term>0.01</term>
        ///         <description>1</description>
        ///     </item>
        ///     <item>
        ///         <term>1.45</term>
        ///         <description>145</description>
        ///     </item>
        /// </list>
        /// </returns>
        public int GetVersion()
        {
            try
            {
                return CaldGetVersion();
            }
            catch
            {
                return 0;
            }

        }
        /// <summary>
        /// Ή API ̖₢킹s܂B
        /// </summary>
        /// <remarks>w肳ꂽ API gp\ǂ𓾂܂B</remarks>
        /// <param name="Function">API lȐlB
        /// ̓IȐlɂĂ UNLHA32.H ̃wb_t@CQƂĉB</param>
        /// <returns>
        /// API gp\Ȃ <b>true</b> ԂAgps\Ȃ <b>false</b> Ԃ܂B<br />
        /// Function ɖȒlnꍇ <b>false</b> Ԃ܂B
        /// </returns>
        public bool QueryFunctionList(int Function)
        {
            try
            {
                return CaldQueryFunctionList(Function);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// DLL ̓샂[h̐ݒs܂B
        /// </summary>
        /// <remarks>DLL ̃obNOEh[hݒ肵܂B</remarks>
        /// <param name="BackGroundMode">
        /// obNOEh[h̏ꍇ true n܂B<br />
        /// obNOEh[h̏ꍇ false n܂B
        /// </param>
        /// <returns>
        /// Ȉꍇ <b>true</b> Ԃ܂B<br />
        /// 쒆ŕύXłȂꍇA 
        /// ԈႢ̏ꍇɂ <b>false</b> Ԃ܂B
        /// </returns>
        public bool SetBackGroundMode(bool BackGroundMode)
        {
            try
            {
                return CaldSetBackGroundMode(BackGroundMode);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// J[\\[h̐ݒs܂B
        /// </summary>
        /// <remarks>DLL ̓쒆ɃJ[\\邩ۂݒ肵܂B</remarks>
        /// <param name="CursorMode">J[\\̂ł true n܂B
        /// J[\\Ȃ̂ł false n܂B</param>
        /// <returns>
        /// Ȉꍇ <b>true</b> Ԃ܂B<br />
        /// 쒆ŕύXłȂꍇA ԈႢ̏ꍇɂ <b>false</b> Ԃ܂B
        /// </returns>
        public bool SetCursorMode(bool CursorMode)
        {
            try
            {
                return CaldSetCursorMode(CursorMode);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// ]^C~O̐ݒs܂B
        /// </summary>
        /// <remarks>J[\̉]xݒ肵܂BADLL ̓쒆ɂ͕ύXł܂B</remarks>
        /// <param name="Interval">J[\̉]ximsec)BftHg 80 (msec) łB</param>
        /// <returns>Ȉꍇ <b>true</b> Ԃ܂B<br />
        /// 쒆ŕύXłȂꍇɂ <b>false</b> Ԃ܂B</returns>
        public bool SetCursorInterval(Int16 Interval)
        {
            try
            {
                return CaldSetCursorInterval(Interval);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// Dx̐ݒs܂B
        /// </summary>
        /// <remarks>DLL ̗D揇 (vCIeB) w肵܂B</remarks>
        /// <param name="Priority">D揇ʁBȉ̒lwł܂F
        /// <list type="table">
        ///   <listheader>
        ///     <term>nׂl</term>
        ///     <description>Ӗ</description>
        ///   </listheader>
        ///   <item>
        ///     <term>2 (THREAD_PRIORITY_HIGHEST)</term>
        ///     <description>XbhW̑ΗD揇ʂ 2 |CgD揇ʂw肵܂B
        ///     </description>
        ///   </item>
        ///   <item>
        ///     <term>1 (THREAD_PRIORITY_ABOVE_NORMAL)</term>
        ///     <description>XbhW̑ΗD揇ʂ  1 |CgD揇ʂw肵܂B
        ///     </description>
        ///   </item>
        ///   <item>
        ///     <term>0 (THREAD_PRIORITY_NORMAL)</term>
        ///     <description>XbhW̑ΗD揇ʂw肵܂B</description>
        ///   </item>
        ///   <item>
        ///     <term>-1 (THREAD_PRIORITY_BELOW_NORMAL)</term>
        ///     <description>XbhW̑ΗD揇ʂ 1 |CgႢD揇ʂw肵܂B
        ///     </description>
        ///   </item>
        ///   <item>
        ///     <term>-2 (THREAD_PRIORITY_LOWEST)</term>
        ///     <description>XbhW̑ΗD揇ʂ 2 |CgႢD揇ʂw肵܂B
        ///     </description>
        ///   </item>
        ///   <item>
        ///     <term>-15 (THREAD_PRIORITY_IDLE)</term>
        ///     <description>{D揇ʂƂ  1 w肵܂B</description>
        ///   </item>
        ///   <item>
        ///     <term>̑ (l)</term>
        ///     <description>DLL   API ̎sɗD揇ʂ̐ݒsȂ悤w肵܂</description>
        ///   </item>
        /// </list>
        /// </param>
        /// <returns>
        ///  <b>true</b> Ԃ܂Bsꍇ <b>false</b> Ԃ܂B
        /// </returns>
        public bool SetPriority(int Priority)
        {
            try
            {
                return CaldSetPriority(Priority);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// ւ̓WJs܂B
        /// </summary>
        /// <remarks>
        /// obt@֓WJ܂B
        /// cOȂA<paramref name="WriteSize" /> Ŏw肵TCYƂɕɕďc
        /// Ƃgp@͍s܂B
        /// </remarks>
        /// <param name="hwnd">
        /// DLL ĂяoAṽEBhẼnhB
        /// EBhE݂ȂR\[Av̏ꍇA
        /// w肷Kv̂Ȃꍇ IntPtr.Zero (null ) n܂B
        /// </param>
        /// <param name="CommandLine">DLL ɓnR}h̕B
        /// <see cref="Exec">Exec</see> Ɠ̂wł܂AR}h͖܂B</param>
        /// <param name="Buffer">WJC[Wi[obt@B
        /// Ŏw肷obt@ɂẮA
        /// <paramref name="Size" /> ŎTCYۏ؂ĂKv܂B</param>
        /// <param name="Size">obt@̃TCYB
        /// DLL Ԃʂ̃TCYw肳ꂽTCYꍇ͎wTCY܂ŏo͂܂B</param>
        /// <param name="Time">WJꂽt@C UTC ł̃^CX^v𓾂܂B</param>
        /// <param name="Attr">WJꂽt@C̑𓾂܂B</param>
        /// <param name="WriteSize">WJ̌ʏ܂ꂽTCY𓾂܂B</param>
        /// <returns>I̎ <b>0</b> A
        /// G[ꍇ <b>0 ȊO̒l</b>Ԃ܂B</returns>
        public int ExtractMem(IntPtr hwnd, string CommandLine, StringBuilder Buffer,
            UInt32 Size, ref UInt32 Time, ref UInt16 Attr, ref UInt32 WriteSize)
        {
            try
            {
                return CaldExtractMem(hwnd, CommandLine, Buffer, Size, ref Time, ref Attr, ref WriteSize);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// ̊i[s܂B
        /// </summary>
        /// <remarks>
        /// obt@̓ekďɂɊi[܂B
        /// cOȂAɏɂ쐬킯ł͂܂B</remarks>
        /// <param name="hwnd">
        /// DLL ĂяoAṽEBhẼnhB
        /// EBhE݂ȂR\[Av̏ꍇA
        /// w肷Kv̂Ȃꍇ IntPtr.Zero (null )n܂B
        /// </param>
        /// <param name="CommandLine">
        /// DLL ɓnR}h̕B
        /// t@CƂĎw肵̂i[̖OɂȂ܂B
        /// </param>
        /// <param name="Buffer">kC[Wi[obt@B</param>
        /// <param name="Size">C[W̃TCYB</param>
        /// <param name="Time">i[鎞 UTC Ŏw肵܂B</param>
        /// <param name="Attr">i[鑮w肵܂B</param>
        /// <param name="WriteSize">k̃TCY𓾂܂B</param>
        /// <returns>
        /// I̎ <b>0</b> Ԃ܂B
        /// G[ꍇ <b>0 ȊO̒l</b>Ԃ܂B
        /// </returns>
        public int CompressMem(IntPtr hwnd, string CommandLine, string Buffer,
            UInt32 Size, UInt32 Time, UInt16 Attr, ref UInt32 WriteSize)
        {
            try
            {
                return CaldCompressMem(hwnd, CommandLine, Buffer, Size, Time, Attr, ref WriteSize);
            }
            catch
            {
                return -1;
            }
        }
        #endregion
        #region UNLHA32.DLL ݊ API (OpenArchive Kvn) ̎
        /// <summary>
        /// ɂ̃I[vs܂B
        /// </summary>
        /// <remarks>
        /// nhƏɃt@Cѕt܂B
        /// </remarks>
        /// <param name="hwnd">DLL ĂяoAṽEBhẼnhB</param>
        /// <param name="FileName">Ƀt@CB</param>
        /// <param name="Mode"><see cref="FindFirst">FindFirst</see> ̏̃[hB</param>
        /// <returns>
        /// w̏Ƀt@CɑΉnhB
        /// G[ <b>IntPtr.Zero</b> Ԃ܂B
        /// </returns>
        /// <example>
        /// OpenArchive nł̑܂ȏ̗͎̂悤ɂȂ܂B
        /// <code lang="C#">
        /// //̃R[h͓쌟؂Ă܂B܂ȗ𗝉邽߂ƍlĂB
        /// CaldBase Cald = new CaldBase();
        /// string FileName = @"D:\ArchiveFileName.lzh";
        /// if(Cald.CheckArchive(FileName) == true)
        /// {
        ///     IntPtr ArcHandle = Cald.OpenArchive(FileName);
        ///     if(ArcHandle != IntPtr.Zero)
        ///     {
        ///         if(Cald.FindFirst(ArcHandle,"*", null) == 0)
        ///         {
        ///             do
        ///             {
        ///                 //  c
        ///                 //API ȂǂŊi[ꂽt@C̏擾B
        ///                 //  c
        ///             }while(Cald.FindNext(ArcHandle,null)==0);
        ///         }
        ///         Cald.CloseArchive(ArcHandle);
        ///     }
        /// }
        /// </code>
        /// </example>
        /// <seealso cref="CloseArchive" />
        /// <seealso cref="FindFirst" />
        /// <seealso cref="FindNext" />
        public IntPtr OpenArchive(IntPtr hwnd, string FileName, uint Mode)
        {
            //[ " L菜B
            FileName = FileName.Trim('\"');
            try
            {
                return CaldOpenArchive(hwnd, FileName, Mode);
            }
            catch
            {
                return IntPtr.Zero;
            }
        }
        /// <summary>
        /// XCb`w肵ďɂ̃I[vs܂B
        /// </summary>
        /// <remarks>
        /// nhƏɃt@Cѕt܂B
        /// {I <see cref="OpenArchive">OpenArchive</see> ƓłA
        ///  <see cref="Exec">Exec</see> Ɠl̃XCb`w肷邱Ƃł܂B
        /// </remarks>
        /// <param name="hwnd">DLL ĂяoAṽEBhẼnhB</param>
        /// <param name="FileName">Ƀt@CB</param>
        /// <param name="Mode"><see cref="FindFirst">FindFirst</see> ̏̃[hB</param>
        /// <param name="Option">
        /// XCb`B<see cref="Exec">Exec</see> Ɠ̂w\łA
        /// X|Xt@C͎gpł܂񂵁ARȂwł̂̓XCb`łB</param>
        /// <returns>
        /// w̏Ƀt@CɑΉnhB
        /// G[ <b>IntPtr.Zero</b> Ԃ܂B
        /// </returns>
        /// <seealso cref="CloseArchive" />
        /// <seealso cref="FindFirst" />
        /// <seealso cref="FindNext" />
        public IntPtr OpenArchive2(IntPtr hwnd, string FileName, uint Mode, string Option)
        {
            //[ " L菜B
            FileName = FileName.Trim('\"');
            try
            {
                return CaldOpenArchive2(hwnd, FileName, Mode, Option);
            }
            catch
            {
                return IntPtr.Zero;
            }
        }
        /// <summary>
        /// ɂ̃N[Ys܂B
        /// </summary>
        /// <remarks>
        /// <see cref="OpenArchive">OpenArchive</see> Ŋtnh܂B
        /// </remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>Iɂ <b>0</b> Ԃ܂B</returns>
        /// <seealso cref="OpenArchive" />
        public int CloseArchive(IntPtr harc)
        {
            try
            {
                return CaldCloseArchive(harc);
            }
            catch
            {
                return 0;
            }
        }
        /// <summary>
        /// i[t@Čs܂B
        /// </summary>
        /// <remarks>ŏ̊i[t@C̏𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="wildname">t@CBt@C͕w肪\B</param>
        /// <param name="subinfo">
        /// ʂԂ߂ 
        /// <see cref="INDIVIDUALINFO">INDIVIDUALINFO \</see>ւ ref QƁB
        /// </param>
        /// <returns>
        /// I <paramref name="subinfo"/> Ɋi[t@C̏i[
        /// <b>0</b> Ԃ܂B
        /// I <b>-1</b> Ԃ܂B
        /// <b><see cref="DllErrorResult">0x8000` ُ̈IR[h</see></b>
        /// ԂƂ܂B
        /// </returns>
        /// <seealso cref="OpenArchive" />
        /// <seealso cref="CloseArchive" />
        /// <seealso cref="FindNext" />
        public int FindFirst(IntPtr harc, string wildname, ref INDIVIDUALINFO subinfo)
        {
            try
            {
                return CaldFindFirst(harc, wildname, ref subinfo);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// i[t@Čs܂B
        /// </summary>
        /// <remarks>2 Ԗڈȍ~̊i[t@C̏𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="subinfo">
        /// ʂԂ߂ <see cref="INDIVIDUALINFO">INDIVIDUALINFO \</see>
        /// ւ ref QƁB
        /// </param>
        /// <returns>
        /// I <paramref name="subinfo"/> Ɋi[t@C̏i[ 
        /// <b>0</b> Ԃ܂B
        /// I <b>-1</b> Ԃ܂B
        /// <b><see cref="DllErrorResult">0x8000` ُ̈IR[h</see></b>ԂƂ܂B
        /// </returns>
        /// <seealso cref="OpenArchive" />
        /// <seealso cref="CloseArchive" />
        /// <seealso cref="FindFirst" />
        public int FindNext(IntPtr harc, ref INDIVIDUALINFO subinfo)
        {
            try
            {
                return CaldFindNext(harc, ref subinfo);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// QƓ̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̎QƓ𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// i[t@C UNIX ` UTC ɂQƓB
        /// G[ <b>uint.MaxValue (-1 )</b>Ԃ܂B
        /// UNIX `Ƃ́AJan.1,1970 00:00:00 ̕błB
        /// </returns>
        public uint GetAccessTime(IntPtr harc)
        {
            try
            {
                return CaldGetAccessTime(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        /// <summary>
        /// kTCY̎擾s܂B
        /// </summary>
        /// <remarks>
        /// Ƀ}b`t@C̈kTCY̍v𓾂܂B<br />
        /// <b><see cref="FindNext">FindNext</see> 
        /// ̌IĂĂяo悤ɂĂB</b>
        /// </remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>kTCY̍vBG[ɂ <b>uint.MaxValue (-1 )</b> Ԃ܂B</returns>
        public uint GetArcCompressedSize(IntPtr harc)
        {
            try
            {
                return CaldGetArcCompressedSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        /// <summary>
        /// ɍXV̎擾s܂B
        /// </summary>
        /// <remarks>Ƀt@C̓t DOS `œ܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// Ƀt@C̓tBG[ɂ <b>-1</b> Ԃ܂B
        /// ` <see cref="INDIVIDUALINFO">INDIVIDUALINFO \</see>Ɋi[̂ƓŁA
        /// ftime ̏ʃoCgƓ\ɂȂĂ܂B
        /// N 1980 ŇoߔN\ĂA2107 Nς܂ŕ\ł܂B
        /// </returns>
        public int GetArcDate(IntPtr harc)
        {
            try
            {
                return CaldGetArcDate(harc);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// ɖ̎擾s܂B
        /// </summary>
        /// <remarks>Ƀt@C𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="lpBuffer">t@Ci[obt@B</param>
        /// <param name="nSize">obt@̃TCYB</param>
        /// <returns>I <b>0</b> Ԃ܂B</returns>
        public int GetArcFileName(IntPtr harc, StringBuilder lpBuffer, uint nSize)
        {
            try
            {
                return CaldGetArcFileName(harc, lpBuffer, nSize);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// ɃTCY̎擾s܂B
        /// </summary>
        /// <remarks>Ƀt@C̃TCY𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// Ƀt@C̃TCYB
        /// G[ɂ <b>uint.MaxValue (-1 )</b> Ԃ܂B
        /// </returns>
        public uint GetArcFileSize(IntPtr harc)
        {
            try
            {
                return CaldGetArcFileSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        /// <summary>
        /// WJTCY̎擾s܂B
        /// </summary>
        /// <remarks>
        /// Ƀ}b`t@C̃TCY̍v𓾂܂B
        /// <see cref="FindNext">FindNext</see> ̌IłȂƕԋplɈӖ͂܂B
        /// ̏ꍇ͂܂łɃ}b`t@C̍vƂȂ܂B<br />
        /// <b><see cref="FindNext">FindNext</see> ̌IĂĂяo悤ɂĂB</b>
        /// </remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// Ƀt@C̃TCYBG[ɂ <b>uint.MaxValue (-1 )</b> Ԃ܂B
        /// </returns>
        public uint GetArcOriginalSize(IntPtr harc)
        {
            try
            {
                return CaldGetArcOriginalSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        /// <summary>
        /// gp OS ̎擾s܂B
        /// </summary>
        /// <remarks>Ƀt@C쐬Ɏgpꂽ OS ̎ނ𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>OS ̎ނŁAL̂ƂłB
        /// <note type="implementnotes"><br />
        /// Windows ňkɂł <b>0</b> Ԃ邱Ƃ܂</note>
        /// <list type="table">
        ///     <listheader>
        ///         <term>߂l</term>
        ///         <description>OS ̎</description>
        ///     </listheader>
        ///     <item>
        ///         <term>0</term>
        ///         <description>MS-DOS</description>
        ///     </item>
        ///     <item>
        ///         <term>1</term>
        ///         <description>PRIMOS</description>
        ///     </item>
        ///     <item>
        ///         <term>2</term>
        ///         <description>UNIX</description>
        ///     </item>
        ///     <item>
        ///         <term>3</term>
        ///         <description>AMIGA</description>
        ///     </item>
        ///     <item>
        ///         <term>4</term>
        ///         <description>MacOS</description>
        ///     </item>
        ///     <item>
        ///         <term>5</term>
        ///         <description>OS/2</description>
        ///     </item>
        ///     <item>
        ///         <term>6</term>
        ///         <description>APPLE GS</description>
        ///     </item>
        ///     <item>
        ///         <term>7</term>
        ///         <description>ATARI GS</description>
        ///     </item>
        ///     <item>
        ///         <term>8</term>
        ///         <description>NeXT</description>
        ///     </item>
        ///     <item>
        ///         <term>9</term>
        ///         <description>VAX VMS</description>
        ///     </item>
        ///     <item>
        ///         <term>10</term>
        ///         <description>̑</description>
        ///     </item>
        ///     <item>
        ///         <term>11</term>
        ///         <description>OS9 (not MacOS9)</description>
        ///     </item>
        ///     <item>
        ///         <term>12</term>
        ///         <description>OS/68K</description>
        ///     </item>
        ///     <item>
        ///         <term>13</term>
        ///         <description>OS/386</description>
        ///     </item>
        ///     <item>
        ///         <term>14</term>
        ///         <description>HUMAN</description>
        ///     </item>
        ///     <item>
        ///         <term>15</term>
        ///         <description>CP/M</description>
        ///     </item>
        ///     <item>
        ///         <term>16</term>
        ///         <description>FLEX</description>
        ///     </item>
        ///     <item>
        ///         <term>17</term>
        ///         <description>Runser</description>
        ///     </item>
        ///     <item>
        ///         <term>18</term>
        ///         <description>Windows NT</description>
        ///     </item>
        ///     <item>
        ///         <term>19</term>
        ///         <description>Windows 95</description>
        ///     </item>
        ///     <item>
        ///         <term>20</term>
        ///         <description>TOPS20</description>
        ///     </item>
        ///     <item>
        ///         <term>21</term>
        ///         <description>Windows CE</description>
        ///     </item>
        ///     <item>
        ///         <term>22</term>
        ///         <description>QDOS</description>
        ///     </item>
        ///     <item>
        ///         <term>23</term>
        ///         <description>VFAT95</description>
        ///     </item>
        ///     <item>
        ///         <term>24</term>
        ///         <description>MVS</description>
        ///     </item>
        ///     <item>
        ///         <term>25</term>
        ///         <description>BEBOX</description>
        ///     </item>
        ///     <item>
        ///         <term>26</term>
        ///         <description>VM CMS</description>
        ///     </item>
        ///     <item>
        ///         <term>27</term>
        ///         <description>Z SYSTEM</description>
        ///     </item>
        ///     <item>
        ///         <term>28</term>
        ///         <description>TAMDEM CSK</description>
        ///     </item>
        ///     <item>
        ///         <term>-1</term>
        ///         <description>G[</description>
        ///     </item>
        /// </list>
        /// </returns>
        public int GetArcOSType(IntPtr harc)
        {
            try
            {
                return CaldGetArcOSType(harc);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// k̎擾s܂B
        /// </summary>
        /// <remarks>Ƀ}b`t@C̑Ŝ̈k𓾂܂B
        /// <b><see cref="FindNext">FindNext</see> ̌IĂĂяo悤ɂĂB</b>
        /// </remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// p[~ (番) ŌꂽŜ̈kBG[ɂ <b>-1</b> Ԃ܂B<br />
        /// <note type="implementnotes"><br />
        /// (kTCY̍v / t@C̍vTCY) * 1000  ̌vZɂ苁߂邱ƂA
        /// 1000 𒴂ꍇ_ɒӂĂB
        /// </note>
        /// </returns>
        public int GetArcRatio(IntPtr harc)
        {
            try
            {
                return CaldGetArcRatio(harc);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// ǂݍ݃TCY̎擾s܂B
        /// </summary>
        /// <remarks>
        /// <see cref="FindFirst">FindFirst</see> / <see cref="FindNext">FindNext</see> 
        /// ō܂łɏɂǂݍ񂾃TCY𓾂܂B
        /// </remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>vTCYBG[ɂ <b>uint.MaxValue (-1)</b> Ԃ܂B</returns>
        public uint GetArcReadSize(IntPtr harc)
        {
            try
            {
                return CaldGetArcReadSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        /// <summary>
        /// ɍXVԂ̎擾s܂
        /// </summary>
        /// <remarks>Ƀt@C̎ DOS `œ܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// Ƀt@C̎BG[ɂ <b>-1</b> Ԃ܂B
        /// ` <see cref="INDIVIDUALINFO">INDIVIDUALINFO \</see>Ɋi[̂ƓłB
        /// </returns>
        public int GetArcTime(IntPtr harc)
        {
            try
            {
                return CaldGetArcTime(harc);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// ̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̑𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// i[t@C̑Bȉ̃tOgݍ킹̂ƂȂ܂B
        /// G[ <b>-1</b> Ԃ܂B<br />
        /// <list type="table">
        ///     <listheader>
        ///         <term>tO</term>
        ///         <description>Ӗ</description>
        ///     </listheader>
        ///     <item>
        ///         <term>1 (0x01 : FA_RDONLY)</term>
        ///         <description>ǂݍݐpt@CB</description>
        ///     </item>
        ///     <item>
        ///         <term>2 (0x02 : FA_HIDDEN)</term>
        ///         <description>st@CB</description>
        ///     </item>
        ///     <item>
        ///         <term>4 (0x04 : FA_SYSTEM)</term>
        ///         <description>VXet@CB</description>
        ///     </item>
        ///     <item>
        ///         <term>8 (0x08 : FA_LABEL)</term>
        ///         <description>{[xB</description>
        ///     </item>
        ///     <item>
        ///         <term>16 (0x10 : FA_DIREC)</term>
        ///         <description>fBNgB</description>
        ///     </item>
        ///     <item>
        ///         <term>32 (0x20 : FA_ARCH)</term>
        ///         <description>ۑrbgB</description>
        ///     </item>
        ///     <item>
        ///         <term>64 (0x40 : FA_ENCRYPTED)</term>
        ///         <description>pX[hی삳ꂽt@CB</description>
        ///     </item>
        /// </list>
        /// </returns>
        public int GetAttribute(IntPtr harc)
        {
            try
            {
                return CaldGetAttribute(harc);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// kTCY̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̈kTCY𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// i[t@C̈kTCYB
        /// G[ <b>uint.MaxValue (-1 )</b>Ԃ܂B
        /// </returns>
        public uint GetCompressedSize(IntPtr harc)
        {
            try
            {
                return CaldGetCompressedSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        /// <summary>
        /// `FbNT̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̃`FbNT𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>i[t@C̃`FbNTBG[ <b>-1</b> Ԃ܂B</returns>
        public int GetCRC(IntPtr harc)
        {
            try
            {
                return CaldGetCRC(harc);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// 쐬̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̍쐬𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// i[t@C UNIX ` UTC ɂ쐬B
        /// G[ <b>uint.MaxValue (-1)</b>Ԃ܂B
        /// UNIX `Ƃ́AJan.1,1970 00:00:00 ̕błB
        /// </returns>
        public uint GetCreateTime(IntPtr harc)
        {
            try
            {
                return CaldGetCreateTime(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        /// <summary>
        /// XV̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̓t DOS `œ܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// i[t@C̓tBG[ɂ <b>-1</b> Ԃ܂B
        /// ` <see cref="INDIVIDUALINFO">INDIVIDUALINFO \</see>Ɋi[̂ƓłB
        /// </returns>
        public int GetDate(IntPtr harc)
        {
            try
            {
                return CaldGetDate(harc);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// t@C̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̃t@C𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="lpBuffer">t@Ci[obt@B</param>
        /// <param name="nSize">obt@̃TCYB</param>
        /// <returns>
        /// Iɂ <b>0</b> ԂA
        /// <paramref name="lpBuffer" /> Ƀt@Ci[܂B
        /// </returns>
        public int GetFileName(IntPtr harc, StringBuilder lpBuffer, uint nSize)
        {
            try
            {
                return CaldGetFileName(harc, lpBuffer, nSize);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// \bh̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̈k@𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="lpBuffer">\bhi[obt@B</param>
        /// <param name="nSize">obt@̃TCYB</param>
        /// <returns>
        /// Iɂ <b>0</b> ԂA
        /// <paramref name="lpBuffer" /> Ɉk@񂪊i[܂B
        /// ͈ꗗXgŕ\ "lh5" "Deflate" Ƃ`̂̂ƂȂ܂B
        /// </returns>
        public int GetMethod(IntPtr harc, StringBuilder lpBuffer, UInt32 nSize)
        {
            try
            {
                return CaldGetMethod(harc, lpBuffer, nSize);
            }
            catch
            {
                return 0x8021;
            }
        }
        /// <summary>
        /// TCY̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̃TCY𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>i[t@C̃TCYBG[ <b>uint.MaxValue (-1)</b>Ԃ܂B</returns>
        public uint GetOriginalSize(IntPtr harc)
        {
            try
            {
                return CaldGetOriginalSize(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        /// <summary>
        /// k̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̈k𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>p[~ (番) Ōꂽi[t@C̈kBG[ <b>-1</b> Ԃ܂B
        /// <note type="implementnotes"><br />
        /// (kTCY / t@C̃TCY) * 1000  ̌vZɂ苁߂邱ƂA
        /// 1000 𒴂ꍇ_ɒӂĂB
        /// </note>
        /// </returns>
        public int GetRatio(IntPtr harc)
        {
            try
            {
                return CaldGetRatio(harc);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// XVԂ̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̎ DOS `œ܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// i[t@C̎BG[ɂ <b>-1</b> Ԃ܂B
        /// ` <see cref="INDIVIDUALINFO">INDIVIDUALINFO \</see>
        /// Ɋi[̂ƓłB
        /// </returns>
        public int GetTime(IntPtr harc)
        {
            try
            {
                return CaldGetTime(harc);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// XV̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̍ŏIXV𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// i[t@C UNIX ` UTC ɂXVB
        /// G[ <b>uint.MaxValue (-1 )</b>Ԃ܂B
        /// UNIX `Ƃ́AJan.1,1970 00:00:00 ̕błB
        /// </returns>
        public uint GetWriteTime(IntPtr harc)
        {
            try
            {
                return CaldGetWriteTime(harc);
            }
            catch
            {
                return uint.MaxValue; //int  -1 B
            }
        }
        /// <summary>
        /// QƓ̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̎QƓ𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="TimeEx">i[ FILETIME \̂ւ ref QƁB</param>
        /// <returns>
        /// I  <b>true</b> A
        /// łȂꍇ <b>false</b> ԂA
        /// w肳ꂽFILETIME \̂ɎQƓi[܂B
        /// FILETIME `Ƃ́A Jan.1, 1601 00:00:00  100ns Pʂ̌oߎԂ 
        /// 64 rbg̐lŕ\̂łBڂ Win32 API ̃wvQƂĂB
        /// </returns>
        public bool GetAccessTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetAccessTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// ɎQƓ̎擾s܂B
        /// </summary>
        /// <remarks>ɂ̎QƓ𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="TimeEx">i[ FILETIME \̂ւ ref QƁB</param>
        /// <returns>
        /// I  <b>true</b> A łȂꍇ <b>false</b> ԂA
        /// w肳ꂽFILETIME \̂ɎQƓi[܂B
        /// FILETIME `Ƃ́A Jan.1, 1601 00:00:00  100ns Pʂ̌oߎԂ 
        /// 64 rbg̐lŕ\̂łBڂ Win32 API ̃wvQƂĂB
        /// </returns>
        public bool GetArcAccessTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetAccessTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// ɍ쐬̎擾s܂B
        /// </summary>
        /// <remarks>ɂ̍쐬𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="TimeEx">i[ FILETIME \̂ւ ref QƁB</param>
        /// <returns>
        /// I  <b>true</b> A łȂꍇ <b>false</b> ԂA
        /// w肳ꂽFILETIME \̂ɎQƓi[܂B
        /// FILETIME `Ƃ́A Jan.1, 1601 00:00:00  100ns Pʂ̌oߎԂ
        /// 64 rbg̐lŕ\̂łBڂ Win32 API ̃wvQƂĂB
        /// </returns>
        public bool GetArcCreateTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetArcCreateTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// ɍXV̎擾s܂B
        /// </summary>
        /// <remarks>ɂ̍ŏIXV𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="TimeEx">i[ FILETIME \̂ւ ref QƁB</param>
        /// <returns>
        /// I <b>true</b> A łȂꍇ <b>false</b> ԂA
        /// w肳ꂽFILETIME \̂ɎQƓi[܂B 
        /// FILETIME `Ƃ́A Jan.1, 1601 00:00:00  100ns Pʂ̌oߎԂ
        /// 64 rbg̐lŕ\̂łBڂ Win32 API ̃wvQƂĂB
        /// </returns>
        public bool GetArcWriteTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetArcWriteTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// 쐬̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̍쐬𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="TimeEx">i[ FILETIME \̂ւ ref QƁB</param>
        /// <returns>
        /// I <b>true</b> A łȂꍇ <b>false</b> ԂA
        /// w肳ꂽFILETIME \̂ɎQƓi[܂B
        /// FILETIME `Ƃ́A Jan.1, 1601 00:00:00  100ns Pʂ̌oߎԂ
        /// 64 rbg̐lŕ\̂łBڂ Win32 API ̃wvQƂĂB
        /// </returns>
        public bool GetCreateTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetCreateTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// XV̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̍ŏIXV𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="TimeEx">i[ FILETIME \̂ւ ref QƁB</param>
        /// <returns>
        /// I <b>true</b> A łȂꍇ <b>false</b> ԂA
        /// w肳ꂽFILETIME \̂ɎQƓi[܂B 
        /// FILETIME `Ƃ́A Jan.1, 1601 00:00:00  100ns Pʂ̌oߎԂ
        /// 64 rbg̐lŕ\̂łBڂ Win32 API ̃wvQƂĂB
        /// </returns>
        public bool GetWriteTimeEx(IntPtr harc, ref Int64 TimeEx)
        {
            try
            {
                return CaldGetWriteTimeEx(harc, ref TimeEx);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// kTCY̎擾s܂B
        /// </summary>
        /// <remarks>
        /// Ƀ}b`t@C̈kTCY̍v 64 rbgœ܂B<br />
        /// <b><see cref="FindNext">FindNext</see> ̌IĂĂяo悤ɂĂB</b>
        /// </remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="Size">i[邽߂̃obt@ւ ref QƁB</param>
        /// <returns>I <b>true</b>BG[ɂ <b>false</b> Ԃ܂B</returns>
        public bool GetArcCompressedSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetArcCompressedSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// ɃTCY̎擾s܂B
        /// </summary>
        /// <remarks>Ƀt@C̃TCY 64 rbgœ܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="Size">i[邽߂̃obt@ւ ref QƁB</param>
        /// <returns>I <b>true</b>BG[ɂ <b>false</b> Ԃ܂B</returns>
        public bool GetArcFileSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetArcFileSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// WJTCY̎擾s܂B
        /// </summary>
        /// <remarks>
        /// Ƀ}b`t@C̃TCY̍v𓾂܂B
        /// <see cref="FindNext">FindNext</see> ̌IłȂƕԋplɈӖ͂܂B
        /// ̏ꍇ͂܂łɃ}b`t@C̍vƂȂ܂B<br />
        /// <b><see cref="FindNext">FindNext</see> ̌IĂĂяo悤ɂĂB</b>
        /// </remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="Size">i[邽߂̃obt@ւ ref QƁB</param>
        /// <returns>I <b>true</b>BG[ɂ <b>false</b> Ԃ܂B</returns>
        public bool GetArcOriginalSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetArcOriginalSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// ǂݍ݃TCY̎擾s܂B
        /// </summary>
        /// <remarks>
        /// <see cref="FindFirst">FindFirst</see> / <see cref="FindNext">FindNext</see>
        /// ō܂łɏɂǂݍ񂾃TCY𓾂܂B
        /// </remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="Size">i[邽߂̃obt@ւ ref QƁB</param>
        /// <returns>I <b>true</b>BG[ɂ <b>false</b> Ԃ܂B</returns>
        public bool GetArcReadSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetArcReadSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// kTCY̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̈kTCY 64 rbgœ܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="Size">i[邽߂̃obt@ւ ref QƁB</param>
        /// <returns>I <b>true</b>BG[ɂ <b>false</b> Ԃ܂B</returns>
        public bool GetCompressedSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetCompressedSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// TCY̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C̃TCY 64 rbgœ܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <param name="Size">i[邽߂̃obt@ւ ref QƁB</param>
        /// <returns>I <b>true</b>BG[ɂ <b>false</b> Ԃ܂B</returns>
        public bool GetOriginalSizeEx(IntPtr harc, ref Int64 Size)
        {
            try
            {
                return CaldGetOriginalSizeEx(harc, ref Size);
            }
            catch
            {
                return false;
            }
        }
        /// <summary>
        /// gp OS ̎擾s܂B
        /// </summary>
        /// <remarks>i[t@C쐬ꂽ OS 𓾂܂B</remarks>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>OS lB
        /// lɂĂ <see cref="GetArcOSType">GetArcOSType</see> QƁB</returns>
        public int GetOSType(IntPtr harc)
        {
            try
            {
                return CaldGetOSType(harc);
            }
            catch
            {
                return -1;
            }
        }
        /// <summary>
        /// SFX ^Cv̎擾s܂B
        /// </summary>
        /// <param name="harc"><see cref="OpenArchive">OpenArchive</see> ŕԂꂽnhB</param>
        /// <returns>
        /// Ƀt@C̎ނ킷lԂ܂
        /// (<b>0</b> : ȉ𓀏ɂł͂ȂA<b>1`</b> : ȉ𓀏ɂł)B
        /// G[̏ꍇ <b>-1</b> Ԃ܂B
        /// </returns>
        public int IsSFXFile(IntPtr harc)
        {
            try
            {
                return CaldIsSFXFile(harc);
            }
            catch
            {
                return -1;
            }
        }
        #endregion
        #region CaldBase.dll Ǝ API ̎
        /// <summary>
        /// [CaldBase.NET g API] ɓWJp̃R}h擾܂B
        /// </summary>
        /// <remarks>
        /// A[JCoKi DLL  <see cref="Exec">Exec</see> nœnR}h IvV
        /// DLL ɂoołA API
        /// ɂWJpR}h擾邱Ƃłꍇ܂B
        /// </remarks>
        /// <param name="ExtractCommand">
        /// WJpR}h̎擾obt@ (obt@̃TCY͎肳܂)
        /// </param>
        public void GetExtractCommand(StringBuilder ExtractCommand)
        {
            try
            {
                CaldGetExtractCommand(ExtractCommand, (uint)ExtractCommand.Capacity);
            }
            catch
            {
            }
        }
        /// <summary>
        /// [CaldBase.NET g API]  CaldBase.dll nĂ{ DLL ̖O擾܂B
        /// </summary>
        /// <remarks>
        /// CaldBase.dll  <see cref="CheckArchive">CheckArchive</see> 
        /// <see cref="SetDllName">SetDllName</see> ɂ苴n铝A[JCo DLL
        /// ؂ւ邱Ƃł邽߁A݋n DLL 킩ȂȂꍇ͕K API 
        ///  DLL 擾ĂB
        /// </remarks>
        /// <returns>݂̓A[JCo DLL Ԃ܂B</returns>
        public string GetDllName()
        {
            try
            {
                StringBuilder strDllName = new StringBuilder();
                CaldGetDllName(strDllName, 256);
                return strDllName.ToString();
            }
            catch
            {
                return "";
            }
        }

        /// <summary>
        /// [CaldBase.NET g API] CaldBase.dll ɋn{ DLL ̖Ow肵܂B
        /// </summary>
        /// <remarks>
        /// UNLHA32.DLL  7-ZIP32.DLL AgA[JCo DLL mȏꍇɗp܂B
        /// </remarks>
        /// <param name="DllName">gp DLL </param>
        /// <returns>
        /// w肳ꂽ DLL  CaldBase.dll ŎgAnꍇ
        /// <b>0</b> Ԃ܂(CaldBase.ini ̐ݒmFKv邩܂)B<br />
        /// w肳ꂽ DLL npɐݒłꍇ <b>1 ȏ̒l</b>Ԃ܂B
        /// </returns>
        public int SetDllName(string DllName)
        {
            try
            {
                return CaldSetDllName(DllName);
            }
            catch
            {
                return 0;
            }
        }
        /// <summary>
        /// [CaldBase.NET g API] CaldBase.dll ɋn{ DLL ̔ԍw肵܂B
        /// </summary>
        /// <param name="idx">CaldBase.dll  DLL R[h (0: n)</param>
        /// <returns>w肳ꂽ DLL R[h͖ŁAnꍇɂ <b>false</b> Ԃ܂B
        /// nLɂꍇ <b>true</b> Ԃ܂B</returns>
        public bool SetDllIndex(int idx)
        {
            try
            {
                return CaldSetDllIndex((UInt16)idx);
            }
            catch
            {
                return false;
            }
        }

        /// <summary>
        /// [CaldBase.NET g API] n DLL  API Ă΂ꂽmF܂B
        /// </summary>
        /// <remarks>
        /// CaldBase.dll ͓A[JCo DLL ̗L API ̗Lɂ炸K
        /// API ̕ԂlԂ܂A̕Ԃln DLL Ă΂ꂽ̂A
        /// CaldBase.dll 㗝 API Œׂ邱Ƃł܂B<br />
        ///  API ͘AČĂԂƁAQڈȍ~ false Ԃ܂̂ŒӂĂB<br />
        /// A[JCo DLL ̗L <see cref="GetVersion">GetVersion</see> API  0 
        /// ȊOŔfĂB
        /// </remarks>
        /// <returns>
        /// n DLL  API Ă΂ꂽꍇ <b>true</b> A
        /// CaldBase.dll ̑㗝̏ꍇ <b>false</b> Ԃ܂B
        /// </returns>
        public bool IsApiCalled()
        {
            try
            {
                return CaldIsApiCalled();
            }
            catch
            {
                return false;
            }
        }
        #endregion
    }
}
