/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.indexer.ByteIndexer;

public class ByteBufferIndexer
extends ByteIndexer {
    protected ByteBuffer buffer;

    public ByteBufferIndexer(ByteBuffer buffer, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.buffer = buffer;
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public byte get(int i) {
        return this.buffer.get(i);
    }

    @Override
    public ByteIndexer get(int i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.buffer.get(i * this.strides[0] + n);
        }
        return this;
    }

    @Override
    public byte get(int i, int j) {
        return this.buffer.get(i * this.strides[0] + j);
    }

    @Override
    public ByteIndexer get(int i, int j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.buffer.get(i * this.strides[0] + j * this.strides[1] + n);
        }
        return this;
    }

    @Override
    public byte get(int i, int j, int k) {
        return this.buffer.get(i * this.strides[0] + j * this.strides[1] + k);
    }

    @Override
    public byte get(int ... indices) {
        return this.buffer.get(this.index(indices));
    }

    @Override
    public ByteIndexer get(int[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.buffer.get(this.index(indices) + n);
        }
        return this;
    }

    @Override
    public ByteIndexer put(int i, byte b) {
        this.buffer.put(i, b);
        return this;
    }

    @Override
    public ByteIndexer put(int i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + n, b[offset + n]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(int i, int j, byte b) {
        this.buffer.put(i * this.strides[0] + j, b);
        return this;
    }

    @Override
    public ByteIndexer put(int i, int j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(i * this.strides[0] + j * this.strides[1] + n, b[offset + n]);
        }
        return this;
    }

    @Override
    public ByteIndexer put(int i, int j, int k, byte b) {
        this.buffer.put(i * this.strides[0] + j * this.strides[1] + k, b);
        return this;
    }

    @Override
    public ByteIndexer put(int[] indices, byte b) {
        this.buffer.put(this.index(indices), b);
        return this;
    }

    @Override
    public ByteIndexer put(int[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.buffer.put(this.index(indices) + n, b[offset + n]);
        }
        return this;
    }

    @Override
    public void release() {
        this.buffer = null;
    }
}

