/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.DoubleIndexer;

public class DoubleArrayIndexer
extends DoubleIndexer {
    protected double[] array;

    public DoubleArrayIndexer(double[] array, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public double[] array() {
        return this.array;
    }

    @Override
    public double get(int i) {
        return this.array[i];
    }

    @Override
    public DoubleIndexer get(int i, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.array[i * this.strides[0] + n];
        }
        return this;
    }

    @Override
    public double get(int i, int j) {
        return this.array[i * this.strides[0] + j];
    }

    @Override
    public DoubleIndexer get(int i, int j, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.array[i * this.strides[0] + j * this.strides[1] + n];
        }
        return this;
    }

    @Override
    public double get(int i, int j, int k) {
        return this.array[i * this.strides[0] + j * this.strides[1] + k];
    }

    @Override
    public double get(int ... indices) {
        return this.array[this.index(indices)];
    }

    @Override
    public DoubleIndexer get(int[] indices, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            d[offset + n] = this.array[this.index(indices) + n];
        }
        return this;
    }

    @Override
    public DoubleIndexer put(int i, double d) {
        this.array[i] = d;
        return this;
    }

    @Override
    public DoubleIndexer put(int i, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + n] = d[offset + n];
        }
        return this;
    }

    @Override
    public DoubleIndexer put(int i, int j, double d) {
        this.array[i * this.strides[0] + j] = d;
        return this;
    }

    @Override
    public DoubleIndexer put(int i, int j, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + j * this.strides[1] + n] = d[offset + n];
        }
        return this;
    }

    @Override
    public DoubleIndexer put(int i, int j, int k, double d) {
        this.array[i * this.strides[0] + j * this.strides[1] + k] = d;
        return this;
    }

    @Override
    public DoubleIndexer put(int[] indices, double d) {
        this.array[this.index((int[])indices)] = d;
        return this;
    }

    @Override
    public DoubleIndexer put(int[] indices, double[] d, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[this.index((int[])indices) + n] = d[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

