/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.DoubleBuffer;
import org.bytedeco.javacpp.DoublePointer;
import org.bytedeco.javacpp.indexer.DoubleArrayIndexer;
import org.bytedeco.javacpp.indexer.DoubleBufferIndexer;
import org.bytedeco.javacpp.indexer.Indexer;

public abstract class DoubleIndexer
extends Indexer {
    protected DoubleIndexer(int[] sizes, int[] strides) {
        super(sizes, strides);
    }

    public static DoubleIndexer create(double[] array, int[] sizes, int[] strides) {
        return new DoubleArrayIndexer(array, sizes, strides);
    }

    public static DoubleIndexer create(DoubleBuffer buffer, int[] sizes, int[] strides) {
        return new DoubleBufferIndexer(buffer, sizes, strides);
    }

    public static DoubleIndexer create(DoublePointer pointer, int[] sizes, int[] strides) {
        return DoubleIndexer.create(pointer, sizes, strides, true);
    }

    public static DoubleIndexer create(final DoublePointer pointer, int[] sizes, int[] strides, boolean direct) {
        if (direct) {
            return new DoubleBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final int position = pointer.position();
        double[] array = new double[pointer.limit() - position];
        pointer.get(array);
        return new DoubleArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract double get(int var1);

    public DoubleIndexer get(int i, double[] d) {
        return this.get(i, d, 0, d.length);
    }

    public abstract DoubleIndexer get(int var1, double[] var2, int var3, int var4);

    public abstract double get(int var1, int var2);

    public DoubleIndexer get(int i, int j, double[] d) {
        return this.get(i, j, d, 0, d.length);
    }

    public abstract DoubleIndexer get(int var1, int var2, double[] var3, int var4, int var5);

    public abstract double get(int var1, int var2, int var3);

    public abstract double get(int ... var1);

    public DoubleIndexer get(int[] indices, double[] d) {
        return this.get(indices, d, 0, d.length);
    }

    public abstract DoubleIndexer get(int[] var1, double[] var2, int var3, int var4);

    public abstract DoubleIndexer put(int var1, double var2);

    public DoubleIndexer put(int i, double ... d) {
        return this.put(i, d, 0, d.length);
    }

    public abstract DoubleIndexer put(int var1, double[] var2, int var3, int var4);

    public abstract DoubleIndexer put(int var1, int var2, double var3);

    public DoubleIndexer put(int i, int j, double ... d) {
        return this.put(i, j, d, 0, d.length);
    }

    public abstract DoubleIndexer put(int var1, int var2, double[] var3, int var4, int var5);

    public abstract DoubleIndexer put(int var1, int var2, int var3, double var4);

    public abstract DoubleIndexer put(int[] var1, double var2);

    public DoubleIndexer put(int[] indices, double ... d) {
        return this.put(indices, d, 0, d.length);
    }

    public abstract DoubleIndexer put(int[] var1, double[] var2, int var3, int var4);

    @Override
    public double getDouble(int ... indices) {
        return this.get(indices);
    }

    @Override
    public DoubleIndexer putDouble(int[] indices, double d) {
        return this.put(indices, d);
    }
}

