/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.ShortBuffer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.ShortArrayIndexer;
import org.bytedeco.javacpp.indexer.ShortBufferIndexer;

public abstract class ShortIndexer
extends Indexer {
    protected ShortIndexer(int[] sizes, int[] strides) {
        super(sizes, strides);
    }

    public static ShortIndexer create(short[] array, int[] sizes, int[] strides) {
        return new ShortArrayIndexer(array, sizes, strides);
    }

    public static ShortIndexer create(ShortBuffer buffer, int[] sizes, int[] strides) {
        return new ShortBufferIndexer(buffer, sizes, strides);
    }

    public static ShortIndexer create(ShortPointer pointer, int[] sizes, int[] strides) {
        return ShortIndexer.create(pointer, sizes, strides, true);
    }

    public static ShortIndexer create(final ShortPointer pointer, int[] sizes, int[] strides, boolean direct) {
        if (direct) {
            return new ShortBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final int position = pointer.position();
        short[] array = new short[pointer.limit() - position];
        pointer.get(array);
        return new ShortArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract short get(int var1);

    public ShortIndexer get(int i, short[] s) {
        return this.get(i, s, 0, s.length);
    }

    public abstract ShortIndexer get(int var1, short[] var2, int var3, int var4);

    public abstract short get(int var1, int var2);

    public ShortIndexer get(int i, int j, short[] s) {
        return this.get(i, j, s, 0, s.length);
    }

    public abstract ShortIndexer get(int var1, int var2, short[] var3, int var4, int var5);

    public abstract short get(int var1, int var2, int var3);

    public abstract short get(int ... var1);

    public ShortIndexer get(int[] indices, short[] s) {
        return this.get(indices, s, 0, s.length);
    }

    public abstract ShortIndexer get(int[] var1, short[] var2, int var3, int var4);

    public abstract ShortIndexer put(int var1, short var2);

    public ShortIndexer put(int i, short ... s) {
        return this.put(i, s, 0, s.length);
    }

    public abstract ShortIndexer put(int var1, short[] var2, int var3, int var4);

    public abstract ShortIndexer put(int var1, int var2, short var3);

    public ShortIndexer put(int i, int j, short ... s) {
        return this.put(i, j, s, 0, s.length);
    }

    public abstract ShortIndexer put(int var1, int var2, short[] var3, int var4, int var5);

    public abstract ShortIndexer put(int var1, int var2, int var3, short var4);

    public abstract ShortIndexer put(int[] var1, short var2);

    public ShortIndexer put(int[] indices, short ... s) {
        return this.put(indices, s, 0, s.length);
    }

    public abstract ShortIndexer put(int[] var1, short[] var2, int var3, int var4);

    @Override
    public double getDouble(int ... indices) {
        return this.get(indices);
    }

    @Override
    public ShortIndexer putDouble(int[] indices, double s) {
        return this.put(indices, (short)s);
    }
}

