/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.UShortIndexer;

public class UShortArrayIndexer
extends UShortIndexer {
    protected short[] array;

    public UShortArrayIndexer(short[] array, int[] sizes, int[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public short[] array() {
        return this.array;
    }

    @Override
    public int get(int i) {
        return this.array[i] & 0xFFFF;
    }

    @Override
    public UShortIndexer get(int i, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[i * this.strides[0] + n] & 0xFFFF;
        }
        return this;
    }

    @Override
    public int get(int i, int j) {
        return this.array[i * this.strides[0] + j] & 0xFFFF;
    }

    @Override
    public UShortIndexer get(int i, int j, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[i * this.strides[0] + j * this.strides[1] + n] & 0xFFFF;
        }
        return this;
    }

    @Override
    public int get(int i, int j, int k) {
        return this.array[i * this.strides[0] + j * this.strides[1] + k] & 0xFFFF;
    }

    @Override
    public int get(int ... indices) {
        return this.array[this.index(indices)] & 0xFFFF;
    }

    @Override
    public UShortIndexer get(int[] indices, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            s[offset + n] = this.array[this.index(indices) + n] & 0xFFFF;
        }
        return this;
    }

    @Override
    public UShortIndexer put(int i, int s) {
        this.array[i] = (short)s;
        return this;
    }

    @Override
    public UShortIndexer put(int i, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + n] = (short)s[offset + n];
        }
        return this;
    }

    @Override
    public UShortIndexer put(int i, int j, int s) {
        this.array[i * this.strides[0] + j] = (short)s;
        return this;
    }

    @Override
    public UShortIndexer put(int i, int j, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[i * this.strides[0] + j * this.strides[1] + n] = (short)s[offset + n];
        }
        return this;
    }

    @Override
    public UShortIndexer put(int i, int j, int k, int s) {
        this.array[i * this.strides[0] + j * this.strides[1] + k] = (short)s;
        return this;
    }

    @Override
    public UShortIndexer put(int[] indices, int s) {
        this.array[this.index((int[])indices)] = (short)s;
        return this;
    }

    @Override
    public UShortIndexer put(int[] indices, int[] s, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[this.index((int[])indices) + n] = (short)s[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

