/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import java.nio.ShortBuffer;
import org.bytedeco.javacpp.ShortPointer;
import org.bytedeco.javacpp.indexer.Indexer;
import org.bytedeco.javacpp.indexer.UShortArrayIndexer;
import org.bytedeco.javacpp.indexer.UShortBufferIndexer;

public abstract class UShortIndexer
extends Indexer {
    protected UShortIndexer(int[] sizes, int[] strides) {
        super(sizes, strides);
    }

    public static UShortIndexer create(short[] array, int[] sizes, int[] strides) {
        return new UShortArrayIndexer(array, sizes, strides);
    }

    public static UShortIndexer create(ShortBuffer buffer, int[] sizes, int[] strides) {
        return new UShortBufferIndexer(buffer, sizes, strides);
    }

    public static UShortIndexer create(ShortPointer pointer, int[] sizes, int[] strides) {
        return UShortIndexer.create(pointer, sizes, strides, true);
    }

    public static UShortIndexer create(final ShortPointer pointer, int[] sizes, int[] strides, boolean direct) {
        if (direct) {
            return new UShortBufferIndexer(pointer.asBuffer(), sizes, strides);
        }
        final int position = pointer.position();
        short[] array = new short[pointer.limit() - position];
        pointer.get(array);
        return new UShortArrayIndexer(array, sizes, strides){

            @Override
            public void release() {
                pointer.position(position).put(this.array);
                super.release();
            }
        };
    }

    public abstract int get(int var1);

    public UShortIndexer get(int i, int[] s) {
        return this.get(i, s, 0, s.length);
    }

    public abstract UShortIndexer get(int var1, int[] var2, int var3, int var4);

    public abstract int get(int var1, int var2);

    public UShortIndexer get(int i, int j, int[] s) {
        return this.get(i, j, s, 0, s.length);
    }

    public abstract UShortIndexer get(int var1, int var2, int[] var3, int var4, int var5);

    public abstract int get(int var1, int var2, int var3);

    public abstract int get(int ... var1);

    public UShortIndexer get(int[] indices, int[] s) {
        return this.get(indices, s, 0, s.length);
    }

    public abstract UShortIndexer get(int[] var1, int[] var2, int var3, int var4);

    public abstract UShortIndexer put(int var1, int var2);

    public UShortIndexer put(int i, int ... s) {
        return this.put(i, s, 0, s.length);
    }

    public abstract UShortIndexer put(int var1, int[] var2, int var3, int var4);

    public abstract UShortIndexer put(int var1, int var2, int var3);

    public UShortIndexer put(int i, int j, int ... s) {
        return this.put(i, j, s, 0, s.length);
    }

    public abstract UShortIndexer put(int var1, int var2, int[] var3, int var4, int var5);

    public abstract UShortIndexer put(int var1, int var2, int var3, int var4);

    public abstract UShortIndexer put(int[] var1, int var2);

    public UShortIndexer put(int[] indices, int ... s) {
        return this.put(indices, s, 0, s.length);
    }

    public abstract UShortIndexer put(int[] var1, int[] var2, int var3, int var4);

    @Override
    public double getDouble(int ... indices) {
        return this.get(indices);
    }

    @Override
    public UShortIndexer putDouble(int[] indices, double s) {
        return this.put(indices, (int)s);
    }
}

