/*
 * Decompiled with CFR 0.152.
 */
package MyCanvas.GameCanvas;

import MyCanvas.GameCanvas.AutoTurnEnemy;
import MyCanvas.GameCanvas.CpLock;
import MyCanvas.GameCanvas.FiveRoundData;
import MyCanvas.GameCanvas.GameTimer;
import MyCanvas.GameCanvas.MyGunSound;
import MyCanvas.GameCanvas.RotateAnimThread;
import MyMain.TextData;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.image.TextureLoader;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Random;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Node;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3f;

public class EnemyData {
    public Transform3D tfd;
    public TransformGroup tg;
    public AutoTurnEnemy autoTurnEnemy;
    public Shape3D shape3D;
    public String name;
    public static Transform3D enemyCountTF3D;
    public static TransformGroup enemyCountTFG;
    public static Transform3D timeTF3D;
    public static TransformGroup timeTFG;
    public static Transform3D levelTF3D;
    public static TransformGroup levelTFG;
    public static Transform3D infoTF3D;
    public static TransformGroup infoTFG;
    public static GameTimer gametimer;
    public CpLock cpLock;
    public MyGunSound myGunSound;
    public int enemyNum = 0;

    public EnemyData(String name, Transform3D tfd, TransformGroup tfg) {
        this.name = name;
        this.tfd = tfd;
        this.tg = tfg;
        this.cpLock = new CpLock();
        this.myGunSound = new MyGunSound();
    }

    public static void prepareText(BranchGroup bg) {
        FiveRoundData.setRoundOne();
        enemyCountTF3D = new Transform3D();
        enemyCountTF3D.setTranslation(new Vector3f(-0.9f, 0.6f, 0.01f));
        enemyCountTFG = new TransformGroup(enemyCountTF3D);
        EnemyData.createText(enemyCountTFG, TextData.GAME_ENEMY_NUM);
        bg.addChild((Node)enemyCountTFG);
        timeTF3D = new Transform3D();
        timeTF3D.setTranslation(new Vector3f(-0.4f, 0.6f, 0.0f));
        timeTFG = new TransformGroup(timeTF3D);
        EnemyData.createText(timeTFG, TextData.GAME_TIME);
        bg.addChild((Node)timeTFG);
        levelTF3D = new Transform3D();
        levelTF3D.setTranslation(new Vector3f(0.2f, 0.6f, 0.0f));
        levelTFG = new TransformGroup(levelTF3D);
        EnemyData.createText(levelTFG, TextData.GAME_LEVEL_LOW);
        bg.addChild((Node)levelTFG);
        infoTF3D = new Transform3D();
        infoTF3D.setTranslation(new Vector3f(-0.9f, -0.7f, 0.0f));
        infoTFG = new TransformGroup(infoTF3D);
        EnemyData.createText(infoTFG, TextData.MENU_SHOT_AND_EXIT);
        bg.addChild((Node)infoTFG);
        gametimer = new GameTimer(timeTFG);
    }

    private static void createText(TransformGroup tg, String str) {
        Text2D text2d = new Text2D(str, new Color3f(0.1f, 0.1f, 0.4f), TextData.FONT, 18, 1);
        Appearance app = text2d.getAppearance();
        app.setCapability(2);
        app.setCapability(3);
        tg.addChild((Node)text2d);
    }

    public static void changeText(TransformGroup tg, String str) {
        ((Text2D)tg.getChild(0)).setString(str);
    }

    public void startAutoTurnEnemy() {
        this.autoTurnEnemy = new AutoTurnEnemy(this.tfd, this.tg, this.cpLock, this.shape3D, this);
        this.autoTurnEnemy.autoTurnStart();
    }

    public void hit() {
        int ran;
        System.out.println(this.name);
        this.myGunSound.gunPlay();
        FiveRoundData.enemyCount = this.enemyNum == 0 || this.enemyNum == 1 ? ++FiveRoundData.enemyCount : --FiveRoundData.enemyCount;
        RotateAnimThread rat = new RotateAnimThread();
        if (!rat.startThread(this.tfd, this.tg, this.cpLock)) {
            return;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Random rnd = new Random();
        this.enemyNum = ran = rnd.nextInt(5);
        Image image = toolkit.getImage("res/" + String.valueOf(ran) + ".png");
        TextureLoader loader = new TextureLoader(image, null);
        this.shape3D.getAppearance().setTexture(loader.getTexture());
        EnemyData.changeText(enemyCountTFG, String.valueOf(TextData.GAME_ENEMY_NUM2) + String.valueOf(FiveRoundData.enemyCount));
    }
}

