/*
 * Decompiled with CFR 0.152.
 */
package MyCanvas.GameCanvas;

import MyCanvas.ClearCanvas.ClearCanvas;
import MyCanvas.EndingCanvas.EndingCanvas;
import MyCanvas.GameCanvas.EnemyData;
import MyCanvas.GameCanvas.FiveRoundData;
import MyCanvas.GameCanvas.GameCanvasBehavior;
import MyCanvas.GameCanvas.GameTimer;
import MyCanvas.GameCanvas.MySound;
import MyCanvas.KaisetsuCanvas.KaisetsuCanvas;
import MyCanvas.StartCanvas.StartCanvas;
import MyMain.CameraPointingGame;
import com.sun.j3d.utils.image.TextureLoader;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Material;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.QuadArray;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TextureAttributes;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;

public class GameCanvas {
    private SimpleUniverse simpleU;
    private BoundingSphere bounds = new BoundingSphere(new Point3d(), 10.0);
    public Canvas3D canvas;
    public PickCanvas cnvs = null;
    public ClearCanvas canvasClearGame;
    public StartCanvas canvasStartView;
    public EndingCanvas canvasEndingView;
    public KaisetsuCanvas canvasKaisetsuView;
    public static GameTimer gametimer;
    BranchGroup branchG0;
    public EnemyData enemy1;
    public EnemyData enemy2;
    public EnemyData enemy3;
    public CameraPointingGame cameraPointingGame;
    public MySound myGameCanvasSound = new MySound();

    public GameCanvas(CameraPointingGame cameraPointingGame) {
        this.cameraPointingGame = cameraPointingGame;
        this.canvas = new Canvas3D(SimpleUniverse.getPreferredConfiguration());
        this.canvas.setBounds(0, 0, 1024, 768);
        this.simpleU = new SimpleUniverse(this.canvas);
        this.simpleU.getViewingPlatform().setNominalViewingTransform();
        this.simpleU.addBranchGraph(this.createSceneGraph());
    }

    private void createPolygon(BranchGroup branch, EnemyData enemy, String name, float point) {
        enemy.tg.setCapability(18);
        enemy.tg.setCapability(17);
        enemy.tg.setCapability(1);
        enemy.tg.setUserData((Object)name);
        branch.addChild((Node)enemy.tg);
        Appearance ap = new Appearance();
        PolygonAttributes pa = new PolygonAttributes();
        pa.setCullFace(0);
        pa.setBackFaceNormalFlip(true);
        ap.setPolygonAttributes(pa);
        ColoringAttributes ca = new ColoringAttributes();
        ca.setColor(new Color3f(0.0f, 0.0f, 0.1f));
        ap.setColoringAttributes(ca);
        Material ma = new Material();
        ap.setMaterial(ma);
        Point3f[] vertex = new Point3f[]{new Point3f(point, 0.6f, 0.0f), new Point3f(point - 0.4f, 0.6f, 0.0f), new Point3f(point - 0.4f, -0.6f, 0.0f), new Point3f(point, -0.6f, 0.0f)};
        QuadArray quadA = new QuadArray(vertex.length, 33);
        TexCoord2f[] texCoord = new TexCoord2f[]{new TexCoord2f(1.0f, 1.0f), new TexCoord2f(0.0f, 1.0f), new TexCoord2f(0.0f, 0.0f), new TexCoord2f(1.0f, 0.0f)};
        quadA.setTextureCoordinates(0, 0, texCoord);
        quadA.setCoordinates(0, vertex);
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = toolkit.getImage("res/1.png");
        TextureLoader loader = new TextureLoader(image, null);
        ap.setTexture(loader.getTexture());
        TextureAttributes texAttr = new TextureAttributes();
        texAttr.setTextureMode(5);
        ap.setTextureAttributes(texAttr);
        ap.setCapability(2);
        ap.setCapability(3);
        enemy.shape3D = new Shape3D((Geometry)quadA, ap);
        enemy.tg.addChild((Node)enemy.shape3D);
    }

    private BranchGroup createSceneGraph() {
        this.branchG0 = new BranchGroup();
        BufferedImage someImage = null;
        try {
            someImage = ImageIO.read(new File("res/gameback_bokashi.png"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ImageComponent2D image = new ImageComponent2D(1, someImage);
        Background background = new Background(image);
        background.setApplicationBounds((Bounds)this.bounds);
        this.branchG0.addChild((Node)background);
        Transform3D tfd = new Transform3D();
        TransformGroup tg = new TransformGroup(tfd);
        this.enemy1 = new EnemyData("polygon1", tfd, tg);
        this.createPolygon(this.branchG0, this.enemy1, "polygon1", 0.7f);
        tfd = new Transform3D();
        tg = new TransformGroup(tfd);
        this.enemy2 = new EnemyData("polygon2", tfd, tg);
        this.createPolygon(this.branchG0, this.enemy2, "polygon2", 0.2f);
        tfd = new Transform3D();
        tg = new TransformGroup(tfd);
        this.enemy3 = new EnemyData("polygon3", tfd, tg);
        this.createPolygon(this.branchG0, this.enemy3, "polygon3", -0.3f);
        GameCanvasBehavior myBehavior3 = new GameCanvasBehavior();
        myBehavior3.setSchedulingBounds((Bounds)this.bounds);
        this.branchG0.addChild((Node)myBehavior3);
        EnemyData.prepareText(this.branchG0);
        MyMouseAdapter adapter = new MyMouseAdapter();
        this.canvas.addMouseListener((MouseListener)adapter);
        this.cnvs = new PickCanvas(this.canvas, this.branchG0);
        this.cnvs.setMode(256);
        this.enemy1.startAutoTurnEnemy();
        this.enemy2.startAutoTurnEnemy();
        this.enemy3.startAutoTurnEnemy();
        this.branchG0.compile();
        return this.branchG0;
    }

    public void destroy() {
        this.simpleU.cleanup();
    }

    private String createID(int x, int y) {
        this.cnvs.setShapeLocation(x, y);
        PickResult result = this.cnvs.pickClosest();
        if (result != null) {
            Node node = null;
            node = result.getNode(4);
            if (node == null) {
                node = result.getNode(32);
            }
            String sensorID = node.getUserData().toString();
            return sensorID;
        }
        return null;
    }

    private void clickMethod(String name) {
        if (FiveRoundData.enemyCount > 0) {
            if (name.equals("polygon1")) {
                this.enemy1.hit();
            } else if (name.equals("polygon2")) {
                this.enemy2.hit();
            } else if (name.equals("polygon3")) {
                this.enemy3.hit();
            }
        }
        if (FiveRoundData.enemyCount == 0) {
            EnemyData.gametimer.timerStop();
            int round = FiveRoundData.upRound();
            if (4 > round) {
                this.cameraPointingGame.changeClearCanvas();
            } else if (4 == round) {
                this.cameraPointingGame.changeEndingCanvas();
                FiveRoundData.setRoundOne();
            }
        }
    }

    class MyMouseAdapter
    extends MouseAdapter {
        MyMouseAdapter() {
        }

        @Override
        public void mouseClicked(MouseEvent evnt) {
            String sensorID = GameCanvas.this.createID(evnt.getX(), evnt.getY());
            if (sensorID == null) {
                return;
            }
            GameCanvas.this.clickMethod(sensorID);
        }
    }

    public abstract class MyOwnCode {
        public abstract void processSensor(String var1);
    }
}

