/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacv;

import java.nio.Buffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.Pointer;
import org.bytedeco.javacpp.opencv_core;
import org.bytedeco.javacv.Frame;
import org.bytedeco.javacv.FrameConverter;

public abstract class OpenCVFrameConverter<F>
extends FrameConverter<F> {
    opencv_core.IplImage img;
    opencv_core.Mat mat;

    public static int getFrameDepth(int depth) {
        switch (depth) {
            case 0: 
            case 8: {
                return 8;
            }
            case -2147483640: 
            case 1: {
                return -8;
            }
            case 2: 
            case 16: {
                return 16;
            }
            case -2147483632: 
            case 3: {
                return -16;
            }
            case 5: 
            case 32: {
                return 32;
            }
            case -2147483616: 
            case 4: {
                return -32;
            }
            case 6: 
            case 64: {
                return 64;
            }
        }
        return -1;
    }

    public static int getIplImageDepth(int depth) {
        switch (depth) {
            case 8: {
                return 8;
            }
            case -8: {
                return -2147483640;
            }
            case 16: {
                return 16;
            }
            case -16: {
                return -2147483632;
            }
            case 32: {
                return 32;
            }
            case -32: {
                return -2147483616;
            }
            case 64: {
                return 64;
            }
        }
        return -1;
    }

    static boolean isEqual(Frame frame, opencv_core.IplImage img) {
        return img != null && frame != null && frame.image != null && frame.image.length > 0 && frame.imageWidth == img.width() && frame.imageHeight == img.height() && frame.imageChannels == img.nChannels() && OpenCVFrameConverter.getIplImageDepth(frame.imageDepth) == img.depth() && new Pointer(frame.image[0]).address() == img.imageData().address() && frame.imageStride * Math.abs(frame.imageDepth) / 8 == img.widthStep();
    }

    public opencv_core.IplImage convertToIplImage(Frame frame) {
        if (frame == null) {
            return null;
        }
        if (frame.opaque instanceof opencv_core.IplImage) {
            return (opencv_core.IplImage)frame.opaque;
        }
        if (!OpenCVFrameConverter.isEqual(frame, this.img)) {
            int depth = OpenCVFrameConverter.getIplImageDepth(frame.imageDepth);
            this.img = depth < 0 ? null : opencv_core.IplImage.createHeader(frame.imageWidth, frame.imageHeight, depth, frame.imageChannels).imageData(new BytePointer(new Pointer(frame.image[0].position(0)))).widthStep(frame.imageStride * Math.abs(frame.imageDepth) / 8).imageSize(frame.image[0].capacity() * Math.abs(frame.imageDepth) / 8);
        }
        return this.img;
    }

    @Override
    public Frame convert(opencv_core.IplImage img) {
        if (img == null) {
            return null;
        }
        if (!OpenCVFrameConverter.isEqual(this.frame, img)) {
            this.frame = new Frame();
            this.frame.imageWidth = img.width();
            this.frame.imageHeight = img.height();
            this.frame.imageDepth = OpenCVFrameConverter.getFrameDepth(img.depth());
            this.frame.imageChannels = img.nChannels();
            this.frame.imageStride = img.widthStep() * 8 / Math.abs(this.frame.imageDepth);
            this.frame.image = new Buffer[]{img.createBuffer()};
            this.frame.opaque = img;
        }
        return this.frame;
    }

    public static int getMatDepth(int depth) {
        switch (depth) {
            case 8: {
                return 0;
            }
            case -8: {
                return 1;
            }
            case 16: {
                return 2;
            }
            case -16: {
                return 3;
            }
            case 32: {
                return 5;
            }
            case -32: {
                return 4;
            }
            case 64: {
                return 6;
            }
        }
        return -1;
    }

    static boolean isEqual(Frame frame, opencv_core.Mat mat) {
        return mat != null && frame != null && frame.image != null && frame.image.length > 0 && frame.imageWidth == mat.cols() && frame.imageHeight == mat.rows() && frame.imageChannels == mat.channels() && OpenCVFrameConverter.getMatDepth(frame.imageDepth) == mat.depth() && new Pointer(frame.image[0]).address() == mat.data().address() && frame.imageStride * Math.abs(frame.imageDepth) / 8 == (int)mat.step();
    }

    public opencv_core.Mat convertToMat(Frame frame) {
        if (frame == null) {
            return null;
        }
        if (frame.opaque instanceof opencv_core.Mat) {
            return (opencv_core.Mat)frame.opaque;
        }
        if (!OpenCVFrameConverter.isEqual(frame, this.mat)) {
            int depth = OpenCVFrameConverter.getMatDepth(frame.imageDepth);
            this.mat = depth < 0 ? null : new opencv_core.Mat(frame.imageHeight, frame.imageWidth, opencv_core.CV_MAKETYPE(depth, frame.imageChannels), new Pointer(frame.image[0].position(0)), (long)(frame.imageStride * Math.abs(frame.imageDepth) / 8));
        }
        return this.mat;
    }

    @Override
    public Frame convert(opencv_core.Mat mat) {
        if (mat == null) {
            return null;
        }
        if (!OpenCVFrameConverter.isEqual(this.frame, mat)) {
            this.frame = new Frame();
            this.frame.imageWidth = mat.cols();
            this.frame.imageHeight = mat.rows();
            this.frame.imageDepth = OpenCVFrameConverter.getFrameDepth(mat.depth());
            this.frame.imageChannels = mat.channels();
            this.frame.imageStride = (int)mat.step() * 8 / Math.abs(this.frame.imageDepth);
            this.frame.image = new Buffer[]{mat.createBuffer()};
            this.frame.opaque = mat;
        }
        return this.frame;
    }

    public static class ToMat
    extends OpenCVFrameConverter<opencv_core.Mat> {
        @Override
        public Frame convert(opencv_core.Mat mat) {
            return super.convert(mat);
        }

        @Override
        public opencv_core.Mat convert(Frame frame) {
            return this.convertToMat(frame);
        }
    }

    public static class ToIplImage
    extends OpenCVFrameConverter<opencv_core.IplImage> {
        @Override
        public Frame convert(opencv_core.IplImage img) {
            return super.convert(img);
        }

        @Override
        public opencv_core.IplImage convert(Frame frame) {
            return this.convertToIplImage(frame);
        }
    }
}

