/*
 * Decompiled with CFR 0.152.
 */
package net.osdn.util.javafx.event;

import javafx.beans.InvalidationListener;
import javafx.beans.Observable;

@FunctionalInterface
public interface SilentInvalidationListener {
    public void invalidated(Observable var1) throws Exception;

    public static InvalidationListener wrap(SilentInvalidationListener listener) {
        return observable -> {
            try {
                listener.invalidated(observable);
            }
            catch (Exception e) {
                Thread.UncaughtExceptionHandler ueh = Thread.currentThread().getUncaughtExceptionHandler();
                if (ueh != null) {
                    ueh.uncaughtException(Thread.currentThread(), e);
                } else {
                    SilentInvalidationListener.rethrow(e);
                }
                return;
            }
        };
    }

    public static void rethrow(Throwable throwable) {
        SilentInvalidationListener.rethrow0(throwable);
    }

    public static <T extends Throwable> void rethrow0(Throwable throwable) throws T {
        throw throwable;
    }
}

