/*
 * Decompiled with CFR 0.152.
 */
package lu.luz.jzopfli;

import lu.luz.jzopfli.BlockSplitterH;
import lu.luz.jzopfli.Deflate;
import lu.luz.jzopfli.Lz77;
import lu.luz.jzopfli.Lz77H;
import lu.luz.jzopfli.UtilH;
import lu.luz.jzopfli.ZopfliH;

final class BlockSplitter
extends BlockSplitterH {
    private static final FindMinimumFun SplitCost = new FindMinimumFun(){

        @Override
        public double f(int n, Object object) {
            SplitCostContext splitCostContext = (SplitCostContext)object;
            return BlockSplitter.EstimateCost(splitCostContext.litlens, splitCostContext.dists, splitCostContext.start, n) + BlockSplitter.EstimateCost(splitCostContext.litlens, splitCostContext.dists, n, splitCostContext.end);
        }
    };

    BlockSplitter() {
    }

    private static int FindMinimum(FindMinimumFun findMinimumFun, Object object, int n, int n2) {
        if (n2 - n < 1024) {
            double d = 1.0E30f;
            int n3 = n;
            for (int i = n; i < n2; ++i) {
                double d2 = findMinimumFun.f(i, object);
                if (!(d2 < d)) continue;
                d = d2;
                n3 = i;
            }
            return n3;
        }
        int n4 = 9;
        int[] nArray = new int[n4];
        double[] dArray = new double[n4];
        double d = 1.0E30f;
        int n5 = n;
        while (n2 - n > n4) {
            int n6;
            for (n6 = 0; n6 < n4; ++n6) {
                nArray[n6] = n + (n6 + 1) * ((n2 - n) / (n4 + 1));
                dArray[n6] = findMinimumFun.f(nArray[n6], object);
            }
            int n7 = 0;
            double d3 = dArray[0];
            for (n6 = 1; n6 < n4; ++n6) {
                if (!(dArray[n6] < d3)) continue;
                d3 = dArray[n6];
                n7 = n6;
            }
            if (d3 > d) break;
            n = n7 == 0 ? n : nArray[n7 - 1];
            n2 = n7 == n4 - 1 ? n2 : nArray[n7 + 1];
            n5 = nArray[n7];
            d = d3;
        }
        return n5;
    }

    private static double EstimateCost(char[] cArray, char[] cArray2, int n, int n2) {
        return Deflate.ZopfliCalculateBlockSize(cArray, cArray2, n, n2, 2);
    }

    private static void AddSorted(int n, int[][] nArray, int[] nArray2) {
        UtilH.ZOPFLI_APPEND_DATA(n, nArray, nArray2);
        int n2 = 0;
        while (n2 + 1 < nArray2[0]) {
            if (nArray[0][n2] > n) {
                for (int i = nArray2[0] - 1; i > n2; --i) {
                    nArray[0][i] = nArray[0][i - 1];
                }
                nArray[0][n2] = n;
                break;
            }
            ++n2;
        }
    }

    private static void PrintBlockSplitPoints(char[] cArray, char[] cArray2, int n, int[] nArray, int n2) {
        int n3;
        Object object = new int[][]{{0}};
        int[] nArray2 = new int[]{0};
        int n4 = 0;
        if (n2 > 0) {
            for (n3 = 0; n3 < n; ++n3) {
                char c;
                char c2 = c = cArray2[n3] == '\u0000' ? (char)'\u0001' : cArray[n3];
                if (nArray[nArray2[0]] == n3) {
                    UtilH.ZOPFLI_APPEND_DATA(n4, object, nArray2);
                    if (nArray2[0] == n2) break;
                }
                n4 += c;
            }
        }
        assert (nArray2[0] == n2);
        System.err.print("block split points: ");
        for (n3 = 0; n3 < nArray2[0]; ++n3) {
            System.err.printf("%d ", object[0][n3]);
        }
        System.err.print("(hex:");
        for (n3 = 0; n3 < nArray2[0]; ++n3) {
            System.err.printf(" %x", object[0][n3]);
        }
        System.err.printf(")\n", new Object[0]);
        object = null;
    }

    private static boolean FindLargestSplittableBlock(int n, boolean[] blArray, int[] nArray, int n2, int[] nArray2, int[] nArray3) {
        int n3 = 0;
        boolean bl = false;
        for (int i = 0; i <= n2; ++i) {
            int n4;
            int n5 = i == 0 ? 0 : nArray[i - 1];
            int n6 = n4 = i == n2 ? n - 1 : nArray[i];
            if (blArray[n5] || n4 - n5 <= n3) continue;
            nArray2[0] = n5;
            nArray3[0] = n4;
            bl = true;
            n3 = n4 - n5;
        }
        return bl;
    }

    public static void ZopfliBlockSplitLZ77(ZopfliH.ZopfliOptions zopfliOptions, char[] cArray, char[] cArray2, int n, int n2, int[][] nArray, int[] nArray2) {
        int[] nArray3 = new int[]{0};
        int[] nArray4 = new int[]{0};
        int n3 = 0;
        int n4 = 1;
        if (n < 10) {
            return;
        }
        boolean[] blArray = new boolean[n];
        nArray3[0] = 0;
        nArray4[0] = n;
        do {
            double d;
            SplitCostContext splitCostContext = new SplitCostContext();
            if (n2 > 0 && n4 >= n2) break;
            splitCostContext.litlens = cArray;
            splitCostContext.dists = cArray2;
            splitCostContext.start = nArray3[0];
            splitCostContext.end = nArray4[0];
            assert (nArray3[0] < nArray4[0]);
            n3 = BlockSplitter.FindMinimum(SplitCost, splitCostContext, nArray3[0] + 1, nArray4[0]);
            assert (n3 > nArray3[0]);
            assert (n3 < nArray4[0]);
            double d2 = BlockSplitter.EstimateCost(cArray, cArray2, nArray3[0], n3) + BlockSplitter.EstimateCost(cArray, cArray2, n3, nArray4[0]);
            if (d2 > (d = BlockSplitter.EstimateCost(cArray, cArray2, nArray3[0], nArray4[0])) || n3 == nArray3[0] + 1 || n3 == nArray4[0]) {
                blArray[nArray3[0]] = true;
                continue;
            }
            BlockSplitter.AddSorted(n3, nArray, nArray2);
            ++n4;
        } while (BlockSplitter.FindLargestSplittableBlock(n, blArray, nArray[0], nArray2[0], nArray3, nArray4) && nArray4[0] - nArray3[0] >= 10);
        if (zopfliOptions.verbose) {
            BlockSplitter.PrintBlockSplitPoints(cArray, cArray2, n, nArray[0], nArray2[0]);
        }
        blArray = null;
    }

    public static void ZopfliBlockSplit(ZopfliH.ZopfliOptions zopfliOptions, byte[] byArray, int n, int n2, int n3, int[][] nArray, int[] nArray2) {
        int n4 = 0;
        Lz77H.ZopfliBlockState zopfliBlockState = new Lz77H.ZopfliBlockState();
        Object object = new int[][]{{0}};
        int[] nArray3 = new int[]{0};
        Lz77H.ZopfliLZ77Store zopfliLZ77Store = new Lz77H.ZopfliLZ77Store();
        Lz77.ZopfliInitLZ77Store(zopfliLZ77Store);
        zopfliBlockState.options = zopfliOptions;
        zopfliBlockState.blockstart = n;
        zopfliBlockState.blockend = n2;
        zopfliBlockState.lmc = null;
        nArray2[0] = 0;
        nArray[0] = new int[0];
        Lz77.ZopfliLZ77Greedy(zopfliBlockState, byArray, n, n2, zopfliLZ77Store);
        BlockSplitter.ZopfliBlockSplitLZ77(zopfliOptions, zopfliLZ77Store.litlens[0], zopfliLZ77Store.dists[0], zopfliLZ77Store.size[0], n3, object, nArray3);
        n4 = n;
        if (nArray3[0] > 0) {
            for (int i = 0; i < zopfliLZ77Store.size[0]; ++i) {
                char c;
                char c2 = c = zopfliLZ77Store.dists[0][i] == '\u0000' ? (char)'\u0001' : zopfliLZ77Store.litlens[0][i];
                if (object[0][nArray2[0]] == i) {
                    UtilH.ZOPFLI_APPEND_DATA(n4, nArray, nArray2);
                    if (nArray2[0] == nArray3[0]) break;
                }
                n4 += c;
            }
        }
        assert (nArray2[0] == nArray3[0]);
        object = null;
        Lz77.ZopfliCleanLZ77Store(zopfliLZ77Store);
    }

    public static void ZopfliBlockSplitSimple(byte[] byArray, int n, int n2, int n3, int[][] nArray, int[] nArray2) {
        for (int i = n; i < n2; i += n3) {
            UtilH.ZOPFLI_APPEND_DATA(i, nArray, nArray2);
        }
    }

    private static final class SplitCostContext {
        char[] litlens;
        char[] dists;
        int start;
        int end;

        private SplitCostContext() {
        }
    }

    private static interface FindMinimumFun {
        public double f(int var1, Object var2);
    }
}

