/* Copyright (C) 2003, 2010 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: CCUnitTestResult.c,v 1.10 2010/08/16 11:20:53 tsutsumi Exp $
 */
/**@file
 * TestResult module implementation.
 */
#include <ccunit/CCUnitTestResult.h>
#include <ccunit/CCUnitTestFixture.h>
#include <stdio.h>

/** @addtogroup CCUnitTestResult
 * @{
 */

extern void _ccunit_runBare (CCUnitTestFixture* testFixture,
			     void (*runTest)(),
			     CCUnitTestResult* result);

/**
 * Informs the result that a test will be started.
 */
void _ccunit_startTest (CCUnitTestResult* result, struct CCUnitTestCase* test)
{
  CCUnitListIterator itor;
  CCUnitTestListener* listener;
  ccunit_initListIterator (&result->listeners, &itor);
  while ((listener = (CCUnitTestListener*)ccunit_nextListIterator (&itor)) != 0)
    {
      listener->startTest (listener, test);
    }
}

/**
 * Informs the result that a test was completed.
 */
void _ccunit_endTest (CCUnitTestResult* result, struct CCUnitTestCase* test)
{
  CCUnitListIterator itor;
  CCUnitTestListener* listener;
  ccunit_initListIterator (&result->listeners, &itor);
  while ((listener = (CCUnitTestListener*)ccunit_nextListIterator (&itor)) != 0)
    {
      listener->endTest (listener, test);
    }
}

CCUnitTestResult* ccunit_newTestResult ()
{
  CCUnitTestResult* result = calloc (1, sizeof (*result));
  if (!result)
    return NULL;
  ccunit_initList (&result->failures);
  ccunit_initList (&result->listeners);
  result->shouldStop = false;
  return result;
}

void ccunit_deleteTestResult (CCUnitTestResult* result)
{
  if (!result)
    return;
  ccunit_deleteList (&result->failures, (void(*)(void*))ccunit_deleteTestFailure);
  ccunit_deleteList (&result->listeners, NULL);
  free (result);
}

inline void ccunit_addResultListener (CCUnitTestResult* result,
				      CCUnitTestListener* listener)
{
  ccunit_addList (&result->listeners, listener);
}

void ccunit_addFailure (CCUnitTestResult* result, struct CCUnitTestFailure* failure)
{
  CCUnitListIterator itor;
  CCUnitTestListener* listener;
  ccunit_initListIterator (&result->listeners, &itor);
  ccunit_addList (&result->failures, failure);
  while ((listener = (CCUnitTestListener*)ccunit_nextListIterator (&itor)) != 0)
    {
      listener->addFailure (listener, failure);
    }
}

inline size_t ccunit_failureCount (CCUnitTestResult* result)
{
  return result->failures.length;
}

inline bool ccunit_wasSuccessful (CCUnitTestResult* result)
{
  return ccunit_failureCount (result) == 0;
}

inline void ccunit_stopTest (CCUnitTestResult* result)
{
  result->shouldStop = true;
}

inline size_t ccunit_runCount (CCUnitTestResult* result)
{
  return result->runCount;
}

inline CCUnitListIterator* ccunit_failures(CCUnitTestResult* result)
{
  return ccunit_newListIterator (&result->failures);
}

/** @} */
