/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: testSuite.c,v 1.2 2003/09/11 02:42:42 tsutsumi Exp $
 */
#include <stdio.h>
#include <ccunit/CCUnitAssert.h>
#include <ccunit/CCUnitTestSuite.h>

/**
 * test case: new test.
 */
static CCUnitTestSuite* suite;

void setUp_newTestSuite ()
{
  suite = ccunit_newTestSuite ("test_newTestSuite");
}

void tearDown_newTestSuite ()
{
  ccunit_deleteTestSuite (suite);
}

/**
 * newTestSuite success.
 */
void test_newTestSuite_success ()
{
  CCUNIT_ASSERT_NOT_NULL (suite);
}

/**
 * newTestSuite name
 */
void test_newTestSuite_name ()
{
  CCUNIT_ASSERT_EQ_STR ("test_newTestSuite", suite->name);
}
