/* Copyright (C) 2003 TSUTSUMI Kikuo.
   This file is part of the CCUnit Library.

   The CCUnit Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   The CCUnit Library is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty
   of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with the CCUnit Library; see the file COPYING.LESSER.
   If not, write to the Free Software Foundation, Inc., 59 Temple
   Place - Suite 330, Boston, MA 02111-1307, USA.  
*/

/*
 * $Id: testAssert.c,v 1.2 2003/10/01 20:58:19 tsutsumi Exp $
 */
#include <stdio.h>
#include <limits.h>
#include <ccunit/CCUnitAssert.h>

/** test suite: assert test */

/** test case: assert macro test */

void setUp_testAssert ()
{
}

void tearDown_testAssert ()
{
}

/**
 * assert success.
 */
void test_assert_success ()
{
  CCUNIT_ASSERT (1 == 1);
}

/**
 * assert eq int success
 */
void test_assertInt_equal ()
{
  CCUNIT_ASSERT_EQ_INT (INT_MAX, INT_MAX);
}

/**
 * assert !eq int success
 */
void test_assertInt_notEqual ()
{
  CCUNIT_ASSERT_NE_INT (INT_MAX, INT_MIN);
}

/**
 * assert int compare
 */
void test_assertInt_comp ()
{
  CCUNIT_ASSERT_GT_INT (INT_MAX, INT_MIN);
}

/**
 * assert str compare
 */
void test_assertStr_comp ()
{
  CCUNIT_ASSERT_EQ_STR ("string", "string");
}

/** end test case */
