#include "categorywindow.h"
#include "category.h"
#include "corona.h"
#include "meme.h"
#include "branch.h"
#include "tokugi.h"
#include <QDebug>
#include <QMessageBox>

CategoryWindow::CategoryWindow(QWidget *parent) :
        QWidget(parent),
        _general(NULL)
{
}

CategoryWindow::~CategoryWindow()
{
}

bool CategoryWindow::setGeneral(Data * data)
{
    _general = data;
    return true;
}


/**
  * 入力：テーブルウィジェット、親データ、子データ格納リスト
  *　結果：テーブルウィジェットの表示にカテゴリ追加
  * T : category content : Corona, Meme, Branch
  */
template <class T> bool CategoryWindow::addCategory(QTableWidget *qtw, Data *data, QList<Data*>& childList, T*)
{
    if(data == NULL)// data が null のエラー回避
    {
	QMessageBox::warning(qtw, QObject::tr("Warning"), QObject::tr("dataがありません"), QMessageBox::Ok, QMessageBox::NoButton);
	return false;
    }

    qtw->setRowCount(0); //行数を初期化して0
    for(int i=0;data->GetChild(i)!=NULL;i++) //下層データを漁る
    {
	T* child = dynamic_cast<T*>(data->GetChild(i));
	if(child==NULL)
	{
	    continue;
	}
	childList.append(child);
	qtw->setRowCount(qtw->rowCount() + 1);
	qtw->setItem(qtw->rowCount()-1,0,new QTableWidgetItem(child->GetName(), 0));
	int column_num = 1;

	if(!child->GetKihonCapability().isEmpty())
	{
	    for(int j=0;j<5;j++)
	    {
		//基本能力の表示
		qtw->setItem(qtw->rowCount()-1,column_num,new QTableWidgetItem(QString::number(child->GetKihonCapability(j)), 0));
		column_num++;
	    }
	}
	if(!child->GetSentouCapability().isEmpty())
	{
	    for(int j=0;j<5;j++)
	    {
		//戦闘能力の表示
		qtw->setItem(qtw->rowCount()-1,column_num,new QTableWidgetItem(QString::number(child->GetSentouCapability(j)), 0));
		column_num++;
	    }
	}
    }
    return true;
}
template bool CategoryWindow::addCategory(QTableWidget*, Data*, QList<Data*>&, Corona*);
template bool CategoryWindow::addCategory(QTableWidget*, Data*, QList<Data*>&, Meme*);
template bool CategoryWindow::addCategory(QTableWidget*, Data*, QList<Data*>&, Branch*);

/**
 * 入力：　ミームまたはブランチのリストウィジェット、特技のテーブルウィジェット、カテゴリのリスト
 * 出力：　選択されたミームまたはブランチのデータのポインタ
 */
QHash<int, Data*> CategoryWindow::ShowTokugi(QTableWidget* ctw, QTableWidget* ttw, QList<Data*> clist)
{
    if(ctw == NULL)
    {
	return QHash<int, Data*>();
    }

    if(ctw->currentRow() >= clist.size())
    {
	QMessageBox::warning(ctw, tr("Warning"), tr("不正参照です"), QMessageBox::Ok, QMessageBox::NoButton);
	return QHash<int, Data*>();
    }
    Data* gottenCategory = clist.at(ctw->currentRow());
    if(gottenCategory == NULL)
    {
	QMessageBox::warning(ctw, tr("Warning"), tr("ここは空です"), QMessageBox::Ok, QMessageBox::NoButton);
	return QHash<int, Data*>();
    }

    int baseColumn = -1;
    for(int k=0;k<ttw->columnCount();k++)
    {
	if( ttw->horizontalHeaderItem(k)->text().contains(QObject::tr("所属")) )
	{
	    baseColumn = k;
	    break;
	}
    }
    if(baseColumn==-1)
    {
	QMessageBox::warning(ttw, QObject::tr("Warning"), QObject::tr("所属列が見つかりません"), QMessageBox::Ok, QMessageBox::NoButton);
	return QHash<int, Data*>();
    }

    ttw->setRowCount(0);
    QHash<int, Data*> tlist;
    for(int i=0,j=0;gottenCategory->GetChild(i)!=NULL;++i)
    {
	Data* tokugi = gottenCategory->GetChild(i);
	if(tokugi->GetCategory() != NULL)
	{
	    continue;
	}
         ttw->setRowCount(ttw->rowCount() + 1);
        //ttw->setVerticalHeaderItem(ttw->rowCount(),new QTableWidgetItem(0));

        tlist.insert(j, tokugi);
        ttw->setItem(j,baseColumn,new QTableWidgetItem( tokugi->GetParent()->GetName(), 0) );

        QVector<QString> tokugiProperty = tokugi->GetProperty();
	//ここの順番を柔軟にしたい
        for(int k=0;k<tokugiProperty.size();++k)
	{
            ttw->setItem(j,k+1,new QTableWidgetItem( tokugiProperty.value(k), 0 ));
	}
        ++j;
    }
    ttw->resizeColumnsToContents();
    return tlist;
}

/**
  * テーブルウィジェットの選択特技返す
  T: Corona,Meme,Branch
  input: twc(category widget),twt(tokugi widget), categoryList(category list of each), tokugiList(tokugi list of each)
  output: Tokugi
  */
Data* CategoryWindow::getTokugi(QTableWidget* twc, QTableWidget* twt, QList<Data*> categoryList)
{
    if(twc->currentRow()>=categoryList.size())
    {
	QMessageBox::warning(twc, "Warning", "選択されていません",QMessageBox::Ok,QMessageBox::NoButton);
	return NULL;
    }

    Data *category = categoryList.at(twc->currentRow());

    //取得特技データ
    Data *selTokugi = NULL;
    for(int i=0,j=0;category->GetChild(i)!=NULL;++i)
    {
        Data* tokugi = category->GetChild(i);
        if(tokugi->GetCategory() != NULL)
        {
            continue;
        }
        if(j++ == twt->currentRow())
        {
            selTokugi = tokugi;
            break;
        }
    }

    //選択特技が存在するかチェック
    if(selTokugi==NULL)
    {
        QMessageBox::warning(twt, "Warning", "特技のデータがありません",QMessageBox::Ok,QMessageBox::NoButton);
        return NULL;
    }

    return selTokugi;
}

/**
  指定されたカテゴリの特技テーブルウィジェットを表示
  */
QTableWidget* CategoryWindow::showTokugiTableWidget(Data *data)
{
    data->getTokugiTableWidget()->show();
    return data->getTokugiTableWidget();
}
